/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.refactoring;

import com.android.repository.io.FileOpUtils;
import com.android.tools.idea.templates.RepositoryUrlManager;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.refactoring.MigrateToAndroidxProcessor;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000$\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0007H\u0002\u001a\u0012\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"CLASS_MIGRATION_BASE_PRIORITY", "", "DEFAULT_MIGRATION_BASE_PRIORITY", "PACKAGE_MIGRATION_BASE_PRIORITY", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "getLibraryRevision", "", "newGroupName", "newArtifactName", "defaultVersion", "isImportElement", "", "element", "Lcom/intellij/psi/PsiElement;", "intellij.android.core"})
public final class MigrateToAndroidxProcessorKt {
    private static final int CLASS_MIGRATION_BASE_PRIORITY = 1000000;
    private static final int PACKAGE_MIGRATION_BASE_PRIORITY = 1000;
    private static final int DEFAULT_MIGRATION_BASE_PRIORITY = 0;
    private static final Logger log;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isImportElement(PsiElement element) {
        if (element == null) return false;
        ASTNode aSTNode = element.getNode();
        if (Intrinsics.areEqual((Object)String.valueOf(aSTNode != null ? aSTNode.getElementType() : null), (Object)"IMPORT_LIST")) return true;
        if (!MigrateToAndroidxProcessorKt.isImportElement(element.getParent())) return false;
        return true;
    }

    private static final String getLibraryRevision(String newGroupName, String newArtifactName, String defaultVersion) {
        String revision = RepositoryUrlManager.get().getLibraryRevision(newGroupName, newArtifactName, null, true, FileOpUtils.create());
        if (revision != null) {
            Logger $receiver$iv = log;
            Exception e$iv = null;
            boolean $i$f$debug = false;
            if ($receiver$iv.isDebugEnabled()) {
                Logger logger = $receiver$iv;
                boolean bl = false;
                String string = newGroupName + ':' + newArtifactName + " will use " + revision;
                logger.debug(string, (Throwable)e$iv);
            }
            return revision;
        }
        Logger $receiver$iv = log;
        Exception e$iv = null;
        boolean $i$f$debug = false;
        if ($receiver$iv.isDebugEnabled()) {
            Logger logger = $receiver$iv;
            boolean bl = false;
            String string = "Unable to find library revision for " + newGroupName + ':' + newArtifactName + ". Using " + defaultVersion;
            logger.debug(string, (Throwable)e$iv);
        }
        return defaultVersion;
    }

    static {
        boolean $i$f$logger = false;
        log = Logger.getInstance(MigrateToAndroidxProcessor.class);
    }

    public static final /* synthetic */ Logger access$getLog$p() {
        return log;
    }

    public static final /* synthetic */ boolean access$isImportElement(PsiElement element) {
        return MigrateToAndroidxProcessorKt.isImportElement(element);
    }

    public static final /* synthetic */ String access$getLibraryRevision(String newGroupName, String newArtifactName, String defaultVersion) {
        return MigrateToAndroidxProcessorKt.getLibraryRevision(newGroupName, newArtifactName, defaultVersion);
    }
}

