/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.refactoring;

import com.android.tools.idea.flags.StudioFlags;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.actions.BaseRefactoringAction;
import org.jetbrains.android.refactoring.MigrateToAppCompatHandler;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MigrateToAppCompatAction
extends BaseRefactoringAction {
    protected boolean isAvailableInEditorOnly() {
        return false;
    }

    public void update(@NotNull AnActionEvent anActionEvent) {
        Project project = (Project)anActionEvent.getData(CommonDataKeys.PROJECT);
        anActionEvent.getPresentation().setEnabledAndVisible(MigrateToAppCompatAction.isEnabled(project));
    }

    protected boolean isEnabledOnDataContext(@NotNull DataContext dataContext) {
        return MigrateToAppCompatAction.isEnabled((Project)CommonDataKeys.PROJECT.getData(dataContext));
    }

    protected boolean isEnabledOnElements(@NotNull PsiElement[] elements) {
        return elements.length > 0 && MigrateToAppCompatAction.isEnabled(elements[0].getProject());
    }

    @Nullable
    protected RefactoringActionHandler getHandler(@NotNull DataContext dataContext) {
        return new MigrateToAppCompatHandler();
    }

    protected boolean isAvailableForLanguage(Language language) {
        return true;
    }

    private static boolean isEnabled(@Nullable Project project) {
        if (project == null || !((Boolean)StudioFlags.MIGRATE_TO_APPCOMPAT_REFACTORING_ENABLED.get()).booleanValue()) {
            return false;
        }
        return AndroidUtils.hasAndroidFacets(project);
    }
}

