/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.refactoring;

import com.android.SdkConstants;
import com.android.ide.common.repository.GradleVersion;
import com.android.resources.ResourceType;
import com.android.sdklib.AndroidVersion;
import com.android.support.AndroidxName;
import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.api.android.AndroidModel;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.projectsystem.GoogleMavenArtifactId;
import com.android.tools.idea.templates.IdeGoogleMavenRepository;
import com.android.tools.idea.util.DependencyManagementUtil;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ExternalLibraryDescriptor;
import com.intellij.openapi.roots.JavaProjectModelModificationService;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMigration;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.impl.migration.PsiMigrationManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.listeners.RefactoringEventData;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.SmartHashSet;
import com.siyeh.ig.psiutils.MethodUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.refactoring.AppCompatMigrationEntry;
import org.jetbrains.android.refactoring.AppCompatPublicDotTxtLookup;
import org.jetbrains.android.refactoring.AppCompatStyleMigration;
import org.jetbrains.android.refactoring.MigrateToAndroidxUtil;
import org.jetbrains.android.refactoring.MigrateToAppCompatUsageInfo;
import org.jetbrains.android.refactoring.MigrateToAppCompatUsageViewDescriptor;
import org.jetbrains.android.refactoring.MigrateToAppCompatUtil;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MigrateToAppCompatProcessor
extends BaseRefactoringProcessor {
    protected static final BiFunction<GoogleMavenArtifactId, String, AppCompatStyleMigration> DEFAULT_MIGRATION_FACTORY = (artifact, version2) -> AppCompatPublicDotTxtLookup.getInstance().createAppCompatStyleMigration((GoogleMavenArtifactId)((Object)artifact), (String)version2);
    static final int MIGRATION_ENTRY_SIZE = 35;
    static final String ATTR_ACTION_VIEW_CLASS = "actionViewClass";
    static final String ANDROID_WIDGET_SEARCH_VIEW_CLASS = "android.widget.SearchView";
    static final String SUPPORT_V7_WIDGET_SEARCH_VIEW_CLASS = "android.support.v7.widget.SearchView";
    static final String ANDROID_WIDGET_SHARE_PROVIDER_CLASS = "android.widget.ShareActionProvider";
    static final String ATTR_ACTION_PROVIDER_CLASS = "actionProviderClass";
    static final String CLASS_SUPPORT_FRAGMENT_ACTIVITY = "android.support.v4.app.FragmentActivity";
    static final AndroidxName ANDROID_SUPPORT_V7_APP_ALERT_DIALOG = AndroidxName.of((String)"android.support.v7.app.", (String)"AlertDialog");
    static final AndroidxName ANDROID_SUPPORT_V7_WIDGET_SEARCH_VIEW = AndroidxName.of((String)"android.support.v7.widget.", (String)"SearchView");
    static final AndroidxName ANDROID_SUPPORT_V7_WIDGET_SHARE_ACTION_PROVIDER = AndroidxName.of((String)"android.support.v7.widget.", (String)"ShareActionProvider");
    static final AndroidxName ANDROID_SUPPORT_V4_VIEW_ACTION_PROVIDER = AndroidxName.of((String)"android.support.v4.view.", (String)"ActionProvider");
    static final AndroidxName ANDROID_SUPPORT_V4_VIEW_MENU_ITEM_COMPAT = AndroidxName.of((String)"android.support.v4.view.", (String)"MenuItemCompat");
    static final AndroidxName ANDROID_SUPPORT_V7_WIDGET_LIST_POPUP_WINDOW = AndroidxName.of((String)"android.support.v7.widget.", (String)"ListPopupWindow");
    static final AndroidxName ANDROID_SUPPORT_V7_APP_ACTION_BAR = AndroidxName.of((String)"android.support.v7.app.", (String)"ActionBar");
    static final AndroidxName ANDROID_SUPPORT_V4_APP_FRAGMENT_TRANSACTION = AndroidxName.of((String)"android.support.v4.app.", (String)"FragmentTransaction");
    static final AndroidxName ANDROID_SUPPORT_V4_APP_FRAGMENT_MANAGER = AndroidxName.of((String)"android.support.v4.app.", (String)"FragmentManager");
    private final Module[] myModules;
    private final List<AppCompatMigrationEntry> myMigrationMap;
    private AppCompatStyleMigration myAppCompatStyleMigration;
    private PsiElement[] myElements = PsiElement.EMPTY_ARRAY;
    private List<SmartPsiElementPointer<PsiElement>> myRefsToShorten;
    private List<MigrateToAppCompatUsageInfo.ClassMigrationUsageInfo> myClassMigrations;
    private final BiFunction<GoogleMavenArtifactId, String, AppCompatStyleMigration> myAppCompatStyleMigrationFactory;
    private final Set<VirtualFile> myPsiFilesWithActivityImports;
    private final Set<VirtualFile> myPsiFilesWithFragmentActivityImports;
    private PsiMigration myPsiMigration;

    protected MigrateToAppCompatProcessor(@NotNull Project project) {
        this(project, DEFAULT_MIGRATION_FACTORY);
    }

    protected MigrateToAppCompatProcessor(@NotNull Project project, @NotNull BiFunction<GoogleMavenArtifactId, String, AppCompatStyleMigration> appCompatStyleMigrationFactory) {
        this(project, MigrateToAppCompatProcessor.buildMigrationMap(project), appCompatStyleMigrationFactory);
    }

    protected MigrateToAppCompatProcessor(Project project, List<AppCompatMigrationEntry> migrationMap, @NotNull BiFunction<GoogleMavenArtifactId, String, AppCompatStyleMigration> appCompatStyleMigrationFactory) {
        super(project, null);
        this.myModules = ModuleManager.getInstance((Project)project).getModules();
        this.myMigrationMap = migrationMap;
        this.myAppCompatStyleMigrationFactory = appCompatStyleMigrationFactory;
        this.myPsiFilesWithFragmentActivityImports = new SmartHashSet();
        this.myPsiFilesWithActivityImports = new SmartHashSet();
        this.myPsiMigration = this.startMigration(project);
    }

    private PsiMigration startMigration(Project project) {
        return PsiMigrationManager.getInstance((Project)project).startMigration();
    }

    @NotNull
    private static String getName(boolean isAndroidx, @NotNull AndroidxName name) {
        return isAndroidx ? name.newName() : name.oldName();
    }

    @NotNull
    static List<AppCompatMigrationEntry> buildMigrationMap(@NotNull Project project) {
        boolean isAndroidx = MigrateToAndroidxUtil.isAndroidx(project);
        ArrayList mapEntries = Lists.newArrayListWithExpectedSize((int)35);
        mapEntries.add(new AppCompatMigrationEntry.ClassMigrationEntry("android.app.Activity", MigrateToAppCompatProcessor.getName(isAndroidx, SdkConstants.CLASS_APP_COMPAT_ACTIVITY)));
        mapEntries.add(new AppCompatMigrationEntry.ClassMigrationEntry("android.support.v7.appActionBarActivity", MigrateToAppCompatProcessor.getName(isAndroidx, SdkConstants.CLASS_APP_COMPAT_ACTIVITY)));
        mapEntries.add(new AppCompatMigrationEntry.ClassMigrationEntry(CLASS_SUPPORT_FRAGMENT_ACTIVITY, MigrateToAppCompatProcessor.getName(isAndroidx, SdkConstants.CLASS_APP_COMPAT_ACTIVITY)));
        mapEntries.add(new AppCompatMigrationEntry.ClassMigrationEntry("android.app.ActionBar", MigrateToAppCompatProcessor.getName(isAndroidx, ANDROID_SUPPORT_V7_APP_ACTION_BAR)));
        mapEntries.add(new AppCompatMigrationEntry.MethodMigrationEntry("android.app.Activity", "getActionBar", MigrateToAppCompatProcessor.getName(isAndroidx, SdkConstants.CLASS_APP_COMPAT_ACTIVITY), "getSupportActionBar"));
        mapEntries.add(new AppCompatMigrationEntry.MethodMigrationEntry("android.app.Activity", "setActionBar", MigrateToAppCompatProcessor.getName(isAndroidx, SdkConstants.CLASS_APP_COMPAT_ACTIVITY), "setSupportActionBar"));
        mapEntries.add(new AppCompatMigrationEntry.ClassMigrationEntry("android.widget.Toolbar", MigrateToAppCompatProcessor.getName(isAndroidx, SdkConstants.CLASS_TOOLBAR_V7)));
        mapEntries.add(new AppCompatMigrationEntry.XmlTagMigrationEntry("android.widget.Toolbar", "", MigrateToAppCompatProcessor.getName(isAndroidx, SdkConstants.CLASS_TOOLBAR_V7), "", 1));
        mapEntries.add(new AppCompatMigrationEntry.ClassMigrationEntry("android.app.Fragment", MigrateToAppCompatProcessor.getName(isAndroidx, SdkConstants.CLASS_V4_FRAGMENT)));
        mapEntries.add(new AppCompatMigrationEntry.ClassMigrationEntry("android.app.FragmentTransaction", MigrateToAppCompatProcessor.getName(isAndroidx, ANDROID_SUPPORT_V4_APP_FRAGMENT_TRANSACTION)));
        mapEntries.add(new AppCompatMigrationEntry.ClassMigrationEntry("android.app.FragmentManager", MigrateToAppCompatProcessor.getName(isAndroidx, ANDROID_SUPPORT_V4_APP_FRAGMENT_MANAGER)));
        mapEntries.add(new AppCompatMigrationEntry.MethodMigrationEntry("android.app.Activity", "getFragmentManager", MigrateToAppCompatProcessor.getName(isAndroidx, SdkConstants.CLASS_APP_COMPAT_ACTIVITY), "getSupportFragmentManager"));
        mapEntries.add(new AppCompatMigrationEntry.ClassMigrationEntry("android.app.AlertDialog", MigrateToAppCompatProcessor.getName(isAndroidx, ANDROID_SUPPORT_V7_APP_ALERT_DIALOG)));
        mapEntries.add(new AppCompatMigrationEntry.ClassMigrationEntry(ANDROID_WIDGET_SEARCH_VIEW_CLASS, MigrateToAppCompatProcessor.getName(isAndroidx, ANDROID_SUPPORT_V7_WIDGET_SEARCH_VIEW)));
        mapEntries.add(new AppCompatMigrationEntry.ClassMigrationEntry(ANDROID_WIDGET_SHARE_PROVIDER_CLASS, MigrateToAppCompatProcessor.getName(isAndroidx, ANDROID_SUPPORT_V7_WIDGET_SHARE_ACTION_PROVIDER)));
        mapEntries.add(new AppCompatMigrationEntry.ClassMigrationEntry("android.view.ActionProvider", MigrateToAppCompatProcessor.getName(isAndroidx, ANDROID_SUPPORT_V4_VIEW_ACTION_PROVIDER)));
        mapEntries.add(new AppCompatMigrationEntry.ReplaceMethodCallMigrationEntry("android.view.MenuItem", "getActionProvider", MigrateToAppCompatProcessor.getName(isAndroidx, ANDROID_SUPPORT_V4_VIEW_MENU_ITEM_COMPAT), "getActionProvider", 0));
        mapEntries.add(new AppCompatMigrationEntry.ReplaceMethodCallMigrationEntry("android.view.MenuItem", "getActionView", MigrateToAppCompatProcessor.getName(isAndroidx, ANDROID_SUPPORT_V4_VIEW_MENU_ITEM_COMPAT), "getActionView", 0));
        mapEntries.add(new AppCompatMigrationEntry.ReplaceMethodCallMigrationEntry("android.view.MenuItem", "collapseActionView", MigrateToAppCompatProcessor.getName(isAndroidx, ANDROID_SUPPORT_V4_VIEW_MENU_ITEM_COMPAT), "collapseActionView", 0));
        mapEntries.add(new AppCompatMigrationEntry.ReplaceMethodCallMigrationEntry("android.view.MenuItem", "expandActionView", MigrateToAppCompatProcessor.getName(isAndroidx, ANDROID_SUPPORT_V4_VIEW_MENU_ITEM_COMPAT), "expandActionView", 0));
        mapEntries.add(new AppCompatMigrationEntry.ReplaceMethodCallMigrationEntry("android.view.MenuItem", "setActionProvider", MigrateToAppCompatProcessor.getName(isAndroidx, ANDROID_SUPPORT_V4_VIEW_MENU_ITEM_COMPAT), "setActionProvider", 0));
        mapEntries.add(new AppCompatMigrationEntry.ReplaceMethodCallMigrationEntry("android.view.MenuItem", "setActionView", MigrateToAppCompatProcessor.getName(isAndroidx, ANDROID_SUPPORT_V4_VIEW_MENU_ITEM_COMPAT), "setActionView", 0));
        mapEntries.add(new AppCompatMigrationEntry.ReplaceMethodCallMigrationEntry("android.view.MenuItem", "isActionViewExpanded", MigrateToAppCompatProcessor.getName(isAndroidx, ANDROID_SUPPORT_V4_VIEW_MENU_ITEM_COMPAT), "isActionViewExpanded", 0));
        mapEntries.add(new AppCompatMigrationEntry.ReplaceMethodCallMigrationEntry("android.view.MenuItem", "setShowAsAction", MigrateToAppCompatProcessor.getName(isAndroidx, ANDROID_SUPPORT_V4_VIEW_MENU_ITEM_COMPAT), "setShowAsAction", 0));
        mapEntries.add(new AppCompatMigrationEntry.ClassMigrationEntry("android.view.MenuItem.OnActionExpandListener", MigrateToAppCompatProcessor.getName(isAndroidx, ANDROID_SUPPORT_V4_VIEW_MENU_ITEM_COMPAT) + ".OnActionExpandListener"));
        mapEntries.add(new AppCompatMigrationEntry.ReplaceMethodCallMigrationEntry("android.view.MenuItem", "setOnActionExpandListener", MigrateToAppCompatProcessor.getName(isAndroidx, ANDROID_SUPPORT_V4_VIEW_MENU_ITEM_COMPAT), "setOnActionExpandListener", 0));
        mapEntries.add(new AppCompatMigrationEntry.AttributeMigrationEntry("showAsAction", "http://schemas.android.com/apk/res/android", "showAsAction", "http://schemas.android.com/apk/res-auto", 2, "item"));
        mapEntries.add(new AppCompatMigrationEntry.AttributeMigrationEntry(ATTR_ACTION_VIEW_CLASS, "http://schemas.android.com/apk/res/android", ATTR_ACTION_VIEW_CLASS, "http://schemas.android.com/apk/res-auto", 2, "item"));
        mapEntries.add(new AppCompatMigrationEntry.AttributeValueMigrationEntry(ANDROID_WIDGET_SEARCH_VIEW_CLASS, SUPPORT_V7_WIDGET_SEARCH_VIEW_CLASS, ATTR_ACTION_VIEW_CLASS, "http://schemas.android.com/apk/res/android", 2, "item"));
        mapEntries.add(new AppCompatMigrationEntry.AttributeMigrationEntry(ATTR_ACTION_PROVIDER_CLASS, "http://schemas.android.com/apk/res/android", ATTR_ACTION_PROVIDER_CLASS, "http://schemas.android.com/apk/res-auto", 2, "item"));
        mapEntries.add(new AppCompatMigrationEntry.AttributeValueMigrationEntry(ANDROID_WIDGET_SHARE_PROVIDER_CLASS, MigrateToAppCompatProcessor.getName(isAndroidx, ANDROID_SUPPORT_V7_WIDGET_SHARE_ACTION_PROVIDER), ATTR_ACTION_PROVIDER_CLASS, "http://schemas.android.com/apk/res/android", 2, "item"));
        mapEntries.add(new AppCompatMigrationEntry(3));
        mapEntries.add(new AppCompatMigrationEntry(4));
        mapEntries.add(new AppCompatMigrationEntry.AttributeMigrationEntry("src", "http://schemas.android.com/apk/res/android", "srcCompat", "http://schemas.android.com/apk/res-auto", 1, "ImageView", "ImageButton"));
        mapEntries.add(new AppCompatMigrationEntry.ClassMigrationEntry("android.widget.ListPopupWindow", MigrateToAppCompatProcessor.getName(isAndroidx, ANDROID_SUPPORT_V7_WIDGET_LIST_POPUP_WINDOW)));
        return ImmutableList.copyOf((Collection)mapEntries);
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usages) {
        return new MigrateToAppCompatUsageViewDescriptor(this.myElements);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    protected UsageInfo[] findUsages() {
        this.myPsiFilesWithFragmentActivityImports.clear();
        this.myPsiFilesWithActivityImports.clear();
        if (this.myAppCompatStyleMigration == null) {
            this.myAppCompatStyleMigration = MigrateToAppCompatProcessor.createAppCompatStyleMigration(this.myModules, this.myAppCompatStyleMigrationFactory);
        }
        ArrayList<UsageInfo> infos = new ArrayList<UsageInfo>();
        try {
            ArrayList menuXmlOperations = Lists.newArrayListWithExpectedSize((int)10);
            ArrayList layoutXmlOperations = Lists.newArrayListWithExpectedSize((int)10);
            for (AppCompatMigrationEntry entry : this.myMigrationMap) {
                switch (entry.getType()) {
                    case 1: {
                        AppCompatMigrationEntry.ClassMigrationEntry classMigrationEntry = (AppCompatMigrationEntry.ClassMigrationEntry)entry;
                        List<UsageInfo> usages = MigrateToAppCompatUtil.findClassUsages(this.myProject, classMigrationEntry.myOldName);
                        boolean isActivity = classMigrationEntry.myOldName.equals("android.app.Activity");
                        boolean isFragmentActivity = classMigrationEntry.myOldName.equals(CLASS_SUPPORT_FRAGMENT_ACTIVITY);
                        for (UsageInfo usageInfo : usages) {
                            PsiElement element = usageInfo.getElement();
                            if (isActivity) {
                                PsiMethod psiMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethod.class);
                                if (psiMethod != null && (MethodUtils.hasSuper((PsiMethod)psiMethod) || MethodUtils.isOverridden((PsiMethod)psiMethod))) {
                                    VirtualFile containingFile = element.getContainingFile().getVirtualFile();
                                    this.myPsiFilesWithActivityImports.add(containingFile);
                                    continue;
                                }
                            } else if (isFragmentActivity && PsiTreeUtil.getParentOfType((PsiElement)element, PsiVariable.class) != null) {
                                VirtualFile containingFile = element.getContainingFile().getVirtualFile();
                                this.myPsiFilesWithFragmentActivityImports.add(containingFile);
                                continue;
                            }
                            infos.add(new MigrateToAppCompatUsageInfo.ClassMigrationUsageInfo(usageInfo, classMigrationEntry));
                        }
                        break;
                    }
                    case 2: {
                        Module[] methodEntry = (Module[])entry;
                        Collection<PsiReference> refs = MigrateToAppCompatUtil.findChangeMethodRefs(this.myProject, (AppCompatMigrationEntry.MethodMigrationEntry)methodEntry);
                        for (PsiReference ref : refs) {
                            infos.add(new MigrateToAppCompatUsageInfo.ChangeMethodUsageInfo(ref, (AppCompatMigrationEntry.MethodMigrationEntry)methodEntry));
                        }
                        break;
                    }
                    case 3: {
                        for (Module module : this.myModules) {
                            AndroidFacet facet = AndroidFacet.getInstance(module);
                            if (facet == null) continue;
                            infos.addAll(this.myAppCompatStyleMigration.findStyleElementsToBeModified(this.myProject, facet));
                        }
                        break;
                    }
                    case 4: {
                        infos.addAll(MigrateToAppCompatUtil.findCustomViewsUsages(this.myProject, this.myModules));
                        break;
                    }
                    case 5: {
                        AppCompatMigrationEntry.ReplaceMethodCallMigrationEntry callMigrationEntry = (AppCompatMigrationEntry.ReplaceMethodCallMigrationEntry)entry;
                        Collection<PsiReference> refs = MigrateToAppCompatUtil.findChangeMethodRefs(this.myProject, callMigrationEntry);
                        for (PsiReference ref : refs) {
                            infos.add(new MigrateToAppCompatUsageInfo.ReplaceMethodUsageInfo(ref, callMigrationEntry));
                        }
                        break;
                    }
                    case 6: 
                    case 7: 
                    case 8: {
                        AppCompatMigrationEntry.XmlElementMigration op = (AppCompatMigrationEntry.XmlElementMigration)entry;
                        if (op.isMenuOperation()) {
                            menuXmlOperations.add((AppCompatMigrationEntry.XmlElementMigration)entry);
                        }
                        if (!op.isLayoutOperation()) break;
                        layoutXmlOperations.add((AppCompatMigrationEntry.XmlElementMigration)entry);
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)("Unhandled type " + entry.getType()));
                    }
                }
                infos.addAll(MigrateToAppCompatUtil.findUsagesOfXmlElements(this.myProject, this.myModules, menuXmlOperations, ResourceType.MENU));
                infos.addAll(MigrateToAppCompatUtil.findUsagesOfXmlElements(this.myProject, this.myModules, layoutXmlOperations, ResourceType.LAYOUT));
            }
        }
        finally {
            ApplicationManager.getApplication().invokeLater(() -> WriteAction.run(this::finishMigration), this.myProject.getDisposed());
        }
        MigrateToAppCompatUtil.removeUnneededUsages(infos);
        return infos.toArray(UsageInfo.EMPTY_ARRAY);
    }

    private void finishMigration() {
        if (this.myPsiMigration != null) {
            this.myPsiMigration.finish();
            this.myPsiMigration = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performRefactoring(@NotNull UsageInfo[] usages) {
        this.finishMigration();
        PsiMigration psiMigration = PsiMigrationManager.getInstance((Project)this.myProject).startMigration();
        this.myClassMigrations = Lists.newArrayList();
        this.myRefsToShorten = Lists.newArrayList();
        try {
            CommandProcessor.getInstance().markCurrentCommandAsGlobal(this.myProject);
            SmartPointerManager smartPointerManager = SmartPointerManager.getInstance((Project)this.myProject);
            for (UsageInfo usage : usages) {
                PsiElement psiElement = null;
                if (usage instanceof MigrateToAppCompatUsageInfo.ClassMigrationUsageInfo) {
                    MigrateToAppCompatUsageInfo.ClassMigrationUsageInfo classMigrationUsageInfo = (MigrateToAppCompatUsageInfo.ClassMigrationUsageInfo)usage;
                    this.myClassMigrations.add(classMigrationUsageInfo);
                    psiElement = classMigrationUsageInfo.applyChange(psiMigration);
                } else if (usage instanceof MigrateToAppCompatUsageInfo) {
                    psiElement = ((MigrateToAppCompatUsageInfo)usage).applyChange(psiMigration);
                }
                if (psiElement == null) continue;
                this.myRefsToShorten.add((SmartPsiElementPointer<PsiElement>)smartPointerManager.createSmartPsiElementPointer(psiElement));
            }
            for (Module module : this.computeModulesNeedingAppCompat()) {
                GradleBuildModel buildModel = GradleBuildModel.get(module);
                if (buildModel == null) continue;
                AndroidModel base = buildModel.android();
                String version2 = base.compileSdkVersion().toString();
                JavaProjectModelModificationService.getInstance((Project)this.myProject).addDependency(module, (ExternalLibraryDescriptor)new AppCompatLibraryDescriptor(version2));
            }
        }
        catch (IncorrectOperationException e) {
            RefactoringUIUtil.processIncorrectOperation((Project)this.myProject, (IncorrectOperationException)e);
        }
        finally {
            psiMigration.finish();
        }
    }

    protected void performPsiSpoilingRefactoring() {
        this.postProcessClassMigrations(this.myClassMigrations);
        JavaCodeStyleManager styleManager = JavaCodeStyleManager.getInstance((Project)this.myProject);
        for (SmartPsiElementPointer<PsiElement> pointer : this.myRefsToShorten) {
            PsiElement element = pointer.getElement();
            if (element == null) continue;
            styleManager.shortenClassReferences(element);
            styleManager.optimizeImports(element.getContainingFile());
        }
    }

    @Nullable
    protected String getRefactoringId() {
        return "refactoring.migrate.to.appcompat";
    }

    @NotNull
    protected String getCommandName() {
        return AndroidBundle.message("android.refactoring.migratetoappcompat", new Object[0]);
    }

    protected boolean skipNonCodeUsages() {
        return true;
    }

    protected void refreshElements(@NotNull PsiElement[] elements) {
        this.finishMigration();
        this.myPsiMigration = this.startMigration(this.myProject);
    }

    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        if (((UsageInfo[])refUsages.get()).length == 0) {
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                Messages.showInfoMessage((Project)this.myProject, (String)RefactoringBundle.message((String)"migration.no.usages.found.in.the.project"), (String)AndroidBundle.message("android.refactoring.migratetoappcompat", new Object[0]));
            }
            return false;
        }
        this.setPreviewUsages(true);
        return true;
    }

    @Nullable
    protected RefactoringEventData getBeforeData() {
        RefactoringEventData data = new RefactoringEventData();
        data.addElements(this.myElements);
        return data;
    }

    @Nullable
    protected RefactoringEventData getAfterData(@NotNull UsageInfo[] usages) {
        RefactoringEventData data = new RefactoringEventData();
        data.addElements(this.myElements);
        return data;
    }

    Set<Module> computeModulesNeedingAppCompat() {
        ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myProject);
        Module[] sortedModules = moduleManager.getSortedModules();
        SmartHashSet modulesWithTransitiveAppCompat = new SmartHashSet();
        SmartHashSet modulesNeedingAppCompat = new SmartHashSet();
        for (Module module : sortedModules) {
            AndroidModuleModel model2 = AndroidModuleModel.get(module);
            if (model2 == null) continue;
            if (!(modulesWithTransitiveAppCompat.contains(module) || DependencyManagementUtil.dependsOn(module, GoogleMavenArtifactId.APP_COMPAT_V7) || DependencyManagementUtil.dependsOn(module, GoogleMavenArtifactId.ANDROIDX_APP_COMPAT_V7))) {
                modulesNeedingAppCompat.add(module);
                modulesWithTransitiveAppCompat.add(module);
            }
            modulesWithTransitiveAppCompat.addAll(moduleManager.getModuleDependentModules(module));
        }
        return modulesNeedingAppCompat;
    }

    private void postProcessClassMigrations(List<MigrateToAppCompatUsageInfo.ClassMigrationUsageInfo> classMigrations) {
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)this.myProject);
        GlobalSearchScope scope = GlobalSearchScope.allScope((Project)this.myProject);
        PsiClass activityClass = psiFacade.findClass("android.app.Activity", scope);
        PsiClass fragmentActivityClass = psiFacade.findClass(CLASS_SUPPORT_FRAGMENT_ACTIVITY, scope);
        JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)this.myProject);
        classMigrations.stream().filter(u -> u.getElement() != null && u.getElement().isValid()).map(u -> u.getElement() == null ? null : u.getElement().getContainingFile()).filter(Objects::nonNull).distinct().forEach(psiFile -> {
            VirtualFile virtualFile = psiFile.getVirtualFile();
            if (this.myPsiFilesWithActivityImports.contains(virtualFile) && activityClass != null) {
                codeStyleManager.addImport((PsiJavaFile)psiFile, activityClass);
            } else if (this.myPsiFilesWithFragmentActivityImports.contains(virtualFile) && fragmentActivityClass != null) {
                codeStyleManager.addImport((PsiJavaFile)psiFile, fragmentActivityClass);
            }
            codeStyleManager.optimizeImports(psiFile);
        });
    }

    private static AppCompatStyleMigration createAppCompatStyleMigration(@NotNull Module[] modules, @NotNull BiFunction<GoogleMavenArtifactId, String, AppCompatStyleMigration> factory) {
        Predicate<GradleVersion> filter2;
        GoogleMavenArtifactId artifact;
        boolean dependsOnAndroidX = false;
        AndroidVersion highest = new AndroidVersion(21);
        for (Module module : modules) {
            String version2;
            dependsOnAndroidX |= DependencyManagementUtil.dependsOn(module, GoogleMavenArtifactId.ANDROIDX_APP_COMPAT_V7);
            GradleBuildModel build2 = GradleBuildModel.get(module);
            if (build2 == null || (version2 = build2.android().compileSdkVersion().toString()) == null) continue;
            try {
                AndroidVersion current = new AndroidVersion(StringUtil.trimStart((String)version2, (String)"android-"));
                if (current.compareTo(highest) <= 0) continue;
                highest = current;
            }
            catch (AndroidVersion.AndroidVersionException androidVersionException) {
                // empty catch block
            }
        }
        AndroidVersion finalAndroidVersion = highest;
        if (dependsOnAndroidX) {
            artifact = GoogleMavenArtifactId.ANDROIDX_APP_COMPAT_V7;
            filter2 = null;
        } else {
            artifact = GoogleMavenArtifactId.APP_COMPAT_V7;
            filter2 = v -> v.toString().startsWith(Integer.toString(finalAndroidVersion.getApiLevel()));
        }
        GradleVersion version3 = IdeGoogleMavenRepository.INSTANCE.findVersion(artifact.getMavenGroupId(), artifact.getMavenArtifactId(), filter2, artifact.isAndroidxLibrary() || finalAndroidVersion.isPreview());
        String defaultVersion = artifact.isAndroidxLibrary() ? "1.0.0-alpha1" : "26.1.0";
        return factory.apply(artifact, version3 == null ? defaultVersion : version3.toString());
    }

    private static class AppCompatLibraryDescriptor
    extends ExternalLibraryDescriptor {
        private AppCompatLibraryDescriptor(@Nullable String minVersion) {
            super(GoogleMavenArtifactId.APP_COMPAT_V7.getMavenGroupId(), GoogleMavenArtifactId.APP_COMPAT_V7.getMavenArtifactId(), minVersion, null);
        }

        @NotNull
        public List<String> getLibraryClassesRoots() {
            return Collections.emptyList();
        }
    }
}

