/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.refactoring;

import com.android.builder.model.AaptOptions;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.SingleNamespaceResourceRepository;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.api.ProjectBuildModel;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.google.common.base.Supplier;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMigration;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.impl.migration.PsiMigrationManager;
import com.intellij.psi.impl.source.xml.SchemaPrefixReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.ui.UsageViewDescriptorAdapter;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.Processor;
import com.intellij.util.text.StringKt;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.WrappingConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.android.dom.converters.AndroidResourceReference;
import org.jetbrains.android.dom.converters.ResourceReferenceConverter;
import org.jetbrains.android.dom.converters.StyleItemNameConverter;
import org.jetbrains.android.dom.resources.ResourceValue;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.IdeaSourceProvider;
import org.jetbrains.android.refactoring.AndroidRefactoringUtil;
import org.jetbrains.android.refactoring.CodeUsageInfo;
import org.jetbrains.android.refactoring.DomValueUsageInfo;
import org.jetbrains.android.refactoring.MigrateToResourceNamespacesKt;
import org.jetbrains.android.refactoring.MigrateToResourceNamespacesProcessor;
import org.jetbrains.android.refactoring.ResourceUsageInfo;
import org.jetbrains.android.refactoring.StyleItemUsageInfo;
import org.jetbrains.android.refactoring.XmlAttributeUsageInfo;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002J\u001b\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0014\u00a2\u0006\u0002\u0010\u0016J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0002J\u000e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0002J\u0018\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u000fH\u0002J\u000e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0002J\u0015\u0010\u001e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00150\u0014H\u0014\u00a2\u0006\u0002\u0010\u001fJ\u001e\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0003H\u0002J\b\u0010$\u001a\u00020\u000fH\u0016J\u001b\u0010%\u001a\u00020\u000b2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0014\u00a2\u0006\u0002\u0010&J\u001c\u0010'\u001a\u00020(2\u0012\u0010)\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u00140*H\u0014R\u001c\u0010\u0005\u001a\u0010\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00030\u00030\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \u0007*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lorg/jetbrains/android/refactoring/MigrateToResourceNamespacesProcessor;", "Lcom/intellij/refactoring/BaseRefactoringProcessor;", "invokingFacet", "Lorg/jetbrains/android/facet/AndroidFacet;", "(Lorg/jetbrains/android/facet/AndroidFacet;)V", "allFacets", "", "kotlin.jvm.PlatformType", "elementFactory", "Lcom/intellij/psi/XmlElementFactory;", "addXmlnsDeclaration", "", "tag", "Lcom/intellij/psi/xml/XmlTag;", "prefix", "", "uri", "createUsageViewDescriptor", "Lcom/intellij/usageView/UsageViewDescriptor;", "usages", "", "Lcom/intellij/usageView/UsageInfo;", "([Lcom/intellij/usageView/UsageInfo;)Lcom/intellij/usageView/UsageViewDescriptor;", "findCodeUsages", "", "Lorg/jetbrains/android/refactoring/ResourceUsageInfo;", "findManifestUsages", "findOrCreateNamespacePrefix", "inferredPackage", "findResUsages", "findUsages", "()[Lcom/intellij/usageView/UsageInfo;", "findXmlUsages", "xmlFile", "Lcom/intellij/psi/xml/XmlFile;", "currentFacet", "getCommandName", "performRefactoring", "([Lcom/intellij/usageView/UsageInfo;)V", "preprocessUsages", "", "refUsages", "Lcom/intellij/openapi/util/Ref;", "intellij.android.core"})
public final class MigrateToResourceNamespacesProcessor
extends BaseRefactoringProcessor {
    private final List<AndroidFacet> allFacets;
    private final XmlElementFactory elementFactory;
    private final AndroidFacet invokingFacet;

    @NotNull
    public String getCommandName() {
        return "Migrate to resource namespaces";
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected UsageInfo[] findUsages() {
        ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
        progressIndicator.setText("Analyzing XML resource files...");
        List result2 = new ArrayList();
        Collection collection = result2;
        Iterable iterable = this.findResUsages();
        CollectionsKt.addAll((Collection)collection, (Iterable)iterable);
        progressIndicator.setText("Analyzing manifest files...");
        collection = result2;
        iterable = this.findManifestUsages();
        CollectionsKt.addAll((Collection)collection, (Iterable)iterable);
        progressIndicator.setText("Analyzing code files...");
        collection = result2;
        iterable = this.findCodeUsages();
        CollectionsKt.addAll((Collection)collection, (Iterable)iterable);
        progressIndicator.setText("Inferring namespaces...");
        progressIndicator.setText2((String)null);
        Collection leafRepos = ResourceRepositoryManager.getAppResources(this.invokingFacet).getLeafResourceRepositories();
        Table inferredNamespaces2 = Tables.newCustomTable((Map)Maps.newEnumMap(ResourceType.class), (Supplier)findUsages.inferredNamespaces.1.INSTANCE);
        double total = result2.size();
        Iterable $receiver$iv = result2;
        int index$iv = 0;
        for (Object item$iv : $receiver$iv) {
            void resourceUsageInfo;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            int n2 = n;
            ResourceUsageInfo resourceUsageInfo2 = (ResourceUsageInfo)((Object)item$iv);
            int index = n2;
            boolean bl = false;
            ProgressManager.checkCanceled();
            resourceUsageInfo.setInferredPackage((String)inferredNamespaces2.row((Object)resourceUsageInfo.getResourceType()).computeIfAbsent(resourceUsageInfo.getName(), (Function)new Function<String, String>((ResourceUsageInfo)resourceUsageInfo, inferredNamespaces2, leafRepos, progressIndicator, total){
                final /* synthetic */ ResourceUsageInfo $resourceUsageInfo;
                final /* synthetic */ Table $inferredNamespaces$inlined;
                final /* synthetic */ Collection $leafRepos$inlined;
                final /* synthetic */ ProgressIndicator $progressIndicator$inlined;
                final /* synthetic */ double $total$inlined;
                {
                    this.$resourceUsageInfo = resourceUsageInfo;
                    this.$inferredNamespaces$inlined = table2;
                    this.$leafRepos$inlined = collection;
                    this.$progressIndicator$inlined = progressIndicator;
                    this.$total$inlined = d;
                }

                @Nullable
                public final String apply(String it) {
                    for (SingleNamespaceResourceRepository repo : this.$leafRepos$inlined) {
                        if (!repo.hasResources(ResourceNamespace.RES_AUTO, this.$resourceUsageInfo.getResourceType(), this.$resourceUsageInfo.getName())) continue;
                        SingleNamespaceResourceRepository singleNamespaceResourceRepository = repo;
                        if (singleNamespaceResourceRepository == null) {
                            throw new TypeCastException("null cannot be cast to non-null type com.android.ide.common.resources.SingleNamespaceResourceRepository");
                        }
                        return singleNamespaceResourceRepository.getPackageName();
                    }
                    return null;
                }
            }));
            progressIndicator.setFraction((double)(index + 1) / total);
        }
        Iterable thisCollection$iv = $receiver$iv = (Collection)result2;
        ResourceUsageInfo[] resourceUsageInfoArray = thisCollection$iv.toArray(new ResourceUsageInfo[0]);
        if (resourceUsageInfoArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return resourceUsageInfoArray;
    }

    private final Collection<ResourceUsageInfo> findResUsages() {
        List result2 = new ArrayList();
        PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
        for (AndroidFacet facet : this.allFacets) {
            ResourceRepositoryManager repositoryManager = ResourceRepositoryManager.getInstance(facet);
            if (repositoryManager.getNamespacing() != AaptOptions.Namespacing.DISABLED) continue;
            for (VirtualFile resourceDir : repositoryManager.getModuleResources().getResourceDirs()) {
                VfsUtil.processFilesRecursively((VirtualFile)resourceDir, (Processor)((Processor)new Processor<VirtualFile>(this, psiManager, result2, facet){
                    final /* synthetic */ MigrateToResourceNamespacesProcessor this$0;
                    final /* synthetic */ PsiManager $psiManager;
                    final /* synthetic */ List $result;
                    final /* synthetic */ AndroidFacet $facet;

                    public final boolean process(VirtualFile vf) {
                        PsiFile psiFile;
                        if (Intrinsics.areEqual((Object)vf.getFileType(), (Object)StdFileTypes.XML) && (psiFile = this.$psiManager.findFile(vf)) instanceof XmlFile) {
                            Collection collection = this.$result;
                            Iterable iterable = MigrateToResourceNamespacesProcessor.access$findXmlUsages(this.this$0, (XmlFile)psiFile, this.$facet);
                            CollectionsKt.addAll((Collection)collection, (Iterable)iterable);
                        }
                        return true;
                    }
                    {
                        this.this$0 = migrateToResourceNamespacesProcessor;
                        this.$psiManager = psiManager;
                        this.$result = list;
                        this.$facet = androidFacet;
                    }
                }));
            }
        }
        return result2;
    }

    private final Collection<ResourceUsageInfo> findManifestUsages() {
        PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
        List result2 = new ArrayList();
        for (AndroidFacet facet : this.allFacets) {
            Collection collection = result2;
            Sequence sequence = SequencesKt.flatMap((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)IdeaSourceProvider.getCurrentSourceProviders(facet)), (Function1)findManifestUsages.1.INSTANCE), (Function1)((Function1)new Function1<VirtualFile, XmlFile>(psiManager){
                final /* synthetic */ PsiManager $psiManager;

                @Nullable
                public final XmlFile invoke(@NotNull VirtualFile it) {
                    PsiFile psiFile = this.$psiManager.findFile(it);
                    if (!(psiFile instanceof XmlFile)) {
                        psiFile = null;
                    }
                    return (XmlFile)psiFile;
                }
                {
                    this.$psiManager = psiManager;
                    super(1);
                }
            })), (Function1)((Function1)new Function1<XmlFile, Sequence<? extends ResourceUsageInfo>>(this, facet){
                final /* synthetic */ MigrateToResourceNamespacesProcessor this$0;
                final /* synthetic */ AndroidFacet $facet;

                @NotNull
                public final Sequence<ResourceUsageInfo> invoke(@NotNull XmlFile it) {
                    return CollectionsKt.asSequence((Iterable)MigrateToResourceNamespacesProcessor.access$findXmlUsages(this.this$0, it, this.$facet));
                }
                {
                    this.this$0 = migrateToResourceNamespacesProcessor;
                    this.$facet = androidFacet;
                    super(1);
                }
            }));
            CollectionsKt.addAll((Collection)collection, (Sequence)sequence);
        }
        return result2;
    }

    private final Collection<ResourceUsageInfo> findXmlUsages(XmlFile xmlFile, AndroidFacet currentFacet) {
        ProgressManager.checkCanceled();
        ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
        progressIndicator.setText2(xmlFile.getVirtualFile().getPath());
        List result2 = new ArrayList();
        DomManager domManager = DomManager.getDomManager((Project)this.myProject);
        LocalResourceRepository moduleRepo = ResourceRepositoryManager.getModuleResources(currentFacet);
        Function2<ResourceType, String, Boolean> referenceNeedsRewriting$ = new Function2<ResourceType, String, Boolean>(moduleRepo){
            final /* synthetic */ LocalResourceRepository $moduleRepo;

            public final boolean invoke(@NotNull ResourceType resourceType, @NotNull String name) {
                return !this.$moduleRepo.hasResources(ResourceNamespace.RES_AUTO, resourceType, name);
            }
            {
                this.$moduleRepo = localResourceRepository;
                super(2);
            }
        };
        xmlFile.accept((PsiElementVisitor)new XmlRecursiveElementVisitor(domManager, result2, referenceNeedsRewriting$){
            final /* synthetic */ DomManager $domManager;
            final /* synthetic */ List $result;
            final /* synthetic */ findXmlUsages.1 $referenceNeedsRewriting$1;

            public void visitXmlTag(@NotNull XmlTag tag) {
                DomElement domElement = this.$domManager.getDomElement(tag);
                if (domElement instanceof GenericDomValue) {
                    this.handleGenericDomValue((GenericDomValue)domElement, (XmlElement)tag);
                }
                super.visitXmlTag(tag);
            }

            public void visitXmlAttribute(@NotNull XmlAttribute attribute) {
                GenericAttributeValue domElement = this.$domManager.getDomElement(attribute);
                if (domElement instanceof GenericDomValue) {
                    if (Intrinsics.areEqual((Object)attribute.getNamespace(), (Object)"http://schemas.android.com/apk/res-auto")) {
                        Collection collection = this.$result;
                        XmlAttributeUsageInfo xmlAttributeUsageInfo = new XmlAttributeUsageInfo(attribute);
                        collection.add(xmlAttributeUsageInfo);
                    }
                    this.handleGenericDomValue((GenericDomValue)domElement, (XmlElement)attribute);
                }
                super.visitXmlAttribute(attribute);
            }

            private final void handleGenericDomValue(GenericDomValue<?> domValue, XmlElement sourceXmlElement) {
                block10: {
                    Object object;
                    String string;
                    XmlElement psiElement;
                    block12: {
                        block11: {
                            Converter converter;
                            block9: {
                                Converter converter2 = WrappingConverter.getDeepestConverter((Converter)domValue.getConverter(), domValue);
                                XmlElement xmlElement = DomUtil.getValueElement(domValue);
                                if (xmlElement == null) {
                                    return;
                                }
                                psiElement = xmlElement;
                                converter = converter2;
                                if (!(converter instanceof ResourceReferenceConverter)) break block9;
                                for (PsiReference reference2 : psiElement.getReferences()) {
                                    String name;
                                    ResourceType resourceType;
                                    ResourceValue resourceValue2;
                                    if (!(reference2 instanceof AndroidResourceReference) || (resourceValue2 = ((AndroidResourceReference)reference2).getResourceValue()).getPackage() != null) continue;
                                    String string2 = resourceValue2.getResourceType();
                                    if (string2 != null && StringsKt.startsWith$default((CharSequence)string2, (char)'+', (boolean)false, (int)2, null)) continue;
                                    if (StringKt.nullize((String)resourceValue2.getResourceName(), (boolean)true) == null) {
                                        continue;
                                    }
                                    if (resourceValue2.getType() == null) {
                                        continue;
                                    }
                                    if (!this.$referenceNeedsRewriting$1.invoke(resourceType, name)) continue;
                                    Collection collection = this.$result;
                                    DomValueUsageInfo domValueUsageInfo = new DomValueUsageInfo(resourceValue2, (ResourceReferenceConverter)converter2, reference2, sourceXmlElement);
                                    collection.add(domValueUsageInfo);
                                }
                                break block10;
                            }
                            if (!(converter instanceof StyleItemNameConverter)) break block10;
                            string = domValue.getStringValue();
                            if (string == null) break block11;
                            object = string;
                            String p1 = object;
                            boolean bl = false;
                            string = ResourceUrl.parseAttrReference((String)p1);
                            if (string != null) break block12;
                        }
                        return;
                    }
                    String url = string;
                    if (((ResourceUrl)url).namespace == null && this.$referenceNeedsRewriting$1.invoke(((ResourceUrl)url).type, ((ResourceUrl)url).name)) {
                        PsiElement psiElement2;
                        object = this.$result;
                        PsiElement $receiver$iv = (PsiElement)psiElement;
                        boolean $i$f$parentOfType = false;
                        PsiElement psiElement3 = psiElement2 = PsiTreeUtilKt.parentOfType((PsiElement)$receiver$iv, (KClass[])new KClass[]{Reflection.getOrCreateKotlinClass(XmlAttribute.class)});
                        if (psiElement3 == null) {
                            Intrinsics.throwNpe();
                        }
                        String string3 = url;
                        XmlAttribute xmlAttribute = (XmlAttribute)psiElement3;
                        StyleItemUsageInfo styleItemUsageInfo = new StyleItemUsageInfo(xmlAttribute, (ResourceUrl)string3);
                        object.add(styleItemUsageInfo);
                    }
                }
            }
            {
                this.$domManager = $captured_local_variable$0;
                this.$result = $captured_local_variable$1;
                this.$referenceNeedsRewriting$1 = $captured_local_variable$2;
            }
        });
        progressIndicator.setText2((String)null);
        return result2;
    }

    private final Collection<ResourceUsageInfo> findCodeUsages() {
        List result2 = new ArrayList();
        for (AndroidFacet facet : this.allFacets) {
            LocalResourceRepository moduleRepo = ResourceRepositoryManager.getModuleResources(facet);
            Collection<? extends PsiClass> rClasses = ProjectSystemUtil.getProjectSystem(this.myProject).getLightResourceClassService().getLightRClassesAccessibleFromModule(facet.getModule(), false);
            GlobalSearchScope scope = facet.getModule().getModuleScope();
            for (PsiClass psiClass : rClasses) {
                for (PsiReference psiReference : ReferencesSearch.search((PsiElement)((PsiElement)psiClass), (SearchScope)((SearchScope)scope))) {
                    String name;
                    ResourceType resourceType;
                    PsiReferenceExpression nameRef;
                    PsiReferenceExpression typeRef;
                    PsiReferenceExpression classRef;
                    PsiElement psiElement = psiReference.getElement();
                    if (!(psiElement instanceof PsiReferenceExpression)) {
                        psiElement = null;
                    }
                    if ((PsiReferenceExpression)psiElement == null) {
                        continue;
                    }
                    PsiElement psiElement2 = classRef.getParent();
                    if (!(psiElement2 instanceof PsiReferenceExpression)) {
                        psiElement2 = null;
                    }
                    if ((PsiReferenceExpression)psiElement2 == null) {
                        continue;
                    }
                    PsiElement psiElement3 = typeRef.getParent();
                    if (!(psiElement3 instanceof PsiReferenceExpression)) {
                        psiElement3 = null;
                    }
                    if ((PsiReferenceExpression)psiElement3 == null) {
                        continue;
                    }
                    if (Intrinsics.areEqual((Object)nameRef.getQualifierExpression(), (Object)typeRef) ^ true || Intrinsics.areEqual((Object)typeRef.getQualifierExpression(), (Object)classRef) ^ true) continue;
                    if (nameRef.getReferenceName() == null) {
                        continue;
                    }
                    String string = typeRef.getReferenceName();
                    if (string == null) {
                        continue;
                    }
                    if (ResourceType.fromClassName((String)string) == null) {
                        continue;
                    }
                    if (moduleRepo.hasResources(ResourceNamespace.RES_AUTO, resourceType, name)) continue;
                    Collection collection = result2;
                    CodeUsageInfo codeUsageInfo = new CodeUsageInfo((PsiElement)nameRef, psiReference, resourceType, name);
                    collection.add(codeUsageInfo);
                }
            }
        }
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void performRefactoring(@NotNull UsageInfo[] usages) {
        ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
        progressIndicator.setIndeterminate(false);
        progressIndicator.setText("Rewriting resource references...");
        PsiMigration psiMigration = PsiMigrationManager.getInstance((Project)this.myProject).startMigration();
        try {
            double totalUsages = usages.length;
            UsageInfo[] $receiver$iv = usages;
            int index$iv = 0;
            for (UsageInfo item$iv : $receiver$iv) {
                int index;
                block20: {
                    PsiReference psiReference;
                    String prefix;
                    block21: {
                        int n;
                        PsiReference[] psiReferenceArray;
                        block25: {
                            String inferredPackage;
                            void var16_26;
                            void usageInfo;
                            block24: {
                                PsiReference[] psiReferenceArray2;
                                XmlAttribute element;
                                PsiReference[] namespace;
                                block23: {
                                    XmlTag xmlTag;
                                    int n2 = index$iv++;
                                    UsageInfo usageInfo2 = item$iv;
                                    index = n2;
                                    boolean bl = false;
                                    if (!(usageInfo instanceof ResourceUsageInfo)) {
                                        String string = "Don't know how to handle " + usageInfo.getClass().getName() + '.';
                                        throw (Throwable)new IllegalStateException(string.toString());
                                    }
                                    if (((ResourceUsageInfo)usageInfo).getInferredPackage() == null) continue;
                                    var16_26 = usageInfo;
                                    if (!(var16_26 instanceof DomValueUsageInfo)) break block23;
                                    XmlElement xmlElement = ((DomValueUsageInfo)usageInfo).getXmlElement();
                                    XmlElement xmlElement2 = xmlElement;
                                    if (xmlElement2 instanceof XmlTag) {
                                        xmlTag = (XmlTag)xmlElement;
                                    } else {
                                        if (!(xmlElement2 instanceof XmlAttribute)) continue;
                                        xmlTag = ((XmlAttribute)xmlElement).getParent();
                                    }
                                    XmlTag tag = xmlTag;
                                    namespace = this.findOrCreateNamespacePrefix(tag, inferredPackage);
                                    ResourceValue resourceValue2 = ((DomValueUsageInfo)usageInfo).getResourceValue();
                                    String string = ((DomValueUsageInfo)usageInfo).getConverter().toString(ResourceValue.referenceTo(resourceValue2.getPrefix(), (String)namespace, resourceValue2.getResourceType(), resourceValue2.getResourceName()), null);
                                    if (string == null) {
                                        string = "";
                                    }
                                    String newStringValue = string;
                                    XmlElement xmlElement3 = xmlElement;
                                    if (xmlElement3 instanceof XmlTag) {
                                        ((XmlTag)xmlElement).getValue().setText(newStringValue);
                                        break block20;
                                    } else {
                                        if (!(xmlElement3 instanceof XmlAttribute)) {
                                            String string2 = "Don't know how to handle " + xmlElement;
                                            throw (Throwable)new IllegalStateException(string2.toString());
                                        }
                                        ((XmlAttribute)xmlElement).setValue(newStringValue);
                                    }
                                    break block20;
                                }
                                if (!(var16_26 instanceof XmlAttributeUsageInfo)) break block24;
                                PsiElement psiElement = ((XmlAttributeUsageInfo)usageInfo).getElement();
                                if (!(psiElement instanceof XmlAttribute)) {
                                    psiElement = null;
                                }
                                if ((XmlAttribute)psiElement == null) continue;
                                prefix = this.findOrCreateNamespacePrefix(element.getParent(), inferredPackage);
                                psiReferenceArray = psiReferenceArray2 = (namespace = element.getReferences());
                                n = psiReferenceArray.length;
                                break block25;
                            }
                            if (var16_26 instanceof StyleItemUsageInfo) {
                                XmlTag tag = ((StyleItemUsageInfo)usageInfo).getXmlAttribute().getParent();
                                prefix = this.findOrCreateNamespacePrefix(tag, inferredPackage);
                                ResourceUrl newUrl = ResourceUrl.create((String)prefix, (ResourceType)ResourceType.ATTR, (String)((ResourceUsageInfo)usageInfo).getName());
                                ((StyleItemUsageInfo)usageInfo).getXmlAttribute().setValue(newUrl.getQualifiedName());
                                break block20;
                            } else if (var16_26 instanceof CodeUsageInfo) {
                                PsiReference reference2 = ((CodeUsageInfo)usageInfo).getClassReference();
                                reference2.bindToElement((PsiElement)AndroidRefactoringUtil.findOrCreateClass(this.myProject, psiMigration, AndroidResourceUtil.packageToRClass(inferredPackage), reference2.getElement().getResolveScope()));
                            }
                            break block20;
                        }
                        for (int j = 0; j < n; ++j) {
                            PsiReference psiReference2;
                            PsiReference it = psiReference2 = psiReferenceArray[j];
                            boolean bl = false;
                            if (!(it instanceof SchemaPrefixReference)) continue;
                            psiReference = psiReference2;
                            break block21;
                        }
                        psiReference = null;
                    }
                    if (psiReference != null) {
                        psiReference.handleElementRename(prefix);
                    }
                }
                progressIndicator.setFraction((double)(index + 1) / totalUsages);
            }
        }
        finally {
            psiMigration.finish();
        }
        progressIndicator.setText("Updating Gradle build files...");
        progressIndicator.setFraction(0.0);
        ProjectBuildModel projectBuildModel = ProjectBuildModel.get(this.myProject);
        double totalFacets = this.allFacets.size();
        Iterable $receiver$iv = this.allFacets;
        int index$iv = 0;
        Iterator iterator = $receiver$iv.iterator();
        while (true) {
            GradleBuildModel moduleBuildModel;
            void facet;
            int n;
            if (!iterator.hasNext()) {
                AndroidRefactoringUtil.syncBeforeFinishingRefactoring(this.myProject, GradleSyncStats.Trigger.TRIGGER_REFACTOR_MIGRATE_TO_RESOURCE_NAMESPACES);
                return;
            }
            Object item$iv = iterator.next();
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            int n3 = n;
            AndroidFacet index = (AndroidFacet)((Object)item$iv);
            int index2 = n3;
            boolean bl = false;
            if (projectBuildModel.getModuleBuildModel(facet.getModule()) == null) continue;
            moduleBuildModel.android().aaptOptions().namespaced().setValue(true);
            moduleBuildModel.applyChanges();
            progressIndicator.setFraction((double)(index2 + 1) / totalFacets);
        }
    }

    private final String findOrCreateNamespacePrefix(XmlTag tag, String inferredPackage) {
        String string = tag.getPrefixByNamespace("http://schemas.android.com/apk/res/" + inferredPackage);
        if (string == null) {
            MigrateToResourceNamespacesProcessor migrateToResourceNamespacesProcessor;
            MigrateToResourceNamespacesProcessor $receiver = migrateToResourceNamespacesProcessor = this;
            boolean bl = false;
            String newPrefix = MigrateToResourceNamespacesKt.access$choosePrefix(inferredPackage);
            CharSequence charSequence = tag.getNamespaceByPrefix(newPrefix);
            if (charSequence.length() > 0) {
                CharSequence charSequence2;
                int i2 = 2;
                while ((charSequence2 = (CharSequence)tag.getNamespaceByPrefix(newPrefix + i2)).length() > 0) {
                    ++i2;
                }
                newPrefix = newPrefix + i2;
            }
            PsiElement $receiver$iv = (PsiElement)tag;
            boolean $i$f$parentOfType = false;
            XmlDocument xmlDocument = (XmlDocument)PsiTreeUtilKt.parentOfType((PsiElement)$receiver$iv, (KClass[])new KClass[]{Reflection.getOrCreateKotlinClass(XmlDocument.class)});
            if (xmlDocument != null && (xmlDocument = xmlDocument.getRootTag()) != null) {
                CharSequence it = charSequence = xmlDocument;
                boolean bl2 = false;
                $receiver.addXmlnsDeclaration((XmlTag)it, newPrefix, "http://schemas.android.com/apk/res/" + inferredPackage);
            }
            string = newPrefix;
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final void addXmlnsDeclaration(XmlTag tag, String prefix, String uri) {
        Object v0;
        XmlTag xmlTag;
        PsiElement psiElement;
        block1: {
            void $receiver$iv;
            XmlAttribute[] xmlAttributeArray = tag.getAttributes();
            psiElement = (PsiElement)this.elementFactory.createAttribute("xmlns:" + prefix, uri, (PsiElement)tag);
            xmlTag = tag;
            void var5_7 = $receiver$iv;
            int n = ((void)var5_7).length;
            for (int j = 0; j < n; ++j) {
                void element$iv;
                void it = element$iv = var5_7[j];
                boolean bl = false;
                if (!(Intrinsics.areEqual((Object)it.getNamespacePrefix(), (Object)"xmlns") ^ true)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        Object var14_13 = v0;
        xmlTag.addBefore(psiElement, (PsiElement)var14_13);
    }

    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        boolean bl;
        Object[] objectArray = (Object[])refUsages.get();
        Object[] objectArray2 = objectArray;
        if (!(objectArray2.length == 0)) {
            bl = true;
        } else {
            Messages.showInfoMessage((Project)this.myProject, (String)"No cross-namespace resource references found", (String)"Migrate to resource namespaces");
            bl = false;
        }
        return bl;
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usages) {
        return (UsageViewDescriptor)new UsageViewDescriptorAdapter(){

            @NotNull
            public PsiElement[] getElements() {
                return PsiElement.EMPTY_ARRAY;
            }

            @NotNull
            public String getProcessedElementsHeader() {
                return "Resource references to migrate";
            }
        };
    }

    public MigrateToResourceNamespacesProcessor(@NotNull AndroidFacet invokingFacet) {
        super(invokingFacet.getModule().getProject());
        this.invokingFacet = invokingFacet;
        this.allFacets = CollectionsKt.plus((Collection)AndroidUtils.getAllAndroidDependencies(this.invokingFacet.getModule(), true), (Object)((Object)this.invokingFacet));
        this.elementFactory = XmlElementFactory.getInstance((Project)this.myProject);
    }

    public static final /* synthetic */ Collection access$findXmlUsages(MigrateToResourceNamespacesProcessor $this, XmlFile xmlFile, AndroidFacet currentFacet) {
        return $this.findXmlUsages(xmlFile, currentFacet);
    }
}

