/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.resourceManagers;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.resources.SingleNamespaceResourceRepository;
import com.android.resources.ResourceType;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.xml.ConvertContext;
import java.util.Collection;
import java.util.List;
import org.jetbrains.android.dom.attrs.AttributeDefinitions;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.resourceManagers.ModuleResourceManagers;
import org.jetbrains.android.resourceManagers.ResourceManager;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FrameworkResourceManager
extends ResourceManager {
    @NotNull
    private final Module myModule;
    private final boolean myPublicOnly;

    public FrameworkResourceManager(@NotNull Module module, boolean publicOnly) {
        super(module.getProject());
        this.myModule = module;
        this.myPublicOnly = publicOnly;
    }

    @Override
    public boolean isResourcePublic(@NotNull String type, @NotNull String name) {
        AndroidPlatform platform = this.getPlatform();
        if (platform == null) {
            return false;
        }
        return !this.myPublicOnly || platform.getSdkData().getTargetData(platform.getTarget()).isResourcePublic(type, name);
    }

    @Nullable
    private VirtualFile getResourceDir() {
        AndroidPlatform platform = this.getPlatform();
        if (platform == null) {
            return null;
        }
        String resPath = platform.getTarget().getPath(11);
        resPath = FileUtil.toSystemIndependentName((String)resPath);
        return LocalFileSystem.getInstance().findFileByPath(resPath);
    }

    @Override
    public boolean isResourceDir(@NotNull VirtualFile dir) {
        return dir.equals(this.getResourceDir());
    }

    @Nullable
    public static FrameworkResourceManager getInstance(@NotNull ConvertContext context) {
        AndroidFacet facet = AndroidFacet.getInstance(context);
        return facet != null ? ModuleResourceManagers.getInstance(facet).getFrameworkResourceManager() : null;
    }

    @Override
    @Nullable
    public AttributeDefinitions getAttributeDefinitions() {
        AndroidPlatform platform = this.getPlatform();
        if (platform == null) {
            return null;
        }
        return platform.getSdkData().getTargetData(platform.getTarget()).getPublicAttrDefs(this.myProject);
    }

    @Override
    @NotNull
    protected Collection<SingleNamespaceResourceRepository> getLeafResourceRepositories() {
        ResourceRepository repository = this.getResourceRepository();
        return repository == null ? ImmutableList.of() : repository.getLeafResourceRepositories();
    }

    @Override
    @NotNull
    protected List<ResourceItem> getResources(@NotNull ResourceNamespace namespace, @NotNull ResourceType resourceType, @NotNull String resName) {
        ResourceRepository repository = this.getResourceRepository();
        return repository == null ? ImmutableList.of() : repository.getResources(namespace, resourceType, resName);
    }

    @Nullable
    private ResourceRepository getResourceRepository() {
        ResourceRepositoryManager repositoryManager = ResourceRepositoryManager.getInstance(this.myModule);
        return repositoryManager == null ? null : repositoryManager.getFrameworkResources(false);
    }

    @Nullable
    private AndroidPlatform getPlatform() {
        return AndroidPlatform.getInstance(this.myModule);
    }
}

