/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.resourceManagers;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.resources.SingleNamespaceResourceRepository;
import com.android.resources.FolderTypeRelationship;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.idea.res.ResourceHelper;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.jetbrains.android.dom.attrs.AttributeDefinitions;
import org.jetbrains.android.dom.resources.ResourceElement;
import org.jetbrains.android.dom.wrappers.FileResourceElementWrapper;
import org.jetbrains.android.dom.wrappers.LazyValueResourceElementWrapper;
import org.jetbrains.android.resourceManagers.ValueResourceInfo;
import org.jetbrains.android.resourceManagers.ValueResourceInfoImpl;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ResourceManager {
    protected final Project myProject;

    protected ResourceManager(@NotNull Project project) {
        this.myProject = project;
    }

    public abstract boolean isResourceDir(@NotNull VirtualFile var1);

    @Nullable
    public abstract AttributeDefinitions getAttributeDefinitions();

    public boolean isResourcePublic(@NotNull String type, @NotNull String name) {
        return true;
    }

    @Nullable
    public ResourceType getValueResourceType(@NotNull XmlTag tag) {
        ResourceFolderType fileResType = this.getFileResourceFolderType(tag.getContainingFile());
        if (ResourceFolderType.VALUES == fileResType) {
            return AndroidResourceUtil.getResourceTypeForResourceTag(tag);
        }
        return null;
    }

    @Nullable
    public ResourceFolderType getFileResourceFolderType(@NotNull PsiFile file) {
        return (ResourceFolderType)ApplicationManager.getApplication().runReadAction(() -> {
            PsiDirectory dir = file.getContainingDirectory();
            if (dir == null) {
                return null;
            }
            PsiDirectory possibleResDir = dir.getParentDirectory();
            if (possibleResDir == null || !this.isResourceDir(possibleResDir.getVirtualFile())) {
                return null;
            }
            return ResourceFolderType.getFolderType((String)dir.getName());
        });
    }

    @Nullable
    public String getFileResourceType(@NotNull PsiFile file) {
        ResourceFolderType folderType = this.getFileResourceFolderType(file);
        return folderType == null ? null : folderType.getName();
    }

    @NotNull
    public List<XmlAttributeValue> findIdDeclarations(@NotNull ResourceNamespace namespace, @NotNull String id) {
        if (!this.isResourcePublic(ResourceType.ID.getName(), id)) {
            return Collections.emptyList();
        }
        Set<VirtualFile> files2 = this.getFilesDeclaringId(namespace, id);
        return this.findIdUsagesFromFiles(files2, attributeValue -> {
            if (AndroidResourceUtil.isIdDeclaration(attributeValue)) {
                String value2 = attributeValue.getValue();
                String idInAttr = AndroidResourceUtil.getResourceNameByReferenceText(value2);
                return id.equals(idInAttr);
            }
            return false;
        });
    }

    @NotNull
    public List<XmlAttributeValue> findConstraintReferencedIds(@NotNull ResourceNamespace namespace, @NotNull String id) {
        if (!this.isResourcePublic(ResourceType.ID.getName(), id)) {
            return Collections.emptyList();
        }
        Set<VirtualFile> files2 = this.getFilesDeclaringId(namespace, id);
        return this.findIdUsagesFromFiles(files2, attributeValue -> {
            if (AndroidResourceUtil.isConstraintReferencedIds(attributeValue)) {
                String ids = attributeValue.getValue();
                return ArrayUtil.indexOf((Object[])ids.split(","), (Object)id) >= 0;
            }
            return false;
        });
    }

    @NotNull
    private Set<VirtualFile> getFilesDeclaringId(@NotNull ResourceNamespace namespace, @NotNull String id) {
        HashSet<VirtualFile> files2 = new HashSet<VirtualFile>();
        for (ResourceRepository resourceRepository : this.getLeafResourceRepositories()) {
            List items2 = resourceRepository.getResources(namespace, ResourceType.ID, id);
            for (ResourceItem item : items2) {
                VirtualFile file = ResourceHelper.getSourceAsVirtualFile(item);
                if (file == null) continue;
                files2.add(file);
            }
        }
        return files2;
    }

    private List<XmlAttributeValue> findIdUsagesFromFiles(@NotNull Set<VirtualFile> fileSet, final @NotNull Predicate<XmlAttributeValue> condition) {
        final ArrayList<XmlAttributeValue> usages = new ArrayList<XmlAttributeValue>();
        PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
        for (VirtualFile file : fileSet) {
            PsiFile psiFile;
            if (!fileSet.contains(file) || !((psiFile = psiManager.findFile(file)) instanceof XmlFile)) continue;
            psiFile.accept((PsiElementVisitor)new XmlRecursiveElementVisitor(){

                public void visitXmlAttributeValue(XmlAttributeValue attributeValue) {
                    if (condition.test(attributeValue)) {
                        usages.add(attributeValue);
                    }
                }
            });
        }
        return usages;
    }

    public List<ResourceElement> findValueResources(@NotNull ResourceNamespace namespace, @NotNull String resType, @NotNull String resName) {
        return this.findValueResources(namespace, resType, resName, true);
    }

    @NotNull
    public List<ResourceElement> findValueResources(@NotNull ResourceNamespace namespace, @NotNull String resourceType, @NotNull String resourceName, boolean distinguishDelimitersInName) {
        List<ValueResourceInfoImpl> resources = this.findValueResourceInfos(namespace, resourceType, resourceName, distinguishDelimitersInName, false);
        ArrayList<ResourceElement> result2 = new ArrayList<ResourceElement>();
        for (ValueResourceInfoImpl resource : resources) {
            ResourceElement domElement = resource.computeDomElement();
            if (domElement == null) continue;
            result2.add(domElement);
        }
        return result2;
    }

    public void collectLazyResourceElements(@NotNull ResourceNamespace namespace, @NotNull String resType, @NotNull String resName, boolean withAttrs, @NotNull PsiElement context, @NotNull Collection<PsiElement> elements) {
        List<ValueResourceInfoImpl> valueResources = this.findValueResourceInfos(namespace, resType, resName, false, withAttrs);
        for (ValueResourceInfo valueResourceInfo : valueResources) {
            elements.add((PsiElement)new LazyValueResourceElementWrapper(valueResourceInfo, context));
        }
        ResourceType resourceType = ResourceType.fromClassName((String)resType);
        if (resourceType != null) {
            if (resourceType == ResourceType.ID) {
                elements.addAll(this.findIdDeclarations(namespace, resName));
            } else if (FolderTypeRelationship.getNonValuesRelatedFolder((ResourceType)resourceType) != null) {
                List<ResourceItem> list = this.getResources(namespace, resourceType, resName);
                for (ResourceItem resource : list) {
                    PsiFile psiFile;
                    VirtualFile file;
                    if (!resource.isFileBased() || (file = ResourceHelper.getSourceAsVirtualFile(resource)) == null || (psiFile = PsiManager.getInstance((Project)this.myProject).findFile(file)) == null) continue;
                    elements.add(new FileResourceElementWrapper(psiFile));
                }
            }
        }
    }

    @NotNull
    public List<ValueResourceInfoImpl> findValueResourceInfos(@NotNull ResourceNamespace namespace, @NotNull String resourceType, @NotNull String resourceName, boolean distinguishDelimitersInName, boolean searchAttrs) {
        ResourceType type;
        ResourceType resourceType2 = type = resourceType.startsWith("+") ? ResourceType.ID : ResourceType.fromClassName((String)resourceType);
        if (type == null) {
            return Collections.emptyList();
        }
        return this.findValueResourceInfos(namespace, type, resourceName, distinguishDelimitersInName, searchAttrs);
    }

    @NotNull
    public List<ValueResourceInfoImpl> findValueResourceInfos(@NotNull ResourceNamespace namespace, @NotNull ResourceType resourceType, @NotNull String resourceName, boolean distinguishDelimitersInName, boolean searchAttrs) {
        if (!(AndroidResourceUtil.VALUE_RESOURCE_TYPES.contains(resourceType) || resourceType == ResourceType.ATTR && searchAttrs)) {
            return Collections.emptyList();
        }
        ArrayList<ValueResourceInfoImpl> result2 = new ArrayList<ValueResourceInfoImpl>();
        for (ResourceRepository resourceRepository : this.getLeafResourceRepositories()) {
            List items2;
            if (distinguishDelimitersInName) {
                List items22 = resourceRepository.getResources(namespace, resourceType, resourceName);
            } else {
                items2 = resourceRepository.getResources(namespace, resourceType, item -> AndroidUtils.equal(resourceName, item.getName(), false));
            }
            for (ResourceItem item2 : items2) {
                VirtualFile file = ResourceHelper.getSourceAsVirtualFile(item2);
                if (file == null || !ResourceManager.isValueResourceFile(file)) continue;
                result2.add(new ValueResourceInfoImpl(item2, file, this.myProject));
            }
        }
        return result2;
    }

    private static boolean isValueResourceFile(@NotNull VirtualFile file) {
        return ResourceFolderType.getFolderType((String)file.getParent().getName()) == ResourceFolderType.VALUES;
    }

    @NotNull
    protected abstract Collection<SingleNamespaceResourceRepository> getLeafResourceRepositories();

    @NotNull
    protected abstract List<ResourceItem> getResources(@NotNull ResourceNamespace var1, @NotNull ResourceType var2, @NotNull String var3);
}

