/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.resourceManagers;

import com.android.ide.common.resources.ResourceItem;
import com.android.resources.ResourceType;
import com.android.tools.idea.res.LocalResourceRepository;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import org.jetbrains.android.dom.resources.Item;
import org.jetbrains.android.dom.resources.ResourceElement;
import org.jetbrains.android.resourceManagers.ValueResourceInfo;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ValueResourceInfoImpl
implements ValueResourceInfo {
    private final ResourceItem myResource;
    private final VirtualFile myFile;
    private final Project myProject;

    public ValueResourceInfoImpl(@NotNull ResourceItem resourceItem, @NotNull VirtualFile file, @NotNull Project project) {
        this.myResource = resourceItem;
        this.myFile = file;
        this.myProject = project;
    }

    @Override
    @NotNull
    public ResourceItem getResource() {
        return this.myResource;
    }

    @Override
    @NotNull
    public VirtualFile getContainingFile() {
        return this.myFile;
    }

    @Override
    @Nullable
    public XmlAttributeValue computeXmlElement() {
        ResourceElement resDomElement = this.computeDomElement();
        return resDomElement != null ? resDomElement.getName().getXmlAttributeValue() : null;
    }

    @Nullable
    public ResourceElement computeDomElement() {
        String resType;
        PsiFile file = PsiManager.getInstance((Project)this.myProject).findFile(this.myFile);
        if (!(file instanceof XmlFile)) {
            return null;
        }
        XmlTag tag = LocalResourceRepository.getItemTag(this.myProject, this.myResource);
        if (tag == null) {
            return null;
        }
        DomElement domElement = DomManager.getDomManager((Project)this.myProject).getDomElement(tag);
        if (!(domElement instanceof ResourceElement)) {
            return null;
        }
        String string = resType = domElement instanceof Item ? ((Item)domElement).getType().getStringValue() : ResourceType.fromXmlTagName((String)tag.getName()).getName();
        if (!this.getType().getName().equals(resType)) {
            return null;
        }
        ResourceElement resDomElement = (ResourceElement)domElement;
        String resName = ((ResourceElement)domElement).getName().getStringValue();
        return this.getName().equals(resName) ? resDomElement : null;
    }

    @Override
    public int compareTo(@NotNull ValueResourceInfo other) {
        int delta = AndroidResourceUtil.compareResourceFiles(this.myFile, other.getContainingFile());
        if (delta != 0) {
            return delta;
        }
        delta = this.getType().compareTo((Enum)other.getType());
        if (delta != 0) {
            return delta;
        }
        return this.getName().compareTo(other.getName());
    }

    public String toString() {
        return "ANDROID_RESOURCE: " + this.getType() + ", " + this.getName() + ", " + this.myFile.getPath();
    }
}

