/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.sdk;

import com.android.ide.common.rendering.api.AttrResourceValue;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.StyleableResourceValue;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceRepository;
import com.android.resources.ResourceType;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.layoutlib.LayoutLibrary;
import com.android.tools.idea.layoutlib.LayoutLibraryLoader;
import com.android.tools.idea.layoutlib.RenderingException;
import com.android.tools.idea.rendering.multi.CompatibilityRenderTarget;
import com.android.tools.idea.res.FrameworkResourceRepositoryManager;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.xml.NanoXmlBuilder;
import com.intellij.util.xml.NanoXmlUtil;
import gnu.trove.TIntObjectHashMap;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.concurrent.GuardedBy;
import net.n3.nanoxml.IXMLBuilder;
import org.jetbrains.android.dom.attrs.AttributeDefinitions;
import org.jetbrains.android.dom.attrs.AttributeDefinitionsImpl;
import org.jetbrains.android.resourceManagers.FilteredAttributeDefinitions;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.android.sdk.StudioEmbeddedRenderTarget;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidTargetData {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.sdk.AndroidTargetData");
    private final AndroidSdkData mySdkData;
    private final IAndroidTarget myTarget;
    private final Object myAttrDefsLock = new Object();
    @GuardedBy(value="myAttrDefsLock")
    private AttributeDefinitions myAttrDefs;
    private volatile LayoutLibrary myLayoutLibrary;
    private final Object myPublicResourceCacheLock = new Object();
    @GuardedBy(value="myPublicResourceCacheLock")
    private volatile Map<String, Set<String>> myPublicResourceCache;
    @GuardedBy(value="myPublicResourceCacheLock")
    private TIntObjectHashMap<String> myPublicResourceIdMap;
    private volatile MyStaticConstantsData myStaticConstantsData;

    public AndroidTargetData(@NotNull AndroidSdkData sdkData, @NotNull IAndroidTarget target) {
        this.mySdkData = sdkData;
        this.myTarget = target;
    }

    @NotNull
    public AttributeDefinitions getPublicAttrDefs(@NotNull Project project) {
        AttributeDefinitions attrDefs = this.getAllAttrDefs(project);
        return new PublicAttributeDefinitions(attrDefs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public AttributeDefinitions getAllAttrDefs(@NotNull Project project) {
        Object object = this.myAttrDefsLock;
        synchronized (object) {
            if (this.myAttrDefs == null) {
                String attrsPath = FileUtil.toSystemIndependentName((String)this.myTarget.getPath(8));
                String attrsManifestPath = FileUtil.toSystemIndependentName((String)this.myTarget.getPath(9));
                this.myAttrDefs = AttributeDefinitionsImpl.parseFrameworkFiles(new File(attrsPath), new File(attrsManifestPath));
            }
            return this.myAttrDefs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Map<String, Set<String>> getPublicResourceCache() {
        Object object = this.myPublicResourceCacheLock;
        synchronized (object) {
            if (this.myPublicResourceCache == null) {
                this.parsePublicResCache();
            }
            return this.myPublicResourceCache;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public TIntObjectHashMap<String> getPublicIdMap() {
        Object object = this.myPublicResourceCacheLock;
        synchronized (object) {
            if (this.myPublicResourceIdMap == null) {
                this.parsePublicResCache();
            }
            return this.myPublicResourceIdMap;
        }
    }

    public boolean isResourcePublic(@NotNull String type, @NotNull String name) {
        Map<String, Set<String>> publicResourceCache = this.getPublicResourceCache();
        if (publicResourceCache == null) {
            return false;
        }
        Set<String> set = publicResourceCache.get(type);
        return set != null && set.contains(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parsePublicResCache() {
        String resDirPath = this.myTarget.getPath(11);
        String publicXmlPath = resDirPath + '/' + "values" + "/public.xml";
        VirtualFile publicXml = LocalFileSystem.getInstance().findFileByPath(FileUtil.toSystemIndependentName((String)publicXmlPath));
        if (publicXml != null) {
            try {
                MyPublicResourceCacheBuilder builder = new MyPublicResourceCacheBuilder();
                NanoXmlUtil.parse((InputStream)publicXml.getInputStream(), (IXMLBuilder)builder);
                Object object = this.myPublicResourceCacheLock;
                synchronized (object) {
                    this.myPublicResourceCache = builder.getPublicResourceCache();
                    this.myPublicResourceIdMap = builder.getIdMap();
                }
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    @Nullable
    public synchronized LayoutLibrary getLayoutLibrary(@NotNull Project project) throws RenderingException, IOException {
        if (this.myLayoutLibrary == null || this.myLayoutLibrary.isDisposed()) {
            IAndroidTarget target;
            AndroidTargetData targetData;
            if (this.myTarget instanceof CompatibilityRenderTarget && (targetData = this.mySdkData.getTargetData(target = ((CompatibilityRenderTarget)this.myTarget).getRenderTarget())) != this) {
                this.myLayoutLibrary = targetData.getLayoutLibrary(project);
                return this.myLayoutLibrary;
            }
            if (!(this.myTarget instanceof StudioEmbeddedRenderTarget)) {
                LOG.warn("Rendering will not use the StudioEmbeddedRenderTarget");
            }
            this.myLayoutLibrary = LayoutLibraryLoader.load((IAndroidTarget)this.myTarget, this.getFrameworkEnumValues());
            Disposer.register((Disposable)project, (Disposable)this.myLayoutLibrary);
        }
        return this.myLayoutLibrary;
    }

    @NotNull
    private Map<String, Map<String, Integer>> getFrameworkEnumValues() {
        ResourceRepository resources = this.getFrameworkResources(false);
        if (resources == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Map<String, Integer>> result2 = new HashMap<String, Map<String, Integer>>();
        Collection items2 = resources.getResources(ResourceNamespace.ANDROID, ResourceType.ATTR).values();
        for (ResourceItem item : items2) {
            Map valueMap;
            ResourceValue attr = item.getResourceValue();
            if (!(attr instanceof AttrResourceValue) || (valueMap = ((AttrResourceValue)attr).getAttributeValues()).isEmpty()) continue;
            result2.put(attr.getName(), valueMap);
        }
        items2 = resources.getResources(ResourceNamespace.ANDROID, ResourceType.STYLEABLE).values();
        for (ResourceItem item : items2) {
            ResourceValue styleable = item.getResourceValue();
            if (!(styleable instanceof StyleableResourceValue)) continue;
            List attrs = ((StyleableResourceValue)styleable).getAllAttributes();
            for (AttrResourceValue attr : attrs) {
                Map valueMap = attr.getAttributeValues();
                if (valueMap.isEmpty()) continue;
                result2.put(attr.getName(), valueMap);
            }
        }
        return result2;
    }

    public void clearLayoutBitmapCache(Module module) {
        if (this.myLayoutLibrary != null) {
            this.myLayoutLibrary.clearResourceCaches((Object)module);
        }
    }

    public void clearFontCache(String path) {
        if (this.myLayoutLibrary != null) {
            this.myLayoutLibrary.clearFontCache(path);
        }
    }

    public void clearAllCaches(Module module) {
        if (this.myLayoutLibrary != null) {
            this.myLayoutLibrary.clearAllCaches((Object)module);
        }
    }

    @NotNull
    public IAndroidTarget getTarget() {
        return this.myTarget;
    }

    @NotNull
    public synchronized MyStaticConstantsData getStaticConstantsData() {
        if (this.myStaticConstantsData == null) {
            this.myStaticConstantsData = new MyStaticConstantsData();
        }
        return this.myStaticConstantsData;
    }

    @Nullable
    public synchronized ResourceRepository getFrameworkResources(boolean withLocale) {
        File resFolderOrJar = this.myTarget.getFile(11);
        if (!resFolderOrJar.exists()) {
            LOG.error(String.format("\"%s\" directory or file cannot be found", resFolderOrJar.getPath()));
            return null;
        }
        return FrameworkResourceRepositoryManager.getInstance().getFrameworkResources(resFolderOrJar, withLocale);
    }

    @Nullable
    public static AndroidTargetData getTargetData(@NotNull IAndroidTarget target, @NotNull Module module) {
        AndroidPlatform platform = AndroidPlatform.getInstance(module);
        return platform != null ? platform.getSdkData().getTargetData(target) : null;
    }

    public class MyStaticConstantsData {
        private final Set<String> myActivityActions = this.collectValues(14);
        private final Set<String> myServiceActions = this.collectValues(16);
        private final Set<String> myReceiverActions = this.collectValues(15);
        private final Set<String> myCategories = this.collectValues(17);

        private MyStaticConstantsData() {
        }

        @Nullable
        public Set<String> getActivityActions() {
            return this.myActivityActions;
        }

        @Nullable
        public Set<String> getServiceActions() {
            return this.myServiceActions;
        }

        @Nullable
        public Set<String> getReceiverActions() {
            return this.myReceiverActions;
        }

        @Nullable
        public Set<String> getCategories() {
            return this.myCategories;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Nullable
        private Set<String> collectValues(int pathId) {
            try (BufferedReader reader = new BufferedReader(new FileReader(AndroidTargetData.this.myTarget.getPath(pathId)));){
                String line;
                HashSet<String> result2 = new HashSet<String>();
                while ((line = reader.readLine()) != null) {
                    if ((line = line.trim()).isEmpty() || line.startsWith("#")) continue;
                    result2.add(line);
                }
                HashSet<String> hashSet = result2;
                return hashSet;
            }
            catch (IOException e) {
                return null;
            }
        }
    }

    @VisibleForTesting
    static class MyPublicResourceCacheBuilder
    implements NanoXmlBuilder {
        private final Map<String, Set<String>> myResult = new HashMap<String, Set<String>>();
        private final TIntObjectHashMap<String> myIdMap = new TIntObjectHashMap(3000);
        private String myName;
        private String myType;
        private int myId;
        private boolean inGroup;

        MyPublicResourceCacheBuilder() {
        }

        public void elementAttributesProcessed(String name, String nsPrefix, String nsURI) {
            if ("public".equals(name) && this.myName != null && this.myType != null) {
                Set<String> set = this.myResult.get(this.myType);
                if (set == null) {
                    set = new HashSet<String>();
                    this.myResult.put(this.myType, set);
                }
                set.add(this.myName);
                if (this.myId != 0) {
                    this.myIdMap.put(this.myId, (Object)("@android:" + this.myType + "/" + this.myName));
                    if (this.inGroup) {
                        ++this.myId;
                    }
                }
            }
        }

        public void addAttribute(String key, String nsPrefix, String nsURI, String value2, String type) {
            switch (key) {
                case "name": {
                    this.myName = value2;
                    break;
                }
                case "type": {
                    this.myType = value2;
                    break;
                }
                case "first-id": 
                case "id": {
                    try {
                        this.myId = Integer.decode(value2);
                        break;
                    }
                    catch (NumberFormatException e) {
                        this.myId = 0;
                    }
                }
            }
        }

        public void startElement(String name, String nsPrefix, String nsURI, String systemID, int lineNr) {
            if (!this.inGroup) {
                this.myType = null;
                this.myId = 0;
            }
            if ("public-group".equals(name)) {
                this.inGroup = true;
            }
            this.myName = null;
        }

        public void endElement(String name, String nsPrefix, String nsURI) {
            if ("public-group".equals(name)) {
                this.inGroup = false;
            }
        }

        public Map<String, Set<String>> getPublicResourceCache() {
            return this.myResult;
        }

        public TIntObjectHashMap<String> getIdMap() {
            return this.myIdMap;
        }
    }

    private class PublicAttributeDefinitions
    extends FilteredAttributeDefinitions {
        protected PublicAttributeDefinitions(AttributeDefinitions wrappee) {
            super(wrappee);
        }

        @Override
        protected boolean isAttributeAcceptable(@NotNull ResourceReference attr) {
            return attr.getNamespace().equals((Object)ResourceNamespace.ANDROID) && !attr.getName().startsWith("__removed") && AndroidTargetData.this.isResourcePublic(ResourceType.ATTR.getName(), attr.getName());
        }
    }
}

