/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.uipreview;

import com.android.tools.lint.checks.AnnotationDetector;
import com.intellij.ide.util.DefaultPsiElementCellRenderer;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.presentation.java.SymbolPresentationUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.ListSpeedSearch;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.JBList;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.function.Predicate;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChooseClassDialog
extends DialogWrapper
implements ListSelectionListener {
    private final JList<PsiClass> myList = new JBList();
    private final JScrollPane myComponent = ScrollPaneFactory.createScrollPane(this.myList);
    private final Predicate<PsiClass> myFilter;
    private String myResultClassName;

    private ChooseClassDialog(Module module, String title, boolean includeAll, @Nullable Predicate<PsiClass> filter2, String ... classes) {
        super(module.getProject());
        this.myFilter = filter2;
        new DoubleClickListener(){

            protected boolean onDoubleClick(MouseEvent e) {
                if (ChooseClassDialog.this.myList.getSelectedValue() != null) {
                    ChooseClassDialog.this.close(0);
                    return true;
                }
                return false;
            }
        }.installOn(this.myList);
        DefaultListModel model2 = new DefaultListModel();
        this.findClasses(module, includeAll, model2, classes);
        this.myList.setModel(model2);
        this.myList.setCellRenderer((ListCellRenderer<PsiClass>)new DefaultPsiElementCellRenderer());
        ListSelectionModel selectionModel = this.myList.getSelectionModel();
        selectionModel.setSelectionMode(0);
        selectionModel.addListSelectionListener(this);
        new ListSpeedSearch(this.myList){

            protected boolean isMatchingElement(Object element, String pattern) {
                PsiClass psiClass = (PsiClass)element;
                assert (psiClass.getName() != null && psiClass.getQualifiedName() != null);
                return this.compare(psiClass.getName(), pattern) || this.compare(psiClass.getQualifiedName(), pattern);
            }
        };
        this.setTitle(title);
        this.setOKActionEnabled(false);
        this.init();
        Dimension size = this.myComponent.getPreferredSize();
        size.height = this.myList.getPreferredSize().height + 20;
        this.myComponent.setPreferredSize(size);
    }

    private void setSelectedClass(@NotNull String className) {
        ListModel<PsiClass> model2 = this.myList.getModel();
        for (int index = 0; index < this.myList.getModel().getSize(); ++index) {
            if (!className.equals(model2.getElementAt(index).getQualifiedName())) continue;
            this.myList.setSelectedIndex(index);
            break;
        }
    }

    protected void findClasses(Module module, boolean includeAll, DefaultListModel model2, String[] classes) {
        ArrayList<PsiClass> collection = new ArrayList<PsiClass>(classes.length);
        for (String className : classes) {
            for (PsiClass psiClass3 : ChooseClassDialog.findInheritors(module, className, includeAll)) {
                if (this.myFilter != null && !this.myFilter.test(psiClass3)) continue;
                collection.add(psiClass3);
            }
        }
        Collator collator = Collator.getInstance(Locale.US);
        collection.stream().sorted((psiClass1, psiClass2) -> collator.compare(SymbolPresentationUtil.getSymbolPresentableText((PsiElement)psiClass1), SymbolPresentationUtil.getSymbolPresentableText((PsiElement)psiClass2))).forEach(psiClass -> model2.addElement(psiClass));
    }

    private static Collection<PsiClass> findInheritors(Module module, String name, boolean includeAll) {
        PsiClass base = ChooseClassDialog.findClass(module, name);
        if (base != null) {
            Collection<Object> classes;
            GlobalSearchScope scope = includeAll ? GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module, (boolean)false) : GlobalSearchScope.moduleScope((Module)module);
            try {
                classes = ClassInheritorsSearch.search((PsiClass)base, (SearchScope)scope, (boolean)true).findAll();
            }
            catch (IndexNotReadyException e) {
                classes = Collections.emptyList();
            }
            return classes;
        }
        return Collections.emptyList();
    }

    @Nullable
    public static PsiClass findClass(Module module, @Nullable String name) {
        PsiClass aClass;
        if (name == null) {
            return null;
        }
        Project project = module.getProject();
        try {
            aClass = JavaPsiFacade.getInstance((Project)project).findClass(name, GlobalSearchScope.allScope((Project)project));
        }
        catch (IndexNotReadyException e) {
            aClass = null;
        }
        return aClass;
    }

    @Nullable
    public static String openDialog(@NotNull Module module, @NotNull String title, @Nullable String currentValue, @Nullable Predicate<PsiClass> filter2, String ... classes) {
        Project project = module.getProject();
        DumbService dumbService = DumbService.getInstance((Project)project);
        if (dumbService.isDumb()) {
            dumbService.showDumbModeNotification(String.format("%1$s are not available while indices are updating.", title));
            return null;
        }
        ChooseClassDialog dialog2 = new ChooseClassDialog(module, title, true, filter2, classes);
        if (currentValue != null) {
            dialog2.setSelectedClass(currentValue);
        }
        if (!dialog2.hasChoices()) {
            String emptyErrorTitle = "No " + title + " Found";
            String emptyErrorMessage = "You must first create one or more " + title + " in code";
            Messages.showErrorDialog((String)emptyErrorMessage, (String)emptyErrorTitle);
            return null;
        }
        return dialog2.showAndGet() ? dialog2.getClassName() : null;
    }

    @NotNull
    public static Predicate<PsiClass> getIsPublicAndUnrestrictedFilter() {
        return psiClass -> {
            PsiModifierList modifiers = psiClass.getModifierList();
            if (modifiers == null) {
                return false;
            }
            if (!modifiers.hasModifierProperty("public")) {
                return false;
            }
            for (PsiAnnotation annotation : modifiers.getAnnotations()) {
                if (!AnnotationDetector.RESTRICT_TO_ANNOTATION.isEquals(annotation.getQualifiedName())) continue;
                return false;
            }
            return true;
        };
    }

    @NotNull
    public static Predicate<PsiClass> qualifiedNameFilter(@NotNull Predicate<String> filter2) {
        return psiClass -> {
            String qualifiedName = psiClass.getQualifiedName();
            if (qualifiedName == null) {
                return false;
            }
            return filter2.test(qualifiedName);
        };
    }

    @NotNull
    public static Predicate<String> getIsUserDefinedFilter() {
        return qualifiedName -> !qualifiedName.startsWith("android.") && !qualifiedName.startsWith("android.support.") && !qualifiedName.startsWith("androidx.") && !qualifiedName.startsWith("com.google.android.");
    }

    @NotNull
    public static Predicate<PsiClass> getUserDefinedPublicAndUnrestrictedFilter() {
        return ChooseClassDialog.getIsPublicAndUnrestrictedFilter().and(ChooseClassDialog.qualifiedNameFilter(ChooseClassDialog.getIsUserDefinedFilter()));
    }

    private boolean hasChoices() {
        return this.myList.getModel().getSize() > 0;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myList;
    }

    protected JComponent createCenterPanel() {
        return this.myComponent;
    }

    public String getClassName() {
        return this.myResultClassName;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        PsiClass psiClass = this.myList.getSelectedValue();
        this.setOKActionEnabled(psiClass != null);
        this.myResultClassName = psiClass == null ? null : psiClass.getQualifiedName();
    }
}

