/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.uipreview;

import com.android.SdkConstants;
import com.android.builder.model.AaptOptions;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.AndroidManifestPackageNameUtils;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.util.PathString;
import com.android.projectmodel.ExternalLibrary;
import com.android.projectmodel.Library;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.LogAnonymizerUtil;
import com.android.tools.idea.editors.theme.ThemeEditorUtils;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.layoutlib.LayoutLibrary;
import com.android.tools.idea.model.AndroidModel;
import com.android.tools.idea.projectsystem.AndroidModuleSystem;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.rendering.RenderClassLoader;
import com.android.tools.idea.rendering.RenderSecurityManager;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.ResourceClassRegistry;
import com.android.tools.idea.res.ResourceIdManager;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.android.tools.idea.resources.aar.AarResourceRepository;
import com.android.tools.idea.util.DependencyManagementUtil;
import com.android.tools.idea.util.FileExtensions;
import com.android.tools.idea.util.VirtualFileSystemOpener;
import com.android.utils.SdkUtils;
import com.google.common.io.Files;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.jetbrains.android.dom.manifest.AndroidManifestUtils;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.sdk.AndroidTargetData;
import org.jetbrains.android.uipreview.RecyclerViewHelper;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ModuleClassLoader
extends RenderClassLoader {
    private static final Logger LOG = Logger.getInstance(ModuleClassLoader.class);
    private final WeakReference<Module> myModuleReference;
    private final LayoutLibrary myLayoutLibrary;
    private Map<String, VirtualFile> myClassFiles;
    private Map<String, ClassModificationTimestamp> myClassFilesLastModified;
    private static final Pattern RESOURCE_CLASS_NAME = Pattern.compile(".+\\.R(\\$[^.]+)?$");
    private static final Map<Module, ModuleClassLoader> ourCache = ContainerUtil.createWeakMap();

    private ModuleClassLoader(@NotNull LayoutLibrary layoutLibrary, @NotNull Module module) {
        super(layoutLibrary.getClassLoader(), layoutLibrary.getApiLevel());
        this.myLayoutLibrary = layoutLibrary;
        this.myModuleReference = new WeakReference<Module>(module);
        ModuleClassLoader.registerResources(module);
    }

    @Override
    @NotNull
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("findClass(%s)", name));
        }
        Module module = (Module)this.myModuleReference.get();
        try {
            if (!this.myInsideJarClassLoader && module != null && ModuleClassLoader.isResourceClassName(name)) {
                AndroidFacet facet = AndroidFacet.getInstance(module);
                if (facet != null) {
                    ResourceRepositoryManager repositoryManager = ResourceRepositoryManager.getInstance(facet);
                    byte[] data = ResourceClassRegistry.get(module.getProject()).findClassDefinition(name, repositoryManager);
                    if (data != null) {
                        data = this.convertClass(data);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("  Defining class from AAR registry");
                        }
                        return this.defineClassAndPackage(name, data, 0, data.length);
                    }
                } else if (LOG.isDebugEnabled()) {
                    LOG.debug("  LocalResourceRepositoryInstance not found");
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("  super.findClass(%s)", LogAnonymizerUtil.anonymizeClassName((String)name)));
            }
            return super.findClass(name);
        }
        catch (ClassNotFoundException e) {
            byte[] clazz = null;
            if ("com.android.layoutlib.bridge.android.support.Adapter".equals(name)) {
                clazz = RecyclerViewHelper.getAdapterClass(DependencyManagementUtil.mapAndroidxName(module, SdkConstants.CLASS_RECYCLER_VIEW_V7), DependencyManagementUtil.mapAndroidxName(module, SdkConstants.CLASS_RECYCLER_VIEW_VIEW_HOLDER), DependencyManagementUtil.mapAndroidxName(module, SdkConstants.CLASS_RECYCLER_VIEW_ADAPTER));
            }
            if ("com.android.layoutlib.bridge.android.support.Adapter$ViewHolder".equals(name)) {
                clazz = RecyclerViewHelper.getViewHolder(DependencyManagementUtil.mapAndroidxName(module, SdkConstants.CLASS_RECYCLER_VIEW_V7), DependencyManagementUtil.mapAndroidxName(module, SdkConstants.CLASS_RECYCLER_VIEW_VIEW_HOLDER), DependencyManagementUtil.mapAndroidxName(module, SdkConstants.CLASS_RECYCLER_VIEW_ADAPTER));
            }
            if (clazz != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("  Defining RecyclerView helper class");
                }
                return this.defineClassAndPackage(name, clazz, 0, clazz.length);
            }
            LOG.debug((Throwable)e);
            throw e;
        }
    }

    @Nullable
    public static ClassLoader create(IAndroidTarget target, Module module) throws Exception {
        AndroidPlatform androidPlatform = AndroidPlatform.getInstance(module);
        if (androidPlatform == null) {
            return null;
        }
        AndroidTargetData targetData = androidPlatform.getSdkData().getTargetData(target);
        LayoutLibrary library = targetData.getLayoutLibrary(module.getProject());
        if (library == null) {
            return null;
        }
        return ModuleClassLoader.get(library, module);
    }

    @Override
    @NotNull
    protected Class<?> load(@NotNull String name) throws ClassNotFoundException {
        Module module;
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("load(%s)", LogAnonymizerUtil.anonymizeClassName((String)name)));
        }
        if ((module = (Module)this.myModuleReference.get()) == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("  ClassNotFoundException(%s)", name));
            }
            throw new ClassNotFoundException(name);
        }
        Class<?> aClass = this.loadClassFromModuleOrDependency(module, name);
        if (aClass == null) {
            aClass = this.loadClassFromJar(name);
        }
        if (aClass != null) {
            return aClass;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("  ClassNotFoundException(%s)", LogAnonymizerUtil.anonymizeClassName((String)name)));
        }
        throw new ClassNotFoundException(name);
    }

    @Override
    @NotNull
    public Class<?> loadClass(@NotNull String name) throws ClassNotFoundException {
        boolean loadFromProject = name.startsWith("android.support.constraint.solver");
        if (loadFromProject) {
            try {
                Class<?> loadedClass = this.findLoadedClass(name);
                if (loadedClass != null) {
                    return loadedClass;
                }
                return this.load(name);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return super.loadClass(name);
    }

    @Nullable
    private Class<?> loadClassFromModuleOrDependency(@NotNull Module module, @NotNull String name) {
        if (module.isDisposed()) {
            return null;
        }
        VirtualFile classFile = ProjectSystemUtil.getModuleSystem(module).findClassFile(name);
        if (classFile == null) {
            return null;
        }
        return this.loadClassFile(name, classFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSourceModified(@NotNull String name, @Nullable Object myCredential) {
        if (ModuleClassLoader.isResourceClassName(name)) {
            return false;
        }
        Module module = (Module)this.myModuleReference.get();
        if (module == null) {
            return false;
        }
        VirtualFile classFile = this.getClassFile(name);
        if (classFile == null) {
            return false;
        }
        AndroidFacet facet = AndroidFacet.getInstance(module);
        if (facet == null || ((AndroidFacetConfiguration)facet.getConfiguration()).getModel() == null) {
            return false;
        }
        boolean token = RenderSecurityManager.enterSafeRegion(myCredential);
        try {
            boolean bl = ((AndroidFacetConfiguration)facet.getConfiguration()).getModel().isClassFileOutOfDate(module, name, classFile);
            return bl;
        }
        finally {
            RenderSecurityManager.exitSafeRegion(token);
        }
    }

    private static boolean isResourceClassName(@NotNull String className) {
        return RESOURCE_CLASS_NAME.matcher(className).matches();
    }

    @Override
    @Nullable
    protected Class<?> loadClassFile(@NotNull String name, @NotNull VirtualFile classFile) {
        if (this.myClassFiles == null) {
            this.myClassFiles = new ConcurrentHashMap<String, VirtualFile>();
            this.myClassFilesLastModified = new ConcurrentHashMap<String, ClassModificationTimestamp>();
        }
        this.myClassFiles.put(name, classFile);
        this.myClassFilesLastModified.put(name, new ClassModificationTimestamp(classFile.getTimeStamp(), classFile.getLength()));
        return super.loadClassFile(name, classFile);
    }

    private static void registerResources(@NotNull Module module) {
        AndroidFacet androidFacet = AndroidFacet.getInstance(module);
        if (androidFacet == null) {
            return;
        }
        ResourceRepositoryManager repositoryManager = ResourceRepositoryManager.getInstance(androidFacet);
        ResourceIdManager idManager = ResourceIdManager.get(module);
        ResourceClassRegistry classRegistry = ResourceClassRegistry.get(module.getProject());
        if (!idManager.finalIdsUsed()) {
            classRegistry.addLibrary((ResourceRepository)repositoryManager.getAppResources(), idManager, (String)ReadAction.compute(() -> AndroidManifestUtils.getPackageName(androidFacet)), repositoryManager.getNamespace());
        }
        for (AndroidFacet dependency : AndroidUtils.getAllAndroidDependencies(module, false)) {
            classRegistry.addLibrary((ResourceRepository)repositoryManager.getAppResources(), idManager, (String)ReadAction.compute(() -> AndroidManifestUtils.getPackageName(dependency)), repositoryManager.getNamespace());
        }
        AndroidModuleSystem moduleSystem = ProjectSystemUtil.getModuleSystem(module);
        for (Library library : moduleSystem.getResolvedDependentLibraries()) {
            if (!(library instanceof ExternalLibrary) || !((ExternalLibrary)library).hasResources()) continue;
            ModuleClassLoader.registerLibraryResources((ExternalLibrary)library, repositoryManager, classRegistry, idManager);
        }
    }

    private static void registerLibraryResources(@NotNull ExternalLibrary library, @NotNull ResourceRepositoryManager repositoryManager, @NotNull ResourceClassRegistry classRegistry, @NotNull ResourceIdManager idManager) {
        ResourceNamespace resourcesNamespace;
        Object rClassContents;
        String packageName;
        LocalResourceRepository appResources = repositoryManager.getAppResources();
        if (repositoryManager.getNamespacing() == AaptOptions.Namespacing.DISABLED) {
            packageName = ModuleClassLoader.getPackageName(library);
            if (packageName == null) {
                return;
            }
            rClassContents = appResources;
            resourcesNamespace = ResourceNamespace.RES_AUTO;
        } else {
            AarResourceRepository aarResources = repositoryManager.findLibraryResources(library);
            if (aarResources == null) {
                return;
            }
            rClassContents = aarResources;
            resourcesNamespace = aarResources.getNamespace();
            packageName = aarResources.getPackageName();
        }
        classRegistry.addLibrary((ResourceRepository)rClassContents, idManager, packageName, resourcesNamespace);
    }

    @Nullable
    private static String getPackageName(@NotNull ExternalLibrary library) {
        block6: {
            if (library.getPackageName() != null) {
                return library.getPackageName();
            }
            PathString manifestFile = library.getManifestFile();
            if (manifestFile != null) {
                try {
                    return AndroidManifestPackageNameUtils.getPackageNameFromManifestFile((PathString)manifestFile);
                }
                catch (IOException ignore) {
                    if (!VirtualFileSystemOpener.INSTANCE.recognizes(manifestFile)) break block6;
                    FileExtensions.toVirtualFile(manifestFile, true);
                    try {
                        return AndroidManifestPackageNameUtils.getPackageNameFromManifestFile((PathString)manifestFile);
                    }
                    catch (IOException ignore2) {
                        return null;
                    }
                }
            }
        }
        return null;
    }

    @Override
    @NotNull
    protected List<URL> getExternalJars() {
        URL customWidgetsUrl;
        Module module = (Module)this.myModuleReference.get();
        if (module == null) {
            return Collections.emptyList();
        }
        ArrayList<URL> result2 = new ArrayList<URL>();
        if (((Boolean)StudioFlags.THEME_EDITOR_ENABLED.get()).booleanValue() && (customWidgetsUrl = ThemeEditorUtils.getCustomWidgetsJarUrl()) != null) {
            result2.add(customWidgetsUrl);
        }
        ModuleClassLoader.getExternalLibraryJars(module).filter(file -> "jar".equals(Files.getFileExtension((String)file.getName())) && file.exists()).forEach(jarFile -> ModuleClassLoader.addFileUrl(jarFile, result2));
        return result2;
    }

    @NotNull
    private static Stream<File> getExternalLibraryJars(@NotNull Module module) {
        AndroidModel model2;
        AndroidFacet facet = AndroidFacet.getInstance(module);
        if (facet != null && facet.requiresAndroidModel() && (model2 = ((AndroidFacetConfiguration)facet.getConfiguration()).getModel()) != null) {
            return model2.getClassJarProvider().getModuleExternalLibraries(module).stream();
        }
        return AndroidRootUtil.getExternalLibraries(module).stream().map(VfsUtilCore::virtualToIoFile);
    }

    private static void addFileUrl(@NotNull File file, @NotNull List<URL> result2) {
        try {
            result2.add(SdkUtils.fileToUrl((File)file));
        }
        catch (MalformedURLException e) {
            LOG.error((Throwable)e);
        }
    }

    @Nullable
    private VirtualFile getClassFile(@NotNull String className) {
        if (this.myClassFiles == null) {
            return null;
        }
        VirtualFile file = this.myClassFiles.get(className);
        if (file == null) {
            return null;
        }
        return file.isValid() ? file : null;
    }

    private boolean isUpToDate() {
        if (this.myClassFiles != null) {
            for (Map.Entry<String, VirtualFile> entry : this.myClassFiles.entrySet()) {
                String className = entry.getKey();
                VirtualFile classFile = entry.getValue();
                if (!classFile.isValid()) {
                    return false;
                }
                ClassModificationTimestamp lastModifiedStamp = this.myClassFilesLastModified.get(className);
                if (lastModifiedStamp == null) continue;
                long loadedModifiedTime = lastModifiedStamp.timestamp;
                long loadedModifiedLength = lastModifiedStamp.length;
                long classFileModifiedTime = classFile.getTimeStamp();
                long classFileModifiedLength = classFile.getLength();
                if ((classFileModifiedTime <= 0L || loadedModifiedTime <= 0L || loadedModifiedTime >= classFileModifiedTime) && loadedModifiedLength == classFileModifiedLength) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static ModuleClassLoader get(@NotNull LayoutLibrary library, @NotNull Module module) {
        ModuleClassLoader loader;
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("ModuleClassLoader.get(%s)", LogAnonymizerUtil.anonymize((Module)module)));
        }
        Map<Module, ModuleClassLoader> map2 = ourCache;
        synchronized (map2) {
            loader = ourCache.get(module);
        }
        if (loader != null) {
            if (library != loader.myLayoutLibrary) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("  Discarding loader because the layout library has changed");
                }
                loader = null;
            } else if (!loader.isUpToDate()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("  Discarding loader because some files have changed");
                }
                loader = null;
            } else {
                List<URL> updatedJarDependencies = loader.getExternalJars();
                if (loader.myJarClassLoader != null && !updatedJarDependencies.equals(loader.myJarClassLoader.getUrls())) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("  Recreating jar class loader because dependencies have changed.");
                    }
                    loader.myJarClassLoader = loader.createClassLoader(updatedJarDependencies);
                }
            }
        }
        if (loader == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("  New class loader");
            }
            loader = new ModuleClassLoader(library, module);
            map2 = ourCache;
            synchronized (map2) {
                ourCache.put(module, loader);
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("  Re-used class loader");
        }
        return loader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearCache() {
        Map<Module, ModuleClassLoader> map2 = ourCache;
        synchronized (map2) {
            ourCache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearCache(Module module) {
        Map<Module, ModuleClassLoader> map2 = ourCache;
        synchronized (map2) {
            ourCache.remove(module);
        }
    }

    public boolean isClassLoaded(@NotNull String className) {
        return this.findLoadedClass(className) != null;
    }

    private static class ClassModificationTimestamp {
        public final long timestamp;
        public final long length;

        ClassModificationTimestamp(long timestamp, long length) {
            this.timestamp = timestamp;
            this.length = length;
        }
    }
}

