/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.uipreview;

import com.android.SdkConstants;
import com.android.layoutlib.bridge.MockView;
import com.android.tools.idea.LogAnonymizerUtil;
import com.android.tools.idea.layoutlib.LayoutLibrary;
import com.android.tools.idea.rendering.IRenderLogger;
import com.android.tools.idea.rendering.InconvertibleClassError;
import com.android.tools.idea.rendering.RenderProblem;
import com.android.tools.idea.rendering.RenderSecurityManager;
import com.android.tools.idea.res.ResourceIdManager;
import com.android.utils.HtmlBuilder;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Maps;
import com.google.common.collect.Multiset;
import com.google.common.collect.Sets;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.HashSet;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.Set;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.uipreview.ModuleClassLoader;
import org.jetbrains.android.uipreview.ViewLoaderExtension;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ViewLoader {
    private static final Logger LOG = Logger.getInstance(ViewLoader.class);
    private static final int ALLOWED_NESTED_VIEWS = 100;
    private static final ViewLoaderExtension[] EMPTY_EXTENSION_LIST = new ViewLoaderExtension[0];
    @NotNull
    private final Module myModule;
    @NotNull
    private final Map<String, Class<?>> myLoadedClasses = Maps.newHashMap();
    @NotNull
    private final Multiset<Class<?>> myLoadingClasses = HashMultiset.create((int)5);
    @NotNull
    private final Set<String> myRecentlyModifiedClasses = Sets.newHashSetWithExpectedSize((int)5);
    @Nullable
    private final Object myCredential;
    @NotNull
    private final LayoutLibrary myLayoutLibrary;
    @NotNull
    private IRenderLogger myLogger;
    @Nullable
    private ModuleClassLoader myModuleClassLoader;

    public ViewLoader(@NotNull LayoutLibrary layoutLib, @NotNull AndroidFacet facet, @NotNull IRenderLogger logger, @Nullable Object credential) {
        this.myLayoutLibrary = layoutLib;
        this.myModule = facet.getModule();
        this.myLogger = logger;
        this.myCredential = credential;
    }

    public void setLogger(@NotNull IRenderLogger logger) {
        this.myLogger = logger;
    }

    @Nullable
    private static String getRClassName(@NotNull Module module) {
        return (String)ApplicationManager.getApplication().runReadAction(() -> {
            AndroidFacet facet = AndroidFacet.getInstance(module);
            if (facet == null) {
                return null;
            }
            Manifest manifest = facet.getManifest();
            if (manifest == null) {
                return null;
            }
            String packageName = (String)manifest.getPackage().getValue();
            return packageName == null ? null : packageName + '.' + "R";
        });
    }

    @Nullable
    public Object loadClass(String className, Class<?>[] constructorSignature, Object[] constructorArgs) {
        if (SdkConstants.CLASS_RECYCLER_VIEW_ADAPTER.isEquals(className)) {
            className = "com.android.layoutlib.bridge.android.support.Adapter";
            constructorSignature = ArrayUtil.EMPTY_CLASS_ARRAY;
            constructorArgs = ArrayUtil.EMPTY_OBJECT_ARRAY;
        }
        return this.loadClass(className, constructorSignature, constructorArgs, false);
    }

    @Nullable
    public Object loadView(@NotNull String className, @Nullable Class<?>[] constructorSignature, @Nullable Object[] constructorArgs) throws ClassNotFoundException {
        Object aClass = this.loadClass(className, constructorSignature, constructorArgs, true);
        if (aClass != null) {
            return aClass;
        }
        try {
            Object o = this.createViewFromSuperclass(className, constructorSignature, constructorArgs);
            if (o != null) {
                return o;
            }
            return this.createMockView(className, constructorSignature, constructorArgs);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException e) {
            throw new ClassNotFoundException(className, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Object loadClass(@NotNull String className, @Nullable Class<?>[] constructorSignature, @Nullable Object[] constructorArgs, boolean isView) {
        block16: {
            Object object;
            assert (this.myLogger != null);
            Class<?> aClass = this.myLoadedClasses.get(className);
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("loadClassA(%s)", LogAnonymizerUtil.anonymizeClassName((String)className)));
            }
            if (aClass != null) {
                this.checkModified(className);
                return this.createNewInstance(aClass, constructorSignature, constructorArgs, isView);
            }
            aClass = this.loadClass(className, isView);
            if (aClass == null) break block16;
            this.checkModified(className);
            if (this.myLoadingClasses.count(aClass) > 100) {
                throw new InstantiationException("The layout involves creation of " + className + " over " + 100 + " levels deep. Infinite recursion?");
            }
            this.myLoadingClasses.add(aClass);
            try {
                Object viewObject = this.createNewInstance(aClass, constructorSignature, constructorArgs, isView);
                this.myLoadedClasses.put(className, aClass);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("  instance created");
                }
                object = viewObject;
            }
            catch (Throwable throwable) {
                try {
                    this.myLoadingClasses.remove(aClass);
                    throw throwable;
                }
                catch (InconvertibleClassError e) {
                    this.myLogger.addIncorrectFormatClass(e.getClassName(), e);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Throwable)e);
                    }
                    break block16;
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException | LinkageError | NoSuchMethodException e) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(e);
                    }
                    this.myLogger.addBrokenClass(className, e);
                    break block16;
                }
                catch (InvocationTargetException e) {
                    Throwable cause;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Throwable)e);
                    }
                    if ((cause = e.getCause()) instanceof InconvertibleClassError) {
                        InconvertibleClassError error = (InconvertibleClassError)cause;
                        this.myLogger.addIncorrectFormatClass(error.getClassName(), error);
                        break block16;
                    }
                    this.myLogger.addBrokenClass(className, cause);
                }
            }
            this.myLoadingClasses.remove(aClass);
            return object;
        }
        return null;
    }

    @NotNull
    private ViewLoaderExtension[] getExtensions() {
        ExtensionsArea area = Extensions.getArea((AreaInstance)this.myModule.getProject());
        if (!area.hasExtensionPoint(ViewLoaderExtension.EP_NAME.getName())) {
            return EMPTY_EXTENSION_LIST;
        }
        return (ViewLoaderExtension[])area.getExtensionPoint(ViewLoaderExtension.EP_NAME).getExtensions();
    }

    @NotNull
    private ModuleClassLoader getModuleClassLoader() {
        if (this.myModuleClassLoader == null) {
            boolean token = RenderSecurityManager.enterSafeRegion(this.myCredential);
            try {
                this.myModuleClassLoader = ModuleClassLoader.get(this.myLayoutLibrary, this.myModule);
            }
            finally {
                RenderSecurityManager.exitSafeRegion(token);
            }
        }
        return this.myModuleClassLoader;
    }

    private void checkModified(@NotNull String fqcn) {
        if (DumbService.getInstance((Project)this.myModule.getProject()).isDumb()) {
            return;
        }
        if (this.myModuleClassLoader != null && this.myModuleClassLoader.isSourceModified(fqcn, this.myCredential) && !this.myRecentlyModifiedClasses.contains(fqcn)) {
            this.myRecentlyModifiedClasses.add(fqcn);
            RenderProblem.Html problem = RenderProblem.create(HighlightSeverity.WARNING);
            HtmlBuilder builder = problem.getHtmlBuilder();
            String className = fqcn.substring(fqcn.lastIndexOf(46) + 1);
            builder.addLink("The " + className + " custom view has been edited more recently than the last build: ", "Build", " the project.", this.myLogger.getLinkManager().createBuildProjectUrl());
            this.myLogger.addMessage(problem);
        }
    }

    @NotNull
    private MockView createMockView(@NotNull String className, @Nullable Class<?>[] constructorSignature, @Nullable Object[] constructorArgs) throws ClassNotFoundException, InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException, NoSuchFieldException {
        String label;
        MockView mockView = (MockView)this.createNewInstance(MockView.class, constructorSignature, constructorArgs, true);
        switch (label = ViewLoader.getShortClassName(className)) {
            case "fragment": {
                label = "<fragment>";
                break;
            }
            case "include": {
                label = "Text";
            }
        }
        mockView.setText((CharSequence)label);
        mockView.setGravity(17);
        return mockView;
    }

    @NotNull
    public Module getModule() {
        return this.myModule;
    }

    @NotNull
    static String getShortClassName(@NotNull String fqcn) {
        int first = fqcn.indexOf(46);
        int last = fqcn.lastIndexOf(46);
        if (fqcn.startsWith("android.") ? last > first : last > (first = fqcn.indexOf(46, first + 1)) && first >= 0) {
            return fqcn.substring(0, first) + ".." + fqcn.substring(last);
        }
        return fqcn;
    }

    @NotNull
    private Object createNewInstance(@NotNull Class<?> clazz, @Nullable Class<?>[] constructorSignature, @Nullable Object[] constructorParameters, boolean isView) throws NoSuchMethodException, ClassNotFoundException, InvocationTargetException, IllegalAccessException, InstantiationException {
        Constructor<?> constructor;
        block10: {
            constructor = null;
            try {
                constructor = clazz.getConstructor(constructorSignature);
            }
            catch (NoSuchMethodException e) {
                int paramsCount;
                if (!isView) {
                    throw e;
                }
                int n = paramsCount = constructorSignature != null ? constructorSignature.length : 0;
                if (paramsCount == 0) {
                    throw e;
                }
                assert (constructorParameters != null);
                for (int i2 = 3; i2 >= 1; --i2) {
                    if (i2 == paramsCount) continue;
                    int k = paramsCount < i2 ? paramsCount : i2;
                    Class[] sig = new Class[i2];
                    System.arraycopy(constructorSignature, 0, sig, 0, k);
                    Object[] params = new Object[i2];
                    System.arraycopy(constructorParameters, 0, params, 0, k);
                    for (int j = k + 1; j <= i2; ++j) {
                        if (j == 2) {
                            sig[j - 1] = this.myLayoutLibrary.getClassLoader().loadClass("android.util.AttributeSet");
                            params[j - 1] = null;
                            continue;
                        }
                        if (j != 3) continue;
                        sig[j - 1] = Integer.TYPE;
                        params[j - 1] = 0;
                    }
                    constructorSignature = sig;
                    constructorParameters = params;
                    try {
                        constructor = clazz.getConstructor(constructorSignature);
                        if (constructor == null) continue;
                        if (constructorSignature.length >= 2) break;
                        LOG.info("wrong_constructor: Custom view " + clazz.getSimpleName() + " is not using the 2- or 3-argument View constructors; XML attributes will not work");
                        this.myLogger.warning("wrongconstructor", String.format("Custom view %1$s is not using the 2- or 3-argument View constructors; XML attributes will not work", clazz.getSimpleName()), null, null);
                        break;
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                }
                if (constructor != null) break block10;
                throw e;
            }
        }
        constructor.setAccessible(true);
        return constructor.newInstance(constructorParameters);
    }

    @Nullable
    public Class<?> loadClass(@NotNull String className, boolean logError) throws InconvertibleClassError {
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("loadClassB(%s)", LogAnonymizerUtil.anonymizeClassName((String)className)));
        }
        try {
            ModuleClassLoader moduleClassLoader = this.getModuleClassLoader();
            for (ViewLoaderExtension extension : this.getExtensions()) {
                Class<?> loadedClass = extension.loadClass(className, moduleClassLoader);
                if (loadedClass == null) continue;
                return loadedClass;
            }
            return moduleClassLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            if (logError && !className.equals("fragment")) {
                this.myLogger.addMissingClass(className);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Object createViewFromSuperclass(@NotNull String className, @Nullable Class<?>[] constructorSignature, @Nullable Object[] constructorArgs) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("createViewFromSuperClass(%s)", LogAnonymizerUtil.anonymizeClassName((String)className)));
        }
        Ref token = new Ref();
        token.set((Object)RenderSecurityManager.enterSafeRegion(this.myCredential));
        try {
            Object object = ApplicationManager.getApplication().runReadAction(() -> {
                JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)this.myModule.getProject());
                PsiClass psiClass = facade.findClass(className, this.myModule.getModuleWithDependenciesAndLibrariesScope(false));
                if (psiClass == null) {
                    return null;
                }
                HashSet visited = new HashSet();
                for (psiClass = psiClass.getSuperClass(); psiClass != null; psiClass = psiClass.getSuperClass()) {
                    Object object;
                    String qName = psiClass.getQualifiedName();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("  parent " + LogAnonymizerUtil.anonymizeClassName((String)qName));
                    }
                    if (qName == null || !visited.add(qName) || "android.view.View".equals(psiClass.getQualifiedName())) break;
                    if (AndroidUtils.isAbstract(psiClass)) continue;
                    Class<?> aClass = this.myLoadedClasses.get(qName);
                    if (aClass == null && this.myLayoutLibrary.getClassLoader() != null && (aClass = this.myLayoutLibrary.getClassLoader().loadClass(qName)) != null) {
                        this.myLoadedClasses.put(qName, aClass);
                    }
                    if (aClass == null) continue;
                    try {
                        RenderSecurityManager.exitSafeRegion((Boolean)token.get());
                        object = this.createNewInstance(aClass, constructorSignature, constructorArgs, true);
                    }
                    catch (Throwable throwable) {
                        try {
                            token.set((Object)RenderSecurityManager.enterSafeRegion(this.myCredential));
                            throw throwable;
                        }
                        catch (Throwable e) {
                            LOG.debug(e);
                        }
                    }
                    token.set((Object)RenderSecurityManager.enterSafeRegion(this.myCredential));
                    return object;
                }
                return null;
            });
            return object;
        }
        finally {
            RenderSecurityManager.exitSafeRegion((Boolean)token.get());
        }
    }

    public void loadAndParseRClassSilently() {
        String rClassName = ViewLoader.getRClassName(this.myModule);
        try {
            if (rClassName == null) {
                LOG.info(String.format("loadAndParseRClass: failed to find manifest package for project %1$s", this.myModule.getProject().getName()));
                return;
            }
            this.myLogger.setResourceClass(rClassName);
            this.loadAndParseRClass(rClassName);
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            this.myLogger.setMissingResourceClass();
        }
        catch (InconvertibleClassError e) {
            assert (rClassName != null);
            this.myLogger.addIncorrectFormatClass(rClassName, e);
        }
    }

    void loadAndParseRClass(@NotNull String className) throws ClassNotFoundException, InconvertibleClassError {
        AndroidFacet facet;
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("loadAndParseRClass(%s)", LogAnonymizerUtil.anonymizeClassName((String)className)));
        }
        Class<?> aClass = this.myLoadedClasses.get(className);
        ResourceIdManager idManager = ResourceIdManager.get(this.myModule);
        if (aClass == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("  The R class is not loaded.");
            }
            ModuleClassLoader moduleClassLoader = this.getModuleClassLoader();
            boolean isClassLoaded = moduleClassLoader.isClassLoaded(className);
            aClass = moduleClassLoader.loadClass(className);
            if (!isClassLoaded && aClass != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(String.format("  Class found in module %s, first time load.", LogAnonymizerUtil.anonymize((Module)this.myModule)));
                }
                this.myLoadedClasses.clear();
                ModuleClassLoader.clearCache(this.myModule);
                this.myModuleClassLoader = null;
                aClass = this.getModuleClassLoader().loadClass(className);
                idManager.resetDynamicIds();
            } else if (LOG.isDebugEnabled() && isClassLoaded) {
                LOG.debug(String.format("  Class already loaded in module %s.", LogAnonymizerUtil.anonymize((Module)this.myModule)));
            }
            if (aClass != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("  Class loaded");
                }
                this.myLoadedClasses.put(className, aClass);
                this.myLogger.setHasLoadedClasses();
            }
        }
        if (aClass != null && (facet = AndroidFacet.getInstance(this.myModule)) != null) {
            idManager.loadCompiledIds(aClass);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("END loadAndParseRClass(%s)", LogAnonymizerUtil.anonymizeClassName((String)className)));
        }
    }
}

