/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.uipreview;

import com.android.io.IAbstractFile;
import com.android.io.IAbstractFolder;
import com.android.io.StreamException;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.jetbrains.android.uipreview.VirtualFolderWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VirtualFileWrapper
implements IAbstractFile {
    private final Project myProject;
    private final VirtualFile myFile;

    public VirtualFileWrapper(@NotNull Project project, @NotNull VirtualFile file) {
        this.myFile = file;
        this.myProject = project;
    }

    public InputStream getContents() throws StreamException {
        String content = this.getFileContent();
        return new ByteArrayInputStream(content.getBytes());
    }

    @NotNull
    private String getFileContent() {
        return (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

            public String compute() {
                if (!VirtualFileWrapper.this.myFile.isValid()) {
                    return "";
                }
                PsiFile psiFile = PsiManager.getInstance((Project)VirtualFileWrapper.this.myProject).findFile(VirtualFileWrapper.this.myFile);
                return psiFile != null ? psiFile.getText() : "";
            }
        });
    }

    public void setContents(InputStream source) throws StreamException {
        throw new UnsupportedOperationException();
    }

    public OutputStream getOutputStream() throws StreamException {
        throw new UnsupportedOperationException();
    }

    public IAbstractFile.PreferredWriteMode getPreferredWriteMode() {
        throw new UnsupportedOperationException();
    }

    public long getModificationStamp() {
        return this.myFile.getTimeStamp();
    }

    public String getName() {
        return this.myFile.getName();
    }

    public String getOsLocation() {
        return FileUtil.toSystemDependentName((String)this.myFile.getPath());
    }

    public String getPath() {
        return this.myFile.getPath();
    }

    public boolean exists() {
        return this.myFile.exists();
    }

    @Nullable
    public IAbstractFolder getParentFolder() {
        VirtualFile parent = this.myFile.getParent();
        return parent != null ? new VirtualFolderWrapper(this.myProject, parent) : null;
    }

    public boolean delete() {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public VirtualFile getFile() {
        return this.myFile;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VirtualFileWrapper wrapper = (VirtualFileWrapper)o;
        if (!this.myFile.equals(wrapper.myFile)) {
            return false;
        }
        return this.myProject.equals(wrapper.myProject);
    }

    public int hashCode() {
        int result2 = this.myProject.hashCode();
        result2 = 31 * result2 + this.myFile.hashCode();
        return result2;
    }
}

