/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.util;

import com.android.tools.idea.res.AndroidProjectRootListener;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.reference.SoftReference;
import com.intellij.util.containers.ContainerUtil;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.annotations.NotNull;

public class AndroidDependenciesCache {
    private static final Key<SoftReference<AndroidDependenciesCache>> KEY = Key.create((String)"ANDROID_DEPENDENCIES_CACHE");
    private final Module myModule;
    private final Ref<List<WeakReference<AndroidFacet>>> myAllDependencies = Ref.create();
    private final Ref<List<WeakReference<AndroidFacet>>> myAllLibraryDependencies = Ref.create();

    private AndroidDependenciesCache(@NotNull Module module) {
        this.myModule = module;
        AndroidProjectRootListener.ensureSubscribed(module.getProject());
    }

    public synchronized void dropCache() {
        this.myAllDependencies.set(null);
        this.myAllLibraryDependencies.set(null);
    }

    @NotNull
    public static AndroidDependenciesCache getInstance(@NotNull Module module) {
        AndroidDependenciesCache cache2 = (AndroidDependenciesCache)SoftReference.dereference((Reference)((Reference)module.getUserData(KEY)));
        if (cache2 == null) {
            cache2 = new AndroidDependenciesCache(module);
            module.putUserData(KEY, (Object)new SoftReference((Object)cache2));
        }
        return cache2;
    }

    @NotNull
    public synchronized List<AndroidFacet> getAllAndroidDependencies(boolean androidLibrariesOnly) {
        return AndroidDependenciesCache.getAllAndroidDependencies(this.myModule, androidLibrariesOnly, this.getListRef(androidLibrariesOnly));
    }

    @NotNull
    private Ref<List<WeakReference<AndroidFacet>>> getListRef(boolean androidLibrariesOnly) {
        return androidLibrariesOnly ? this.myAllLibraryDependencies : this.myAllDependencies;
    }

    @NotNull
    private static List<AndroidFacet> getAllAndroidDependencies(@NotNull Module module, boolean androidLibrariesOnly, @NotNull Ref<List<WeakReference<AndroidFacet>>> listRef) {
        List refs = (List)listRef.get();
        if (refs == null) {
            ArrayList<AndroidFacet> facets = new ArrayList<AndroidFacet>();
            AndroidDependenciesCache.collectAllAndroidDependencies(module, androidLibrariesOnly, facets, new HashSet<AndroidFacet>());
            refs = ContainerUtil.map((Collection)ContainerUtil.reverse(facets), facet -> new WeakReference<AndroidFacet>((AndroidFacet)((Object)facet)));
            listRef.set((Object)refs);
        }
        return AndroidDependenciesCache.dereference(refs);
    }

    @NotNull
    private static List<AndroidFacet> dereference(@NotNull List<WeakReference<AndroidFacet>> refs) {
        return ContainerUtil.mapNotNull(refs, ref -> (AndroidFacet)((Object)((Object)ref.get())));
    }

    private static void collectAllAndroidDependencies(@NotNull Module module, boolean androidLibrariesOnly, @NotNull List<AndroidFacet> result2, @NotNull Set<AndroidFacet> visited) {
        AndroidFacet facet = AndroidFacet.getInstance(module);
        boolean isDynamicFeature = facet != null && ((AndroidFacetConfiguration)facet.getConfiguration()).getProjectType() == 6;
        OrderEntry[] entries = ModuleRootManager.getInstance((Module)module).getOrderEntries();
        int i2 = entries.length;
        while (--i2 >= 0) {
            AndroidFacet depFacet;
            Module depModule;
            ModuleOrderEntry moduleOrderEntry;
            OrderEntry orderEntry = entries[i2];
            if (!(orderEntry instanceof ModuleOrderEntry) || (moduleOrderEntry = (ModuleOrderEntry)orderEntry).getScope() != DependencyScope.COMPILE || (depModule = moduleOrderEntry.getModule()) == null || (depFacet = AndroidFacet.getInstance(depModule)) == null || androidLibrariesOnly && ((AndroidFacetConfiguration)depFacet.getConfiguration()).isAppProject() && !isDynamicFeature || !visited.add(depFacet)) continue;
            List cachedDepDeps = (List)AndroidDependenciesCache.getInstance(depModule).getListRef(androidLibrariesOnly).get();
            if (cachedDepDeps != null) {
                List<AndroidFacet> depDeps = AndroidDependenciesCache.dereference(cachedDepDeps);
                for (AndroidFacet depDepFacet : depDeps) {
                    if (!visited.add(depDepFacet)) continue;
                    result2.add(depDepFacet);
                }
            } else {
                AndroidDependenciesCache.collectAllAndroidDependencies(depModule, androidLibrariesOnly, result2, visited);
            }
            result2.add(depFacet);
        }
    }
}

