/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.util;

import com.android.builder.model.AaptOptions;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ValueXmlHelper;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.tools.idea.projectsystem.LightResourceClassService;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.res.AndroidRClassBase;
import com.android.tools.idea.res.PsiResourceItem;
import com.android.tools.idea.res.ResourceHelper;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.android.tools.idea.res.StateList;
import com.android.tools.idea.res.StateListState;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.ide.actions.CreateElementActionBase;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.FileTemplateUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Processor;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.jetbrains.android.AndroidFileTemplateProvider;
import org.jetbrains.android.actions.CreateTypedResourceFileAction;
import org.jetbrains.android.augment.ManifestClass;
import org.jetbrains.android.dom.AndroidDomElement;
import org.jetbrains.android.dom.color.ColorSelector;
import org.jetbrains.android.dom.drawable.DrawableSelector;
import org.jetbrains.android.dom.resources.Item;
import org.jetbrains.android.dom.resources.ResourceElement;
import org.jetbrains.android.dom.resources.Resources;
import org.jetbrains.android.dom.wrappers.LazyValueResourceElementWrapper;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.ResourceFolderManager;
import org.jetbrains.android.resourceManagers.ModuleResourceManagers;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidCommonUtils;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidResourceUtil {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.util.AndroidResourceUtil");
    public static final Set<ResourceType> VALUE_RESOURCE_TYPES = EnumSet.of(ResourceType.DRAWABLE, new ResourceType[]{ResourceType.COLOR, ResourceType.DIMEN, ResourceType.STRING, ResourceType.STYLE, ResourceType.ARRAY, ResourceType.PLURALS, ResourceType.ID, ResourceType.BOOL, ResourceType.INTEGER, ResourceType.FRACTION, ResourceType.LAYOUT});
    public static final Set<ResourceType> ALL_VALUE_RESOURCE_TYPES = EnumSet.noneOf(ResourceType.class);
    static final String ROOT_TAG_PROPERTY = "ROOT_TAG";
    static final String LAYOUT_WIDTH_PROPERTY = "LAYOUT_WIDTH";
    static final String LAYOUT_HEIGHT_PROPERTY = "LAYOUT_HEIGHT";
    private static final String RESOURCE_CLASS_SUFFIX = ".R";
    public static final Comparator<PsiElement> RESOURCE_ELEMENT_COMPARATOR = (e1, e2) -> {
        PsiFile file2;
        if (e1 instanceof LazyValueResourceElementWrapper && e2 instanceof LazyValueResourceElementWrapper) {
            return ((LazyValueResourceElementWrapper)e1).compareTo((LazyValueResourceElementWrapper)e2);
        }
        PsiFile file1 = e1.getContainingFile();
        int delta = AndroidResourceUtil.compareResourceFiles(file1, file2 = e2.getContainingFile());
        if (delta != 0) {
            return delta;
        }
        return e1.getTextOffset() - e2.getTextOffset();
    };

    private AndroidResourceUtil() {
    }

    @NotNull
    public static String normalizeXmlResourceValue(@NotNull String value2) {
        return ValueXmlHelper.escapeResourceString((String)value2, (boolean)false);
    }

    public static String packageToRClass(@NotNull String packageName) {
        return packageName + RESOURCE_CLASS_SUFFIX;
    }

    @NotNull
    public static PsiField[] findResourceFields(@NotNull AndroidFacet facet, @NotNull String resClassName, @NotNull String resourceName, boolean onlyInOwnPackages) {
        return AndroidResourceUtil.findResourceFields(facet, resClassName, Collections.singleton(resourceName), onlyInOwnPackages);
    }

    @NotNull
    public static PsiField[] findResourceFields(@NotNull AndroidFacet facet, @NotNull String resClassName, @NotNull Collection<String> resourceNames, boolean onlyInOwnPackages) {
        ArrayList<PsiField> result2 = new ArrayList<PsiField>();
        for (PsiClass psiClass : AndroidResourceUtil.findRJavaClasses(facet, onlyInOwnPackages)) {
            AndroidResourceUtil.findResourceFieldsFromClass(psiClass, resClassName, resourceNames, result2);
        }
        return result2.toArray(PsiField.EMPTY_ARRAY);
    }

    private static void findResourceFieldsFromClass(@NotNull PsiClass rClass, @NotNull String resClassName, @NotNull Collection<String> resourceNames, @NotNull List<PsiField> result2) {
        PsiClass resourceTypeClass = rClass.findInnerClassByName(resClassName, false);
        if (resourceTypeClass != null) {
            for (String resourceName : resourceNames) {
                String fieldName = AndroidResourceUtil.getRJavaFieldName(resourceName);
                PsiField field2 = resourceTypeClass.findFieldByName(fieldName, false);
                if (field2 == null) continue;
                result2.add(field2);
            }
        }
    }

    @NotNull
    private static Collection<? extends PsiClass> findRJavaClasses(@NotNull AndroidFacet facet, boolean onlyInOwnPackages) {
        Module module = facet.getModule();
        Project project = module.getProject();
        if (facet.getManifest() == null) {
            return Collections.emptySet();
        }
        LightResourceClassService resourceClassService = ProjectSystemUtil.getProjectSystem(facet.getModule().getProject()).getLightResourceClassService();
        return resourceClassService.getLightRClassesContainingModuleResources(module);
    }

    @NotNull
    public static PsiField[] findResourceFieldsForFileResource(@NotNull PsiFile file, boolean onlyInOwnPackages) {
        AndroidFacet facet = AndroidFacet.getInstance((PsiElement)file);
        if (facet == null) {
            return PsiField.EMPTY_ARRAY;
        }
        String resourceType = ModuleResourceManagers.getInstance(facet).getLocalResourceManager().getFileResourceType(file);
        if (resourceType == null) {
            return PsiField.EMPTY_ARRAY;
        }
        String resourceName = AndroidCommonUtils.getResourceName((String)resourceType, (String)file.getName());
        return AndroidResourceUtil.findResourceFields(facet, resourceType, resourceName, onlyInOwnPackages);
    }

    @NotNull
    public static PsiField[] findResourceFieldsForValueResource(XmlTag tag, boolean onlyInOwnPackages) {
        ResourceType resourceType;
        AndroidFacet facet = AndroidFacet.getInstance((PsiElement)tag);
        if (facet == null) {
            return PsiField.EMPTY_ARRAY;
        }
        ResourceFolderType fileResType = ResourceHelper.getFolderType(tag.getContainingFile());
        ResourceType resourceType2 = resourceType = fileResType == ResourceFolderType.VALUES ? AndroidResourceUtil.getResourceTypeForResourceTag(tag) : null;
        if (resourceType == null) {
            return PsiField.EMPTY_ARRAY;
        }
        String name = tag.getAttributeValue("name");
        if (name == null) {
            return PsiField.EMPTY_ARRAY;
        }
        return AndroidResourceUtil.findResourceFields(facet, resourceType.getName(), name, onlyInOwnPackages);
    }

    @NotNull
    public static PsiField[] findStyleableAttributeFields(XmlTag tag, boolean onlyInOwnPackages) {
        XmlTag parentTag;
        String tagName = tag.getName();
        if ("declare-styleable".equals(tagName)) {
            String styleableName = tag.getAttributeValue("name");
            if (styleableName == null) {
                return PsiField.EMPTY_ARRAY;
            }
            AndroidFacet facet = AndroidFacet.getInstance((PsiElement)tag);
            if (facet == null) {
                return PsiField.EMPTY_ARRAY;
            }
            HashSet names = Sets.newHashSet();
            for (XmlTag attr : tag.getSubTags()) {
                String attrName;
                if (!"attr".equals(attr.getName()) || (attrName = attr.getAttributeValue("name")) == null) continue;
                names.add(styleableName + '_' + attrName);
            }
            if (!names.isEmpty()) {
                return AndroidResourceUtil.findResourceFields(facet, ResourceType.STYLEABLE.getName(), names, onlyInOwnPackages);
            }
        } else if ("attr".equals(tagName) && (parentTag = tag.getParentTag()) != null && "declare-styleable".equals(parentTag.getName())) {
            String styleName = parentTag.getAttributeValue("name");
            String attributeName = tag.getAttributeValue("name");
            AndroidFacet facet = AndroidFacet.getInstance((PsiElement)tag);
            if (facet != null && styleName != null && attributeName != null) {
                return AndroidResourceUtil.findResourceFields(facet, ResourceType.STYLEABLE.getName(), styleName + '_' + attributeName, onlyInOwnPackages);
            }
        }
        return PsiField.EMPTY_ARRAY;
    }

    @NotNull
    public static String getRJavaFieldName(@NotNull String resourceName) {
        if (resourceName.indexOf(46) == -1) {
            return resourceName;
        }
        String[] identifiers = resourceName.split("\\.");
        StringBuilder result2 = new StringBuilder(resourceName.length());
        int n = identifiers.length;
        for (int i2 = 0; i2 < n; ++i2) {
            result2.append(identifiers[i2]);
            if (i2 >= n - 1) continue;
            result2.append('_');
        }
        return result2.toString();
    }

    public static boolean isCorrectAndroidResourceName(@NotNull String resourceName) {
        String[] identifiers;
        if (resourceName.isEmpty()) {
            return false;
        }
        if (resourceName.startsWith(".") || resourceName.endsWith(".")) {
            return false;
        }
        for (String identifier : identifiers = resourceName.split("\\.")) {
            if (StringUtil.isJavaIdentifier((String)identifier)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public static ResourceType getResourceTypeForResourceTag(@NotNull XmlTag tag) {
        return ResourceType.fromXmlTag((Object)tag, XmlTag::getName, XmlTag::getAttributeValue);
    }

    @Nullable
    public static String getResourceClassName(@NotNull PsiField field2) {
        PsiClass parentClass;
        PsiClass resourceClass = field2.getContainingClass();
        if (resourceClass != null && (parentClass = resourceClass.getContainingClass()) != null && "R".equals(parentClass.getName()) && parentClass.getContainingClass() == null) {
            return resourceClass.getName();
        }
        return null;
    }

    @NotNull
    public static List<PsiElement> findResourcesByField(@NotNull PsiField field2) {
        AndroidFacet facet = AndroidFacet.getInstance((PsiElement)field2);
        return facet != null ? ModuleResourceManagers.getInstance(facet).getLocalResourceManager().findResourcesByField(field2) : Collections.emptyList();
    }

    public static boolean isResourceField(@NotNull PsiField field2) {
        AndroidFacet facet;
        PsiClass rClass = field2.getContainingClass();
        if (rClass == null) {
            return false;
        }
        return (rClass = rClass.getContainingClass()) != null && "R".equals(rClass.getName()) && (facet = AndroidFacet.getInstance((PsiElement)field2)) != null && AndroidResourceUtil.isRJavaClass(rClass);
    }

    public static boolean isStringResource(@NotNull XmlTag tag) {
        return tag.getName().equals("string") && tag.getAttribute("name") != null;
    }

    @NotNull
    public static PsiField[] findIdFields(@NotNull XmlAttributeValue value2) {
        if (value2.getParent() instanceof XmlAttribute) {
            return AndroidResourceUtil.findIdFields((XmlAttribute)value2.getParent());
        }
        return PsiField.EMPTY_ARRAY;
    }

    public static boolean isIdDeclaration(@Nullable String attrValue) {
        return attrValue != null && attrValue.startsWith("@+id/");
    }

    public static boolean isIdReference(@Nullable String attrValue) {
        return attrValue != null && attrValue.startsWith("@id/");
    }

    public static boolean isIdDeclaration(@NotNull XmlAttributeValue value2) {
        return AndroidResourceUtil.isIdDeclaration(value2.getValue());
    }

    public static boolean isConstraintReferencedIds(@Nullable String nsURI, @Nullable String nsPrefix, @Nullable String key) {
        return "http://schemas.android.com/apk/res-auto".equals(nsURI) && "app".equals(nsPrefix) && "constraint_referenced_ids".equals(key);
    }

    public static boolean isConstraintReferencedIds(@NotNull XmlAttributeValue value2) {
        PsiElement parent = value2.getParent();
        if (parent instanceof XmlAttribute) {
            XmlAttribute xmlAttribute = (XmlAttribute)parent;
            String nsURI = xmlAttribute.getNamespace();
            String nsPrefix = xmlAttribute.getNamespacePrefix();
            String key = xmlAttribute.getLocalName();
            return AndroidResourceUtil.isConstraintReferencedIds(nsURI, nsPrefix, key);
        }
        return false;
    }

    @NotNull
    public static PsiField[] findIdFields(@NotNull XmlAttribute attribute) {
        AndroidFacet facet;
        String id;
        XmlAttributeValue valueElement = attribute.getValueElement();
        String value2 = attribute.getValue();
        if (valueElement != null && value2 != null && AndroidResourceUtil.isIdDeclaration(valueElement) && (id = AndroidResourceUtil.getResourceNameByReferenceText(value2)) != null && (facet = AndroidFacet.getInstance((PsiElement)attribute)) != null) {
            return AndroidResourceUtil.findResourceFields(facet, ResourceType.ID.getName(), id, false);
        }
        return PsiField.EMPTY_ARRAY;
    }

    @NotNull
    public static String getValidResourceFileName(@NotNull String base) {
        return base.replace('-', '_').replace(' ', '_').toLowerCase(Locale.US);
    }

    @Nullable
    public static String getResourceNameByReferenceText(@NotNull String text) {
        int i2 = text.indexOf(47);
        if (i2 < text.length() - 1) {
            return text.substring(i2 + 1);
        }
        return null;
    }

    @NotNull
    public static ResourceElement addValueResource(@NotNull ResourceType resType, @NotNull Resources resources, @Nullable String value2) {
        switch (resType) {
            case STRING: {
                return resources.addString();
            }
            case PLURALS: {
                return resources.addPlurals();
            }
            case DIMEN: {
                if (value2 != null && value2.trim().endsWith("%")) {
                    Item item = resources.addItem();
                    item.getType().setStringValue(ResourceType.DIMEN.getName());
                    return item;
                }
                if (value2 != null && value2.indexOf(46) > 0) {
                    Item item = resources.addItem();
                    item.getType().setStringValue(ResourceType.DIMEN.getName());
                    item.getFormat().setStringValue("float");
                    return item;
                }
                return resources.addDimen();
            }
            case COLOR: {
                return resources.addColor();
            }
            case DRAWABLE: {
                return resources.addDrawable();
            }
            case STYLE: {
                return resources.addStyle();
            }
            case ARRAY: {
                return resources.addStringArray();
            }
            case INTEGER: {
                return resources.addInteger();
            }
            case FRACTION: {
                return resources.addFraction();
            }
            case BOOL: {
                return resources.addBool();
            }
            case ID: {
                Item item = resources.addItem();
                item.getType().setValue((Object)ResourceType.ID.getName());
                return item;
            }
            case ATTR: {
                return resources.addAttr();
            }
            case STYLEABLE: {
                return resources.addDeclareStyleable();
            }
        }
        throw new IllegalArgumentException("Incorrect resource type");
    }

    @NotNull
    public static List<VirtualFile> getResourceSubdirs(@NotNull ResourceFolderType resourceType, @NotNull Collection<VirtualFile> resourceDirs) {
        ArrayList<VirtualFile> dirs = new ArrayList<VirtualFile>();
        for (VirtualFile resourcesDir : resourceDirs) {
            if (resourcesDir == null || !resourcesDir.isValid()) continue;
            for (VirtualFile child : resourcesDir.getChildren()) {
                ResourceFolderType type = ResourceFolderType.getFolderType((String)child.getName());
                if (!resourceType.equals((Object)type)) continue;
                dirs.add(child);
            }
        }
        return dirs;
    }

    @Nullable
    public static String getDefaultResourceFileName(@NotNull ResourceType type) {
        if (ResourceType.PLURALS == type || ResourceType.STRING == type) {
            return "strings.xml";
        }
        if (VALUE_RESOURCE_TYPES.contains(type)) {
            if (type == ResourceType.LAYOUT || type == ResourceType.DRAWABLE && !ApplicationManager.getApplication().isUnitTestMode()) {
                return "refs.xml";
            }
            return type.getName() + "s.xml";
        }
        if (ResourceType.ATTR == type || ResourceType.STYLEABLE == type) {
            return "attrs.xml";
        }
        return null;
    }

    @NotNull
    public static List<ResourceElement> getValueResourcesFromElement(@NotNull ResourceType resourceType, @NotNull Resources resources) {
        ArrayList<ResourceElement> result2 = new ArrayList<ResourceElement>();
        switch (resourceType) {
            case STRING: {
                result2.addAll(resources.getStrings());
                break;
            }
            case PLURALS: {
                result2.addAll(resources.getPluralses());
                break;
            }
            case DRAWABLE: {
                result2.addAll(resources.getDrawables());
                break;
            }
            case COLOR: {
                result2.addAll(resources.getColors());
                break;
            }
            case DIMEN: {
                result2.addAll(resources.getDimens());
                break;
            }
            case STYLE: {
                result2.addAll(resources.getStyles());
                break;
            }
            case ARRAY: {
                result2.addAll(resources.getStringArrays());
                result2.addAll(resources.getIntegerArrays());
                result2.addAll(resources.getArrays());
                break;
            }
            case INTEGER: {
                result2.addAll(resources.getIntegers());
                break;
            }
            case FRACTION: {
                result2.addAll(resources.getFractions());
                break;
            }
            case BOOL: {
                result2.addAll(resources.getBools());
                break;
            }
        }
        for (Item item : resources.getItems()) {
            String type = (String)item.getType().getValue();
            if (!resourceType.getName().equals(type)) continue;
            result2.add(item);
        }
        return result2;
    }

    public static boolean isInResourceSubdirectory(@NotNull PsiFile file, @Nullable String resourceType) {
        PsiDirectory dir = (file = file.getOriginalFile()).getContainingDirectory();
        if (dir == null) {
            return false;
        }
        return AndroidResourceUtil.isResourceSubdirectory(dir, resourceType);
    }

    public static boolean isResourceSubdirectory(@NotNull PsiDirectory directory, @Nullable String resourceType) {
        PsiDirectory dir = directory;
        String dirName = dir.getName();
        if (resourceType != null) {
            int typeLength = resourceType.length();
            int dirLength = dirName.length();
            if (dirLength < typeLength || !dirName.startsWith(resourceType) || dirLength > typeLength && dirName.charAt(typeLength) != '-') {
                return false;
            }
        }
        if ((dir = dir.getParent()) == null) {
            return false;
        }
        if ("default".equals(dir.getName())) {
            dir = dir.getParentDirectory();
        }
        return dir != null && AndroidResourceUtil.isResourceDirectory(dir);
    }

    public static boolean isLocalResourceDirectory(@NotNull VirtualFile dir, @NotNull Project project) {
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)dir, (Project)project);
        if (module != null) {
            AndroidFacet facet = AndroidFacet.getInstance(module);
            return facet != null && ModuleResourceManagers.getInstance(facet).getLocalResourceManager().isResourceDir(dir);
        }
        return false;
    }

    public static boolean isResourceFile(@NotNull VirtualFile file, @NotNull AndroidFacet facet) {
        VirtualFile parent = file.getParent();
        VirtualFile resDir = parent != null ? parent.getParent() : null;
        return resDir != null && ModuleResourceManagers.getInstance(facet).getLocalResourceManager().isResourceDir(resDir);
    }

    public static boolean isResourceDirectory(@NotNull PsiDirectory directory) {
        PsiDirectory dir = directory;
        VirtualFile vf = dir.getVirtualFile();
        if (AndroidResourceUtil.isLocalResourceDirectory(vf, dir.getProject())) {
            return true;
        }
        if (!"res".equals(dir.getName())) {
            return false;
        }
        if ((dir = dir.getParent()) != null) {
            String protocol = vf.getFileSystem().getProtocol();
            if (protocol.equals("jar") || protocol.equals("apk")) {
                return true;
            }
            if (dir.findFile("AndroidManifest.xml") != null) {
                return true;
            }
            if ((dir = dir.getParent()) != null) {
                if (AndroidResourceUtil.containsAndroidJar(dir)) {
                    return true;
                }
                if ((dir = dir.getParent()) != null) {
                    return AndroidResourceUtil.containsAndroidJar(dir);
                }
            }
        }
        return false;
    }

    private static boolean containsAndroidJar(@NotNull PsiDirectory psiDirectory) {
        return psiDirectory.findFile("android.jar") != null;
    }

    public static boolean isRJavaClass(@NotNull PsiClass psiClass) {
        return psiClass instanceof AndroidRClassBase;
    }

    public static boolean isManifestClass(@NotNull PsiClass psiClass) {
        return psiClass instanceof ManifestClass;
    }

    public static boolean createValueResource(@NotNull Project project, @NotNull VirtualFile resDir, @NotNull String resourceName, @Nullable String resourceValue2, @NotNull ResourceType resourceType, @NotNull String fileName, @NotNull List<String> dirNames, @NotNull Processor<ResourceElement> afterAddedProcessor) {
        try {
            return AndroidResourceUtil.addValueResource(project, resDir, resourceName, resourceType, fileName, dirNames, resourceValue2, afterAddedProcessor);
        }
        catch (Exception e) {
            String message2 = CreateElementActionBase.filterMessage((String)e.getMessage());
            if (message2 == null || message2.isEmpty()) {
                LOG.error((Throwable)e);
            } else {
                LOG.info((Throwable)e);
                AndroidUtils.reportError(project, message2);
            }
            return false;
        }
    }

    public static boolean createValueResource(@NotNull Project project, @NotNull VirtualFile resDir, @NotNull String resourceName, @NotNull ResourceType resourceType, @NotNull String fileName, @NotNull List<String> dirNames, @NotNull String value2) {
        return AndroidResourceUtil.createValueResource(project, resDir, resourceName, resourceType, fileName, dirNames, value2, null);
    }

    public static boolean createValueResource(@NotNull Project project, @NotNull VirtualFile resDir, @NotNull String resourceName, @NotNull ResourceType resourceType, @NotNull String fileName, @NotNull List<String> dirNames, @NotNull String value2, @Nullable List<ResourceElement> outTags) {
        return AndroidResourceUtil.createValueResource(project, resDir, resourceName, value2, resourceType, fileName, dirNames, (Processor<ResourceElement>)((Processor)element -> {
            if (!value2.isEmpty()) {
                String s = resourceType == ResourceType.STRING ? AndroidResourceUtil.normalizeXmlResourceValue(value2) : value2;
                element.setStringValue(s);
            } else if (resourceType == ResourceType.STYLEABLE || resourceType == ResourceType.STYLE) {
                element.setStringValue("value");
                element.getXmlTag().getValue().setText("");
            }
            if (outTags != null) {
                outTags.add((ResourceElement)element);
            }
            return true;
        }));
    }

    private static boolean addValueResource(@NotNull Project project, @NotNull VirtualFile resDir, @NotNull String resourceName, @NotNull ResourceType resourceType, @NotNull String fileName, @NotNull List<String> dirNames, @Nullable String resourceValue2, @NotNull Processor<ResourceElement> afterAddedProcessor) throws Exception {
        if (dirNames.isEmpty()) {
            return false;
        }
        VirtualFile[] resFiles = new VirtualFile[dirNames.size()];
        int n = dirNames.size();
        for (int i2 = 0; i2 < n; ++i2) {
            String dirName = dirNames.get(i2);
            resFiles[i2] = (VirtualFile)WriteAction.compute(() -> AndroidResourceUtil.findOrCreateResourceFile(project, resDir, fileName, dirName));
            if (resFiles[i2] != null) continue;
            return false;
        }
        if (!ReadonlyStatusHandler.ensureFilesWritable((Project)project, (VirtualFile[])resFiles)) {
            return false;
        }
        Resources[] resourcesElements = new Resources[resFiles.length];
        for (int i3 = 0; i3 < resFiles.length; ++i3) {
            Resources resources = AndroidUtils.loadDomElement(project, resFiles[i3], Resources.class);
            if (resources == null) {
                AndroidUtils.reportError(project, AndroidBundle.message("not.resource.file.error", fileName));
                return false;
            }
            resourcesElements[i3] = resources;
        }
        ArrayList psiFiles = Lists.newArrayListWithExpectedSize((int)resFiles.length);
        PsiManager manager = PsiManager.getInstance((Project)project);
        for (VirtualFile file : resFiles) {
            PsiFile psiFile = manager.findFile(file);
            if (psiFile == null) continue;
            psiFiles.add(psiFile);
        }
        WriteCommandAction.writeCommandAction((Project)project, (PsiFile[])psiFiles.toArray(PsiFile.EMPTY_ARRAY)).withName("Add Resource").run(() -> {
            for (Resources resources : resourcesElements) {
                ResourceElement element = AndroidResourceUtil.addValueResource(resourceType, resources, resourceValue2);
                element.getName().setValue((Object)resourceName);
                afterAddedProcessor.process((Object)element);
            }
        });
        return true;
    }

    public static boolean changeValueResource(final @NotNull Project project, @NotNull VirtualFile resDir, final @NotNull String name, final @NotNull ResourceType resourceType, final @NotNull String newValue, @NotNull String fileName, @NotNull List<String> dirNames, final boolean useGlobalCommand) {
        if (dirNames.isEmpty()) {
            return false;
        }
        ArrayList resFiles = Lists.newArrayListWithExpectedSize((int)dirNames.size());
        for (String dirName : dirNames) {
            VirtualFile resFile = AndroidResourceUtil.findResourceFile(resDir, fileName, dirName);
            if (resFile == null) continue;
            resFiles.add(resFile);
        }
        if (!AndroidResourceUtil.ensureFilesWritable(project, resFiles)) {
            return false;
        }
        final Resources[] resourcesElements = new Resources[resFiles.size()];
        for (int i2 = 0; i2 < resFiles.size(); ++i2) {
            Resources resources = AndroidUtils.loadDomElement(project, (VirtualFile)resFiles.get(i2), Resources.class);
            if (resources == null) {
                AndroidUtils.reportError(project, AndroidBundle.message("not.resource.file.error", fileName));
                return false;
            }
            resourcesElements[i2] = resources;
        }
        ArrayList psiFiles = Lists.newArrayListWithExpectedSize((int)resFiles.size());
        PsiManager manager = PsiManager.getInstance((Project)project);
        for (VirtualFile file : resFiles) {
            PsiFile psiFile = manager.findFile(file);
            if (psiFile == null) continue;
            psiFiles.add(psiFile);
        }
        PsiFile[] files2 = psiFiles.toArray(PsiFile.EMPTY_ARRAY);
        WriteCommandAction<Boolean> action2 = new WriteCommandAction<Boolean>(project, "Change " + resourceType.getName() + " Resource", files2){

            protected void run(@NotNull Result<Boolean> result2) {
                if (useGlobalCommand) {
                    CommandProcessor.getInstance().markCurrentCommandAsGlobal(project);
                }
                result2.setResult((Object)false);
                for (Resources resources : resourcesElements) {
                    for (ResourceElement element : AndroidResourceUtil.getValueResourcesFromElement(resourceType, resources)) {
                        String value2 = element.getName().getStringValue();
                        if (!name.equals(value2)) continue;
                        element.setStringValue(newValue);
                        result2.setResult((Object)true);
                    }
                }
            }
        };
        return (Boolean)action2.execute().getResultObject();
    }

    @Nullable
    private static VirtualFile findResourceFile(@NotNull VirtualFile resDir, @NotNull String fileName, @NotNull String dirName) {
        VirtualFile dir = resDir.findChild(dirName);
        if (dir == null) {
            return null;
        }
        return dir.findChild(fileName);
    }

    @Nullable
    private static VirtualFile findOrCreateResourceFile(@NotNull Project project, @NotNull VirtualFile resDir, @NotNull String fileName, @NotNull String dirName) throws Exception {
        VirtualFile dir = AndroidUtils.createChildDirectoryIfNotExist(project, resDir, dirName);
        String dirPath = FileUtil.toSystemDependentName((String)(resDir.getPath() + '/' + dirName));
        if (dir == null) {
            AndroidUtils.reportError(project, AndroidBundle.message("android.cannot.create.dir.error", dirPath));
            return null;
        }
        VirtualFile file = dir.findChild(fileName);
        if (file != null) {
            return file;
        }
        AndroidFileTemplateProvider.createFromTemplate(project, dir, "valueResourceFile.xml", fileName);
        VirtualFile result2 = dir.findChild(fileName);
        if (result2 == null) {
            AndroidUtils.reportError(project, AndroidBundle.message("android.cannot.create.file.error", dirPath + File.separatorChar + fileName));
        }
        return result2;
    }

    @Nullable
    public static MyReferredResourceFieldInfo getReferredResourceOrManifestField(@NotNull AndroidFacet facet, @NotNull PsiReferenceExpression exp, boolean localOnly) {
        return AndroidResourceUtil.getReferredResourceOrManifestField(facet, exp, null, localOnly);
    }

    @Nullable
    public static MyReferredResourceFieldInfo getReferredResourceOrManifestField(@NotNull AndroidFacet facet, @NotNull PsiReferenceExpression exp, @Nullable String className, boolean localOnly) {
        String resFieldName = exp.getReferenceName();
        if (resFieldName == null || resFieldName.isEmpty()) {
            return null;
        }
        PsiExpression qExp = exp.getQualifierExpression();
        if (!(qExp instanceof PsiReferenceExpression)) {
            return null;
        }
        PsiReferenceExpression resClassReference = (PsiReferenceExpression)qExp;
        String resClassName = resClassReference.getReferenceName();
        if (resClassName == null || resClassName.isEmpty() || className != null && !className.equals(resClassName)) {
            return null;
        }
        qExp = resClassReference.getQualifierExpression();
        if (!(qExp instanceof PsiReferenceExpression)) {
            return null;
        }
        PsiElement resolvedElement = ((PsiReferenceExpression)qExp).resolve();
        if (!(resolvedElement instanceof PsiClass)) {
            return null;
        }
        Module resolvedModule = ModuleUtilCore.findModuleForPsiElement((PsiElement)resolvedElement);
        PsiClass aClass = (PsiClass)resolvedElement;
        String classShortName = aClass.getName();
        boolean fromManifest = "Manifest".equals(classShortName);
        if (!fromManifest && !"R".equals(classShortName)) {
            return null;
        }
        String qName = aClass.getQualifiedName();
        if (qName == null) {
            return null;
        }
        if (!localOnly && ("android.R".equals(qName) || "com.android.internal.R".equals(qName))) {
            return new MyReferredResourceFieldInfo(resClassName, resFieldName, resolvedModule, ResourceNamespace.ANDROID, false);
        }
        if (fromManifest ? !AndroidResourceUtil.isManifestClass(aClass) : !AndroidResourceUtil.isRJavaClass(aClass)) {
            return null;
        }
        return new MyReferredResourceFieldInfo(resClassName, resFieldName, resolvedModule, AndroidResourceUtil.getRClassNamespace(facet, qName), fromManifest);
    }

    @NotNull
    public static ResourceNamespace getRClassNamespace(@NotNull AndroidFacet facet, String qName) {
        ResourceNamespace resourceNamespace = ResourceRepositoryManager.getInstance(facet).getNamespacing() == AaptOptions.Namespacing.DISABLED ? ResourceNamespace.RES_AUTO : ResourceNamespace.fromPackageName((String)StringUtil.getPackageName((String)qName));
        return resourceNamespace;
    }

    public static int compareResourceFiles(@Nullable VirtualFile file1, @Nullable VirtualFile file2) {
        if (file1 != null && file1.equals(file2) || file1 == file2) {
            return 0;
        }
        if (file1 != null && file2 != null) {
            boolean xml2;
            boolean xml1 = file1.getFileType() == StdFileTypes.XML;
            boolean bl = xml2 = file2.getFileType() == StdFileTypes.XML;
            if (xml1 != xml2) {
                return xml1 ? -1 : 1;
            }
            VirtualFile parent1 = file1.getParent();
            VirtualFile parent2 = file2.getParent();
            if (parent1 != null && parent2 != null && !parent1.equals(parent2)) {
                boolean qualifier2;
                String parentName1 = parent1.getName();
                String parentName2 = parent2.getName();
                boolean qualifier1 = parentName1.indexOf(45) != -1;
                boolean bl2 = qualifier2 = parentName2.indexOf(45) != -1;
                if (qualifier1 != qualifier2) {
                    return qualifier1 ? 1 : -1;
                }
                if (qualifier1) {
                    FolderConfiguration config1 = FolderConfiguration.getConfigForFolder((String)parentName1);
                    FolderConfiguration config2 = FolderConfiguration.getConfigForFolder((String)parentName2);
                    if (config1 != null && config2 != null) {
                        return config1.compareTo(config2);
                    }
                    if (config1 != null) {
                        return -1;
                    }
                    if (config2 != null) {
                        return 1;
                    }
                    int delta = parentName1.compareTo(parentName2);
                    if (delta != 0) {
                        return delta;
                    }
                }
            }
            return file1.getPath().compareTo(file2.getPath());
        }
        if (file1 != null) {
            return -1;
        }
        return 1;
    }

    public static int compareResourceFiles(@Nullable PsiFile file1, @Nullable PsiFile file2) {
        if (file1 == file2) {
            return 0;
        }
        if (file1 != null && file2 != null) {
            boolean xml2;
            boolean xml1 = file1.getFileType() == StdFileTypes.XML;
            boolean bl = xml2 = file2.getFileType() == StdFileTypes.XML;
            if (xml1 != xml2) {
                return xml1 ? -1 : 1;
            }
            PsiDirectory parent1 = file1.getParent();
            PsiDirectory parent2 = file2.getParent();
            if (parent1 != null && parent2 != null && parent1 != parent2) {
                boolean qualifier2;
                String parentName1 = parent1.getName();
                String parentName2 = parent2.getName();
                boolean qualifier1 = parentName1.indexOf(45) != -1;
                boolean bl2 = qualifier2 = parentName2.indexOf(45) != -1;
                if (qualifier1 != qualifier2) {
                    return qualifier1 ? 1 : -1;
                }
                if (qualifier1) {
                    FolderConfiguration config1 = FolderConfiguration.getConfigForFolder((String)parentName1);
                    FolderConfiguration config2 = FolderConfiguration.getConfigForFolder((String)parentName2);
                    if (config1 != null && config2 != null) {
                        return config1.compareTo(config2);
                    }
                    if (config1 != null) {
                        return -1;
                    }
                    if (config2 != null) {
                        return 1;
                    }
                    int delta = parentName1.compareTo(parentName2);
                    if (delta != 0) {
                        return delta;
                    }
                }
            }
            return file1.getName().compareTo(file2.getName());
        }
        if (file1 != null) {
            return -1;
        }
        return 1;
    }

    public static boolean ensureFilesWritable(@NotNull Project project, @NotNull Collection<VirtualFile> files2) {
        return !ReadonlyStatusHandler.getInstance((Project)project).ensureFilesWritable(files2).hasReadonlyFiles();
    }

    @NotNull
    public static Map<VirtualFile, AndroidFacet> getResourceDirectoriesForFacets(@NotNull List<AndroidFacet> facets) {
        HashMap<VirtualFile, AndroidFacet> resDirectories = new HashMap<VirtualFile, AndroidFacet>();
        for (AndroidFacet facet : facets) {
            for (VirtualFile resourceDir : ResourceFolderManager.getInstance(facet).getFolders()) {
                if (resDirectories.containsKey(resourceDir)) continue;
                resDirectories.put(resourceDir, facet);
            }
        }
        return resDirectories;
    }

    @Nullable
    public static PsiFile getItemPsiFile(@NotNull Project project, @NotNull ResourceItem item) {
        if (project.isDisposed()) {
            return null;
        }
        if (item instanceof PsiResourceItem) {
            PsiResourceItem psiResourceItem = (PsiResourceItem)item;
            return psiResourceItem.getPsiFile();
        }
        VirtualFile virtualFile = ResourceHelper.getSourceAsVirtualFile(item);
        if (virtualFile != null) {
            PsiManager psiManager = PsiManager.getInstance((Project)project);
            return psiManager.findFile(virtualFile);
        }
        return null;
    }

    @Nullable
    public static XmlAttribute getIdDeclarationAttribute(@NotNull Project project, @NotNull ResourceItem idResource) {
        assert (idResource.getType() == ResourceType.ID);
        PsiFile psiFile = AndroidResourceUtil.getItemPsiFile(project, idResource);
        if (!(psiFile instanceof XmlFile)) {
            return null;
        }
        XmlFile xmlFile = (XmlFile)psiFile;
        String resourceName = idResource.getName();
        PsiElementProcessor.FindFilteredElement processor = new PsiElementProcessor.FindFilteredElement(element -> {
            ResourceUrl resourceUrl;
            XmlAttribute attr;
            String attrValue;
            return element instanceof XmlAttribute && AndroidResourceUtil.isIdDeclaration(attrValue = (attr = (XmlAttribute)element).getValue()) && (resourceUrl = ResourceUrl.parse((String)attrValue)) != null && resourceUrl.name.equals(resourceName);
        });
        PsiTreeUtil.processElements((PsiElement)xmlFile, (PsiElementProcessor)processor);
        return (XmlAttribute)processor.getFoundElement();
    }

    @NotNull
    public static XmlFile createFileResource(@NotNull String fileName, @NotNull PsiDirectory resSubdir, @NotNull String rootTagName, @NotNull String resourceType, boolean valuesResourceFile) throws Exception {
        FileTemplateManager manager = FileTemplateManager.getInstance((Project)resSubdir.getProject());
        String templateName = AndroidResourceUtil.getTemplateName(resourceType, valuesResourceFile, rootTagName);
        FileTemplate template = manager.getJ2eeTemplate(templateName);
        Properties properties = new Properties();
        if (!valuesResourceFile) {
            properties.setProperty(ROOT_TAG_PROPERTY, rootTagName);
        }
        if (ResourceType.LAYOUT.getName().equals(resourceType)) {
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)resSubdir);
            AndroidPlatform platform = module != null ? AndroidPlatform.getInstance(module) : null;
            int apiLevel = platform != null ? platform.getApiLevel() : -1;
            String value2 = apiLevel == -1 || apiLevel >= 8 ? "match_parent" : "fill_parent";
            properties.setProperty(LAYOUT_WIDTH_PROPERTY, value2);
            properties.setProperty(LAYOUT_HEIGHT_PROPERTY, value2);
        }
        PsiElement createdElement = FileTemplateUtil.createFromTemplate((FileTemplate)template, (String)fileName, (Properties)properties, (PsiDirectory)resSubdir);
        assert (createdElement instanceof XmlFile);
        return (XmlFile)createdElement;
    }

    private static String getTemplateName(@NotNull String resourceType, boolean valuesResourceFile, @NotNull String rootTagName) {
        if (valuesResourceFile) {
            return "valueResourceFile.xml";
        }
        if (ResourceType.LAYOUT.getName().equals(resourceType) && !"layout".equals(rootTagName) && !"merge".equals(rootTagName)) {
            return "LinearLayout".equals(rootTagName) ? "layoutResourceFile_vertical.xml" : "layoutResourceFile.xml";
        }
        if (ResourceType.NAVIGATION.getName().equals(resourceType)) {
            return "navigationResourceFile.xml";
        }
        return "resourceFile.xml";
    }

    @NotNull
    public static String getFieldNameByResourceName(@NotNull String styleName) {
        int n = styleName.length();
        for (int i2 = 0; i2 < n; ++i2) {
            char c = styleName.charAt(i2);
            if (c != '.' && c != '-' && c != ':') continue;
            return styleName.replace('.', '_').replace('-', '_').replace(':', '_');
        }
        return styleName;
    }

    @Nullable
    public static List<VirtualFile> findOrCreateStateListFiles(final @NotNull Project project, final @NotNull VirtualFile resDir, final @NotNull ResourceFolderType folderType, final @NotNull ResourceType resourceType, final @NotNull String stateListName, final @NotNull List<String> dirNames) {
        final PsiManager manager = PsiManager.getInstance((Project)project);
        final ArrayList files2 = Lists.newArrayListWithCapacity((int)dirNames.size());
        boolean foundFiles = (Boolean)new WriteCommandAction<Boolean>(project, "Find statelists files", new PsiFile[0]){

            protected void run(@NotNull Result<Boolean> result2) {
                result2.setResult((Object)true);
                try {
                    String fileName = stateListName;
                    if (!stateListName.endsWith(".xml")) {
                        fileName = fileName + ".xml";
                    }
                    for (String dirName : dirNames) {
                        String dirPath = FileUtil.toSystemDependentName((String)(resDir.getPath() + '/' + dirName));
                        VirtualFile dir = AndroidUtils.createChildDirectoryIfNotExist(project, resDir, dirName);
                        if (dir == null) {
                            throw new IOException("cannot make " + resDir + File.separatorChar + dirName);
                        }
                        VirtualFile file = dir.findChild(fileName);
                        if (file != null) {
                            files2.add(file);
                            continue;
                        }
                        PsiDirectory directory = manager.findDirectory(dir);
                        if (directory == null) {
                            throw new IOException("cannot find " + resDir + File.separatorChar + dirName);
                        }
                        AndroidResourceUtil.createFileResource(fileName, directory, CreateTypedResourceFileAction.getDefaultRootTagByResourceType(folderType), resourceType.getName(), false);
                        file = dir.findChild(fileName);
                        if (file == null) {
                            throw new IOException("cannot find " + Joiner.on((char)File.separatorChar).join((Object)resDir, (Object)dirPath, new Object[]{fileName}));
                        }
                        files2.add(file);
                    }
                }
                catch (Exception e) {
                    LOG.error(e.getMessage());
                    result2.setResult((Object)false);
                }
            }
        }.execute().getResultObject();
        return foundFiles ? files2 : null;
    }

    public static void updateStateList(@NotNull Project project, final @NotNull StateList stateList, @NotNull List<VirtualFile> files2) {
        if (!AndroidResourceUtil.ensureFilesWritable(project, files2)) {
            return;
        }
        ArrayList psiFiles = Lists.newArrayListWithCapacity((int)files2.size());
        PsiManager manager = PsiManager.getInstance((Project)project);
        for (VirtualFile file : files2) {
            PsiFile psiFile = manager.findFile(file);
            if (psiFile == null) continue;
            psiFiles.add(psiFile);
        }
        final ArrayList selectors = Lists.newArrayListWithCapacity((int)files2.size());
        Class selectorClass = stateList.getFolderType() == ResourceFolderType.COLOR ? ColorSelector.class : DrawableSelector.class;
        for (VirtualFile file : files2) {
            AndroidDomElement selector = AndroidUtils.loadDomElement(project, file, selectorClass);
            if (selector == null) {
                AndroidUtils.reportError(project, file.getName() + " is not a statelist file");
                return;
            }
            selectors.add(selector);
        }
        new WriteCommandAction.Simple(project, "Change State List", psiFiles.toArray(PsiFile.EMPTY_ARRAY)){

            protected void run() {
                for (AndroidDomElement selector : selectors) {
                    XmlTag tag = selector.getXmlTag();
                    for (XmlTag subtag : tag.getSubTags()) {
                        subtag.delete();
                    }
                    for (StateListState state : stateList.getStates()) {
                        XmlTag child = tag.createChildTag("item", tag.getNamespace(), null, false);
                        child = tag.addSubTag(child, false);
                        Map<String, Boolean> attributes = state.getAttributes();
                        for (String attributeName : attributes.keySet()) {
                            child.setAttribute(attributeName, "http://schemas.android.com/apk/res/android", attributes.get(attributeName).toString());
                        }
                        if (!StringUtil.isEmpty((String)state.getAlpha())) {
                            child.setAttribute("alpha", "http://schemas.android.com/apk/res/android", state.getAlpha());
                        }
                        if (selector instanceof ColorSelector) {
                            child.setAttribute("color", "http://schemas.android.com/apk/res/android", state.getValue());
                            continue;
                        }
                        if (!(selector instanceof DrawableSelector)) continue;
                        child.setAttribute("drawable", "http://schemas.android.com/apk/res/android", state.getValue());
                    }
                }
                FileDocumentManager.getInstance().saveAllDocuments();
            }
        }.execute();
    }

    @NotNull
    public static String ensureNamespaceImported(@NotNull XmlFile file, @NotNull String namespaceUri, @Nullable String suggestedPrefix) {
        XmlTag rootTag = file.getRootTag();
        assert (rootTag != null);
        XmlElementFactory elementFactory = XmlElementFactory.getInstance((Project)file.getProject());
        if (StringUtil.isEmpty((String)namespaceUri)) {
            return "";
        }
        String prefix = rootTag.getPrefixByNamespace(namespaceUri);
        if (prefix != null) {
            return prefix;
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        prefix = suggestedPrefix != null ? suggestedPrefix : ("http://schemas.android.com/tools".equals(namespaceUri) ? "tools" : ("http://schemas.android.com/apk/res/android".equals(namespaceUri) ? "android" : ("http://schemas.android.com/aapt".equals(namespaceUri) ? "aapt" : "app")));
        if (rootTag.getAttribute("xmlns:" + prefix) != null) {
            String base = prefix;
            int i2 = 2;
            while (true) {
                prefix = base + Integer.toString(i2);
                if (rootTag.getAttribute("xmlns:" + prefix) == null) break;
                ++i2;
            }
        }
        String name = "xmlns:" + prefix;
        XmlAttribute xmlnsAttr = elementFactory.createXmlAttribute(name, namespaceUri);
        XmlAttribute[] attributes = rootTag.getAttributes();
        XmlAttribute next = attributes.length > 0 ? attributes[0] : null;
        for (XmlAttribute attribute : attributes) {
            String attributeName = attribute.getName();
            if (attributeName.startsWith("xmlns:") && attributeName.compareTo(name) <= 0) continue;
            next = attribute;
            break;
        }
        if (next != null) {
            rootTag.addBefore((PsiElement)xmlnsAttr, (PsiElement)next);
        } else {
            rootTag.add((PsiElement)xmlnsAttr);
        }
        return prefix;
    }

    static {
        ALL_VALUE_RESOURCE_TYPES.addAll(VALUE_RESOURCE_TYPES);
        ALL_VALUE_RESOURCE_TYPES.add(ResourceType.ATTR);
        ALL_VALUE_RESOURCE_TYPES.add(ResourceType.STYLEABLE);
    }

    public static class MyReferredResourceFieldInfo {
        @NotNull
        private final String myClassName;
        @NotNull
        private final String myFieldName;
        @Nullable
        private final Module myResolvedModule;
        @NotNull
        private final ResourceNamespace myNamespace;
        private final boolean myFromManifest;

        public MyReferredResourceFieldInfo(@NotNull String className, @NotNull String fieldName, @Nullable Module resolvedModule, @NotNull ResourceNamespace namespace, boolean fromManifest) {
            this.myClassName = className;
            this.myFieldName = fieldName;
            this.myNamespace = namespace;
            this.myResolvedModule = resolvedModule;
            this.myFromManifest = fromManifest;
        }

        @NotNull
        public String getClassName() {
            return this.myClassName;
        }

        @NotNull
        public String getFieldName() {
            return this.myFieldName;
        }

        @NotNull
        public ResourceNamespace getNamespace() {
            return this.myNamespace;
        }

        @Nullable
        public Module getResolvedModule() {
            return this.myResolvedModule;
        }

        public boolean isFromManifest() {
            return this.myFromManifest;
        }
    }
}

