/*
 * Decompiled with CFR 0.152.
 */
package com.android.java.model.builder;

import com.android.java.model.JavaLibrary;
import com.android.java.model.JavaProject;
import com.android.java.model.LibraryVersion;
import com.android.java.model.SourceSet;
import com.android.java.model.impl.JavaLibraryImpl;
import com.android.java.model.impl.JavaProjectImpl;
import com.android.java.model.impl.LibraryVersionImpl;
import com.android.java.model.impl.SourceSetImpl;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.LenientConfiguration;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ModuleVersionSelector;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.SelfResolvingDependency;
import org.gradle.api.artifacts.UnresolvedDependency;
import org.gradle.api.artifacts.component.BuildIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.initialization.IncludedBuild;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.specs.Specs;
import org.gradle.tooling.provider.model.ToolingModelBuilder;
import org.gradle.util.VersionNumber;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\u0005H\u0016R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/android/java/model/builder/JavaModelBuilder;", "Lorg/gradle/tooling/provider/model/ToolingModelBuilder;", "()V", "buildMapping", "", "", "buildAll", "", "modelName", "project", "Lorg/gradle/api/Project;", "canBuild", "", "Companion", "android.sdktools.java-lib-model-builder"})
public final class JavaModelBuilder
implements ToolingModelBuilder {
    private Map<String, String> buildMapping;
    private static final String UNRESOLVED_DEPENDENCY_PREFIX = "unresolved dependency - ";
    private static final String LOCAL_JAR_DISPLAY_NAME = "local jar - ";
    private static final String CURRENT_BUILD_NAME = "__current_build__";
    public static final Companion Companion = new Companion(null);

    public boolean canBuild(@NotNull String modelName) {
        return Intrinsics.areEqual((Object)modelName, (Object)JavaProject.class.getName());
    }

    @Nullable
    public Object buildAll(@NotNull String modelName, @NotNull Project project) {
        if (!project.getPlugins().hasPlugin(JavaPlugin.class)) {
            return null;
        }
        if (this.buildMapping.isEmpty() && JavaModelBuilder.Companion.isCompositeBuildSupported(project)) {
            this.buildMapping = JavaModelBuilder.Companion.computeBuildMapping(project.getGradle());
        }
        JavaPluginConvention javaPlugin = (JavaPluginConvention)project.getConvention().findPlugin(JavaPluginConvention.class);
        ArrayList<SourceSet> sourceSets = new ArrayList<SourceSet>();
        JavaPluginConvention javaPluginConvention = javaPlugin;
        if (javaPluginConvention == null) {
            Intrinsics.throwNpe();
        }
        for (org.gradle.api.tasks.SourceSet sourceSet : javaPluginConvention.getSourceSets()) {
            sourceSets.add(JavaModelBuilder.Companion.createSourceSets(project, sourceSet, this.buildMapping));
        }
        return new JavaProjectImpl(project.getName(), (Collection<? extends SourceSet>)sourceSets, javaPlugin.getSourceCompatibility().toString());
    }

    public JavaModelBuilder() {
        JavaModelBuilder javaModelBuilder = this;
        HashMap hashMap = new HashMap();
        javaModelBuilder.buildMapping = hashMap;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002J,\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\bH\u0002J,\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u00192\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\bH\u0002J\u001e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J2\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u00042\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\bH\u0002J\u001a\u0010\u001f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010 \u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0016\u0010!\u001a\u00020\f2\u0006\u0010\"\u001a\u00020\u00042\u0006\u0010#\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/android/java/model/builder/JavaModelBuilder$Companion;", "", "()V", "CURRENT_BUILD_NAME", "", "LOCAL_JAR_DISPLAY_NAME", "UNRESOLVED_DEPENDENCY_PREFIX", "computeBuildMapping", "", "gradle", "Lorg/gradle/api/invocation/Gradle;", "contains", "", "directory", "Ljava/io/File;", "file", "createSourceSets", "Lcom/android/java/model/SourceSet;", "project", "Lorg/gradle/api/Project;", "sourceSet", "Lorg/gradle/api/tasks/SourceSet;", "buildMapping", "getBuildId", "artifact", "Lorg/gradle/api/artifacts/ResolvedArtifact;", "getClassesDirs", "", "getLibrariesForConfiguration", "Lcom/android/java/model/JavaLibrary;", "configurationName", "getProjectPath", "isCompositeBuildSupported", "isGradleAtLeast", "gradleVersion", "expectedVersion", "android.sdktools.java-lib-model-builder"})
    public static final class Companion {
        private final Map<String, String> computeBuildMapping(Gradle gradle) {
            HashMap buildMapping = new HashMap();
            String currentBuildPath = gradle.getRootProject().getProjectDir().getAbsolutePath();
            Map map = buildMapping;
            Object object = JavaModelBuilder.CURRENT_BUILD_NAME;
            Object object2 = currentBuildPath;
            map.put(object, object2);
            Gradle rootGradleProject = gradle;
            while (true) {
                Gradle gradle2 = rootGradleProject;
                if (gradle2 == null) {
                    Intrinsics.throwNpe();
                }
                if (gradle2.getParent() == null) break;
                rootGradleProject = rootGradleProject.getParent();
            }
            if (rootGradleProject != gradle) {
                object = buildMapping;
                object2 = rootGradleProject.getRootProject().getName();
                String string = rootGradleProject.getRootProject().getProjectDir().getAbsolutePath();
                object.put(object2, string);
            }
            for (IncludedBuild includedBuild : rootGradleProject.getIncludedBuilds()) {
                String includedBuildPath = includedBuild.getProjectDir().getAbsolutePath();
                if (!(Intrinsics.areEqual((Object)includedBuildPath, (Object)currentBuildPath) ^ true)) continue;
                Map map2 = buildMapping;
                String string = includedBuild.getName();
                String string2 = includedBuildPath;
                map2.put(string, string2);
            }
            return buildMapping;
        }

        private final SourceSet createSourceSets(Project project, org.gradle.api.tasks.SourceSet sourceSet, Map<String, String> buildMapping) {
            String compileConfigurationName = this.isGradleAtLeast(project.getGradle().getGradleVersion(), "2.12") ? sourceSet.getCompileClasspathConfigurationName() : sourceSet.getCompileConfigurationName();
            String runtimeConfigurationName = this.isGradleAtLeast(project.getGradle().getGradleVersion(), "3.4") ? sourceSet.getRuntimeClasspathConfigurationName() : sourceSet.getRuntimeConfigurationName();
            return new SourceSetImpl(sourceSet.getName(), sourceSet.getAllJava().getSrcDirs(), sourceSet.getResources().getSrcDirs(), this.getClassesDirs(sourceSet, project), sourceSet.getOutput().getResourcesDir(), this.getLibrariesForConfiguration(project, compileConfigurationName, buildMapping), this.getLibrariesForConfiguration(project, runtimeConfigurationName, buildMapping));
        }

        private final Collection<File> getClassesDirs(org.gradle.api.tasks.SourceSet sourceSet, Project project) {
            Collection collection;
            if (this.isGradleAtLeast(project.getGradle().getGradleVersion(), "4.0")) {
                collection = sourceSet.getOutput().getClassesDirs().getFiles();
            } else {
                Object object = Class.forName("org.gradle.api.tasks.SourceSetOutput").getDeclaredMethod("getClassesDir", new Class[0]).invoke((Object)sourceSet.getOutput(), new Object[0]);
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.io.File");
                }
                collection = CollectionsKt.listOf((Object)((File)object));
            }
            return collection;
        }

        public final boolean isGradleAtLeast(@NotNull String gradleVersion, @NotNull String expectedVersion) {
            VersionNumber givenVersion;
            VersionNumber currentVersion = VersionNumber.parse((String)gradleVersion);
            return currentVersion.compareTo(givenVersion = VersionNumber.parse((String)expectedVersion)) >= 0;
        }

        /*
         * WARNING - void declaration
         */
        private final Collection<JavaLibrary> getLibrariesForConfiguration(Project project, String configurationName, Map<String, String> buildMapping) {
            JavaLibraryImpl javaLibraryImpl;
            String string;
            CharSequence charSequence;
            String string2;
            CharSequence buildId;
            UnresolvedDependency artifact;
            ArrayList<JavaLibraryImpl> arrayList;
            Configuration configuration = project.getConfigurations().getAt(configurationName);
            ArrayList<JavaLibraryImpl> javaLibraries = new ArrayList<JavaLibraryImpl>();
            LenientConfiguration lenientConfiguration = configuration.getResolvedConfiguration().getLenientConfiguration();
            Iterable $receiver$iv = lenientConfiguration.getArtifacts(Specs.satisfyAll());
            for (Object item$iv : $receiver$iv) {
                ResolvedArtifact resolvedArtifact = (ResolvedArtifact)item$iv;
                arrayList = javaLibraries;
                boolean bl = false;
                String projectPath = Companion.getProjectPath(project, (ResolvedArtifact)artifact);
                buildId = projectPath == null ? null : Companion.getBuildId(project, (ResolvedArtifact)artifact, buildMapping);
                ModuleVersionIdentifier versionId = artifact.getModuleVersion().getId();
                LibraryVersionImpl libraryVersion = new LibraryVersionImpl(versionId.getGroup(), versionId.getName(), versionId.getVersion());
                string2 = artifact.getName();
                charSequence = buildId;
                String string3 = projectPath;
                String string4 = string2;
                if (string4 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)string4.intern(), (String)"(this as java.lang.String).intern()");
                LibraryVersion libraryVersion2 = libraryVersion;
                File file = artifact.getFile();
                String string5 = string;
                CharSequence charSequence2 = charSequence;
                String string6 = string3;
                javaLibraryImpl = new JavaLibraryImpl(string6, (String)charSequence2, string5, file, libraryVersion2);
                arrayList.add(javaLibraryImpl);
            }
            $receiver$iv = lenientConfiguration.getUnresolvedModuleDependencies();
            for (Object item$iv : $receiver$iv) {
                void unresolvedDependency;
                artifact = (UnresolvedDependency)item$iv;
                arrayList = javaLibraries;
                boolean bl = false;
                ModuleVersionSelector selector = unresolvedDependency.getSelector();
                buildId = selector.toString();
                String string7 = ":";
                StringBuilder stringBuilder = new StringBuilder().append(JavaModelBuilder.UNRESOLVED_DEPENDENCY_PREFIX);
                string7 = string2 = new Regex(string7);
                charSequence = " ";
                string2 = string7.replace(buildId, charSequence);
                String unresolvedName = stringBuilder.append(string2).toString();
                String string8 = selector.getGroup();
                String string9 = selector.getName();
                String string10 = selector.getVersion();
                if (string10 == null) {
                    string10 = "unknown";
                }
                LibraryVersionImpl libraryVersion = new LibraryVersionImpl(string8, string9, string10);
                string7 = unresolvedName;
                String string11 = null;
                String string12 = null;
                String string13 = string7;
                if (string13 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)string13.intern(), (String)"(this as java.lang.String).intern()");
                LibraryVersion libraryVersion3 = libraryVersion;
                File file = new File(unresolvedName);
                String string14 = string;
                String string15 = string11;
                String string16 = string12;
                javaLibraryImpl = new JavaLibraryImpl(string16, string15, string14, file, libraryVersion3);
                arrayList.add(javaLibraryImpl);
            }
            for (Dependency dependency : configuration.getAllDependencies()) {
                if (!(dependency instanceof SelfResolvingDependency) || dependency instanceof ProjectDependency) continue;
                for (File file : ((SelfResolvingDependency)dependency).resolve()) {
                    String string17;
                    String localJarName;
                    String string18 = localJarName = JavaModelBuilder.LOCAL_JAR_DISPLAY_NAME + file.getName();
                    String string19 = null;
                    String string20 = null;
                    arrayList = javaLibraries;
                    String string21 = string18;
                    if (string21 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)string21.intern(), (String)"(this as java.lang.String).intern()");
                    LibraryVersion libraryVersion = null;
                    File file2 = file;
                    String string22 = string17;
                    String string23 = string19;
                    String string24 = string20;
                    arrayList.add(new JavaLibraryImpl(string24, string23, string22, file2, libraryVersion));
                }
            }
            return javaLibraries;
        }

        private final String getProjectPath(Project project, ResolvedArtifact artifact) {
            if (this.isGradleAtLeast(project.getGradle().getGradleVersion(), "2.6")) {
                ComponentIdentifier id = artifact.getId().getComponentIdentifier();
                if (id instanceof ProjectComponentIdentifier) {
                    String string;
                    String string2 = string = ((ProjectComponentIdentifier)id).getProjectPath();
                    if (string2 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string3 = string2.intern();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).intern()");
                    return string3;
                }
            } else {
                String string;
                Object object;
                Object v2;
                block8: {
                    Iterable $receiver$iv = project.getRootProject().getAllprojects();
                    for (Object element$iv : $receiver$iv) {
                        Project it = (Project)element$iv;
                        boolean bl = false;
                        if (!Companion.contains(it.getBuildDir(), artifact.getFile())) continue;
                        v2 = element$iv;
                        break block8;
                    }
                    v2 = null;
                }
                if ((object = (Project)v2) != null && (object = object.getPath()) != null) {
                    Object object2;
                    Object object3 = object2 = object;
                    if (object3 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string4 = ((String)object3).intern();
                    string = string4;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).intern()");
                } else {
                    string = null;
                }
                return string;
            }
            return null;
        }

        private final boolean isCompositeBuildSupported(Project project) {
            return this.isGradleAtLeast(project.getGradle().getGradleVersion(), "3.1");
        }

        private final String getBuildId(Project project, ResolvedArtifact artifact, Map<String, String> buildMapping) {
            ComponentIdentifier id;
            if (this.isCompositeBuildSupported(project) && (id = artifact.getId().getComponentIdentifier()) instanceof ProjectComponentIdentifier) {
                BuildIdentifier identifier = ((ProjectComponentIdentifier)id).getBuild();
                String string = buildMapping.get(identifier.isCurrentBuild() ? JavaModelBuilder.CURRENT_BUILD_NAME : identifier.getName());
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                return string;
            }
            return project.getProjectDir().getAbsolutePath();
        }

        private final boolean contains(File directory, File file) {
            try {
                File canonicalDirectory = directory.getCanonicalFile();
                for (File canonicalFile = file.getCanonicalFile().getParentFile(); canonicalFile != null; canonicalFile = canonicalFile.getParentFile()) {
                    if (!Intrinsics.areEqual((Object)canonicalFile, (Object)canonicalDirectory)) continue;
                    return true;
                }
            }
            catch (IOException ex) {
                return false;
            }
            return false;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

