/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutinspector.parser;

import com.android.layoutinspector.model.ViewNode;
import com.android.layoutinspector.model.ViewProperty;
import com.android.layoutinspector.parser.DisplayInfoFactory;
import com.android.layoutinspector.parser.ViewNodeV2Decoder;
import com.android.layoutinspector.parser.ViewPropertyParser;
import com.google.common.base.Verify;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\n\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0010\u0012\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J2\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\t2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u0004H\u0002J(\u0010\u0011\u001a\u00020\r2\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00010\u00042\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\rH\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0005H\u0002J&\u0010\u0016\u001a\u0004\u0018\u00010\u00012\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00010\u00042\u0006\u0010\u0018\u001a\u00020\u0005H\u0002J\u0017\u0010\u0019\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0015\u001a\u00020\u0005H\u0002\u00a2\u0006\u0002\u0010\u001aJ\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0018\u001a\u00020\u0006H\u0002J$\u0010\u001c\u001a\u00020\u00052\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00010\u00042\u0006\u0010\u0018\u001a\u00020\u0005H\u0002J$\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\u001f\u001a\u00020\r2\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00010\u0004H\u0002J\u0010\u0010!\u001a\u0004\u0018\u00010\r2\u0006\u0010\"\u001a\u00020#J(\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00042\u0012\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00010\u0004H\u0002R\u001c\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00010\u00040\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/android/layoutinspector/parser/ViewNodeV2Parser;", "", "()V", "ids", "", "", "", "mStringTable", "mViews", "", "addChildren", "", "parent", "Lcom/android/layoutinspector/model/ViewNode;", "metaProps", "Lcom/android/layoutinspector/model/ViewProperty;", "childrenProps", "createViewNode", "propMap", "getChildIndex", "", "name", "getProperty", "props", "key", "getPropertyKey", "(Ljava/lang/String;)Ljava/lang/Short;", "getPropertyName", "getStringProperty", "view", "loadProperties", "node", "viewProperties", "parse", "data", "", "reverse", "m", "android.sdktools.layoutinspector"})
public final class ViewNodeV2Parser {
    private Map<String, Short> ids;
    private Map<Short, ? extends Object> mStringTable;
    private final List<Map<Short, Object>> mViews = Lists.newArrayListWithExpectedSize((int)100);

    @Nullable
    public final ViewNode parse(@NotNull byte[] data) {
        ViewNodeV2Decoder d = new ViewNodeV2Decoder(ByteBuffer.wrap(data));
        while (d.hasRemaining()) {
            Object o = d.readObject();
            if (!(o instanceof Map)) continue;
            this.mViews.add((Map)o);
        }
        if (this.mViews.isEmpty()) {
            return null;
        }
        Map<Short, ? extends Object> map = this.mStringTable = this.mViews.remove(this.mViews.size() - 1);
        if (map == null) {
            Intrinsics.throwNpe();
        }
        this.ids = this.reverse(map);
        Map<Short, Object> rootMap = this.mViews.get(0);
        ViewNode root = ViewNodeV2Parser.createViewNode$default(this, rootMap, null, 2, null);
        root.updateNodeDrawn(true);
        return root;
    }

    private final ViewNode createViewNode(Map<Short, ? extends Object> propMap, ViewNode parent) {
        Object hashProperty = this.getProperty(propMap, "meta:__hash__");
        String hash = "";
        if (hashProperty instanceof Integer) {
            hash = Integer.toHexString(((Number)hashProperty).intValue());
        }
        ViewNode node = new ViewNode(parent, this.getStringProperty(propMap, "meta:__name__"), hash);
        this.loadProperties(node, propMap);
        node.setDisplayInfo(DisplayInfoFactory.INSTANCE.createDisplayInfoFromNode(node));
        return node;
    }

    static /* synthetic */ ViewNode createViewNode$default(ViewNodeV2Parser viewNodeV2Parser, Map map, ViewNode viewNode, int n, Object object) {
        if ((n & 2) != 0) {
            viewNode = null;
        }
        return viewNodeV2Parser.createViewNode(map, viewNode);
    }

    private final Object getProperty(Map<Short, ? extends Object> props, String key) {
        Map<Short, ? extends Object> map = props;
        Map<String, Short> map2 = this.ids;
        if (map2 == null) {
            Intrinsics.throwNpe();
        }
        Short s = map2.get(key);
        return map.get(s);
    }

    private final Map<String, Short> reverse(Map<Short, ? extends Object> m) {
        HashMap r = new HashMap(m.size());
        Map<Short, ? extends Object> map = m;
        for (Map.Entry<Short, ? extends Object> entry : map.entrySet()) {
            Object object = entry;
            short key = ((Number)object.getKey()).shortValue();
            object = entry;
            Object value = object.getValue();
            object = r;
            Object object2 = value;
            if (object2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
            }
            String string = (String)object2;
            Short s = key;
            object.put(string, s);
        }
        return r;
    }

    private final Short getPropertyKey(String name) {
        Map<String, Short> map = this.ids;
        if (map == null) {
            Intrinsics.throwNpe();
        }
        return map.get(name);
    }

    private final String getPropertyName(short key) {
        Object v;
        Object object;
        Map<Short, ? extends Object> map = this.mStringTable;
        if (map == null) {
            Intrinsics.throwNpe();
        }
        if (!((object = (v = map.get(key))) instanceof String)) {
            object = null;
        }
        return (String)object;
    }

    private final String getStringProperty(Map<Short, ? extends Object> view, String key) {
        Map<Short, ? extends Object> map = view;
        Short s = this.getPropertyKey(key);
        Object v = map.get(s);
        if (v instanceof String) {
            return (String)v;
        }
        return "";
    }

    private final int getChildIndex(String name) {
        String string = name;
        int n = StringsKt.indexOf$default((CharSequence)name, (String)"__child__", (int)0, (boolean)false, (int)6, null) + 9;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(n);
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
        string = string3;
        return Integer.parseInt(string);
    }

    /*
     * WARNING - void declaration
     */
    private final void loadProperties(ViewNode node, Map<Short, ? extends Object> viewProperties) {
        List<ViewProperty> metaProps;
        void $receiver$iv$iv;
        Object $receiver$iv;
        Object object;
        Map namedProperties = Maps.newHashMap();
        List properties = Lists.newArrayList();
        Map childrenProps = Maps.newHashMap();
        for (Map.Entry<Short, ? extends Object> p : viewProperties.entrySet()) {
            String fullName;
            if (this.getPropertyName(((Number)p.getKey()).shortValue()) == null) {
                Intrinsics.throwNpe();
            }
            Object value = p.getValue();
            if (StringsKt.startsWith$default((String)fullName, (String)"meta:__child__", (boolean)false, (int)2, null)) {
                Map map = childrenProps;
                object = value;
                map.put(fullName, object);
                continue;
            }
            ViewProperty property = ViewPropertyParser.INSTANCE.parse(fullName, value.toString());
            properties.add(property);
            object = namedProperties;
            String string = property.getName();
            ViewProperty viewProperty = property;
            object.put(string, viewProperty);
        }
        node.getNamedProperties().putAll(namedProperties);
        node.getProperties().addAll(properties);
        Object object2 = $receiver$iv = (Iterable)node.getProperties();
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            object = (ViewProperty)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            node.addPropertyToGroup((ViewProperty)it);
            Unit unit = Unit.INSTANCE;
            collection.add(unit);
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
        ViewProperty viewProperty = node.getNamedProperties().get("id");
        if (viewProperty != null) {
            Object it = $receiver$iv = viewProperty;
            boolean bl = false;
            node.setId(((ViewProperty)it).getValue());
        }
        List<ViewProperty> list2 = metaProps = node.getGroupedProperties().remove("meta");
        if (list2 == null) {
            Intrinsics.throwNpe();
        }
        this.addChildren(node, list2, childrenProps);
    }

    /*
     * WARNING - void declaration
     */
    private final void addChildren(ViewNode parent, List<ViewProperty> metaProps, Map<String, ? extends Object> childrenProps) {
        Object object;
        void $receiver$iv$iv;
        Object v0;
        Object it;
        Object object2;
        StringCompanionObject stringCompanionObject;
        Object object3;
        block4: {
            Iterable iterable = metaProps;
            object3 = iterable;
            stringCompanionObject = object3.iterator();
            while (stringCompanionObject.hasNext()) {
                object2 = stringCompanionObject.next();
                it = (ViewProperty)object2;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)((ViewProperty)it).getName(), (Object)"__childCount__")) continue;
                v0 = object2;
                break block4;
            }
            v0 = null;
        }
        ViewProperty viewProperty = v0;
        if (viewProperty == null) {
            return;
        }
        ViewProperty childCountProp = viewProperty;
        object3 = childCountProp.getValue();
        int childCount = Integer.parseInt((String)object3);
        Iterable $receiver$iv = childrenProps.entrySet();
        object2 = $receiver$iv;
        it = new Comparator<T>(this){
            final /* synthetic */ ViewNodeV2Parser this$0;
            {
                this.this$0 = viewNodeV2Parser;
            }

            public final int compare(T a, T b) {
                Map.Entry it = (Map.Entry)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(ViewNodeV2Parser.access$getChildIndex(this.this$0, (String)it.getKey()));
                it = (Map.Entry)b;
                Comparable comparable2 = comparable;
                bl = false;
                Integer n = ViewNodeV2Parser.access$getChildIndex(this.this$0, (String)it.getKey());
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
            }
        };
        $receiver$iv = CollectionsKt.sortedWith(object2, (Comparator)it);
        object2 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it2;
            Map.Entry entry = (Map.Entry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Object v = it2.getValue();
            if (v == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.Short, kotlin.Any>");
            }
            object = this.createViewNode((Map)v, parent);
            collection.add(object);
        }
        List children = (List)destination$iv$iv;
        boolean bl = childCount == children.size();
        stringCompanionObject = StringCompanionObject.INSTANCE;
        object2 = "Expect view node %s to have %d children but instead found %d";
        Object[] objectArray = new Object[]{parent, childCount, children.size()};
        boolean bl2 = bl;
        String string = String.format(object2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"java.lang.String.format(format, *args)");
        object = string;
        Verify.verify((boolean)bl2, (String)object, (Object[])new Object[0]);
        parent.getChildren().addAll(children);
    }

    public static final /* synthetic */ int access$getChildIndex(ViewNodeV2Parser $this, String name) {
        return $this.getChildIndex(name);
    }
}

