/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.apk.analyzer;

import com.android.xml.XmlBuilder;
import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.google.devrel.gmscore.tools.apk.arsc.BinaryResourceFile;
import com.google.devrel.gmscore.tools.apk.arsc.BinaryResourceValue;
import com.google.devrel.gmscore.tools.apk.arsc.Chunk;
import com.google.devrel.gmscore.tools.apk.arsc.StringPoolChunk;
import com.google.devrel.gmscore.tools.apk.arsc.XmlAttribute;
import com.google.devrel.gmscore.tools.apk.arsc.XmlChunk;
import com.google.devrel.gmscore.tools.apk.arsc.XmlEndElementChunk;
import com.google.devrel.gmscore.tools.apk.arsc.XmlNamespaceEndChunk;
import com.google.devrel.gmscore.tools.apk.arsc.XmlNamespaceStartChunk;
import com.google.devrel.gmscore.tools.apk.arsc.XmlResourceMapChunk;
import com.google.devrel.gmscore.tools.apk.arsc.XmlStartElementChunk;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class BinaryXmlParser {
    public static byte[] decodeXml(String fileName, byte[] bytes) {
        BinaryResourceFile file = new BinaryResourceFile(bytes);
        List<Chunk> chunks = file.getChunks();
        if (chunks.size() != 1) {
            return bytes;
        }
        if (!(chunks.get(0) instanceof XmlChunk)) {
            return bytes;
        }
        XmlPrinter printer = new XmlPrinter();
        XmlChunk xmlChunk = (XmlChunk)chunks.get(0);
        BinaryXmlParser.visitChunks(xmlChunk.getChunks(), printer);
        String reconstructedXml = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n" + printer.getReconstructedXml();
        return reconstructedXml.getBytes(Charsets.UTF_8);
    }

    private static void visitChunks(Map<Integer, Chunk> chunks, XmlChunkHandler handler) {
        List<Chunk> contentChunks = BinaryXmlParser.sortByOffset(chunks);
        for (Chunk chunk : contentChunks) {
            if (chunk instanceof StringPoolChunk) {
                handler.stringPool((StringPoolChunk)chunk);
                continue;
            }
            if (chunk instanceof XmlResourceMapChunk) {
                handler.xmlResourceMap((XmlResourceMapChunk)chunk);
                continue;
            }
            if (chunk instanceof XmlNamespaceStartChunk) {
                handler.startNamespace((XmlNamespaceStartChunk)chunk);
                continue;
            }
            if (chunk instanceof XmlNamespaceEndChunk) {
                handler.endNamespace((XmlNamespaceEndChunk)chunk);
                continue;
            }
            if (chunk instanceof XmlStartElementChunk) {
                handler.startElement((XmlStartElementChunk)chunk);
                continue;
            }
            if (!(chunk instanceof XmlEndElementChunk)) continue;
            handler.endElement((XmlEndElementChunk)chunk);
        }
    }

    private static List<Chunk> sortByOffset(Map<Integer, Chunk> contentChunks) {
        ArrayList offsets = Lists.newArrayList(contentChunks.keySet());
        Collections.sort(offsets);
        ArrayList<Chunk> chunks = new ArrayList<Chunk>(offsets.size());
        for (Integer offset : offsets) {
            chunks.add(contentChunks.get(offset));
        }
        return chunks;
    }

    public static String formatValue(BinaryResourceValue resValue, StringPoolChunk stringPool) {
        int data = resValue.data();
        switch (resValue.type()) {
            case NULL: {
                return "null";
            }
            case DYNAMIC_REFERENCE: {
                return String.format(Locale.US, "@dref/0x%1$08x", data);
            }
            case REFERENCE: {
                return String.format(Locale.US, "@ref/0x%1$08x", data);
            }
            case ATTRIBUTE: {
                return String.format(Locale.US, "@attr/0x%1$x", data);
            }
            case STRING: {
                return stringPool != null && stringPool.getStringCount() < data ? stringPool.getString(data) : String.format(Locale.US, "@string/0x%1$x", data);
            }
            case DIMENSION: {
                return String.format(Locale.US, "dimension(%1$d)", data);
            }
            case FRACTION: {
                return String.format(Locale.US, "fraction(%1$d)", data);
            }
            case FLOAT: {
                return String.format(Locale.US, "%f", Float.valueOf(data));
            }
            case DYNAMIC_ATTRIBUTE: {
                break;
            }
            case INT_DEC: {
                return Integer.toString(data);
            }
            case INT_HEX: {
                return "0x" + Integer.toHexString(data);
            }
            case INT_BOOLEAN: {
                return Boolean.toString(data != 0);
            }
            case INT_COLOR_ARGB8: {
                return String.format("argb8(0x%x)", data);
            }
            case INT_COLOR_RGB8: {
                return String.format("rgb8(0x%x)", data);
            }
            case INT_COLOR_ARGB4: {
                return String.format("argb4(0x%x)", data);
            }
            case INT_COLOR_RGB4: {
                return String.format("rgb4(0x%x)", data);
            }
        }
        return String.format("@res/0x%x", data);
    }

    private static class XmlPrinter
    implements XmlChunkHandler {
        private final XmlBuilder builder;
        private Map<String, String> namespaces = new HashMap<String, String>();
        private boolean namespacesAdded;
        private StringPoolChunk stringPool;

        public XmlPrinter() {
            this.builder = new XmlBuilder();
        }

        @Override
        public void stringPool(StringPoolChunk chunk) {
            this.stringPool = chunk;
        }

        @Override
        public void startNamespace(XmlNamespaceStartChunk chunk) {
            this.namespaces.put(chunk.getUri(), chunk.getPrefix());
        }

        @Override
        public void startElement(XmlStartElementChunk chunk) {
            this.builder.startTag(chunk.getName());
            if (!this.namespacesAdded && !this.namespaces.isEmpty()) {
                this.namespacesAdded = true;
                for (Map.Entry entry : this.namespaces.entrySet()) {
                    this.builder.attribute("xmlns", (String)entry.getValue(), (String)entry.getKey());
                }
            }
            for (XmlAttribute xmlAttribute : chunk.getAttributes()) {
                String prefix = XmlPrinter.notNullize(this.namespaces.get(xmlAttribute.namespace()));
                this.builder.attribute(prefix, xmlAttribute.name(), this.getValue(xmlAttribute));
            }
        }

        public static String notNullize(String s) {
            return s == null ? "" : s;
        }

        @Override
        public void endElement(XmlEndElementChunk chunk) {
            this.builder.endTag(chunk.getName());
        }

        public String getReconstructedXml() {
            return this.builder.toString();
        }

        private String getValue(XmlAttribute attribute) {
            String rawValue = attribute.rawValue();
            if (rawValue != null && !rawValue.isEmpty()) {
                return rawValue;
            }
            BinaryResourceValue resValue = attribute.typedValue();
            return BinaryXmlParser.formatValue(resValue, this.stringPool);
        }
    }

    private static interface XmlChunkHandler {
        default public void stringPool(StringPoolChunk chunk) {
        }

        default public void xmlResourceMap(XmlResourceMapChunk chunk) {
        }

        default public void startNamespace(XmlNamespaceStartChunk chunk) {
        }

        default public void endNamespace(XmlNamespaceEndChunk chunk) {
        }

        default public void startElement(XmlStartElementChunk chunk) {
        }

        default public void endElement(XmlEndElementChunk chunk) {
        }
    }
}

