/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.apk.analyzer.optimizer;

import com.android.tools.apk.analyzer.optimizer.Analyzer;
import com.android.tools.apk.analyzer.optimizer.AppSizeIssueRegistry;
import com.android.tools.apk.analyzer.optimizer.Suggestion;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.LintDriver;
import com.android.tools.lint.client.api.LintRequest;
import com.android.tools.lint.detector.api.Issue;
import com.google.common.annotations.Beta;
import java.util.ArrayList;
import java.util.List;

@Beta
public class LintAnalyzer
implements Analyzer {
    private final AppSizeIssueRegistry issueRegistry = new AppSizeIssueRegistry();
    private final LintClient client;
    private final LintRequest request;

    public LintAnalyzer(LintClient client, LintRequest request) {
        this.client = client;
        this.request = request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Suggestion> analyze() {
        List<Issue> sizeIssues = this.issueRegistry.getIssues();
        ArrayList<Issue> enabledIssues = new ArrayList<Issue>(sizeIssues.size());
        try {
            for (Issue issue : sizeIssues) {
                if (issue.isEnabledByDefault()) continue;
                issue.setEnabledByDefault(true);
                enabledIssues.add(issue);
            }
            LintDriver lint = new LintDriver(this.issueRegistry, this.client, this.request);
            lint.analyze();
        }
        catch (Throwable throwable) {
            for (Issue issue : enabledIssues) {
                issue.setEnabledByDefault(false);
            }
            throw throwable;
        }
        for (Issue issue : enabledIssues) {
            issue.setEnabledByDefault(false);
        }
        return null;
    }
}

