/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.deployer;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.InstallException;
import com.android.ddmlib.InstallMetrics;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.SyncException;
import com.android.ddmlib.TimeoutException;
import com.android.sdklib.AndroidVersion;
import com.android.tools.deployer.ApkInstaller;
import com.android.tools.tracer.Trace;
import com.android.utils.ILogger;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public class AdbClient {
    private final IDevice device;
    private final ILogger logger;

    public AdbClient(IDevice device, ILogger logger) {
        this.device = device;
        this.logger = logger;
    }

    public byte[] shell(String[] parameters) throws IOException {
        return this.shell(parameters, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] shell(String[] parameters, InputStream input) throws IOException {
        try (Trace ignored = Trace.begin("adb shell" + Arrays.toString(parameters));){
            ByteArrayOutputReceiver receiver = new ByteArrayOutputReceiver();
            this.device.executeShellCommand(String.join((CharSequence)" ", parameters), (IShellOutputReceiver)receiver, 5L, TimeUnit.MINUTES, input);
            byte[] byArray = receiver.toByteArray();
            return byArray;
        }
        catch (AdbCommandRejectedException | ShellCommandUnresponsiveException | TimeoutException e) {
            throw new IOException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] binder(String[] parameters, InputStream input) throws IOException {
        this.logger.info("BINDER: " + String.join((CharSequence)" ", parameters), new Object[0]);
        try (Trace ignored = Trace.begin("binder" + Arrays.toString(parameters));){
            ByteArrayOutputReceiver receiver = new ByteArrayOutputReceiver();
            this.device.executeBinderCommand(parameters, receiver, 5L, TimeUnit.MINUTES, input);
            byte[] byArray = receiver.toByteArray();
            return byArray;
        }
        catch (AdbCommandRejectedException | ShellCommandUnresponsiveException | TimeoutException e) {
            throw new IOException(e);
        }
    }

    public InstallResult install(List<String> apks, List<String> options, boolean reinstall) {
        List<File> files = apks.stream().map(File::new).collect(Collectors.toList());
        try {
            if (this.device.getVersion().isGreaterOrEqualThan(21)) {
                this.device.installPackages(files, reinstall, options, 5L, TimeUnit.MINUTES);
                return new InstallResult(InstallStatus.OK, null, this.device.getLastInstallMetrics());
            }
            if (apks.size() != 1) {
                return new InstallResult(InstallStatus.MULTI_APKS_NO_SUPPORTED_BELOW21);
            }
            this.device.installPackage(apks.get(0), reinstall, options.toArray(new String[0]));
            return new InstallResult(InstallStatus.OK, null, this.device.getLastInstallMetrics());
        }
        catch (InstallException e) {
            String code = e.getErrorCode();
            if (code != null) {
                try {
                    return ApkInstaller.parseInstallerResultErrorCode(code);
                }
                catch (IllegalArgumentException | NullPointerException ignored) {
                    this.logger.warning("Unrecognized Installation Failure: %s\n%s\n", new Object[]{code, e.getMessage()});
                }
            } else {
                Throwable cause = e.getCause();
                if (cause instanceof ShellCommandUnresponsiveException) {
                    return new InstallResult(InstallStatus.SHELL_UNRESPONSIVE);
                }
                this.logger.warning("Installation Failure: %s\n", new Object[]{e.getMessage()});
                return new InstallResult(InstallStatus.UNKNOWN_ERROR, e.getMessage(), null);
            }
            return new InstallResult(InstallStatus.UNKNOWN_ERROR);
        }
    }

    public boolean uninstall(String packageName) {
        try {
            this.device.uninstallPackage(packageName);
            return true;
        }
        catch (InstallException installException) {
            return false;
        }
    }

    public List<String> getAbis() {
        return this.device.getAbis();
    }

    public void push(String from, String to) throws IOException {
        try (Trace ignored = Trace.begin("adb push");){
            this.device.pushFile(from, to);
        }
        catch (AdbCommandRejectedException | SyncException | TimeoutException e) {
            throw new IOException(e);
        }
    }

    public AndroidVersion getVersion() {
        return this.device.getVersion();
    }

    private class ByteArrayOutputReceiver
    implements IShellOutputReceiver {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();

        private ByteArrayOutputReceiver() {
        }

        @Override
        public void addOutput(byte[] data, int offset, int length) {
            this.stream.write(data, offset, length);
        }

        @Override
        public void flush() {
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        byte[] toByteArray() {
            return this.stream.toByteArray();
        }
    }

    static class InstallResult {
        public final InstallStatus status;
        public final String reason;
        public final InstallMetrics metrics;

        InstallResult(InstallStatus status) {
            this.status = status;
            this.reason = null;
            this.metrics = null;
        }

        InstallResult(InstallStatus status, String reason, InstallMetrics metrics) {
            this.status = status;
            this.reason = reason;
            this.metrics = metrics;
        }
    }

    static enum InstallStatus {
        OK,
        INSTALL_FAILED_ALREADY_EXISTS,
        INSTALL_FAILED_INVALID_APK,
        INSTALL_FAILED_INVALID_URI,
        INSTALL_FAILED_INSUFFICIENT_STORAGE,
        INSTALL_FAILED_DUPLICATE_PACKAGE,
        INSTALL_FAILED_NO_SHARED_USER,
        INSTALL_FAILED_UPDATE_INCOMPATIBLE,
        INSTALL_FAILED_SHARED_USER_INCOMPATIBLE,
        INSTALL_FAILED_MISSING_SHARED_LIBRARY,
        INSTALL_FAILED_REPLACE_COULDNT_DELETE,
        INSTALL_FAILED_DEXOPT,
        INSTALL_FAILED_OLDER_SDK,
        INSTALL_FAILED_CONFLICTING_PROVIDER,
        INSTALL_FAILED_NEWER_SDK,
        INSTALL_FAILED_TEST_ONLY,
        INSTALL_FAILED_CPU_ABI_INCOMPATIBLE,
        INSTALL_FAILED_MISSING_FEATURE,
        INSTALL_FAILED_CONTAINER_ERROR,
        INSTALL_FAILED_INVALID_INSTALL_LOCATION,
        INSTALL_FAILED_MEDIA_UNAVAILABLE,
        INSTALL_FAILED_VERIFICATION_TIMEOUT,
        INSTALL_FAILED_VERIFICATION_FAILURE,
        INSTALL_FAILED_PACKAGE_CHANGED,
        INSTALL_FAILED_UID_CHANGED,
        INSTALL_FAILED_VERSION_DOWNGRADE,
        INSTALL_PARSE_FAILED_NOT_APK,
        INSTALL_PARSE_FAILED_BAD_MANIFEST,
        INSTALL_PARSE_FAILED_UNEXPECTED_EXCEPTION,
        INSTALL_PARSE_FAILED_NO_CERTIFICATES,
        INSTALL_PARSE_FAILED_INCONSISTENT_CERTIFICATES,
        INSTALL_PARSE_FAILED_CERTIFICATE_ENCODING,
        INSTALL_PARSE_FAILED_BAD_PACKAGE_NAME,
        INSTALL_PARSE_FAILED_BAD_SHARED_USER_ID,
        INSTALL_PARSE_FAILED_MANIFEST_MALFORMED,
        INSTALL_PARSE_FAILED_MANIFEST_EMPTY,
        INSTALL_FAILED_INTERNAL_ERROR,
        INSTALL_FAILED_USER_RESTRICTED,
        INSTALL_FAILED_DUPLICATE_PERMISSION,
        INSTALL_FAILED_NO_MATCHING_ABIS,
        INSTALL_FAILED_ABORTED,
        INSTALL_FAILED_BAD_DEX_METADATA,
        INSTALL_FAILED_MISSING_SPLIT,
        INSTALL_FAILED_BAD_SIGNATURE,
        INSTALL_FAILED_WRONG_INSTALLED_VERSION,
        DEVICE_NOT_RESPONDING,
        INCONSISTENT_CERTIFICATES,
        NO_CERTIFICATE,
        DEVICE_NOT_FOUND,
        SHELL_UNRESPONSIVE,
        MULTI_APKS_NO_SUPPORTED_BELOW21,
        UNKNOWN_ERROR,
        SKIPPED_INSTALL;

    }
}

