/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.deployer;

import com.android.tools.deploy.proto.Deploy;
import com.android.tools.deploy.protobuf.CodedInputStream;
import com.android.tools.deploy.protobuf.CodedOutputStream;
import com.android.tools.deploy.protobuf.MessageLite;
import com.android.tools.deploy.protobuf.Parser;
import com.android.tools.deployer.AdbClient;
import com.android.tools.deployer.DeployMetric;
import com.android.tools.deployer.Installer;
import com.android.tools.deployer.Version;
import com.android.tools.tracer.Trace;
import com.android.utils.ILogger;
import com.google.common.collect.ObjectArrays;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Stack;

public class AdbInstaller
implements Installer {
    public static final String INSTALLER_BINARY_NAME = "installer";
    public static final String INSTALLER_PATH = "/data/local/tmp/.studio/bin/installer";
    public static final String ANDROID_EXECUTABLE_PATH = "/tools/base/deploy/installer/android-installer";
    private final AdbClient adb;
    private final String installersFolder;
    private final Collection<DeployMetric> metrics;
    private final ILogger logger;
    private static final int HEX_LINE_SIZE = 10;

    public AdbInstaller(String installersFolder, AdbClient adb, Collection<DeployMetric> metrics, ILogger logger) {
        this.adb = adb;
        this.installersFolder = installersFolder;
        this.metrics = metrics;
        this.logger = logger;
    }

    private void logEvents(List<Deploy.Event> events) {
        for (Deploy.Event event : events) {
            this.logger.info(event.getTimestampNs() / 1000000L + "ms " + event.getType() + " [" + event.getPid() + "][" + event.getTid() + "] : " + event.getText(), new Object[0]);
        }
    }

    @Override
    public Deploy.DumpResponse dump(List<String> packageNames) throws IOException {
        String[] cmd = this.buildCmd((String[])ObjectArrays.concat((Object)"dump", (Object[])packageNames.toArray(new String[packageNames.size()])));
        Deploy.InstallerResponse installerResponse = this.invokeRemoteCommand(cmd, null);
        Deploy.DumpResponse response = installerResponse.getDumpResponse();
        this.logger.verbose("installer dump: " + response.getStatus().toString(), new Object[0]);
        return response;
    }

    @Override
    public Deploy.SwapResponse swap(Deploy.SwapRequest request) throws IOException {
        String[] cmd = this.buildCmd(new String[]{"swap"});
        ByteArrayInputStream inputStream = this.wrap((MessageLite)request);
        Deploy.InstallerResponse installerResponse = this.invokeRemoteCommand(cmd, inputStream);
        Deploy.SwapResponse response = installerResponse.getSwapResponse();
        this.logger.verbose("installer swap: " + response.getStatus().toString(), new Object[0]);
        return response;
    }

    @Override
    public Deploy.DeltaPreinstallResponse deltaPreinstall(Deploy.DeltaPreinstallRequest request) throws IOException {
        String[] cmd = this.buildCmd(new String[]{"deltapreinstall"});
        ByteArrayInputStream inputStream = this.wrap((MessageLite)request);
        Deploy.InstallerResponse installerResponse = this.invokeRemoteCommand(cmd, inputStream);
        Deploy.DeltaPreinstallResponse response = installerResponse.getDeltapreinstallResponse();
        this.logger.verbose("installer deltapreinstall: " + response.getStatus().toString(), new Object[0]);
        return response;
    }

    @Override
    public Deploy.DeltaInstallResponse deltaInstall(Deploy.DeltaInstallRequest request) throws IOException {
        String[] cmd = this.buildCmd(new String[]{"deltainstall"});
        ByteArrayInputStream inputStream = this.wrap((MessageLite)request);
        Deploy.InstallerResponse installerResponse = this.invokeRemoteCommand(cmd, inputStream);
        Deploy.DeltaInstallResponse response = installerResponse.getDeltainstallResponse();
        this.logger.verbose("installer deltainstall: " + response.getStatus().toString(), new Object[0]);
        return response;
    }

    private Deploy.InstallerResponse invokeRemoteCommand(String[] cmd, ByteArrayInputStream inputStream) throws IOException {
        Trace.begin("./installer " + cmd[2]);
        long start = System.nanoTime();
        Deploy.InstallerResponse response = this.invokeRemoteCommand(cmd, inputStream, OnFail.RETRY);
        this.logEvents(response.getEventsList());
        long end = System.nanoTime();
        long maxNs = Long.MIN_VALUE;
        long minNs = Long.MAX_VALUE;
        for (Deploy.Event event : response.getEventsList()) {
            maxNs = Math.max(maxNs, event.getTimestampNs());
            minNs = Math.min(minNs, event.getTimestampNs());
        }
        long delta = (maxNs + minNs - (end + start)) / 2L;
        Stack<Deploy.Event> eventStack = new Stack<Deploy.Event>();
        for (Deploy.Event event : response.getEventsList()) {
            switch (event.getType()) {
                case TRC_BEG: 
                case TRC_METRIC: {
                    Trace.begin(event.getPid(), event.getTid(), event.getTimestampNs() - delta, event.getText());
                    eventStack.push(event);
                    break;
                }
                case TRC_END: {
                    Deploy.Event begin;
                    Trace.end(event.getPid(), event.getTid(), event.getTimestampNs() - delta);
                    if (eventStack.empty() || (begin = (Deploy.Event)eventStack.pop()).getType() != Deploy.Event.Type.TRC_METRIC) break;
                    long startMs = begin.getTimestampNs() - delta;
                    long endMs = event.getTimestampNs() - delta;
                    this.metrics.add(new DeployMetric(begin.getText(), startMs, endMs));
                    break;
                }
            }
        }
        Trace.end();
        return response;
    }

    private Deploy.InstallerResponse invokeRemoteCommand(String[] cmd, ByteArrayInputStream inputStream, OnFail onFail) throws IOException {
        byte[] output = this.adb.shell(cmd, inputStream);
        Deploy.InstallerResponse response = (Deploy.InstallerResponse)this.unwrap(output, Deploy.InstallerResponse.parser());
        if (response == null) {
            if (onFail == OnFail.DO_NO_RETRY) {
                throw new IOException("Invalid installer response");
            }
            this.prepare();
            if (inputStream != null) {
                inputStream.reset();
            }
            return this.invokeRemoteCommand(cmd, inputStream, OnFail.DO_NO_RETRY);
        }
        if (response.getStatus() == Deploy.InstallerResponse.Status.ERROR_WRONG_VERSION) {
            this.prepare();
            if (inputStream != null) {
                inputStream.reset();
            }
            return this.invokeRemoteCommand(cmd, inputStream, OnFail.DO_NO_RETRY);
        }
        return response;
    }

    private void prepare() throws IOException {
        File installerFile = null;
        List<String> abis = this.adb.getAbis();
        for (String abi : abis) {
            String installerJarPath = abi + "/" + INSTALLER_BINARY_NAME;
            InputStream inputStream = this.getResource(installerJarPath);
            Throwable throwable = null;
            try {
                if (inputStream == null) continue;
                this.logger.info("Pushed installer '" + installerJarPath + "'", new Object[0]);
                installerFile = File.createTempFile(".studio_installer", abi);
                Files.copy(inputStream, Paths.get(installerFile.getAbsolutePath(), new String[0]), StandardCopyOption.REPLACE_EXISTING);
                break;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (inputStream == null) continue;
                if (throwable != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                inputStream.close();
            }
        }
        if (installerFile == null) {
            throw new IOException("Unsupported abis: " + Arrays.toString(abis.toArray()));
        }
        this.adb.shell(new String[]{"mkdir", "-p", "/data/local/tmp/.studio/bin"}, null);
        this.adb.push(installerFile.getAbsolutePath(), INSTALLER_PATH);
        this.adb.shell(new String[]{"chmod", "+x", INSTALLER_PATH}, null);
        installerFile.delete();
    }

    private InputStream getResource(String path2) throws FileNotFoundException {
        InputStream stream = this.installersFolder == null ? Installer.class.getResourceAsStream("/tools/base/deploy/installer/android-installer/" + path2) : new FileInputStream(this.installersFolder + "/" + path2);
        return stream;
    }

    private String[] buildCmd(String[] parameters) {
        Object[] base = new String[]{INSTALLER_PATH, "-version=" + Version.hash()};
        return (String[])ObjectArrays.concat((Object[])base, (Object[])parameters, String.class);
    }

    private <T extends MessageLite> T unwrap(byte[] b, Parser<T> parser) {
        if (b == null) {
            return null;
        }
        if (b.length < 4) {
            return null;
        }
        ByteBuffer buffer = ByteBuffer.wrap(b).order(ByteOrder.LITTLE_ENDIAN);
        int size = buffer.getInt();
        if (size != buffer.remaining()) {
            return null;
        }
        try {
            CodedInputStream cis = CodedInputStream.newInstance((byte[])b, (int)4, (int)(b.length - 4));
            return (T)((MessageLite)parser.parseFrom(cis));
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private ByteArrayInputStream wrap(MessageLite message2) {
        int size = message2.getSerializedSize();
        byte[] buffer = new byte[4 + size];
        ByteBuffer sizeWritter = ByteBuffer.wrap(buffer).order(ByteOrder.LITTLE_ENDIAN);
        sizeWritter.putInt(size);
        try {
            CodedOutputStream cos = CodedOutputStream.newInstance((byte[])buffer, (int)4, (int)size);
            message2.writeTo(cos);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return new ByteArrayInputStream(buffer);
    }

    private static enum OnFail {
        RETRY,
        DO_NO_RETRY;

    }
}

