/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.deployer;

import com.android.tools.deployer.ApplicationDumper;
import com.android.tools.deployer.DeployerException;
import com.android.tools.deployer.model.ApkEntry;
import com.android.tools.deployer.model.FileDiff;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ApkDiffer {
    public List<FileDiff> diff(ApplicationDumper.Dump oldFiles, List<ApkEntry> newFiles) throws DeployerException {
        Map<String, Map<String, ApkEntry>> oldMap = this.groupFiles(oldFiles.apkEntries);
        Map<String, Map<String, ApkEntry>> newMap2 = this.groupFiles(newFiles);
        if (newMap2.size() != oldMap.size()) {
            throw DeployerException.apkCountMismatch();
        }
        if (!newMap2.keySet().equals(oldMap.keySet())) {
            throw DeployerException.apkNameMismatch();
        }
        ArrayList<FileDiff> diffs = new ArrayList<FileDiff>();
        for (ApkEntry newFile : newFiles) {
            ApkEntry oldFile = oldMap.get(newFile.apk.name).get(newFile.name);
            if (oldFile == null) {
                diffs.add(new FileDiff(null, newFile, FileDiff.Status.CREATED));
                continue;
            }
            if (oldFile.checksum == newFile.checksum) continue;
            diffs.add(new FileDiff(oldFile, newFile, FileDiff.Status.MODIFIED));
        }
        for (ApkEntry oldFile : oldFiles.apkEntries) {
            ApkEntry newFile = newMap2.get(oldFile.apk.name).get(oldFile.name);
            if (newFile != null) continue;
            diffs.add(new FileDiff(oldFile, null, FileDiff.Status.DELETED));
        }
        return diffs;
    }

    public Map<String, Map<String, ApkEntry>> groupFiles(List<ApkEntry> oldFiles) {
        HashMap<String, Map<String, ApkEntry>> oldMap = new HashMap<String, Map<String, ApkEntry>>();
        for (ApkEntry file : oldFiles) {
            Map map = oldMap.computeIfAbsent(file.apk.name, k -> new HashMap());
            map.put(file.name, file);
        }
        return oldMap;
    }
}

