/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.deployer;

import com.android.tools.deployer.DeployerException;
import com.android.tools.deployer.ZipUtils;
import com.android.tools.deployer.model.Apk;
import com.android.tools.deployer.model.ApkEntry;
import com.android.tools.tracer.Trace;
import com.google.devrel.gmscore.tools.apk.arsc.BinaryResourceFile;
import com.google.devrel.gmscore.tools.apk.arsc.BinaryResourceValue;
import com.google.devrel.gmscore.tools.apk.arsc.Chunk;
import com.google.devrel.gmscore.tools.apk.arsc.XmlAttribute;
import com.google.devrel.gmscore.tools.apk.arsc.XmlChunk;
import com.google.devrel.gmscore.tools.apk.arsc.XmlStartElementChunk;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ApkParser {
    private static final int EOCD_SIGNATURE = 101010256;
    private static final byte[] SIGNATURE_BLOCK_MAGIC = "APK Sig Block 42".getBytes();
    private static final long USHRT_MAX = 65535L;
    private static final int EOCD_SIZE = 22;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<ApkEntry> parsePaths(List<String> paths) throws DeployerException {
        try (Trace ignored = Trace.begin("parseApks");){
            ArrayList<ApkEntry> newFiles = new ArrayList<ApkEntry>();
            for (String apkPath : paths) {
                newFiles.addAll(this.parse(apkPath));
            }
            ArrayList<ApkEntry> arrayList = newFiles;
            return arrayList;
        }
        catch (IOException e) {
            throw DeployerException.parseFailed(e.getMessage());
        }
    }

    public ApkDetails getApkDetails(String path2) throws IOException {
        ApkDetails apkDetails;
        try (ZipFile zipFile = new ZipFile(path2);){
            ZipEntry manifestEntry = zipFile.getEntry("AndroidManifest.xml");
            InputStream stream = zipFile.getInputStream(manifestEntry);
            apkDetails = this.parseManifest(stream);
        }
        return apkDetails;
    }

    private List<ApkEntry> parse(String apkPath) throws IOException, DeployerException {
        HashMap<String, ZipUtils.ZipEntry> zipEntries;
        String digest;
        File file = new File(apkPath);
        String absolutePath = file.getAbsolutePath();
        try (RandomAccessFile raf = new RandomAccessFile(absolutePath, "r");){
            FileChannel fileChannel = raf.getChannel();
            Object object = null;
            try {
                ApkArchiveMap apkArchiveMap = new ApkArchiveMap();
                ApkParser.findCDLocation(fileChannel, apkArchiveMap);
                ApkParser.findSignatureLocation(fileChannel, apkArchiveMap);
                digest = this.generateDigest(raf, apkArchiveMap);
                zipEntries = this.readZipEntries(raf, apkArchiveMap);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (fileChannel != null) {
                    if (object != null) {
                        try {
                            fileChannel.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        fileChannel.close();
                    }
                }
            }
        }
        ApkDetails apkDetails = this.getApkDetails(absolutePath);
        ArrayList<ApkEntry> files = new ArrayList<ApkEntry>();
        Apk apk = Apk.builder().setName(apkDetails.fileName).setChecksum(digest).setPath(absolutePath).setPackageName(apkDetails.packageName).setTargetPackages(apkDetails.targetPackages).setZipEntries(zipEntries).build();
        for (Map.Entry entry : zipEntries.entrySet()) {
            files.add(new ApkEntry((String)entry.getKey(), ((ZipUtils.ZipEntry)entry.getValue()).crc, apk));
        }
        return files;
    }

    public static void findSignatureLocation(FileChannel channel, ApkArchiveMap map) {
        try {
            ByteBuffer signatureBlockMagicNumber = ByteBuffer.allocate(SIGNATURE_BLOCK_MAGIC.length);
            channel.read(signatureBlockMagicNumber, map.cdOffset - (long)SIGNATURE_BLOCK_MAGIC.length);
            signatureBlockMagicNumber.rewind();
            if (!signatureBlockMagicNumber.equals(ByteBuffer.wrap(SIGNATURE_BLOCK_MAGIC))) {
                return;
            }
            ByteBuffer sizeBuffer = ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN);
            channel.read(sizeBuffer, map.cdOffset - (long)SIGNATURE_BLOCK_MAGIC.length - 8L);
            sizeBuffer.rewind();
            long lowerSignatureBlockSize = sizeBuffer.getLong();
            sizeBuffer.rewind();
            channel.read(sizeBuffer, map.cdOffset - 8L - lowerSignatureBlockSize);
            sizeBuffer.rewind();
            long upperSignatureBlocSize = sizeBuffer.getLong();
            if (lowerSignatureBlockSize != upperSignatureBlocSize) {
                return;
            }
            map.signatureBlockOffset = map.cdOffset - 8L - lowerSignatureBlockSize;
            map.signatureBlockSize = lowerSignatureBlockSize;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void findCDLocation(FileChannel channel, ApkArchiveMap map) throws IOException, DeployerException {
        long fileSize = channel.size();
        if (fileSize < 22L) {
            throw DeployerException.parseFailed("File is too small to be a valid zip file");
        }
        ByteBuffer eocdBuffer = ByteBuffer.allocate(22).order(ByteOrder.LITTLE_ENDIAN);
        channel.read(eocdBuffer, fileSize - 22L);
        eocdBuffer.rewind();
        if (eocdBuffer.getInt() == 101010256) {
            eocdBuffer.position(eocdBuffer.position() + 8);
            map.cdSize = eocdBuffer.getInt();
            map.cdOffset = eocdBuffer.getInt();
            return;
        }
        ByteBuffer endofFileBuffer = ByteBuffer.allocate((int)Math.min(fileSize, 65557L)).order(ByteOrder.LITTLE_ENDIAN);
        channel.read(endofFileBuffer, fileSize - (long)endofFileBuffer.capacity());
        endofFileBuffer.position(endofFileBuffer.capacity() - 22);
        while (true) {
            if (endofFileBuffer.getInt() == 101010256) {
                eocdBuffer.position(eocdBuffer.position() + 8);
                map.cdSize = eocdBuffer.getInt();
                map.cdOffset = eocdBuffer.getInt();
                return;
            }
            if (endofFileBuffer.position() - 5 < 0) {
                throw DeployerException.parseFailed("Unable to find apk's ECOD signature");
            }
            endofFileBuffer.position(endofFileBuffer.position() - 5);
        }
    }

    private HashMap<String, ZipUtils.ZipEntry> readZipEntries(RandomAccessFile randomAccessFile, ApkArchiveMap map) throws IOException {
        byte[] cdContent = new byte[(int)map.cdSize];
        randomAccessFile.seek(map.cdOffset);
        randomAccessFile.readFully(cdContent);
        ByteBuffer buffer = ByteBuffer.wrap(cdContent);
        return ZipUtils.readZipEntries(buffer);
    }

    private String generateDigest(RandomAccessFile randomAccessFile, ApkArchiveMap map) throws IOException {
        byte[] sigContent;
        if (map.signatureBlockOffset != -1L) {
            sigContent = new byte[(int)map.signatureBlockSize];
            randomAccessFile.seek(map.signatureBlockOffset);
            randomAccessFile.readFully(sigContent);
        } else {
            sigContent = new byte[(int)map.cdSize];
            randomAccessFile.seek(map.cdOffset);
            randomAccessFile.readFully(sigContent);
        }
        ByteBuffer buffer = ByteBuffer.wrap(sigContent);
        return ZipUtils.digest(buffer);
    }

    private ApkDetails parseManifest(InputStream decompressedManifest) throws IOException {
        BinaryResourceFile file = BinaryResourceFile.fromInputStream(decompressedManifest);
        List<Chunk> chunks = file.getChunks();
        if (chunks.isEmpty()) {
            throw new IllegalArgumentException("Invalid APK, empty manifest");
        }
        if (!(chunks.get(0) instanceof XmlChunk)) {
            throw new IllegalArgumentException("APK manifest chunk[0] != XmlChunk");
        }
        String packageName = null;
        String splitName = null;
        int versionCode = 0;
        ArrayList<String> targetPackages = new ArrayList<String>();
        XmlChunk xmlChunk = (XmlChunk)chunks.get(0);
        for (Chunk chunk : xmlChunk.getChunks().values()) {
            if (!(chunk instanceof XmlStartElementChunk)) continue;
            XmlStartElementChunk startChunk = (XmlStartElementChunk)chunk;
            if (startChunk.getName().equals("manifest")) {
                for (XmlAttribute attribute : startChunk.getAttributes()) {
                    BinaryResourceValue value;
                    if (attribute.name().equals("split")) {
                        splitName = attribute.rawValue();
                    }
                    if (attribute.name().equals("package")) {
                        packageName = attribute.rawValue();
                    }
                    if (!attribute.name().equals("versionCode") || (value = attribute.typedValue()) == null) continue;
                    versionCode = value.data();
                }
            }
            if (!startChunk.getName().equals("instrumentation")) continue;
            for (XmlAttribute attribute : startChunk.getAttributes()) {
                if (!attribute.name().equals("targetPackage")) continue;
                targetPackages.add(attribute.rawValue());
            }
        }
        if (packageName == null) {
            throw new IllegalArgumentException("Package name was not found in manifest");
        }
        String apkFileName = splitName == null ? "base.apk" : "split_" + splitName + ".apk";
        return new ApkDetails(apkFileName, packageName, versionCode, targetPackages);
    }

    public static class ApkDetails {
        public final int versionCode;
        public final String fileName;
        public final String packageName;
        public final List<String> targetPackages;

        private ApkDetails(String fileName, String packageName, int versionCode, List<String> targetPackages) {
            this.fileName = fileName;
            this.packageName = packageName;
            this.versionCode = versionCode;
            this.targetPackages = targetPackages;
        }
    }

    public static class ApkArchiveMap {
        public static final long UNINITIALIZED = -1L;
        long cdOffset = -1L;
        long cdSize = -1L;
        long signatureBlockOffset = -1L;
        long signatureBlockSize = -1L;
    }
}

