/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.deployer;

import com.android.annotations.Trace;
import com.android.tools.deploy.proto.Deploy;
import com.android.tools.deployer.AdbClient;
import com.android.tools.deployer.ApkInstaller;
import com.android.tools.deployer.ApplicationDumper;
import com.android.tools.deployer.DeployerException;
import com.android.tools.deployer.Installer;
import com.android.tools.deployer.PatchSetGenerator;
import com.android.tools.deployer.model.Apk;
import com.android.tools.deployer.model.ApkEntry;
import com.android.tools.deployer.model.FileDiff;
import com.android.utils.ILogger;
import com.android.utils.Pair;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ApkPreInstaller {
    private final AdbClient adb;
    private final Installer installer;
    private final ILogger logger;

    public ApkPreInstaller(AdbClient adb, Installer installer, ILogger logger) {
        this.adb = adb;
        this.installer = installer;
        this.logger = logger;
    }

    /*
     * WARNING - void declaration
     */
    @Trace
    public String preinstall(ApplicationDumper.Dump remoteContent, List<ApkEntry> localContent, List<FileDiff> diffs) throws DeployerException {
        void var6_9;
        HashMap<String, Apk> localApks = new HashMap<String, Apk>();
        for (ApkEntry apkEntry : localContent) {
            localApks.put(apkEntry.apk.name, apkEntry.apk);
        }
        HashMap<String, Apk> remoteApks = new HashMap<String, Apk>();
        for (ApkEntry apkEntry : remoteContent.apkEntries) {
            remoteApks.put(apkEntry.apk.name, apkEntry.apk);
        }
        Object var6_8 = null;
        for (Apk apk : localApks.values()) {
            if (var6_9 == null) {
                String string = apk.packageName;
            }
            if (var6_9.equals(apk.packageName)) continue;
            throw DeployerException.appIdChanged((String)var6_9, apk.packageName);
        }
        try {
            return this.deltaPreinstall(localApks, remoteApks, (String)var6_9, diffs);
        }
        catch (DeltaPreInstallException deltaPreInstallException) {
            return this.fullPreinstall(localApks);
        }
    }

    @Trace
    private String deltaPreinstall(HashMap<String, Apk> localApks, HashMap<String, Apk> remoteApks, String packageName, List<FileDiff> diffs) throws DeltaPreInstallException {
        try {
            ArrayList<Pair<Apk, Apk>> pairs = new ArrayList<Pair<Apk, Apk>>();
            for (Map.Entry<String, Apk> localApk : localApks.entrySet()) {
                if (!remoteApks.keySet().contains(localApk.getValue().name)) {
                    throw new DeltaPreInstallException("APK names changed.");
                }
                pairs.add((Pair<Apk, Apk>)Pair.of((Object)localApk.getValue(), (Object)remoteApks.get(localApk.getValue().name)));
            }
            Deploy.DeltaPreinstallRequest.Builder pushRequestBuilder = Deploy.DeltaPreinstallRequest.newBuilder();
            List<Deploy.PatchInstruction> patches = new PatchSetGenerator().generateFromPairs(pairs);
            if (patches.isEmpty()) {
                return "<SKIPPED-INSTALLATION>";
            }
            pushRequestBuilder.addAllPatchInstructions(patches);
            boolean inherit = ApkInstaller.canInherit(localApks.size(), diffs);
            pushRequestBuilder.setInherit(inherit);
            pushRequestBuilder.setPackageName(packageName);
            Deploy.DeltaPreinstallRequest request = (Deploy.DeltaPreinstallRequest)pushRequestBuilder.build();
            if (request.getSerializedSize() > 0x2800000) {
                throw new DeltaPreInstallException("Patches too big.");
            }
            Deploy.DeltaPreinstallResponse response = this.installer.deltaPreinstall(request);
            if (response.getStatus().equals((Object)Deploy.DeltaPreinstallResponse.Status.OK)) {
                return response.getSessionId();
            }
            throw new DeltaPreInstallException("Failed to delta pre-install on device.");
        }
        catch (IOException e) {
            this.logger.error((Throwable)e, "Unable to deltaInstall", new Object[0]);
            throw new DeltaPreInstallException(e);
        }
    }

    @Trace
    private String fullPreinstall(HashMap<String, Apk> fullApks) throws DeployerException {
        String sessionId;
        long totalSize = 0L;
        try {
            for (Apk apk : fullApks.values()) {
                totalSize += Files.size(Paths.get(apk.path, new String[0]));
            }
        }
        catch (IOException e) {
            throw DeployerException.preinstallFailed(e.getMessage());
        }
        try {
            byte[] rawResponse = this.adb.binder(new String[]{"package", "install-create", "-t", "-r", "--dont-kill", "-S", Long.toString(totalSize)}, null);
            String stringResponse = new String(rawResponse, "UTF-8");
            if (!stringResponse.startsWith("Success: created install session [")) {
                throw DeployerException.preinstallFailed("Unable to create session : " + stringResponse);
            }
            sessionId = stringResponse.substring(stringResponse.indexOf(91) + 1, stringResponse.indexOf(93));
        }
        catch (IOException e) {
            throw DeployerException.preinstallFailed(e.getMessage());
        }
        for (Apk apk : fullApks.values()) {
            try {
                FileInputStream stream = new FileInputStream(new File(apk.path));
                long size = Files.size(Paths.get(apk.path, new String[0]));
                byte[] rawResponse = this.adb.binder(new String[]{"package", "install-write", "-S", Long.toString(size), sessionId, apk.name}, stream);
                String stringResponse = new String(rawResponse, "UTF-8");
                if (stringResponse.startsWith("Success")) continue;
                throw DeployerException.preinstallFailed(stringResponse);
            }
            catch (IOException e) {
                throw DeployerException.preinstallFailed(e.getMessage());
            }
        }
        return sessionId;
    }

    public static class DeltaPreInstallException
    extends Exception {
        public DeltaPreInstallException(String msg) {
            super(msg);
        }

        public DeltaPreInstallException(Exception e) {
            super(e);
        }
    }
}

