/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.deployer;

import com.android.tools.deploy.proto.Deploy;
import com.android.tools.deploy.protobuf.ByteString;
import com.android.tools.deployer.ApplicationDumper;
import com.android.tools.deployer.ClassRedefiner;
import com.android.tools.deployer.DeployerException;
import com.android.tools.deployer.Installer;
import com.android.tools.deployer.InstallerBasedClassRedefiner;
import com.android.tools.deployer.JvmtiError;
import com.android.tools.deployer.model.DexClass;
import com.google.common.base.Enums;
import com.google.common.base.Optional;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Map;

public class ApkSwapper {
    private final Installer installer;
    private final boolean restart;
    private final Map<Integer, ClassRedefiner> redefiners;

    public ApkSwapper(Installer installer, Map<Integer, ClassRedefiner> redefiners, boolean restart) {
        this.installer = installer;
        this.redefiners = redefiners;
        this.restart = restart;
    }

    public boolean swap(ApplicationDumper.Dump dump2, String sessionId, List<DexClass> toSwap) throws DeployerException {
        if (dump2.packagePids.isEmpty()) {
            throw DeployerException.unknownProcess();
        }
        if (dump2.packagePids.size() > 1) {
            throw DeployerException.swapMultiplePackages();
        }
        Deploy.SwapRequest swapRequest = this.buildSwapRequest(dump2, sessionId, toSwap);
        boolean needAgents = this.isSwapRequestInstallOnly(swapRequest);
        Thread t = null;
        DeployerException[] exceptions = new DeployerException[1];
        if (needAgents) {
            t = new Thread(() -> {
                try {
                    ApkSwapper.sendSwapRequest(swapRequest, new InstallerBasedClassRedefiner(this.installer));
                }
                catch (DeployerException e) {
                    exceptions[0] = e;
                }
            });
            t.start();
        }
        for (Map.Entry<Integer, ClassRedefiner> entry : this.redefiners.entrySet()) {
            ApkSwapper.sendSwapRequest(swapRequest, entry.getValue());
        }
        if (t != null) {
            try {
                t.join();
            }
            catch (InterruptedException e) {
                throw DeployerException.interrupted(e.getMessage());
            }
            if (exceptions[0] != null) {
                throw exceptions[0];
            }
        } else {
            ApkSwapper.sendSwapRequest(swapRequest, new InstallerBasedClassRedefiner(this.installer));
        }
        return true;
    }

    private Deploy.SwapRequest buildSwapRequest(ApplicationDumper.Dump dump2, String sessionId, List<DexClass> toSwap) throws DeployerException {
        Map.Entry onlyPackage = (Map.Entry)Iterables.getOnlyElement(dump2.packagePids.entrySet());
        Deploy.SwapRequest.Builder request = Deploy.SwapRequest.newBuilder().setPackageName((String)onlyPackage.getKey()).setRestartActivity(this.restart).setSessionId(sessionId);
        for (DexClass clazz : toSwap) {
            request.addClasses(Deploy.ClassDef.newBuilder().setName(clazz.name).setDex(ByteString.copyFrom((byte[])clazz.code)));
        }
        int extraAgents = 0;
        block7: for (Integer pid : (List)onlyPackage.getValue()) {
            if (this.redefiners.containsKey(pid)) {
                ClassRedefiner redefiner = this.redefiners.get(pid);
                switch (redefiner.canRedefineClass().support) {
                    case FULL: {
                        continue block7;
                    }
                    case NEEDS_AGENT_SERVER: {
                        ++extraAgents;
                        continue block7;
                    }
                    case MAIN_THREAD_RUNNING: {
                        request.addProcessIds(pid.intValue());
                        continue block7;
                    }
                    case NONE: {
                        throw DeployerException.operationNotSupported("The redefiner is not able to swap the current state of the debug application. All available threads are suspended but not on a breakpoint.");
                    }
                }
                continue;
            }
            request.addProcessIds(pid.intValue());
        }
        request.setExtraAgents(extraAgents);
        return (Deploy.SwapRequest)request.build();
    }

    private boolean isSwapRequestInstallOnly(Deploy.SwapRequest request) {
        return request.getProcessIdsCount() > 0 || request.getExtraAgents() > 0;
    }

    private static void sendSwapRequest(Deploy.SwapRequest request, ClassRedefiner redefiner) throws DeployerException {
        Deploy.SwapResponse swapResponse = redefiner.redefine(request);
        if (swapResponse.getStatus() != Deploy.SwapResponse.Status.OK) {
            if (swapResponse.getJvmtiErrorCodeCount() == 0) {
                throw DeployerException.swapFailed(swapResponse.getStatus());
            }
            if (swapResponse.getJvmtiErrorDetailsCount() == 0) {
                Optional errorCode = Enums.getIfPresent(JvmtiError.class, (String)((String)swapResponse.getJvmtiErrorCodeList().get(0)));
                throw DeployerException.jvmtiError((JvmtiError)((Object)errorCode.or((Object)JvmtiError.UNKNOWN_JVMTI_ERROR)));
            }
            Deploy.JvmtiErrorDetails details = (Deploy.JvmtiErrorDetails)swapResponse.getJvmtiErrorDetailsList().get(0);
            String parentClass = details.getClassName();
            String resType = parentClass.substring(parentClass.lastIndexOf(36) + 1);
            if (details.getType() == Deploy.JvmtiErrorDetails.Type.FIELD_ADDED) {
                throw DeployerException.addedResources(details.getName(), resType);
            }
            if (details.getType() == Deploy.JvmtiErrorDetails.Type.FIELD_REMOVED) {
                throw DeployerException.removedResources(details.getName(), resType);
            }
            throw DeployerException.unknownJvmtiError(details.getType().name());
        }
    }
}

