/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.deployer;

import com.android.tools.deploy.proto.Deploy;
import com.android.tools.deployer.DeployerException;
import com.android.tools.deployer.Installer;
import com.android.tools.deployer.ZipUtils;
import com.android.tools.deployer.model.Apk;
import com.android.tools.deployer.model.ApkEntry;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class ApplicationDumper {
    private final Installer installer;

    public ApplicationDumper(Installer installer) {
        this.installer = installer;
    }

    public Dump dump(List<ApkEntry> apkEntries) throws DeployerException {
        Deploy.DumpResponse response;
        String packageName = null;
        HashSet<String> targetPackages = new HashSet<String>();
        for (ApkEntry entry : apkEntries) {
            if (packageName == null) {
                packageName = entry.apk.packageName;
            }
            if (!entry.apk.packageName.equals(packageName)) {
                throw DeployerException.swapMultiplePackages();
            }
            targetPackages.addAll(entry.apk.targetPackages);
        }
        ArrayList<String> packagesToDump = new ArrayList<String>();
        packagesToDump.add(packageName);
        packagesToDump.addAll(targetPackages);
        try {
            response = this.installer.dump(packagesToDump);
        }
        catch (IOException e) {
            throw DeployerException.dumpFailed(e.getMessage());
        }
        if (response.getStatus() == Deploy.DumpResponse.Status.ERROR_PACKAGE_NOT_FOUND) {
            throw DeployerException.unknownPackage(response.getFailedPackage());
        }
        return new Dump(ApplicationDumper.GetApkEntries(response.getPackages(0)), ApplicationDumper.GetPids(response));
    }

    private static List<ApkEntry> GetApkEntries(Deploy.PackageDump packageDump) {
        ArrayList<ApkEntry> dumps = new ArrayList<ApkEntry>();
        for (Deploy.ApkDump dump2 : packageDump.getApksList()) {
            ByteBuffer cd = dump2.getCd().asReadOnlyByteBuffer();
            ByteBuffer signature = dump2.getSignature().asReadOnlyByteBuffer();
            HashMap<String, ZipUtils.ZipEntry> zipEntries = ZipUtils.readZipEntries(cd);
            cd.rewind();
            String digest = ZipUtils.digest(signature.remaining() != 0 ? signature : cd);
            Apk apk = Apk.builder().setName(dump2.getName()).setChecksum(digest).setPath(dump2.getAbsolutePath()).setZipEntries(zipEntries).build();
            for (Map.Entry<String, ZipUtils.ZipEntry> entry : zipEntries.entrySet()) {
                dumps.add(new ApkEntry(entry.getKey(), entry.getValue().crc, apk));
            }
        }
        return dumps;
    }

    private static Map<String, List<Integer>> GetPids(Deploy.DumpResponse response) {
        HashMap<String, List<Integer>> pids = new HashMap<String, List<Integer>>();
        for (Deploy.PackageDump packageDump : response.getPackagesList()) {
            if (packageDump.getProcessesList().isEmpty()) continue;
            pids.put(packageDump.getName(), packageDump.getProcessesList());
        }
        return pids;
    }

    public static class Dump {
        public final List<ApkEntry> apkEntries;
        public final Map<String, List<Integer>> packagePids;

        public Dump(List<ApkEntry> apkEntries, Map<String, List<Integer>> packagePids) {
            this.apkEntries = apkEntries;
            this.packagePids = packagePids;
        }
    }
}

