/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.deployer;

import com.android.tools.deployer.ApkFileDatabase;
import com.android.tools.deployer.DeployerException;
import com.android.tools.deployer.DexSplitter;
import com.android.tools.deployer.model.ApkEntry;
import com.android.tools.deployer.model.DexClass;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.List;
import java.util.function.Predicate;

public class CachedDexSplitter
implements DexSplitter {
    private final ApkFileDatabase db;
    private final DexSplitter splitter;

    public CachedDexSplitter(ApkFileDatabase db, DexSplitter splitter) {
        this.db = db;
        this.splitter = splitter;
    }

    @Override
    public List<DexClass> split(ApkEntry dex, Predicate<DexClass> keepCode) throws DeployerException {
        List<DexClass> classes = this.db.getClasses(dex);
        if (classes.isEmpty() || keepCode != null) {
            if (dex.apk.path == null || Files.notExists(Paths.get(dex.apk.path, new String[0]), new LinkOption[0])) {
                throw DeployerException.remoteApkNotFound();
            }
            classes = this.splitter.split(dex, keepCode);
            this.db.addClasses(classes);
        }
        return classes;
    }
}

