/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.deployer;

import com.android.tools.deployer.DexSplitter;
import com.android.tools.deployer.model.ApkEntry;
import com.android.tools.deployer.model.DexClass;
import com.android.tools.r8.ByteDataView;
import com.android.tools.r8.CompilationFailedException;
import com.android.tools.r8.D8;
import com.android.tools.r8.D8Command;
import com.android.tools.r8.DexFilePerClassFileConsumer;
import com.android.tools.r8.DiagnosticsHandler;
import com.android.tools.r8.ProgramConsumer;
import com.android.tools.r8.origin.Origin;
import com.android.tools.tracer.Trace;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.function.Predicate;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class D8DexSplitter
implements DexSplitter {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<DexClass> split(ApkEntry dex, Predicate<DexClass> keepCode) {
        try (Trace ignored = Trace.begin("split " + dex.name);){
            ArrayList<DexClass> classes = new ArrayList<DexClass>();
            DexConsumer consumer = new DexConsumer(dex, classes, keepCode);
            D8Command.Builder newBuilder = D8Command.builder();
            newBuilder.addDexProgramData(D8DexSplitter.readDex(dex), Origin.unknown());
            newBuilder.setDisableDesugaring(true);
            newBuilder.setProgramConsumer((ProgramConsumer)consumer);
            D8.run((D8Command)((D8Command)newBuilder.build()));
            consumer.join();
            ArrayList<DexClass> arrayList = classes;
            return arrayList;
        }
        catch (CompilationFailedException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] readDex(ApkEntry dex) {
        try (ZipFile file = new ZipFile(dex.apk.path);){
            ZipEntry entry = file.getEntry(dex.name);
            byte[] byArray = ByteStreams.toByteArray((InputStream)file.getInputStream(entry));
            return byArray;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static class DexConsumer
    implements DexFilePerClassFileConsumer {
        private final List<DexClass> classes;
        private final CountDownLatch finished = new CountDownLatch(1);
        private final Predicate<DexClass> keepCode;
        private final ApkEntry dex;

        private DexConsumer(ApkEntry dex, List<DexClass> classes, Predicate<DexClass> keepCode) {
            this.dex = dex;
            this.classes = classes;
            this.keepCode = keepCode;
        }

        public void finished(DiagnosticsHandler handler) {
            this.finished.countDown();
        }

        public void join() throws InterruptedException {
            this.finished.await();
        }

        public synchronized void accept(String name, ByteDataView data, Set<String> descriptors, DiagnosticsHandler handler) {
            String className = DexConsumer.typeNameToClassName(name);
            CRC32 crc = new CRC32();
            crc.update(data.getBuffer(), data.getOffset(), data.getLength());
            long newChecksum = crc.getValue();
            DexClass clazz = new DexClass(className, newChecksum, null, this.dex);
            if (this.keepCode != null && this.keepCode.test(clazz)) {
                clazz = new DexClass(className, newChecksum, data.copyByteData(), this.dex);
            }
            this.classes.add(clazz);
        }

        private static String typeNameToClassName(String typeName) {
            assert (typeName.startsWith("L"));
            assert (typeName.endsWith(";"));
            return typeName.substring(1, typeName.length() - 1).replace('/', '.');
        }
    }
}

