/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.deployer;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import com.android.tools.deployer.AdbClient;
import com.android.tools.deployer.AdbInstaller;
import com.android.tools.deployer.ApkFileDatabase;
import com.android.tools.deployer.ClassRedefiner;
import com.android.tools.deployer.DeployMetric;
import com.android.tools.deployer.DeployRunnerParameters;
import com.android.tools.deployer.Deployer;
import com.android.tools.deployer.DeployerException;
import com.android.tools.deployer.InstallOptions;
import com.android.tools.deployer.SqlApkFileDatabase;
import com.android.tools.deployer.UIService;
import com.android.tools.deployer.tasks.TaskRunner;
import com.android.tools.tracer.Trace;
import com.android.utils.ILogger;
import com.android.utils.StdLogger;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import java.util.Scanner;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class DeployerRunner {
    private static final String DB_PATH = "/tmp/studio.db";
    private final ApkFileDatabase db;
    private final ArrayList<DeployMetric> metrics;
    private final UIService service;

    public static void main(String[] args) {
        Trace.start();
        Trace.begin("main");
        int errorcode = DeployerRunner.tracedMain(args, (ILogger)new StdLogger(StdLogger.Level.VERBOSE));
        Trace.end();
        Trace.flush();
        if (errorcode != 0) {
            System.exit(errorcode);
        }
    }

    public static int tracedMain(String[] args, ILogger logger) {
        SqlApkFileDatabase db = new SqlApkFileDatabase(new File(DB_PATH));
        DeployerRunner runner = new DeployerRunner(db, new CommandLineService());
        return runner.run(args, logger);
    }

    public DeployerRunner(ApkFileDatabase db, UIService service) {
        this.db = db;
        this.service = service;
        this.metrics = new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int run(String[] args, ILogger logger) {
        try {
            AndroidDebugBridge bridge = this.initDebugBridge();
            int n = this.run(bridge, args, logger);
            return n;
        }
        finally {
            AndroidDebugBridge.terminate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int run(AndroidDebugBridge bridge, String[] args, ILogger logger) {
        if (args.length < 2) {
            logger.info("Usage: DeployerRunner packageName [packageBase,packageSplit1,...]", new Object[0]);
            return -1;
        }
        DeployRunnerParameters parameters = DeployRunnerParameters.parse(args);
        String packageName = parameters.get(0);
        ArrayList<String> apks = new ArrayList<String>();
        for (int i = 1; i < parameters.size(); ++i) {
            apks.add(parameters.get(i));
        }
        Trace.begin("getDevice()");
        IDevice device = this.getDevice(bridge);
        if (device == null) {
            logger.error(null, "%s", new Object[]{"No device found."});
            return -2;
        }
        Trace.end();
        this.metrics.clear();
        AdbClient adb = new AdbClient(device, logger);
        AdbInstaller installer = new AdbInstaller(parameters.getInstallersPath(), adb, this.metrics, logger);
        ExecutorService service = Executors.newFixedThreadPool(5);
        TaskRunner runner = new TaskRunner(service);
        Deployer deployer = new Deployer(adb, this.db, runner, installer, this.service, this.metrics, logger);
        try {
            if (parameters.getCommand() == DeployRunnerParameters.Command.INSTALL) {
                InstallOptions.Builder options = InstallOptions.builder().setAllowDebuggable();
                if (device.supportsFeature(IDevice.HardwareFeature.EMBEDDED)) {
                    options.setGrantAllPermissions();
                }
                Deployer.InstallMode installMode = Deployer.InstallMode.DELTA;
                if (parameters.isForceFullInstall()) {
                    installMode = Deployer.InstallMode.FULL;
                }
                deployer.install(packageName, apks, options.build(), installMode);
            } else if (parameters.getCommand() == DeployRunnerParameters.Command.FULLSWAP) {
                deployer.fullSwap(apks);
            } else if (parameters.getCommand() == DeployRunnerParameters.Command.CODESWAP) {
                deployer.codeSwap(apks, (Map<Integer, ClassRedefiner>)ImmutableMap.of());
            } else {
                throw new RuntimeException("UNKNOWN command");
            }
            runner.run();
        }
        catch (DeployerException e) {
            logger.error((Throwable)e, "Not possible to execute " + parameters.getCommand().name().toLowerCase(), new Object[0]);
            logger.warning(e.getDetails(), new Object[0]);
            int n = e.getError().ordinal();
            return n;
        }
        finally {
            service.shutdown();
        }
        return 0;
    }

    public ArrayList<DeployMetric> getMetrics() {
        return this.metrics;
    }

    private IDevice getDevice(AndroidDebugBridge bridge) {
        IDevice[] devices = bridge.getDevices();
        if (devices.length < 1) {
            return null;
        }
        return devices[0];
    }

    private AndroidDebugBridge initDebugBridge() {
        AndroidDebugBridge.init(false);
        AndroidDebugBridge bridge = AndroidDebugBridge.createBridge();
        while (!bridge.hasInitialDeviceList()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return bridge;
    }

    static class CommandLineService
    implements UIService {
        CommandLineService() {
        }

        @Override
        public boolean prompt(String message2) {
            System.err.println(message2 + ". Y/N?");
            try (Scanner scanner = new Scanner(System.in);){
                boolean bl = scanner.nextLine().equalsIgnoreCase("y");
                return bl;
            }
        }

        @Override
        public void message(String message2) {
            System.err.println(message2);
        }
    }
}

