/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.deployer;

import com.android.annotations.Trace;
import com.android.tools.deployer.DeployerException;
import com.android.tools.deployer.DexSplitter;
import com.android.tools.deployer.model.DexClass;
import com.android.tools.deployer.model.FileDiff;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class DexComparator {
    @Trace
    public List<DexClass> compare(List<FileDiff> dexDiffs, DexSplitter splitter) throws DeployerException {
        HashMap<String, Long> oldChecksums = new HashMap<String, Long>();
        for (FileDiff diff : dexDiffs) {
            if (diff.status == FileDiff.Status.CREATED) continue;
            List<DexClass> klasses = splitter.split(diff.oldFile, null);
            for (DexClass clz2 : klasses) {
                oldChecksums.put(clz2.name, clz2.checksum);
            }
        }
        ArrayList<DexClass> toSwap = new ArrayList<DexClass>();
        for (FileDiff diff : dexDiffs) {
            Predicate<DexClass> keepCode = clz -> {
                Long oldChecksum = (Long)oldChecksums.get(clz.name);
                return oldChecksum != null && clz.checksum != oldChecksum;
            };
            List<DexClass> newClasses = splitter.split(diff.newFile, keepCode);
            for (DexClass klass : newClasses) {
                if (oldChecksums.containsKey(klass.name)) continue;
                throw DeployerException.addedNewClass(klass.name);
            }
            toSwap.addAll(newClasses.stream().filter(c -> c.code != null).collect(Collectors.toList()));
        }
        return toSwap;
    }
}

