/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.deployer;

import com.android.tools.deploy.proto.Deploy;
import com.android.tools.deployer.ClassRedefiner;
import com.android.tools.deployer.DeployerException;
import com.android.tools.deployer.Version;
import com.google.common.collect.Lists;
import com.sun.jdi.Bootstrap;
import com.sun.jdi.ClassType;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StringReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.VirtualMachineManager;
import com.sun.jdi.connect.AttachingConnector;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import com.sun.tools.jdi.SocketAttachingConnector;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class JdiBasedClassRedefiner
implements ClassRedefiner {
    private static final long DEBUGGER_TIMEOUT_MS = TimeUnit.SECONDS.toMillis(10L);
    private final VirtualMachine vm;
    private final ClassRedefiner.RedefineClassSupportState redefineSupportState;

    static VirtualMachine attach(String hostname, int portNumber) throws IOException, IllegalConnectorArgumentsException {
        VirtualMachineManager manager = Bootstrap.virtualMachineManager();
        for (AttachingConnector connector : manager.attachingConnectors()) {
            if (!(connector instanceof SocketAttachingConnector)) continue;
            HashMap<String, Connector.Argument> args = new HashMap<String, Connector.Argument>(connector.defaultArguments());
            args.get("timeout").setValue(String.valueOf(DEBUGGER_TIMEOUT_MS));
            args.get("hostname").setValue(hostname);
            args.get("port").setValue("" + portNumber);
            return connector.attach(args);
        }
        return null;
    }

    public JdiBasedClassRedefiner(VirtualMachine vm) {
        this(vm, new ClassRedefiner.RedefineClassSupportState(ClassRedefiner.RedefineClassSupport.FULL, null));
    }

    public JdiBasedClassRedefiner(VirtualMachine vm, ClassRedefiner.RedefineClassSupportState redefineSupportState) {
        this.vm = vm;
        this.redefineSupportState = redefineSupportState;
    }

    @Override
    public Deploy.SwapResponse redefine(Deploy.SwapRequest request) throws DeployerException {
        HashMap<ReferenceType, byte[]> redefinitionRequest = new HashMap<ReferenceType, byte[]>();
        for (Deploy.ClassDef redefinition : request.getClassesList()) {
            List<ReferenceType> classes = this.getReferenceTypeByName(redefinition.getName());
            for (ReferenceType classRef : classes) {
                redefinitionRequest.put(classRef, redefinition.getDex().toByteArray());
            }
        }
        Deploy.SwapResponse.Builder response = Deploy.SwapResponse.newBuilder();
        switch (this.redefineSupportState.support) {
            case FULL: {
                try {
                    this.vm.redefineClasses(redefinitionRequest);
                    break;
                }
                catch (Throwable t) {
                    throw DeployerException.jdwpRedefineClassesException(t);
                }
            }
            case MAIN_THREAD_RUNNING: {
                break;
            }
            case NEEDS_AGENT_SERVER: {
                List<ReferenceType> debugList = this.vm.classesByName("dalvik.system.VMDebug");
                ClassType debug = (ClassType)debugList.get(0);
                List<ThreadReference> allThreads = this.vm.allThreads();
                for (ThreadReference thread : allThreads) {
                    if (!thread.name().equals(this.redefineSupportState.targetThread)) continue;
                    Method attachAgentMethod = debug.concreteMethodByName("attachAgent", "(Ljava/lang/String;)V");
                    if (attachAgentMethod == null) {
                        throw DeployerException.attachAgentNotFound();
                    }
                    String agentLoc = "/data/data/" + request.getPackageName() + "/code_cache/.studio/agent-" + Version.hash() + ".so=irsocket";
                    try {
                        debug.invokeMethod(thread, attachAgentMethod, Lists.newArrayList((Object[])new StringReference[]{this.vm.mirrorOf(agentLoc)}), 1);
                    }
                    catch (Exception e) {
                        try {
                            Thread.sleep(1000L);
                            debug.invokeMethod(thread, attachAgentMethod, Lists.newArrayList((Object[])new StringReference[]{this.vm.mirrorOf(agentLoc)}), 1);
                        }
                        catch (Exception e1) {
                            throw DeployerException.attachAgentException(e1);
                        }
                    }
                }
                break;
            }
            default: {
                throw DeployerException.jdiInvalidState();
            }
        }
        response.setStatus(Deploy.SwapResponse.Status.OK);
        return (Deploy.SwapResponse)response.build();
    }

    @Override
    public ClassRedefiner.RedefineClassSupportState canRedefineClass() {
        return this.redefineSupportState;
    }

    List<ReferenceType> getReferenceTypeByName(String name) {
        return this.vm.classesByName(name);
    }

    boolean hasRedefineClassesCapabilities() {
        return this.vm.canRedefineClasses();
    }
}

