/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.deployer;

import com.android.tools.deployer.ApkMap;
import com.android.tools.deployer.ZipUtils;
import com.android.tools.deployer.model.Apk;
import com.android.tools.tracer.Trace;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public class PatchGenerator {
    public Patch generate(Apk remoteApk, Apk localApk) throws IOException {
        String sourcePath = remoteApk.path;
        long destinationSize = Files.size(Paths.get(localApk.path, new String[0]));
        List<ApkMap.Area> dirtyAreas = this.generateDirtyMap(remoteApk, localApk);
        int patchSize = 0;
        for (ApkMap.Area dirtyArea : dirtyAreas) {
            patchSize = (int)((long)patchSize + dirtyArea.size());
        }
        ByteBuffer data = ByteBuffer.wrap(new byte[patchSize]);
        ByteBuffer instructions = ByteBuffer.wrap(new byte[dirtyAreas.size() * 8]).order(ByteOrder.LITTLE_ENDIAN);
        Trace.begin("building patch");
        try (FileChannel fileChannel = new RandomAccessFile(new File(localApk.path), "r").getChannel();){
            for (ApkMap.Area dirtyArea : dirtyAreas) {
                instructions.putInt((int)dirtyArea.start);
                instructions.putInt((int)dirtyArea.size());
                data.limit((int)((long)data.position() + dirtyArea.size()));
                fileChannel.read(data, dirtyArea.start);
            }
        }
        Trace.end();
        data.rewind();
        instructions.rewind();
        return new Patch(data, instructions, sourcePath, destinationSize);
    }

    public Patch generateCleanPatch(Apk remoteApk, Apk localApk) throws IOException {
        String sourcePath = remoteApk.path;
        long destinationSize = Files.size(Paths.get(localApk.path, new String[0]));
        return new Patch(null, null, sourcePath, destinationSize);
    }

    private List<ApkMap.Area> generateDirtyMap(Apk remoteApk, Apk localApk) throws IOException {
        Trace.begin("marking dirty");
        HashMap<String, ZipUtils.ZipEntry> remoteApkEntries = remoteApk.zipEntries;
        HashMap<String, ZipUtils.ZipEntry> localApkEntries = localApk.zipEntries;
        ApkMap dirtyMap = new ApkMap(Files.size(Paths.get(localApk.path, new String[0])));
        for (ZipUtils.ZipEntry remoteEntry : remoteApkEntries.values()) {
            ZipUtils.ZipEntry localEntry = localApkEntries.get(remoteEntry.name);
            if (localEntry == null || !Arrays.equals(remoteEntry.localFileHeader, localEntry.localFileHeader)) continue;
            if (localEntry.extraLength == 0) {
                ApkMap.Area cleanArea = new ApkMap.Area(localEntry.start, localEntry.end);
                dirtyMap.markClean(cleanArea);
                continue;
            }
            ApkMap.Area headerUpToName = new ApkMap.Area(localEntry.start, localEntry.payloadStart - (long)localEntry.extraLength - 1L);
            dirtyMap.markClean(headerUpToName);
            ApkMap.Area compressedDataArea = new ApkMap.Area(localEntry.payloadStart, localEntry.end);
            dirtyMap.markClean(compressedDataArea);
        }
        Trace.end();
        return dirtyMap.getDirtyAreas();
    }

    public static class Patch {
        final ByteBuffer data;
        final ByteBuffer instructions;
        final String sourcePath;
        final long destinationSize;

        Patch(ByteBuffer data, ByteBuffer instructions, String sourcePath, long destinationSize) {
            this.data = data;
            this.instructions = instructions;
            this.sourcePath = sourcePath;
            this.destinationSize = destinationSize;
        }
    }
}

