/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.deployer;

import com.android.tools.deployer.ApkFileDatabase;
import com.android.tools.deployer.model.Apk;
import com.android.tools.deployer.model.ApkEntry;
import com.android.tools.deployer.model.DexClass;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class SqlApkFileDatabase
implements ApkFileDatabase {
    public static final int MAX_DEXFILES_ENTRY = 200;
    private static final String CURRENT_SCHEMA_VERSION_NUMBER = "0.2";
    private final String schemaVersion;
    private final int maxDexFilesEntries;
    private Connection connection;

    public SqlApkFileDatabase(File file) {
        this(file, CURRENT_SCHEMA_VERSION_NUMBER, 200);
    }

    public SqlApkFileDatabase(File file, String schemaVersionNumber, int maxDexFileEntries) {
        this.schemaVersion = schemaVersionNumber;
        this.maxDexFilesEntries = maxDexFileEntries;
        try {
            Class.forName("org.sqlite.JDBC");
            boolean newFile = !file.exists();
            this.connection = DriverManager.getConnection(String.format("jdbc:sqlite:%s", file.getPath()));
            if (newFile) {
                this.fillTables();
            } else {
                this.dropOldTables();
            }
            this.executeStatements("PRAGMA foreign_keys=ON;");
        }
        catch (ClassNotFoundException | SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() {
        try {
            this.connection.close();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private void dropOldTables() throws SQLException {
        try (Statement s = this.connection.createStatement();
             ResultSet result = s.executeQuery("SELECT value from metadata WHERE name = \"schema-version\";");){
            String version;
            if (result.next() && (version = result.getString("value")).equals(this.schemaVersion)) {
                return;
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.executeStatements("PRAGMA writable_schema = 1;", "delete from sqlite_master where type in ('table', 'index', 'trigger');", "PRAGMA writable_schema = 0;", "VACUUM;");
        this.fillTables();
    }

    private void fillTables() throws SQLException {
        this.executeStatements("CREATE TABLE metadata (name VARCHAR(255) UNIQUE NOT NULL, value VARCHAR(255) NOT NULL, PRIMARY KEY (name));", "INSERT INTO metadata (name, value) values (\"schema-version\", \"" + this.schemaVersion + "\");", "CREATE TABLE dexfiles (id INTEGER PRIMARY KEY AUTOINCREMENT, name VARCHAR(255) NOT NULL, checksum LONG NOT NULL);", "CREATE INDEX dexfiles_checksum_index ON dexfiles(checksum);", "CREATE TABLE archives (dexfileId INTEGER, checksum VARCHAR(255), CONSTRAINT fk_archives_dexfileId FOREIGN KEY(dexfileId) REFERENCES dexfiles(id) ON DELETE CASCADE);", "CREATE INDEX archives_checksum_index ON archives(checksum);", "CREATE TABLE classes (dexfileId INTEGER, name TEXT, checksum LONG, CONSTRAINT fk_classes_dexfileId FOREIGN KEY(dexfileId) REFERENCES dexfiles(id) ON DELETE CASCADE);", "CREATE INDEX classes_dexfileId_name_index ON classes(dexfileId);");
    }

    private void flushOldCache() {
        try {
            this.executeUpdate("DELETE FROM dexfiles WHERE id < (SELECT * FROM (SELECT id from dexfiles ORDER BY id DESC LIMIT " + this.maxDexFilesEntries + ") ORDER BY id LIMIT 1);");
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private void executeStatements(String ... statements) throws SQLException {
        try (Statement s = this.connection.createStatement();){
            if (statements.length == 1) {
                s.execute(statements[0]);
            } else {
                for (String statement : statements) {
                    s.addBatch(statement);
                }
                s.executeBatch();
            }
        }
    }

    private int executeUpdate(String query) throws SQLException {
        try (Statement s = this.connection.createStatement();){
            int n = s.executeUpdate(query);
            return n;
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public List<DexClass> getClasses(ApkEntry dex) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void addClasses(List<DexClass> allClasses) {
        try {
            HashMap<Apk, Multimap> map = new HashMap<Apk, Multimap>();
            for (DexClass dexClass : allClasses) {
                Multimap multimap = (Multimap)map.get(dexClass.dex.apk);
                if (multimap == null) {
                    multimap = HashMultimap.create();
                    map.put(dexClass.dex.apk, multimap);
                }
                multimap.put((Object)dexClass.dex, (Object)dexClass);
            }
            for (Map.Entry entry : map.entrySet()) {
                Multimap classes = (Multimap)entry.getValue();
                ArrayList<Integer> ids = new ArrayList<Integer>();
                for (ApkEntry dex : classes.keySet()) {
                    int id = this.addDexFile(dex.checksum, dex.name);
                    ids.add(id);
                    this.addClasses(id, classes.get((Object)dex));
                }
                this.addDexFiles(((Apk)entry.getKey()).checksum, ids);
            }
            this.flushOldCache();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Exception decompiling
     */
    private int addDexFile(long checksum, String name) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void addClasses(int dexId, Collection<DexClass> classes) throws SQLException {
        if (classes.isEmpty()) {
            return;
        }
        String values = classes.stream().map(e -> String.format("(%d, \"%s\", %d)", dexId, e.name, e.checksum)).collect(Collectors.joining(","));
        String insert = String.format("INSERT INTO classes (dexfileId, name, checksum) VALUES %s;", values);
        int updated = this.executeUpdate(insert);
        assert (updated == classes.size());
    }

    private void addDexFiles(String archiveChecksum, List<Integer> files) throws SQLException {
        if (files.isEmpty()) {
            return;
        }
        String values = files.stream().map(e -> String.format("(%d, \"%s\")", e, archiveChecksum)).collect(Collectors.joining(","));
        String insert = String.format("INSERT INTO archives (dexfileId, checksum) VALUES %s;", values);
        int updated = this.executeUpdate(insert);
        assert (updated == files.size());
    }

    @Override
    @VisibleForTesting
    public List<DexClass> dump() {
        ArrayList<DexClass> classes = new ArrayList<DexClass>();
        for (Apk apk : this.getApks()) {
            for (ApkEntry file : this.getFiles(apk)) {
                classes.addAll(this.getClasses(file));
            }
        }
        classes.sort(Comparator.comparingInt(a -> (int)a.checksum));
        return classes;
    }

    /*
     * Exception decompiling
     */
    private List<ApkEntry> getFiles(Apk apk) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private List<Apk> getApks() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

