/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.deployer;

import com.android.tools.deployer.DeployerException;
import com.android.tools.deployer.model.FileDiff;
import java.util.ArrayList;
import java.util.List;

class SwapVerifier {
    SwapVerifier() {
    }

    public List<FileDiff> verify(List<FileDiff> diffs, boolean allChanges) throws DeployerException {
        ArrayList<FileDiff> dexes = new ArrayList<FileDiff>();
        for (FileDiff diff : diffs) {
            if (!diff.status.equals((Object)FileDiff.Status.MODIFIED)) continue;
            String name = diff.oldFile.name;
            if (name.endsWith(".so")) {
                throw DeployerException.changedSharedObject(name);
            }
            if (name.equals("AndroidManifest.xml")) {
                throw DeployerException.changedManifest(name);
            }
            if (name.startsWith("META-INF/")) continue;
            if (name.endsWith(".dex")) {
                dexes.add(diff);
                continue;
            }
            if (allChanges) continue;
            throw DeployerException.changedResources(name);
        }
        return dexes;
    }
}

