/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.deployer;

import com.google.common.io.BaseEncoding;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;

public class ZipUtils {
    private static final int CENTRAL_DIRECTORY_FILE_HEADER_MAGIC = 33639248;
    private static final int CENTRAL_DIRECTORY_FILE_HEADER_SIZE = 46;
    private static final int LOCAL_DIRECTORY_FILE_HEADER_SIZE = 30;
    private static final String DIGEST_ALGORITHM = "SHA-1";

    public static HashMap<String, ZipEntry> readZipEntries(byte[] buf) {
        ByteBuffer buffer = ByteBuffer.wrap(buf);
        return ZipUtils.readZipEntries(buffer);
    }

    public static HashMap<String, ZipEntry> readZipEntries(ByteBuffer buf) {
        buf.order(ByteOrder.LITTLE_ENDIAN);
        HashMap<String, ZipEntry> entries = new HashMap<String, ZipEntry>();
        while (buf.remaining() >= 46 && buf.getInt() == 33639248) {
            short version = buf.getShort();
            short versionNeeded = buf.getShort();
            short flags = buf.getShort();
            short compression = buf.getShort();
            short modTime = buf.getShort();
            short modDate = buf.getShort();
            long crc = (long)buf.getInt() & 0xFFFFFFFFL;
            int compressedSize = buf.getInt();
            int decompressedSize = buf.getInt();
            short pathLength = buf.getShort();
            short extraLength = buf.getShort();
            short commentLength = buf.getShort();
            buf.position(buf.position() + 8);
            long start = buf.getInt();
            byte[] pathBytes = new byte[pathLength];
            buf.get(pathBytes);
            String name = new String(pathBytes, Charset.forName("UTF-8"));
            buf.position(buf.position() + extraLength + commentLength);
            byte[] localFileHeader = new byte[30 + pathBytes.length];
            ByteBuffer fakeEntry = ByteBuffer.wrap(localFileHeader).order(ByteOrder.LITTLE_ENDIAN);
            fakeEntry.putLong(start);
            fakeEntry.putShort(versionNeeded);
            fakeEntry.putShort(modTime);
            fakeEntry.putShort(modDate);
            fakeEntry.putInt((int)crc);
            fakeEntry.putInt(compression);
            fakeEntry.putInt(decompressedSize);
            fakeEntry.putShort((short)name.length());
            fakeEntry.putShort(extraLength);
            fakeEntry.put(pathBytes);
            long payloadStart = start + 30L + (long)pathLength + (long)extraLength;
            long payloadSize = compression == 0 ? (long)decompressedSize : (long)compressedSize;
            long end = payloadStart - 1L + payloadSize;
            ZipEntry entry = new ZipEntry(crc, name, start, end, payloadStart, extraLength, localFileHeader);
            entries.put(entry.name, entry);
        }
        return entries;
    }

    public static String digest(ByteBuffer buffer) {
        MessageDigest messageDigest;
        try {
            messageDigest = MessageDigest.getInstance(DIGEST_ALGORITHM);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("MessageDigest:SHA-1 unavailable.", e);
        }
        messageDigest.update(buffer);
        byte[] digestBytes = messageDigest.digest();
        return BaseEncoding.base16().lowerCase().encode(digestBytes);
    }

    public static class ZipEntry {
        public final long crc;
        public final String name;
        public final long start;
        public final long end;
        public final long payloadStart;
        public final int extraLength;
        public final byte[] localFileHeader;

        ZipEntry(long crc, String name, long start, long end, long payloadStart, int extraLength, byte[] localFileHeader) {
            this.crc = crc;
            this.name = name;
            this.start = start;
            this.end = end;
            this.payloadStart = payloadStart;
            this.extraLength = extraLength;
            this.localFileHeader = localFileHeader;
        }
    }
}

