/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.deployer.model;

import com.android.tools.deployer.ZipUtils;
import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.List;

public class Apk {
    public final String name;
    public final String checksum;
    public final String path;
    public final String packageName;
    public final List<String> targetPackages;
    public final HashMap<String, ZipUtils.ZipEntry> zipEntries;

    private Apk(String name, String checksum, String path2, String packageName, List<String> targetPackages, HashMap<String, ZipUtils.ZipEntry> zipEntries) {
        this.name = name;
        this.checksum = checksum;
        this.path = path2;
        this.packageName = packageName;
        this.targetPackages = targetPackages;
        this.zipEntries = zipEntries;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String name = "";
        private String checksum = "";
        private String path = "";
        private String packageName = "";
        private List<String> targetPackages = null;
        private HashMap<String, ZipUtils.ZipEntry> zipEntries = null;

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setChecksum(String checksum) {
            this.checksum = checksum;
            return this;
        }

        public Builder setPath(String path2) {
            this.path = path2;
            return this;
        }

        public Builder setPackageName(String packageName) {
            this.packageName = packageName;
            return this;
        }

        public Builder setTargetPackages(List<String> targetPackages) {
            this.targetPackages = targetPackages;
            return this;
        }

        public Builder setZipEntries(HashMap<String, ZipUtils.ZipEntry> zipEntries) {
            this.zipEntries = zipEntries;
            return this;
        }

        public Apk build() {
            this.targetPackages = this.targetPackages == null ? ImmutableList.of() : this.targetPackages;
            this.zipEntries = this.zipEntries == null ? new HashMap<String, ZipUtils.ZipEntry>() : this.zipEntries;
            return new Apk(this.name, this.checksum, this.path, this.packageName, this.targetPackages, this.zipEntries);
        }
    }
}

