/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.deployer.tasks;

import com.android.tools.deployer.DeployMetric;
import com.android.tools.deployer.DeployerException;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.SettableFuture;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Semaphore;
import java.util.stream.Collectors;

public class TaskRunner {
    private final ExecutorService executor;
    private final ArrayList<Task<?>> tasks;
    private final Semaphore running;

    public TaskRunner(ExecutorService executor) {
        this.executor = executor;
        this.tasks = new ArrayList();
        this.running = new Semaphore(1);
    }

    public <T> Task<T> create(T value) {
        Task<Object> task = new Task<Object>("", () -> value, new Task[0]);
        this.tasks.add(task);
        return task;
    }

    public <I, O, E extends Enum> Task<O> create(E id, ThrowingFunction<I, O> function, Task<I> input) {
        Callable<Object> callable = () -> function.apply(input.future.get());
        Task<Object> task = new Task<Object>(id.name(), callable, input);
        this.tasks.add(task);
        return task;
    }

    public <T, U, O, E extends Enum> Task<O> create(E id, ThrowingBiFunction<T, U, O> function, Task<T> input1, Task<U> input2) {
        Callable<Object> callable = () -> {
            Object value1 = input1.future.get();
            Object value2 = input2.future.get();
            return function.apply(value1, value2);
        };
        Task<Object> task = new Task<Object>(id.name(), callable, input1, input2);
        this.tasks.add(task);
        return task;
    }

    public <T, U, V, O, E extends Enum> Task<O> create(E id, ThrowingTriFunction<T, U, V, O> function, Task<T> input1, Task<U> input2, Task<V> input3) {
        Callable<Object> callable = () -> {
            Object value1 = input1.future.get();
            Object value2 = input2.future.get();
            Object value3 = input3.future.get();
            return function.apply(value1, value2, value3);
        };
        Task<Object> task = new Task<Object>(id.name(), callable, input1, input2, input3);
        this.tasks.add(task);
        return task;
    }

    private void runInternal(ArrayList<Task<?>> batch) throws DeployerException {
        for (Task<?> task : batch) {
            task.run(this.executor);
        }
        for (Task<?> task : batch) {
            task.get();
        }
    }

    public List<Task<?>> run() throws DeployerException {
        try {
            this.running.acquireUninterruptibly();
            ArrayList batch = new ArrayList(this.tasks);
            this.tasks.clear();
            this.runInternal(batch);
            ArrayList arrayList = batch;
            return arrayList;
        }
        finally {
            this.running.release();
        }
    }

    public void runAsync(Executor executor) {
        ArrayList batch = new ArrayList(this.tasks);
        this.tasks.clear();
        this.running.acquireUninterruptibly();
        executor.execute(() -> {
            try {
                this.runInternal(batch);
            }
            catch (DeployerException e) {
                throw new RuntimeException(e);
            }
            finally {
                this.running.release();
            }
        });
    }

    public void runAsync() {
        this.runAsync(this.executor);
    }

    public static interface ThrowingTriFunction<T, U, V, R> {
        public R apply(T var1, U var2, V var3) throws Exception;
    }

    public static interface ThrowingBiFunction<T, U, R> {
        public R apply(T var1, U var2) throws Exception;
    }

    public static interface ThrowingFunction<I, O> {
        public O apply(I var1) throws Exception;
    }

    public static class Task<T> {
        private final Callable<T> callable;
        private final Task<?>[] inputs;
        private final SettableFuture<T> future = SettableFuture.create();
        private DeployMetric metric;

        Task(String name, Callable<T> callable, Task<?> ... inputs) {
            this.inputs = inputs;
            this.callable = () -> {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            };
        }

        public T get() throws DeployerException {
            try {
                return (T)this.future.get();
            }
            catch (InterruptedException e) {
                throw DeployerException.interrupted(e.getMessage());
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof DeployerException) {
                    throw (DeployerException)e.getCause();
                }
                throw new IllegalStateException(e);
            }
        }

        public void run(Executor executor) {
            List futures = Arrays.stream(this.inputs).map(t -> t.future).collect(Collectors.toList());
            this.future.setFuture(Futures.whenAllComplete(futures).call(this.callable, executor));
        }

        public DeployMetric getMetric() {
            return this.metric;
        }
    }
}

