/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.ide.common.resources.configuration.LocaleQualifier;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceUrl;
import com.android.tools.lint.checks.ActionsXmlDetector;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.DefaultPosition;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Position;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.utils.DomExtensions;
import com.android.utils.XmlUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\fH\u0002J\u0018\u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\fH\u0002J\u0018\u0010\u0011\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\fH\u0002J&\u0010\u0013\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\f2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0002J6\u0010\u0018\u001a\u0004\u0018\u00010\u00172\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\f2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0002J\u0018\u0010\u001c\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\fH\u0002J\u0010\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\fH\u0002J\u0018\u0010\u001f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010 \u001a\u00020!H\u0016\u00a8\u0006#"}, d2={"Lcom/android/tools/lint/checks/ActionsXmlDetector;", "Lcom/android/tools/lint/detector/api/ResourceXmlDetector;", "()V", "appliesTo", "", "folderType", "Lcom/android/resources/ResourceFolderType;", "checkAction", "", "context", "Lcom/android/tools/lint/detector/api/XmlContext;", "action", "Lorg/w3c/dom/Element;", "checkActions", "actions", "checkEntitySetReference", "entitySetReference", "checkFulfillment", "fulfillment", "checkParameter", "parameter", "parameterNames", "", "", "checkParameterMapping", "parameterMapping", "intentParams", "urlParameters", "ensureRegisteredInManifest", "hasEntitySetReference", "templateRequiresParameters", "visitDocument", "document", "Lorg/w3c/dom/Document;", "Companion", "android.sdktools.lint-checks"})
public final class ActionsXmlDetector
extends ResourceXmlDetector {
    @JvmField
    @NotNull
    public static final Issue ISSUE;
    private static final String TAG_ACTIONS = "actions";
    private static final String TAG_ACTION = "action";
    private static final String TAG_ACTION_DISPLAY = "action-display";
    private static final String TAG_PARAMETER = "parameter";
    private static final String TAG_FULFILLMENT = "fulfillment";
    private static final String TAG_PARAMETER_MAPPING = "parameter-mapping";
    private static final String TAG_ENTITY_SET_REFERENCE = "entity-set-reference";
    private static final String ATTR_URL_TEMPLATE = "urlTemplate";
    private static final String ATTR_URL_FILTER = "urlFilter";
    private static final String ATTR_URL_PARAMETER = "urlParameter";
    private static final String ATTR_INTENT_PARAMETER = "intentParameter";
    private static final String ATTR_INTENT_NAME = "intentName";
    private static final String ATTR_RESOURCE = "resource";
    private static final String VAR_URL = "url";
    public static final Companion Companion;

    @Override
    public boolean appliesTo(@NotNull ResourceFolderType folderType) {
        return folderType == ResourceFolderType.XML;
    }

    @Override
    public void visitDocument(@NotNull XmlContext context2, @NotNull Document document) {
        Element element = document.getDocumentElement();
        if (element == null) {
            return;
        }
        Element root = element;
        if (Intrinsics.areEqual((Object)TAG_ACTIONS, (Object)root.getTagName()) ^ true) {
            if (Intrinsics.areEqual((Object)TAG_ACTION, (Object)root.getTagName())) {
                ActionsXmlDetector.Companion.wrongParent(context2, root, TAG_ACTIONS);
            }
            return;
        }
        Element element2 = document.getDocumentElement();
        if (element2 == null) {
            return;
        }
        this.checkActions(context2, element2);
        this.ensureRegisteredInManifest(context2, root);
    }

    private final void ensureRegisteredInManifest(XmlContext context2, Element actions) {
        if (context2.getProject().isLibrary()) {
            return;
        }
        Project mainProject = context2.getMainProject();
        Document document = mainProject.getMergedManifest();
        if (document == null) {
            return;
        }
        Document mergedManifest = document;
        Element element = mergedManifest.getDocumentElement();
        if (element == null) {
            return;
        }
        Element root = element;
        Element element2 = DomExtensions.subtag((Element)root, (String)"application");
        if (element2 == null) {
            return;
        }
        Element application = element2;
        String actionResourceName = Lint.getBaseName(context2.file.getName());
        Element metadata = DomExtensions.subtag((Element)application, (String)"meta-data");
        while (metadata != null) {
            String resource;
            ResourceUrl url;
            String name = metadata.getAttributeNS("http://schemas.android.com/apk/res/android", "name");
            if (Intrinsics.areEqual((Object)name, (Object)"com.google.android.actions") && (url = ResourceUrl.parse((String)(resource = metadata.getAttributeNS("http://schemas.android.com/apk/res/android", ATTR_RESOURCE)))) != null && Intrinsics.areEqual((Object)url.name, (Object)actionResourceName)) {
                return;
            }
            metadata = DomExtensions.next((Element)metadata, (String)"meta-data");
        }
        XmlContext.report$default(context2, ISSUE, actions, context2.getElementLocation(actions), "This action resource should be registered in the manifest under the `<application>` tag as `<meta-data android:name=\"com.google.android.actions\" " + "android:resource=\"@xml/" + actionResourceName + "\" />`", null, 16, null);
    }

    private final void checkActions(XmlContext context2, Element actions) {
        Iterator iterator = DomExtensions.iterator((Element)actions);
        while (iterator.hasNext()) {
            Element action = (Element)iterator.next();
            Boolean bl = ActionsXmlDetector.Companion.checkParent(context2, action);
            if (bl == null) {
                return;
            }
            bl.booleanValue();
            String tag = action.getTagName();
            if (!Intrinsics.areEqual((Object)tag, (Object)TAG_ACTION)) continue;
            this.checkAction(context2, action);
        }
        Attr localeNode = actions.getAttributeNode("supportedLocales");
        if (localeNode != null) {
            String locales = localeNode.getValue();
            int index = 0;
            Iterable $this$forEach$iv = StringsKt.split$default((CharSequence)locales, (String[])new String[]{","}, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String locale = (String)element$iv;
                boolean bl = false;
                Object object = locale;
                StringBuilder stringBuilder = new StringBuilder().append("b+");
                boolean bl2 = false;
                String string = object;
                if (string == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                String string2 = ((Object)StringsKt.trim((CharSequence)string)).toString();
                String bcp = stringBuilder.append(StringsKt.replace$default((String)string2, (String)"-", (String)"+", (boolean)false, (int)4, null)).toString();
                if (LocaleQualifier.getQualifier((String)bcp) == null) {
                    object = this;
                    bl2 = false;
                    boolean bl3 = false;
                    ActionsXmlDetector $receiver = (ActionsXmlDetector)object;
                    boolean bl4 = false;
                    Location loc = context2.getValueLocation(localeNode);
                    Position position = loc.getStart();
                    if (position == null) {
                        return;
                    }
                    Position start = position;
                    start = new DefaultPosition(start.getLine(), start.getColumn() + index, start.getOffset() + index);
                    DefaultPosition end = new DefaultPosition(start.getLine(), start.getColumn() + locale.length(), start.getOffset() + locale.length());
                    Location location = Location.Companion.create(context2.file, start, end);
                    XmlContext.report$default(context2, ISSUE, actions, location, "Invalid BCP-47 locale qualifier `" + locale + '`', null, 16, null);
                    return;
                }
                index += locale.length() + 1;
            }
        }
    }

    private final void checkAction(XmlContext context2, Element action) {
        Boolean bl = ActionsXmlDetector.Companion.checkParent(context2, action);
        if (bl == null) {
            return;
        }
        bl.booleanValue();
        if (com.android.tools.lint.checks.ActionsXmlDetector$Companion.checkRequiredAttribute$default(Companion, context2, action, ATTR_INTENT_NAME, false, false, 24, null) == null) {
            return;
        }
        boolean atLeastOneFulfillment = false;
        boolean atLeastOneEntitySetReference = false;
        Set parameterNames = null;
        boolean foundNonRequiredTemplate = false;
        Iterator iterator = DomExtensions.iterator((Element)action);
        while (iterator.hasNext()) {
            String string;
            Element child = (Element)iterator.next();
            String tag = child.getTagName();
            if (Intrinsics.areEqual((Object)tag, (Object)TAG_ACTION)) {
                ActionsXmlDetector.Companion.nestingNotAllowed(context2, child);
                return;
            }
            Boolean bl2 = ActionsXmlDetector.Companion.checkParent(context2, child);
            if (bl2 == null) {
                return;
            }
            bl2.booleanValue();
            if (tag == null) continue;
            int n = -1;
            switch (string.hashCode()) {
                case 1954460585: {
                    if (!string.equals(TAG_PARAMETER)) break;
                    n = 1;
                    break;
                }
                case 1512395230: {
                    if (!string.equals(TAG_FULFILLMENT)) break;
                    n = 2;
                    break;
                }
            }
            switch (n) {
                case 1: {
                    boolean hasEntitySetReference;
                    if (parameterNames == null) {
                        boolean bl3 = false;
                        parameterNames = new LinkedHashSet();
                    }
                    if (!(hasEntitySetReference = this.checkParameter(context2, child, parameterNames))) break;
                    atLeastOneEntitySetReference = true;
                    break;
                }
                case 2: {
                    this.checkFulfillment(context2, child);
                    atLeastOneFulfillment = true;
                    if (this.templateRequiresParameters(child)) break;
                    foundNonRequiredTemplate = true;
                }
            }
        }
        if (!atLeastOneFulfillment) {
            if (!atLeastOneEntitySetReference) {
                XmlContext.report$default(context2, ISSUE, action, context2.getElementLocation(action), "`<action>` must declare a `<fulfillment>` or a `<parameter>` with an `<entity-set-reference>`", null, 16, null);
            }
        } else if (!foundNonRequiredTemplate) {
            XmlContext.report$default(context2, ISSUE, action, context2.getElementLocation(action), "At least one <fulfillment> `urlTemplate` must not be required", null, 16, null);
        }
    }

    private final boolean templateRequiresParameters(Element fulfillment) {
        Iterator iterator = DomExtensions.iterator((Element)fulfillment);
        while (iterator.hasNext()) {
            String required;
            Element child = (Element)iterator.next();
            if (!Intrinsics.areEqual((Object)child.getTagName(), (Object)TAG_PARAMETER_MAPPING) || !Intrinsics.areEqual((Object)(required = child.getAttribute("required")), (Object)"true")) continue;
            return true;
        }
        return false;
    }

    private final boolean checkParameter(XmlContext context2, Element parameter, Set<String> parameterNames) {
        Boolean bl = ActionsXmlDetector.Companion.checkParent(context2, parameter);
        if (bl == null) {
            return false;
        }
        bl.booleanValue();
        if (com.android.tools.lint.checks.ActionsXmlDetector$Companion.checkRequiredAttribute$default(Companion, context2, parameter, "name", false, false, 24, null) == null) {
            return false;
        }
        String string = com.android.tools.lint.checks.ActionsXmlDetector$Companion.checkRequiredAttribute$default(Companion, context2, parameter, "name", false, false, 24, null);
        if (string == null) {
            return false;
        }
        String name = string;
        ActionsXmlDetector.Companion.checkNotAlreadyPresent(name, "name", parameterNames, context2, parameter, TAG_ACTION, TAG_PARAMETER);
        boolean hasEntitySetReference = false;
        Iterator iterator = DomExtensions.iterator((Element)parameter);
        while (iterator.hasNext()) {
            Element child = (Element)iterator.next();
            String tag = child.getTagName();
            if (Intrinsics.areEqual((Object)tag, (Object)TAG_PARAMETER)) {
                ActionsXmlDetector.Companion.nestingNotAllowed(context2, child);
                return false;
            }
            Boolean bl2 = ActionsXmlDetector.Companion.checkParent(context2, child);
            if (bl2 == null) {
                return false;
            }
            bl2.booleanValue();
            if (!Intrinsics.areEqual((Object)tag, (Object)TAG_ENTITY_SET_REFERENCE)) continue;
            this.checkEntitySetReference(context2, child);
            hasEntitySetReference = true;
        }
        return hasEntitySetReference;
    }

    private final void checkEntitySetReference(XmlContext context2, Element entitySetReference) {
        if (com.android.tools.lint.checks.ActionsXmlDetector$Companion.checkRequiredAttribute$default(Companion, context2, entitySetReference, ATTR_URL_FILTER, false, false, 24, null) == null) {
            return;
        }
    }

    private final void checkFulfillment(XmlContext context2, Element fulfillment) {
        Boolean bl = ActionsXmlDetector.Companion.checkParent(context2, fulfillment);
        if (bl == null) {
            return;
        }
        bl.booleanValue();
        String string = com.android.tools.lint.checks.ActionsXmlDetector$Companion.checkRequiredAttribute$default(Companion, context2, fulfillment, ATTR_URL_TEMPLATE, false, false, 8, null);
        if (string == null) {
            return;
        }
        String urlTemplate = string;
        Set<String> templateParameters = Companion.getUriTemplateParameters(urlTemplate);
        boolean bl2 = false;
        Set intentParameterNames = new LinkedHashSet();
        boolean bl3 = false;
        Set urlParameters = new LinkedHashSet();
        Object object = DomExtensions.iterator((Element)fulfillment);
        while (object.hasNext()) {
            String string2;
            Element child = (Element)object.next();
            String tag = child.getTagName();
            if (Intrinsics.areEqual((Object)tag, (Object)TAG_FULFILLMENT)) {
                ActionsXmlDetector.Companion.nestingNotAllowed(context2, child);
                return;
            }
            Boolean bl4 = ActionsXmlDetector.Companion.checkParent(context2, child);
            if (bl4 == null) {
                return;
            }
            bl4.booleanValue();
            if (tag == null) continue;
            switch (string2.hashCode()) {
                case 1170863786: {
                    String parameter;
                    if (!string2.equals(TAG_PARAMETER_MAPPING) || (parameter = this.checkParameterMapping(context2, child, intentParameterNames, urlParameters)) == null || templateParameters.contains(parameter) || StringsKt.startsWith$default((String)parameter, (String)"@", (boolean)false, (int)2, null) || !(Intrinsics.areEqual((Object)parameter, (Object)VAR_URL) ^ true)) break;
                    XmlContext.report$default(context2, ISSUE, child, context2.getElementLocation(child), "The parameter `" + parameter + "` is not present in the `urlTemplate`", null, 16, null);
                }
            }
        }
        if (templateParameters.contains(VAR_URL) && !urlParameters.contains(VAR_URL)) {
            Node node = fulfillment.getParentNode();
            if (node == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.w3c.dom.Element");
            }
            if (this.hasEntitySetReference((Element)node)) {
                urlParameters.add(VAR_URL);
            }
        }
        Sets.SetView missing = Sets.difference(templateParameters, (Set)urlParameters);
        object = (Collection)missing;
        boolean tag = false;
        if (!object.isEmpty()) {
            Location attributeLocation = context2.getValueLocation(fulfillment.getAttributeNode(ATTR_URL_TEMPLATE));
            String message2 = missing.size() == 1 ? "The parameter " + (String)CollectionsKt.first((Iterable)((Iterable)missing)) + " is not defined as a `<parameter-mapping>` element below" : "The parameters " + CollectionsKt.joinToString$default((Iterable)((Iterable)missing), (CharSequence)" and ", null, null, (int)0, null, (Function1)checkFulfillment.message.1.INSTANCE, (int)30, null) + " are not defined as `<parameter-mapping>` elements below";
            XmlContext.report$default(context2, ISSUE, fulfillment, attributeLocation, message2, null, 16, null);
        }
    }

    private final boolean hasEntitySetReference(Element action) {
        boolean bl = Intrinsics.areEqual((Object)action.getTagName(), (Object)TAG_ACTION);
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        Iterator iterator = DomExtensions.iterator((Element)action);
        while (iterator.hasNext()) {
            Element parameter = (Element)iterator.next();
            if (!Intrinsics.areEqual((Object)parameter.getTagName(), (Object)TAG_PARAMETER) || DomExtensions.subtag((Element)parameter, (String)TAG_ENTITY_SET_REFERENCE) == null) continue;
            return true;
        }
        return false;
    }

    private final String checkParameterMapping(XmlContext context2, Element parameterMapping, Set<String> intentParams, Set<String> urlParameters) {
        String string = com.android.tools.lint.checks.ActionsXmlDetector$Companion.checkRequiredAttribute$default(Companion, context2, parameterMapping, ATTR_INTENT_PARAMETER, false, false, 8, null);
        if (string == null) {
            return null;
        }
        String intentParameter = string;
        Boolean bl = ActionsXmlDetector.Companion.checkParent(context2, parameterMapping);
        if (bl == null) {
            return null;
        }
        bl.booleanValue();
        String string2 = com.android.tools.lint.checks.ActionsXmlDetector$Companion.checkRequiredAttribute$default(Companion, context2, parameterMapping, ATTR_URL_PARAMETER, false, false, 8, null);
        if (string2 == null) {
            return null;
        }
        String urlParameter = string2;
        urlParameters.add(urlParameter);
        Boolean bl2 = ActionsXmlDetector.Companion.checkNotAlreadyPresent(intentParameter, ATTR_INTENT_PARAMETER, intentParams, context2, parameterMapping, TAG_FULFILLMENT, TAG_PARAMETER_MAPPING);
        if (bl2 == null) {
            return null;
        }
        bl2.booleanValue();
        return urlParameter;
    }

    static {
        Companion = new Companion(null);
        Collection collection = null;
        EnumSet enumSet = null;
        Boolean bl = null;
        boolean bl2 = false;
        Implementation implementation = new Implementation(ActionsXmlDetector.class, Scope.RESOURCE_FILE_SCOPE);
        Severity severity = Severity.FATAL;
        int n = 5;
        String string = null;
        Category category = Category.CORRECTNESS;
        ISSUE = Issue.Companion.create$default(Issue.Companion, "ValidActionsXml", "Invalid Action Descriptor", "Ensures that an actions XML file is properly formed", implementation, string, category, n, severity, bl2, bl, enumSet, collection, 3600, null);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\"\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00040\u00172\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001aH\u0002JO\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u001f\u001a\u00020\u00042\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00040\u00172\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u00042\u0006\u0010&\u001a\u00020\u0004H\u0002\u00a2\u0006\u0002\u0010'J\u001f\u0010(\u001a\u0004\u0018\u00010\u001d2\u0006\u0010!\u001a\u00020\"2\u0006\u0010)\u001a\u00020$H\u0002\u00a2\u0006\u0002\u0010*J6\u0010+\u001a\u0004\u0018\u00010\u00042\u0006\u0010!\u001a\u00020\"2\u0006\u0010)\u001a\u00020$2\u0006\u0010,\u001a\u00020\u00042\b\b\u0002\u0010-\u001a\u00020\u001d2\b\b\u0002\u0010.\u001a\u00020\u001dH\u0002J\u0016\u0010/\u001a\b\u0012\u0004\u0012\u00020\u0004002\u0006\u00101\u001a\u00020\u0004H\u0007J\u0018\u00102\u001a\u00020\u00152\u0006\u0010!\u001a\u00020\"2\u0006\u0010)\u001a\u00020$H\u0002J \u00103\u001a\u00020\u00152\u0006\u0010!\u001a\u00020\"2\u0006\u0010)\u001a\u00020$2\u0006\u00104\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u00020\u000b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lcom/android/tools/lint/checks/ActionsXmlDetector$Companion;", "", "()V", "ATTR_INTENT_NAME", "", "ATTR_INTENT_PARAMETER", "ATTR_RESOURCE", "ATTR_URL_FILTER", "ATTR_URL_PARAMETER", "ATTR_URL_TEMPLATE", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "TAG_ACTION", "TAG_ACTIONS", "TAG_ACTION_DISPLAY", "TAG_ENTITY_SET_REFERENCE", "TAG_FULFILLMENT", "TAG_PARAMETER", "TAG_PARAMETER_MAPPING", "VAR_URL", "addVariables", "", "variables", "", "s", "from", "", "to", "checkNotAlreadyPresent", "", "name", "nameAttribute", "parameterNames", "context", "Lcom/android/tools/lint/detector/api/XmlContext;", "parameter", "Lorg/w3c/dom/Element;", "parentTag", "nameTag", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/Set;Lcom/android/tools/lint/detector/api/XmlContext;Lorg/w3c/dom/Element;Ljava/lang/String;Ljava/lang/String;)Ljava/lang/Boolean;", "checkParent", "element", "(Lcom/android/tools/lint/detector/api/XmlContext;Lorg/w3c/dom/Element;)Ljava/lang/Boolean;", "checkRequiredAttribute", "attribute", "allowBlank", "allowReference", "getUriTemplateParameters", "", "urlTemplate", "nestingNotAllowed", "wrongParent", "expected", "android.sdktools.lint-checks"})
    public static final class Companion {
        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final Boolean checkParent(XmlContext context2, Element element) {
            String string;
            String tag;
            String string2 = tag = element.getTagName();
            if (string2 == null) return true;
            switch (string2) {
                case "action": {
                    string = ActionsXmlDetector.TAG_ACTIONS;
                    break;
                }
                case "action-display": {
                    string = ActionsXmlDetector.TAG_ACTION;
                    break;
                }
                case "parameter": 
                case "fulfillment": {
                    string = ActionsXmlDetector.TAG_ACTION;
                    break;
                }
                case "parameter-mapping": {
                    string = ActionsXmlDetector.TAG_FULFILLMENT;
                    break;
                }
                case "entity-set-reference": {
                    string = ActionsXmlDetector.TAG_PARAMETER;
                    break;
                }
                default: {
                    return true;
                }
            }
            String expectedParent = string;
            Object object = element.getParentNode();
            if (object == null || (object = object.getNodeName()) == null) {
                return true;
            }
            Object actualParent = object;
            if (Intrinsics.areEqual((Object)expectedParent, (Object)actualParent) ^ true) {
                this.wrongParent(context2, element, expectedParent);
                return null;
            }
            if (!Intrinsics.areEqual((Object)tag, (Object)actualParent)) return true;
            this.nestingNotAllowed(context2, element);
            return null;
        }

        private final void wrongParent(XmlContext context2, Element element, String expected) {
            XmlContext.report$default(context2, ISSUE, element, context2.getNameLocation(element), "`<" + element.getTagName() + ">` must be inside `<" + expected + ">`", null, 16, null);
        }

        private final void nestingNotAllowed(XmlContext context2, Element element) {
            XmlContext.report$default(context2, ISSUE, element, context2.getNameLocation(element), "Nesting `<" + element.getTagName() + ">` is not allowed", null, 16, null);
        }

        private final Boolean checkNotAlreadyPresent(String name, String nameAttribute, Set<String> parameterNames, XmlContext context2, Element parameter, String parentTag, String nameTag) {
            boolean duplicate;
            if (name == null) {
                return true;
            }
            boolean bl = duplicate = !parameterNames.add(name);
            if (duplicate) {
                Location location = context2.getLocation(parameter.getAttributeNode(nameAttribute));
                Element prev = XmlUtils.getPreviousTagByName((Node)parameter, (String)parameter.getTagName());
                while (prev != null) {
                    Attr attr;
                    Attr attr2 = attr = prev.getAttributeNode(nameAttribute);
                    if (Intrinsics.areEqual((Object)(attr2 != null ? attr2.getValue() : null), (Object)name)) {
                        location.setSecondary(context2.getLocation(attr));
                        break;
                    }
                    prev = XmlUtils.getPreviousTagByName((Node)prev, (String)parameter.getTagName());
                }
                XmlContext.report$default(context2, ISSUE, parameter, location, "`<" + parentTag + ">` contains two `<" + nameTag + ">` elements with the same " + nameAttribute + ", `" + name + '`', null, 16, null);
                return null;
            }
            return true;
        }

        private final String checkRequiredAttribute(XmlContext context2, Element element, String attribute, boolean allowBlank, boolean allowReference) {
            String value = element.getAttribute(attribute);
            if (value != null && (allowBlank || !StringsKt.isBlank((CharSequence)value))) {
                if (!allowReference && StringsKt.startsWith$default((String)value, (String)"@", (boolean)false, (int)2, null)) {
                    XmlContext.report$default(context2, ISSUE, element, context2.getLocation(element.getAttributeNode(attribute)), '`' + attribute + "` must be a value, not a reference", null, 16, null);
                }
                return value;
            }
            LintFix fix = LintFix.create().set().todo(null, attribute).build();
            context2.report(ISSUE, (Node)element, context2.getElementLocation(element), "Missing required attribute `" + attribute + '`', fix);
            return null;
        }

        static /* synthetic */ String checkRequiredAttribute$default(Companion companion, XmlContext xmlContext, Element element, String string, boolean bl, boolean bl2, int n, Object object) {
            if ((n & 8) != 0) {
                bl = false;
            }
            if ((n & 0x10) != 0) {
                bl2 = true;
            }
            return companion.checkRequiredAttribute(xmlContext, element, string, bl, bl2);
        }

        /*
         * WARNING - void declaration
         */
        @VisibleForTesting
        @NotNull
        public final Set<String> getUriTemplateParameters(@NotNull String urlTemplate) {
            int length = urlTemplate.length();
            int n = 0;
            Set variables = new LinkedHashSet();
            n = 0;
            int n2 = length;
            while (n < n2) {
                int end;
                void begin;
                char c = urlTemplate.charAt((int)begin);
                if (c == '{' && (end = StringsKt.indexOf$default((CharSequence)urlTemplate, (char)'}', (int)(begin + true), (boolean)false, (int)4, null)) != -1) {
                    this.addVariables(variables, urlTemplate, (int)begin, end + 1);
                }
                ++begin;
            }
            return variables;
        }

        private final void addVariables(Set<String> variables, String s, int from, int to) {
            boolean bl;
            if (from > to - 2) {
                return;
            }
            char operator = s.charAt(from + 1);
            switch (operator) {
                case '#': 
                case '+': {
                    bl = true;
                    break;
                }
                case '&': 
                case '.': 
                case '/': 
                case ';': 
                case '?': {
                    bl = true;
                    break;
                }
                case '!': 
                case ',': 
                case '=': 
                case '@': 
                case '|': {
                    bl = true;
                    break;
                }
                default: {
                    bl = false;
                }
            }
            boolean hasOperator = bl;
            int offset = from + (hasOperator ? 2 : 1);
            while (offset < to) {
                int beginVarSpec;
                int endVarSpec;
                int variableEnd = -1;
                for (endVarSpec = beginVarSpec = offset; endVarSpec < to; ++endVarSpec) {
                    char c = s.charAt(endVarSpec);
                    if (c == ',' || c == '}') {
                        if (variableEnd != -1) break;
                        variableEnd = endVarSpec;
                        break;
                    }
                    if (c != ':' && c != '*') continue;
                    variableEnd = endVarSpec;
                }
                if (variableEnd > beginVarSpec) {
                    String variable;
                    String string = s;
                    boolean bl2 = false;
                    String string2 = string;
                    if (string2 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2.substring(beginVarSpec, variableEnd), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    variables.add(variable);
                }
                offset = endVarSpec + 1;
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

