/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.repository.api.LocalPackage;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.lint.checks.Api;
import com.android.tools.lint.checks.ApiClass;
import com.android.tools.lint.checks.ApiDatabase;
import com.android.tools.lint.checks.ApiMember;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.detector.api.Lint;
import com.android.utils.Pair;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ApiLookup
extends ApiDatabase {
    public static final String XML_FILE_PATH = "api-versions.xml";
    public static final int SDK_DATABASE_MIN_VERSION = 26;
    private static final int API_LOOKUP_BINARY_FORMAT_VERSION = 0;
    private static final int CLASS_HEADER_MEMBER_OFFSETS = 1;
    private static final int CLASS_HEADER_API = 2;
    private static final int CLASS_HEADER_DEPRECATED = 3;
    private static final int CLASS_HEADER_REMOVED = 4;
    private static final int CLASS_HEADER_INTERFACES = 5;
    @VisibleForTesting
    static final boolean DEBUG_FORCE_REGENERATE_BINARY = false;
    private final Api<ApiClass> mInfo;
    private static final Map<AndroidVersion, WeakReference<ApiLookup>> instances = new HashMap<AndroidVersion, WeakReference<ApiLookup>>();
    private final IAndroidTarget target;

    public static ApiLookup get(LintClient client) {
        return ApiLookup.get(client, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ApiLookup get(LintClient client, IAndroidTarget target) {
        Class<ApiLookup> clazz = ApiLookup.class;
        synchronized (ApiLookup.class) {
            ApiLookup db;
            AndroidVersion version = target != null ? target.getVersion() : AndroidVersion.DEFAULT;
            WeakReference<ApiLookup> reference = instances.get(version);
            ApiLookup apiLookup = db = reference != null ? (ApiLookup)reference.get() : null;
            if (db == null) {
                String env = System.getProperty("LINT_API_DATABASE");
                File file = null;
                if (env != null) {
                    file = new File(env);
                    if (!file.exists()) {
                        file = null;
                    }
                } else {
                    if (target != null && version.getFeatureLevel() >= 26 && !(file = new File(target.getFile(7), XML_FILE_PATH)).isFile()) {
                        file = null;
                    }
                    if (file == null) {
                        target = null;
                        file = client.findResource(XML_FILE_PATH);
                    }
                }
                if (file == null) {
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return null;
                }
                db = ApiLookup.get(client, file, target);
                instances.put(version, new WeakReference<ApiLookup>(db));
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return db;
        }
    }

    public IAndroidTarget getTarget() {
        return this.target;
    }

    @VisibleForTesting
    static String getPlatformVersion(LintClient client) {
        LocalPackage pkgInfo;
        AndroidSdkHandler sdk = client.getSdk();
        if (sdk != null && (pkgInfo = sdk.getLocalPackage("platform-tools", client.getRepositoryLogger())) != null) {
            return pkgInfo.getVersion().toShortString();
        }
        return null;
    }

    @VisibleForTesting
    static String getCacheFileName(String xmlFileName, String platformVersion) {
        if (Lint.endsWith(xmlFileName, ".xml")) {
            xmlFileName = xmlFileName.substring(0, xmlFileName.length() - ".xml".length());
        }
        StringBuilder sb = new StringBuilder(100);
        sb.append(xmlFileName);
        sb.append('-').append(ApiLookup.getBinaryFormatVersion(0));
        if (platformVersion != null) {
            sb.append('-').append(platformVersion.replace(' ', '_'));
        }
        sb.append(".bin");
        return sb.toString();
    }

    private static ApiLookup get(LintClient client, File xmlFile, IAndroidTarget target) {
        if (!xmlFile.exists()) {
            client.log(null, "The API database file %1$s does not exist", xmlFile);
            return null;
        }
        File cacheDir = client.getCacheDir(null, true);
        if (cacheDir == null) {
            cacheDir = xmlFile.getParentFile();
        }
        String platformVersion = ApiLookup.getPlatformVersion(client);
        File binaryData = new File(cacheDir, ApiLookup.getCacheFileName(xmlFile.getName(), platformVersion));
        if (!(binaryData.exists() && binaryData.lastModified() >= xmlFile.lastModified() && binaryData.length() != 0L || ApiLookup.cacheCreator(xmlFile).create(client, binaryData))) {
            return null;
        }
        if (!binaryData.exists()) {
            client.log(null, "The API database file %1$s does not exist", binaryData);
            return null;
        }
        return new ApiLookup(client, xmlFile, binaryData, null, target);
    }

    private static ApiDatabase.CacheCreator cacheCreator(File xmlFile) {
        return (client, binaryData) -> {
            Api<ApiClass> info;
            long begin = 0L;
            try {
                info = Api.parseApi(xmlFile);
            }
            catch (RuntimeException e) {
                client.log(e, "Can't read API file " + xmlFile.getAbsolutePath(), new Object[0]);
                return false;
            }
            try {
                ApiLookup.writeDatabase(binaryData, info, 0);
                return true;
            }
            catch (IOException e) {
                client.log(e, "Can't write API cache file", new Object[0]);
                return false;
            }
        };
    }

    private ApiLookup(LintClient client, File xmlFile, File binaryFile, Api<ApiClass> info, IAndroidTarget target) {
        this.mInfo = info;
        this.target = target;
        if (binaryFile != null) {
            this.readData(client, binaryFile, ApiLookup.cacheCreator(xmlFile), 0);
        }
    }

    public int getClassVersion(String className) {
        ApiClass cls;
        if (this.mData != null) {
            return this.getClassVersion(this.findClass(className));
        }
        if (this.mInfo != null && (cls = this.mInfo.getClass(className)) != null) {
            return cls.getSince();
        }
        return -1;
    }

    private int getClassVersion(int classNumber) {
        if (classNumber >= 0) {
            int offset = this.seekClassData(classNumber, 2);
            int api = Byte.toUnsignedInt(this.mData[offset]) & 0xFFFFFF7F;
            return api > 0 ? api : -1;
        }
        return -1;
    }

    public int getValidCastVersion(String sourceClass, String destinationClass) {
        ApiClass cls;
        if (this.mData != null) {
            int interfaceNumber;
            int classNumber = this.findClass(sourceClass);
            if (classNumber >= 0 && (interfaceNumber = this.findClass(destinationClass)) >= 0) {
                int offset = this.seekClassData(classNumber, 5);
                int interfaceCount = this.mData[offset++];
                for (int i = 0; i < interfaceCount; ++i) {
                    int clsNumber = ApiLookup.get3ByteInt(this.mData, offset);
                    offset += 3;
                    byte api = this.mData[offset++];
                    if (clsNumber != interfaceNumber) continue;
                    return api;
                }
                return this.getClassVersion(classNumber);
            }
        } else if (this.mInfo != null && (cls = this.mInfo.getClass(sourceClass)) != null) {
            List<Pair<String, Integer>> interfaces = cls.getInterfaces();
            for (Pair<String, Integer> pair : interfaces) {
                String interfaceName = (String)pair.getFirst();
                if (!interfaceName.equals(destinationClass)) continue;
                return (Integer)pair.getSecond();
            }
        }
        return -1;
    }

    public int getClassDeprecatedIn(String className) {
        ApiClass cls;
        if (this.mData != null) {
            int classNumber = this.findClass(className);
            if (classNumber >= 0) {
                int offset = this.seekClassData(classNumber, 3);
                if (offset < 0) {
                    return -1;
                }
                int deprecatedIn = Byte.toUnsignedInt(this.mData[offset]) & 0xFFFFFF7F;
                return deprecatedIn != 0 ? deprecatedIn : -1;
            }
        } else if (this.mInfo != null && (cls = this.mInfo.getClass(className)) != null) {
            int deprecatedIn = cls.getDeprecatedIn();
            return deprecatedIn != 0 ? deprecatedIn : -1;
        }
        return -1;
    }

    public int getClassRemovedIn(String className) {
        ApiClass cls;
        if (this.mData != null) {
            int classNumber = this.findClass(className);
            if (classNumber >= 0) {
                int offset = this.seekClassData(classNumber, 4);
                if (offset < 0) {
                    return -1;
                }
                int removedIn = Byte.toUnsignedInt(this.mData[offset]) & 0xFFFFFF7F;
                return removedIn != 0 ? removedIn : -1;
            }
        } else if (this.mInfo != null && (cls = this.mInfo.getClass(className)) != null) {
            int removedIn = cls.getRemovedIn();
            return removedIn != 0 ? removedIn : -1;
        }
        return -1;
    }

    public boolean containsClass(String className) {
        if (this.mData != null) {
            return this.findClass(className) >= 0;
        }
        if (this.mInfo != null) {
            return this.mInfo.getClass(className) != null;
        }
        return false;
    }

    public int getMethodVersion(String owner, String name, String desc) {
        ApiClass cls;
        if (this.mData != null) {
            int classNumber = this.findClass(owner);
            if (classNumber >= 0) {
                int api = this.findMember(classNumber, name, desc);
                if (api < 0) {
                    return -1;
                }
                return api;
            }
        } else if (this.mInfo != null && (cls = this.mInfo.getClass(owner)) != null) {
            String signature = name + desc;
            int since = cls.getMethod(signature, this.mInfo);
            if (since == 0) {
                since = -1;
            }
            return since;
        }
        return -1;
    }

    public int getMethodDeprecatedIn(String owner, String name, String desc) {
        ApiClass cls;
        if (this.mData != null) {
            int classNumber = this.findClass(owner);
            if (classNumber >= 0) {
                int deprecatedIn = this.findMemberDeprecatedIn(classNumber, name, desc);
                return deprecatedIn == 0 ? -1 : deprecatedIn;
            }
        } else if (this.mInfo != null && (cls = this.mInfo.getClass(owner)) != null) {
            String signature = name + desc;
            int deprecatedIn = cls.getMemberDeprecatedIn(signature, this.mInfo);
            return deprecatedIn == 0 ? -1 : deprecatedIn;
        }
        return -1;
    }

    public int getMethodRemovedIn(String owner, String name, String desc) {
        ApiClass cls;
        if (this.mData != null) {
            int classNumber = this.findClass(owner);
            if (classNumber >= 0) {
                int removedIn = this.findMemberRemovedIn(classNumber, name, desc);
                return removedIn == 0 ? -1 : removedIn;
            }
        } else if (this.mInfo != null && (cls = this.mInfo.getClass(owner)) != null) {
            String signature = name + desc;
            int removedIn = cls.getMemberRemovedIn(signature, this.mInfo);
            return removedIn == 0 ? -1 : removedIn;
        }
        return -1;
    }

    public Collection<ApiMember> getRemovedFields(String owner) {
        ApiClass cls;
        if (this.mData != null) {
            int classNumber = this.findClass(owner);
            if (classNumber >= 0) {
                return this.getRemovedMembers(classNumber, false);
            }
        } else if (this.mInfo != null && (cls = this.mInfo.getClass(owner)) != null) {
            return cls.getAllRemovedFields(this.mInfo);
        }
        return null;
    }

    public Collection<ApiMember> getRemovedMethods(String owner) {
        ApiClass cls;
        if (this.mData != null) {
            int classNumber = this.findClass(owner);
            if (classNumber >= 0) {
                return this.getRemovedMembers(classNumber, true);
            }
        } else if (this.mInfo != null && (cls = this.mInfo.getClass(owner)) != null) {
            return cls.getAllRemovedMethods(this.mInfo);
        }
        return null;
    }

    private Collection<ApiMember> getRemovedMembers(int classNumber, boolean methods) {
        int curr = this.seekClassData(classNumber, 1);
        int start = ApiLookup.get3ByteInt(this.mData, curr);
        int length = ApiLookup.get2ByteInt(this.mData, curr += 3);
        if (length == 0) {
            return Collections.emptyList();
        }
        ArrayList<ApiMember> result = null;
        int end = start + length;
        for (int index = start; index < end; ++index) {
            int deprecatedIn;
            int since;
            byte b;
            int i;
            int offset = this.mIndices[index];
            boolean methodSignatureDetected = false;
            for (i = offset; i < this.mData.length && (b = this.mData[i]) != 0; ++i) {
                if (b != 40) continue;
                methodSignatureDetected = true;
            }
            if (i >= this.mData.length) {
                assert (false);
                break;
            }
            if (methodSignatureDetected != methods) continue;
            int endOfSignature = i++;
            if (((since = Byte.toUnsignedInt(this.mData[i++])) & 0x80) == 0 || ((deprecatedIn = Byte.toUnsignedInt(this.mData[i++])) & 0x80) == 0) continue;
            int removedIn = Byte.toUnsignedInt(this.mData[i]);
            if (removedIn != 0) {
                StringBuilder sb = new StringBuilder(endOfSignature - offset);
                for (i = offset; i < endOfSignature; ++i) {
                    sb.append((char)Byte.toUnsignedInt(this.mData[i]));
                }
                since &= 0xFFFFFF7F;
                deprecatedIn &= 0xFFFFFF7F;
                if (result == null) {
                    result = new ArrayList<ApiMember>();
                }
                result.add(new ApiMember(sb.toString(), since, deprecatedIn, removedIn));
                continue;
            }
            assert (false);
        }
        return result == null ? Collections.emptyList() : result;
    }

    public int getFieldVersion(String owner, String name) {
        ApiClass cls;
        if (this.mData != null) {
            int classNumber = this.findClass(owner);
            if (classNumber >= 0) {
                int api = this.findMember(classNumber, name, null);
                if (api < 0) {
                    return -1;
                }
                return api;
            }
        } else if (this.mInfo != null && (cls = this.mInfo.getClass(owner)) != null) {
            int since = cls.getField(name, this.mInfo);
            if (since == 0) {
                since = -1;
            }
            return since;
        }
        return -1;
    }

    public int getFieldDeprecatedIn(String owner, String name) {
        ApiClass cls;
        if (this.mData != null) {
            int classNumber = this.findClass(owner);
            if (classNumber >= 0) {
                int deprecatedIn = this.findMemberDeprecatedIn(classNumber, name, null);
                return deprecatedIn == 0 ? -1 : deprecatedIn;
            }
        } else if (this.mInfo != null && (cls = this.mInfo.getClass(owner)) != null) {
            int deprecatedIn = cls.getMemberDeprecatedIn(name, this.mInfo);
            return deprecatedIn == 0 ? -1 : deprecatedIn;
        }
        return -1;
    }

    public int getFieldRemovedIn(String owner, String name) {
        ApiClass cls;
        if (this.mData != null) {
            int classNumber = this.findClass(owner);
            if (classNumber >= 0) {
                int removedIn = this.findMemberRemovedIn(classNumber, name, null);
                return removedIn == 0 ? -1 : removedIn;
            }
        } else if (this.mInfo != null && (cls = this.mInfo.getClass(owner)) != null) {
            int removedIn = cls.getMemberRemovedIn(name, this.mInfo);
            return removedIn == 0 ? -1 : removedIn;
        }
        return -1;
    }

    public boolean isRelevantOwner(String owner) {
        return this.findClass(owner) >= 0;
    }

    public boolean isValidJavaPackage(String classOrPackageName, int packageNameLength) {
        return this.findContainer(classOrPackageName, packageNameLength, true) >= 0;
    }

    public static boolean equivalentName(String name1, String name2) {
        int len2;
        int len1 = name1.length();
        if (len1 != (len2 = name2.length())) {
            return false;
        }
        for (int i = 0; i < len1; ++i) {
            if (ApiLookup.normalizeSeparator(name1.charAt(i)) == ApiLookup.normalizeSeparator(name2.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean startsWithEquivalentPrefix(String classOrPackageName, String prefix) {
        return ApiLookup.equivalentFragmentAtOffset(classOrPackageName, 0, prefix);
    }

    public static boolean equivalentFragmentAtOffset(String classOrPackageName, int offset, String fragment) {
        int prefixLength = fragment.length();
        if (offset < 0 || offset > classOrPackageName.length() - prefixLength) {
            return false;
        }
        for (int prefixOffset = 0; prefixOffset < prefixLength; ++prefixOffset) {
            if (ApiLookup.normalizeSeparator(classOrPackageName.charAt(offset++)) == ApiLookup.normalizeSeparator(fragment.charAt(prefixOffset))) continue;
            return false;
        }
        return true;
    }

    private static char normalizeSeparator(char c) {
        if (c == '/' || c == '$') {
            c = (char)46;
        }
        return c;
    }

    private int findMember(int classNumber, String name, String desc) {
        return this.findMember(classNumber, name, desc, 2);
    }

    private int findMemberDeprecatedIn(int classNumber, String name, String desc) {
        return this.findMember(classNumber, name, desc, 3);
    }

    private int findMemberRemovedIn(int classNumber, String name, String desc) {
        return this.findMember(classNumber, name, desc, 4);
    }

    private int seekClassData(int classNumber, int field) {
        int offset = this.mIndices[classNumber];
        offset += this.mData[offset] & 0xFF;
        if (field == 1) {
            return offset;
        }
        offset += 5;
        if (field == 2) {
            return offset;
        }
        boolean hasDeprecatedIn = (this.mData[offset] & 0x80) != 0;
        boolean hasRemovedIn = false;
        ++offset;
        if (field == 3) {
            return hasDeprecatedIn ? offset : -1;
        }
        if (hasDeprecatedIn) {
            hasRemovedIn = (this.mData[offset] & 0x80) != 0;
            ++offset;
        }
        if (field == 4) {
            return hasRemovedIn ? offset : -1;
        }
        if (hasRemovedIn) {
            ++offset;
        }
        assert (field == 5);
        return offset;
    }

    private int findMember(int classNumber, String name, String desc, int apiLevelField) {
        int curr = this.seekClassData(classNumber, 1);
        int low = ApiLookup.get3ByteInt(this.mData, curr);
        int length = ApiLookup.get2ByteInt(this.mData, curr += 3);
        if (length == 0) {
            return -1;
        }
        int high = low + length;
        while (low < high) {
            int compare;
            int nameLength;
            int middle = low + high >>> 1;
            int offset = this.mIndices[middle];
            if (desc != null) {
                int argsEnd;
                nameLength = name.length();
                compare = ApiLookup.compare(this.mData, offset, (byte)40, name, 0, nameLength);
                if (compare == 0 && (compare = ApiLookup.compare(this.mData, offset += nameLength, (byte)41, desc, 0, argsEnd = desc.indexOf(41))) == 0) {
                    offset += argsEnd + 1;
                    if (this.mData[offset++] == 0) {
                        return this.getApiLevel(offset, apiLevelField);
                    }
                }
            } else {
                nameLength = name.length();
                compare = ApiLookup.compare(this.mData, offset, (byte)0, name, 0, nameLength);
                if (compare == 0) {
                    offset += nameLength;
                    if (this.mData[offset++] == 0) {
                        return this.getApiLevel(offset, apiLevelField);
                    }
                }
            }
            if (compare < 0) {
                low = middle + 1;
                continue;
            }
            if (compare > 0) {
                high = middle;
                continue;
            }
            assert (false);
            return -1;
        }
        return -1;
    }

    private int getApiLevel(int offset, int apiLevelField) {
        int api = Byte.toUnsignedInt(this.mData[offset]);
        if (apiLevelField == 2) {
            return api & 0xFFFFFF7F;
        }
        if ((api & 0x80) == 0) {
            return -1;
        }
        api = Byte.toUnsignedInt(this.mData[++offset]);
        if (apiLevelField == 3) {
            return (api &= 0xFFFFFF7F) == 0 ? -1 : api;
        }
        assert (apiLevelField == 4);
        if ((api & 0x80) == 0 || apiLevelField != 4) {
            return -1;
        }
        return (api = Byte.toUnsignedInt(this.mData[++offset])) == 0 ? -1 : api;
    }

    @VisibleForTesting
    static void dispose() {
        instances.clear();
    }
}

