/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.builder.model.AndroidLibrary;
import com.android.builder.model.Dependencies;
import com.android.builder.model.JavaLibrary;
import com.android.builder.model.Library;
import com.android.builder.model.MavenCoordinates;
import com.android.tools.lint.checks.Coordinate;
import com.android.tools.lint.checks.GradleDetector;
import com.android.tools.lint.detector.api.Project;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J&\u0010\f\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011J\u001e\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\t0\u00152\u0006\u0010\u0016\u001a\u00020\tH\u0002J\u0012\u0010\u0017\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\bJ\u0018\u0010\u0018\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002J$\u0010\u0019\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\t0\u00152\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0002J\u001e\u0010\u001d\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\t0\u00152\u0006\u0010\u0016\u001a\u00020\u001cH\u0002J$\u0010\u001e\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\t0\u00152\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001bH\u0002J\u001e\u0010 \u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\t0\u00152\u0006\u0010\u0016\u001a\u00020\u001fH\u0002R\"\u0010\u0005\u001a\u0016\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006!"}, d2={"Lcom/android/tools/lint/checks/BlacklistedDeps;", "", "project", "Lcom/android/tools/lint/detector/api/Project;", "(Lcom/android/tools/lint/detector/api/Project;)V", "map", "", "Lcom/android/tools/lint/checks/Coordinate;", "", "Lcom/android/builder/model/Library;", "getProject", "()Lcom/android/tools/lint/detector/api/Project;", "checkDependency", "groupId", "", "artifactId", "remove", "", "checkLibrary", "", "stack", "Ljava/util/ArrayDeque;", "library", "getBlacklistedDependencies", "isBlacklistedDependency", "visitAndroidLibraries", "libraries", "", "Lcom/android/builder/model/AndroidLibrary;", "visitAndroidLibrary", "visitJavaLibraries", "Lcom/android/builder/model/JavaLibrary;", "visitJavaLibrary", "android.sdktools.lint-checks"})
public final class BlacklistedDeps {
    private Map<Coordinate, List<Library>> map;
    @NotNull
    private final Project project;

    @Nullable
    public final List<Library> checkDependency(@NotNull String groupId, @NotNull String artifactId, boolean remove) {
        Map<Coordinate, List<Library>> map = this.map;
        if (map == null) {
            return null;
        }
        Map<Coordinate, List<Library>> map2 = map;
        Coordinate coordinate = new Coordinate(groupId, artifactId);
        List<Library> list2 = map2.get(coordinate);
        if (list2 == null) {
            return null;
        }
        List<Library> path2 = list2;
        if (remove) {
            map2.remove(coordinate);
        }
        return path2;
    }

    @NotNull
    public final List<List<Library>> getBlacklistedDependencies() {
        Map<Coordinate, List<Library>> map = this.map;
        if (map == null) {
            return CollectionsKt.emptyList();
        }
        Map<Coordinate, List<Library>> map2 = map;
        Iterable $this$sortedBy$iv = CollectionsKt.toMutableList(map2.values());
        boolean $i$f$sortedBy = false;
        Iterable iterable = $this$sortedBy$iv;
        boolean bl = false;
        Comparator comparator = new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                List it = (List)a;
                boolean bl2 = false;
                Comparable comparable = (Comparable)((Object)((Library)it.get(0)).getResolvedCoordinates().getGroupId());
                it = (List)b;
                Comparable comparable2 = comparable;
                bl2 = false;
                String string = ((Library)it.get(0)).getResolvedCoordinates().getGroupId();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string)));
            }
        };
        return CollectionsKt.sortedWith((Iterable)iterable, (Comparator)comparator);
    }

    private final void visitAndroidLibraries(ArrayDeque<Library> stack, Collection<? extends AndroidLibrary> libraries) {
        for (AndroidLibrary androidLibrary : libraries) {
            this.visitAndroidLibrary(stack, androidLibrary);
        }
    }

    private final void visitJavaLibraries(ArrayDeque<Library> stack, Collection<? extends JavaLibrary> libraries) {
        for (JavaLibrary javaLibrary : libraries) {
            this.visitJavaLibrary(stack, javaLibrary);
        }
    }

    private final void visitAndroidLibrary(ArrayDeque<Library> stack, AndroidLibrary library) {
        stack.addLast(library);
        this.checkLibrary(stack, library);
        this.visitAndroidLibraries(stack, (Collection<? extends AndroidLibrary>)library.getLibraryDependencies());
        this.visitJavaLibraries(stack, library.getJavaDependencies());
        stack.removeLast();
    }

    private final void visitJavaLibrary(ArrayDeque<Library> stack, JavaLibrary library) {
        stack.addLast(library);
        this.checkLibrary(stack, library);
        this.visitJavaLibraries(stack, (Collection<? extends JavaLibrary>)library.getDependencies());
        stack.removeLast();
    }

    private final void checkLibrary(ArrayDeque<Library> stack, Library library) {
        block4: {
            if (library.isProvided()) {
                return;
            }
            MavenCoordinates coordinates = library.getResolvedCoordinates();
            if (coordinates == null || coordinates.getGroupId() == null || coordinates.getArtifactId() == null) {
                return;
            }
            if (!this.isBlacklistedDependency(coordinates.getGroupId(), coordinates.getArtifactId())) break block4;
            if (this.map == null) {
                this.map = new HashMap();
            }
            MavenCoordinates root = stack.getFirst().getResolvedCoordinates();
            Map<Coordinate, List<Library>> map = this.map;
            if (map != null) {
                List cfr_ignored_0 = map.put(new Coordinate(root.getGroupId(), root.getArtifactId()), new ArrayList(stack));
            }
        }
    }

    private final boolean isBlacklistedDependency(String groupId, String artifactId) {
        switch (groupId) {
            case "org.apache.httpcomponents": {
                return Intrinsics.areEqual((Object)"httpclient", (Object)artifactId);
            }
            case "xpp3": {
                return Intrinsics.areEqual((Object)"xpp3", (Object)artifactId);
            }
            case "commons-logging": {
                return Intrinsics.areEqual((Object)"commons-logging", (Object)artifactId);
            }
            case "xerces": {
                return Intrinsics.areEqual((Object)"xmlParserAPIs", (Object)artifactId);
            }
            case "org.json": {
                return Intrinsics.areEqual((Object)"json", (Object)artifactId);
            }
            case "org.khronos": {
                return Intrinsics.areEqual((Object)"opengl-api", (Object)artifactId);
            }
            case "com.google.android": {
                return Intrinsics.areEqual((Object)"android", (Object)artifactId);
            }
        }
        return false;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public BlacklistedDeps(@NotNull Project project) {
        this.project = project;
        Dependencies dependencies = GradleDetector.Companion.getCompileDependencies(this.project);
        if (dependencies != null) {
            ArrayDeque<Library> stack = new ArrayDeque<Library>();
            this.visitAndroidLibraries(stack, dependencies.getLibraries());
            this.visitJavaLibraries(stack, dependencies.getJavaLibraries());
        }
    }
}

