/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.builder.model.AndroidProject;
import com.android.builder.model.BuildTypeContainer;
import com.android.builder.model.Variant;
import com.android.tools.lint.client.api.UElementHandler;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.utils.CharSequences;
import java.util.Collections;
import java.util.List;
import org.jetbrains.uast.UComment;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UFile;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CommentDetector
extends ResourceXmlDetector
implements SourceCodeScanner {
    private static final String STOPSHIP_COMMENT = "STOPSHIP";
    private static final Implementation IMPLEMENTATION = new Implementation(CommentDetector.class, Scope.JAVA_AND_RESOURCE_FILES, Scope.JAVA_FILE_SCOPE, Scope.RESOURCE_FILE_SCOPE);
    public static final Issue EASTER_EGG = Issue.create("EasterEgg", "Code contains easter egg", "An \"easter egg\" is code deliberately hidden in the code, both from potential users and even from other developers. This lint check looks for code which looks like it may be hidden from sight.", Category.SECURITY, 6, Severity.WARNING, IMPLEMENTATION).setEnabledByDefault(false);
    public static final Issue STOP_SHIP = Issue.create("StopShip", "Code contains `STOPSHIP` marker", "Using the comment `// STOPSHIP` can be used to flag code that is incomplete but checked in. This comment marker can be used to indicate that the code should not be shipped until the issue is addressed, and lint will look for these.  In Gradle projects, this is only checked for non-debug (release) builds.", Category.CORRECTNESS, 10, Severity.FATAL, IMPLEMENTATION).setEnabledByDefault(false);
    private static final boolean USE_AST = true;
    private static final String ESCAPE_STRING = "\\u002a\\u002f";

    @Override
    public List<Class<? extends UElement>> getApplicableUastTypes() {
        return Collections.singletonList(UFile.class);
    }

    @Override
    public UElementHandler createUastHandler(JavaContext context2) {
        return new CommentChecker(context2);
    }

    @Override
    public void afterCheckFile(Context context2) {
    }

    private static void checkJava(JavaContext context2) {
        CharSequence source = context2.getContents();
        if (source == null) {
            return;
        }
        int n = source.length() - 1;
        for (int i = 0; i < n; ++i) {
            int end;
            int start;
            char c = source.charAt(i);
            if (c == '\\') {
                ++i;
                continue;
            }
            if (c != '/') continue;
            char next = source.charAt(i + 1);
            if (next == '/') {
                start = i + 2;
                end = CharSequences.indexOf((CharSequence)source, (char)'\n', (int)start);
                if (end == -1) {
                    end = n;
                }
                CommentDetector.checkComment(context2, null, null, null, source, 0, start, end);
                continue;
            }
            if (next != '*') continue;
            start = i + 2;
            end = CharSequences.indexOf((CharSequence)source, (CharSequence)"*/", (int)start);
            if (end == -1) {
                end = n;
            }
            CommentDetector.checkComment(context2, null, null, null, source, 0, start, end);
        }
    }

    @Override
    public void visitDocument(XmlContext context2, Document document) {
        CommentDetector.checkXml(context2, document);
    }

    private static void checkXml(XmlContext context2, Node node) {
        if (node.getNodeType() == 8) {
            String source = node.getNodeValue();
            CommentDetector.checkComment(null, context2, node, null, source, 0, 0, source.length());
        }
        NodeList children = node.getChildNodes();
        int n = children.getLength();
        for (int i = 0; i < n; ++i) {
            CommentDetector.checkXml(context2, children.item(i));
        }
    }

    private static void checkComment(JavaContext javaContext, XmlContext xmlContext, Node xmlNode, UComment javaNode, CharSequence source, int offset, int start, int end) {
        assert (javaContext != null || xmlContext != null);
        int prev = 0;
        Context context2 = javaContext != null ? javaContext : xmlContext;
        for (int i = start; i < end - 2; ++i) {
            Location location;
            String message2;
            char c = source.charAt(i);
            if (prev == 92) {
                if (c == 'u' || c == 'U') {
                    if (CharSequences.regionMatches((CharSequence)source, (boolean)true, (int)(i - 1), (CharSequence)ESCAPE_STRING, (int)0, (int)ESCAPE_STRING.length())) {
                        message2 = "Code might be hidden here; found unicode escape sequence which is interpreted as comment end, compiled code follows";
                        if (javaContext != null) {
                            location = javaNode != null ? javaContext.getRangeLocation((UElement)javaNode, offset + i - 1, ESCAPE_STRING.length()) : Location.create(context2.file, source, offset + i - 1, offset + i - 1 + ESCAPE_STRING.length());
                            javaContext.report(EASTER_EGG, (UElement)javaNode, location, message2);
                        } else {
                            assert (xmlNode != null);
                            location = xmlContext.getLocation(xmlNode, i, i + ESCAPE_STRING.length());
                            xmlContext.report(EASTER_EGG, xmlNode, location, message2);
                        }
                    }
                } else {
                    ++i;
                }
            } else if (prev == 83 && c == 'T' && CharSequences.regionMatches((CharSequence)source, (int)(i - 1), (CharSequence)STOPSHIP_COMMENT, (int)0, (int)STOPSHIP_COMMENT.length())) {
                LintFix fix;
                Boolean releaseMode;
                if (!Scope.checkSingleFile(context2.getDriver().getScope()) && (releaseMode = CommentDetector.getReleaseMode(context2)) == Boolean.FALSE) {
                    return;
                }
                message2 = "`STOPSHIP` comment found; points to code which must be fixed prior to release";
                if (javaContext != null) {
                    location = javaNode != null ? javaContext.getRangeLocation((UElement)javaNode, offset + i - 1, STOPSHIP_COMMENT.length()) : Location.create(context2.file, source, offset + i - 1, offset + i - 1 + STOPSHIP_COMMENT.length());
                    fix = CommentDetector.createRemoveStopShipFix();
                    javaContext.report(STOP_SHIP, (UElement)javaNode, location, message2, fix);
                } else {
                    assert (xmlNode != null);
                    location = xmlContext.getLocation(xmlNode, i, i + STOPSHIP_COMMENT.length());
                    fix = CommentDetector.createRemoveStopShipFix();
                    xmlContext.report(STOP_SHIP, xmlNode, location, message2, fix);
                }
            }
            prev = c;
        }
    }

    private static LintFix createRemoveStopShipFix() {
        return LintFix.create().name("Remove STOPSHIP").replace().pattern("(\\s*STOPSHIP)").with("").build();
    }

    private static Boolean getReleaseMode(Context context2) {
        Project project = context2.getMainProject();
        AndroidProject model = project.getGradleProjectModel();
        Variant variant = project.getCurrentVariant();
        if (model != null && variant != null) {
            String buildType = variant.getBuildType();
            for (BuildTypeContainer container : model.getBuildTypes()) {
                if (!buildType.equals(container.getBuildType().getName())) continue;
                return !container.getBuildType().isDebuggable();
            }
        }
        return null;
    }

    private static class CommentChecker
    extends UElementHandler {
        private final JavaContext mContext;

        public CommentChecker(JavaContext context2) {
            this.mContext = context2;
        }

        @Override
        public void visitFile(UFile node) {
            for (UComment comment : node.getAllCommentsInFile()) {
                String contents = comment.getText();
                CommentDetector.checkComment(this.mContext, null, null, comment, contents, 0, 0, contents.length());
            }
        }
    }
}

