/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.SdkConstants;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.resources.FolderTypeRelationship;
import com.android.resources.ResourceFolderType;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LayoutDetector;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.io.File;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DuplicateIdDetector
extends LayoutDetector {
    private Map<String, Attr> mFileIds;
    private Map<File, Set<String>> mFileToIds;
    private Map<File, List<String>> mIncludes;
    private Multimap<File, Multimap<String, Occurrence>> mLocations;
    private List<Occurrence> mErrors;
    private static final Implementation IMPLEMENTATION = new Implementation(DuplicateIdDetector.class, Scope.RESOURCE_FILE_SCOPE);
    private static final String MOTION_SCENE_CONSTRAINT = "Constraint";
    public static final Issue WITHIN_LAYOUT = Issue.create("DuplicateIds", "Duplicate ids within a single layout", "Within a layout, id's should be unique since otherwise `findViewById()` can return an unexpected view.", Category.CORRECTNESS, 7, Severity.FATAL, IMPLEMENTATION);
    public static final Issue CROSS_LAYOUT = Issue.create("DuplicateIncludedIds", "Duplicate ids across layouts combined with include tags", "It's okay for two independent layouts to use the same ids. However, if layouts are combined with include tags, then the id's need to be unique within any chain of included layouts, or `Activity#findViewById()` can return an unexpected view.", Category.CORRECTNESS, 6, Severity.WARNING, IMPLEMENTATION);

    @Override
    public boolean appliesTo(ResourceFolderType folderType) {
        return FolderTypeRelationship.isIdGeneratingFolderType((ResourceFolderType)folderType);
    }

    @Override
    public Collection<String> getApplicableAttributes() {
        return Collections.singletonList("id");
    }

    @Override
    public Collection<String> getApplicableElements() {
        return Collections.singletonList("include");
    }

    @Override
    public void beforeCheckFile(Context context2) {
        if (context2.getPhase() == 1) {
            this.mFileIds = new HashMap<String, Attr>();
        }
    }

    @Override
    public void afterCheckFile(Context context2) {
        if (context2.getPhase() == 1) {
            this.mFileToIds.put(context2.file, this.mFileIds.keySet());
            this.mFileIds = null;
        }
    }

    @Override
    public void beforeCheckRootProject(Context context2) {
        if (context2.getPhase() == 1) {
            this.mFileToIds = new HashMap<File, Set<String>>();
            this.mIncludes = new HashMap<File, List<String>>();
        }
    }

    @Override
    public void afterCheckRootProject(Context context2) {
        if (context2.getPhase() == 1) {
            if (!this.mIncludes.isEmpty() && context2.isEnabled(CROSS_LAYOUT) && context2.getScope().contains((Object)Scope.ALL_RESOURCE_FILES)) {
                IncludeGraph graph = new IncludeGraph(context2);
                graph.check();
            }
        } else {
            assert (context2.getPhase() == 2);
            if (this.mErrors != null) {
                for (Occurrence occurrence : this.mErrors) {
                    Location location = occurrence.location;
                    if (location == null) {
                        location = Location.create(occurrence.file);
                    } else {
                        Object clientData = location.getClientData();
                        if (clientData instanceof Node) {
                            Node node = (Node)clientData;
                            if (context2.getDriver().isSuppressed(null, CROSS_LAYOUT, node)) continue;
                        }
                    }
                    ArrayList<Occurrence> sorted = new ArrayList<Occurrence>();
                    Occurrence curr = occurrence.next;
                    while (curr != null) {
                        sorted.add(curr);
                        curr = curr.next;
                    }
                    Collections.sort(sorted);
                    Location prev = location;
                    for (Occurrence o : sorted) {
                        if (o.location == null) continue;
                        prev.setSecondary(o.location);
                        prev = o.location;
                    }
                    context2.report(CROSS_LAYOUT, location, occurrence.message);
                }
            }
        }
    }

    @Override
    public void visitElement(XmlContext context2, Element element) {
        String layout = element.getAttribute("layout");
        if (layout.startsWith("@layout/")) {
            layout = layout.substring("@layout/".length());
            if (context2.getPhase() == 1) {
                if (!context2.getProject().getReportIssues()) {
                    return;
                }
                List<String> to = this.mIncludes.get(context2.file);
                if (to == null) {
                    to = new ArrayList<String>();
                    this.mIncludes.put(context2.file, to);
                }
                to.add(layout);
            } else {
                assert (context2.getPhase() == 2);
                Collection maps = this.mLocations.get((Object)context2.file);
                if (maps != null && !maps.isEmpty()) {
                    for (Multimap map : maps) {
                        Collection occurrences;
                        if (maps.isEmpty() || (occurrences = map.get((Object)layout)) == null || occurrences.isEmpty()) continue;
                        for (Occurrence occurrence : occurrences) {
                            Location location = context2.getLocation(element);
                            location.setData(element);
                            location.setMessage(occurrence.message);
                            location.setSecondary(occurrence.location);
                            occurrence.location = location;
                        }
                    }
                }
            }
        }
    }

    @Override
    public void visitAttribute(XmlContext context2, Attr attribute) {
        block14: {
            String id;
            block12: {
                block13: {
                    assert (attribute.getName().equals("id") || "id".equals(attribute.getLocalName()));
                    id = attribute.getValue();
                    if (context2.getPhase() != 1) break block12;
                    String ownerName = null;
                    if (attribute.getOwnerElement() != null) {
                        String parentName;
                        Node parentNode;
                        ownerName = attribute.getOwnerElement().getTagName();
                        if (ownerName != null && SdkConstants.CLASS_CONSTRAINT_LAYOUT_REFERENCE.isEquals(ownerName) && (parentNode = attribute.getOwnerElement().getParentNode()) != null && (parentName = parentNode.getNodeName()) != null && SdkConstants.CLASS_CONSTRAINT_LAYOUT_CONSTRAINTS.isEquals(parentName)) {
                            return;
                        }
                        if (ownerName != null && ownerName.equals("tag") && (parentNode = attribute.getOwnerElement().getParentNode()) != null && (parentName = parentNode.getNodeName()) != null && (SdkConstants.CLASS_CONSTRAINT_LAYOUT_BARRIER.isEquals(parentName) || SdkConstants.CLASS_CONSTRAINT_LAYOUT_CHAIN.isEquals(parentName) || SdkConstants.CLASS_CONSTRAINT_LAYOUT_LAYER.isEquals(parentName) || SdkConstants.CLASS_CONSTRAINT_LAYOUT_GROUP.isEquals(parentName))) {
                            return;
                        }
                    }
                    if (MOTION_SCENE_CONSTRAINT.equals(ownerName)) {
                        return;
                    }
                    if (!this.mFileIds.containsKey(id)) break block13;
                    Location location = context2.getLocation(attribute);
                    Attr first = this.mFileIds.get(id);
                    if (first != null && first != attribute) {
                        if (context2.getResourceFolderType() == ResourceFolderType.NAVIGATION && first.getOwnerElement().getParentNode() != attribute.getOwnerElement().getParentNode()) {
                            this.mFileIds.put(id, attribute);
                            return;
                        }
                        Location secondLocation = context2.getLocation(first);
                        secondLocation.setMessage(String.format("Duplicate id `%1$s` originally defined here", id), true);
                        location.setSecondary(secondLocation);
                    }
                    context2.report(WITHIN_LAYOUT, attribute, location, String.format("Duplicate id `%1$s`, already defined earlier in this layout", id));
                    break block14;
                }
                if (!id.startsWith("@+id/")) break block14;
                if (attribute.getOwnerElement().getTagName().equals("include")) {
                    return;
                }
                this.mFileIds.put(id, attribute);
                break block14;
            }
            Collection maps = this.mLocations.get((Object)context2.file);
            if (maps != null && !maps.isEmpty()) {
                for (Multimap map : maps) {
                    Collection occurrences;
                    if (maps.isEmpty() || (occurrences = map.get((Object)id)) == null || occurrences.isEmpty()) continue;
                    for (Occurrence occurrence : occurrences) {
                        if (context2.getDriver().isSuppressed(context2, CROSS_LAYOUT, attribute)) {
                            return;
                        }
                        Location location = context2.getLocation(attribute);
                        location.setData(attribute);
                        location.setMessage(occurrence.message);
                        location.setSecondary(occurrence.location);
                        occurrence.location = location;
                    }
                }
            }
        }
    }

    private static class Occurrence
    implements Comparable<Occurrence> {
        public final File file;
        public final String includePath;
        public Occurrence next;
        public Location location;
        public String message;

        public Occurrence(File file, String message2, String includePath) {
            this.file = file;
            this.message = message2;
            this.includePath = includePath;
        }

        public String toString() {
            return this.includePath != null ? this.includePath : this.message;
        }

        @Override
        public int compareTo(Occurrence other) {
            int delta = this.toString().length() - other.toString().length();
            if (delta != 0) {
                return delta;
            }
            return this.toString().compareTo(other.toString());
        }
    }

    private class IncludeGraph {
        private final Context mContext;
        private final Map<File, Layout> mFileToLayout;

        public IncludeGraph(Context context2) {
            this.mContext = context2;
            this.mFileToLayout = new HashMap<File, Layout>(2 * DuplicateIdDetector.this.mIncludes.size());
            for (File file : DuplicateIdDetector.this.mIncludes.keySet()) {
                if (this.mFileToLayout.containsKey(file)) continue;
                this.mFileToLayout.put(file, new Layout(file, (Set)DuplicateIdDetector.this.mFileToIds.get(file)));
            }
            for (File file : DuplicateIdDetector.this.mFileToIds.keySet()) {
                Set ids = (Set)DuplicateIdDetector.this.mFileToIds.get(file);
                if (ids == null || ids.isEmpty() || this.mFileToLayout.containsKey(file)) continue;
                this.mFileToLayout.put(file, new Layout(file, ids));
            }
            ArrayListMultimap nameToLayout = ArrayListMultimap.create((int)this.mFileToLayout.size(), (int)4);
            for (File file : this.mFileToLayout.keySet()) {
                String name = Lint.getLayoutName(file);
                nameToLayout.put((Object)name, (Object)this.mFileToLayout.get(file));
            }
            for (File file : DuplicateIdDetector.this.mIncludes.keySet()) {
                Layout from = this.mFileToLayout.get(file);
                assert (from != null) : file;
                List includedLayouts = (List)DuplicateIdDetector.this.mIncludes.get(file);
                for (String name : includedLayouts) {
                    Collection layouts = nameToLayout.get((Object)name);
                    if (layouts == null || layouts.isEmpty()) continue;
                    if (layouts.size() == 1) {
                        from.include((Layout)layouts.iterator().next());
                        continue;
                    }
                    File folder = from.getFile().getParentFile();
                    File candidate = new File(folder, name + ".xml");
                    Layout candidateLayout = this.mFileToLayout.get(candidate);
                    if (candidateLayout != null) {
                        from.include(candidateLayout);
                        continue;
                    }
                    if (DuplicateIdDetector.this.mFileToIds.containsKey(candidate)) continue;
                    for (Layout to : layouts) {
                        if (!this.isCompatible(from, to)) continue;
                        from.include(to);
                    }
                }
            }
        }

        boolean isCompatible(Layout from, Layout to) {
            File toFolder;
            File fromFolder = from.mFile.getParentFile();
            if (fromFolder.equals(toFolder = to.mFile.getParentFile())) {
                return true;
            }
            Iterable fromQualifiers = FolderConfiguration.QUALIFIER_SPLITTER.split((CharSequence)fromFolder.getName());
            Iterable toQualifiers = FolderConfiguration.QUALIFIER_SPLITTER.split((CharSequence)toFolder.getName());
            return this.isPortrait(fromQualifiers) == this.isPortrait(toQualifiers);
        }

        private boolean isPortrait(Iterable<String> qualifiers) {
            for (String qualifier : qualifiers) {
                if (qualifier.equals("port")) {
                    return true;
                }
                if (!qualifier.equals("land")) continue;
                return false;
            }
            return true;
        }

        public void check() {
            for (Layout layout : this.mFileToLayout.values()) {
                if (layout.isIncluded()) continue;
                ArrayDeque<Layout> stack = new ArrayDeque<Layout>();
                this.getIds(layout, stack, new HashSet<Layout>());
            }
        }

        private Set<String> getIds(Layout layout, Deque<Layout> stack, Set<Layout> seen) {
            seen.add(layout);
            Set<String> layoutIds = layout.getIds();
            List<Layout> includes = layout.getIncludes();
            if (includes != null) {
                HashSet<String> ids = new HashSet<String>();
                if (layoutIds != null) {
                    ids.addAll(layoutIds);
                }
                stack.push(layout);
                ArrayListMultimap nameToIds = ArrayListMultimap.create((int)includes.size(), (int)4);
                LintClient client = this.mContext.getClient();
                for (Layout included : includes) {
                    Set<String> includedIds;
                    if (seen.contains(included) || (includedIds = this.getIds(included, stack, seen)) == null) continue;
                    String layoutName = included.getLayoutName();
                    block1: for (String id : includedIds) {
                        if (ids.contains(id)) {
                            Collection idSets = nameToIds.get((Object)layoutName);
                            if (idSets != null) {
                                for (Set siblingIds : idSets) {
                                    if (!siblingIds.contains(id)) continue;
                                    continue block1;
                                }
                            }
                            if (DuplicateIdDetector.this.mLocations == null) {
                                DuplicateIdDetector.this.mErrors = new ArrayList();
                                DuplicateIdDetector.this.mLocations = (Multimap)ArrayListMultimap.create();
                                this.mContext.getDriver().requestRepeat(DuplicateIdDetector.this, Scope.ALL_RESOURCES_SCOPE);
                            }
                            HashMap<Layout, Occurrence> occurrences = new HashMap<Layout, Occurrence>();
                            this.findId(layout, id, new ArrayDeque<Layout>(), occurrences, new HashSet<Layout>());
                            assert (occurrences.size() >= 2);
                            Collection values = occurrences.values();
                            ArrayList sorted = new ArrayList(values);
                            Collections.sort(sorted);
                            String msg = String.format("Duplicate id %1$s, defined or included multiple times in %2$s: %3$s", id, layout.getDisplayName(client), ((Object)sorted).toString());
                            Occurrence primary = new Occurrence(layout.getFile(), msg, null);
                            ArrayListMultimap m = ArrayListMultimap.create();
                            m.put((Object)layoutName, (Object)primary);
                            DuplicateIdDetector.this.mLocations.put((Object)layout.getFile(), (Object)m);
                            DuplicateIdDetector.this.mErrors.add(primary);
                            Occurrence prev = primary;
                            for (Occurrence occurrence : values) {
                                occurrence.message = occurrence.file.equals(layout.getFile()) ? "Defined here" : String.format("Defined here, included via %1$s", occurrence.includePath);
                                m = ArrayListMultimap.create();
                                m.put((Object)id, (Object)occurrence);
                                DuplicateIdDetector.this.mLocations.put((Object)occurrence.file, (Object)m);
                                prev.next = occurrence;
                                prev = occurrence;
                            }
                        }
                        ids.add(id);
                    }
                    nameToIds.put((Object)layoutName, includedIds);
                }
                Layout visited = stack.pop();
                assert (visited == layout);
                return ids;
            }
            return layoutIds;
        }

        private void findId(Layout layout, String id, Deque<Layout> stack, Map<Layout, Occurrence> occurrences, Set<Layout> seen) {
            List<Layout> includes;
            seen.add(layout);
            LintClient client = this.mContext.getClient();
            Set<String> layoutIds = layout.getIds();
            if (layoutIds != null && layoutIds.contains(id)) {
                StringBuilder path2 = new StringBuilder(80);
                if (!stack.isEmpty()) {
                    Iterator<Layout> iterator = stack.descendingIterator();
                    while (iterator.hasNext()) {
                        path2.append(iterator.next().getDisplayName(client));
                        path2.append(" => ");
                    }
                }
                path2.append(layout.getDisplayName(client));
                path2.append(" defines ");
                path2.append(id);
                assert (occurrences.get(layout) == null) : id + ',' + layout;
                occurrences.put(layout, new Occurrence(layout.getFile(), null, path2.toString()));
            }
            if ((includes = layout.getIncludes()) != null) {
                stack.push(layout);
                for (Layout included : includes) {
                    if (seen.contains(included)) continue;
                    this.findId(included, id, stack, occurrences, seen);
                }
                Layout visited = stack.pop();
                assert (visited == layout);
            }
        }
    }

    private static class Layout {
        private final File mFile;
        private final Set<String> mIds;
        private List<Layout> mIncludes;
        private List<Layout> mIncludedBy;

        Layout(File file, Set<String> ids) {
            this.mFile = file;
            this.mIds = ids;
        }

        Set<String> getIds() {
            return this.mIds;
        }

        String getLayoutName() {
            return Lint.getLayoutName(this.mFile);
        }

        String getDisplayName(LintClient client) {
            return Lint.getFileNameWithParent(client, this.mFile);
        }

        void include(Layout target) {
            if (this.mIncludes == null) {
                this.mIncludes = new ArrayList<Layout>();
            }
            this.mIncludes.add(target);
            if (target.mIncludedBy == null) {
                target.mIncludedBy = new ArrayList<Layout>();
            }
            target.mIncludedBy.add(this);
        }

        boolean isIncluded() {
            return this.mIncludedBy != null && !this.mIncludedBy.isEmpty();
        }

        File getFile() {
            return this.mFile;
        }

        List<Layout> getIncludes() {
            return this.mIncludes;
        }
    }
}

