/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LayoutDetector;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import java.util.Collection;
import java.util.Collections;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class IncludeDetector
extends LayoutDetector {
    public static final Issue ISSUE = Issue.create("IncludeLayoutParam", "Ignored layout params on include", "Layout parameters specified on an `<include>` tag will only be used if you also override `layout_width` and `layout_height` on the `<include>` tag; otherwise they will be ignored.", Category.CORRECTNESS, 5, Severity.ERROR, new Implementation(IncludeDetector.class, Scope.RESOURCE_FILE_SCOPE)).addMoreInfo("http://stackoverflow.com/questions/2631614/does-android-xml-layouts-include-tag-really-work");

    @Override
    public Collection<String> getApplicableElements() {
        return Collections.singletonList("include");
    }

    @Override
    public void visitElement(XmlContext context2, Element element) {
        boolean flagHeight;
        NamedNodeMap attributes = element.getAttributes();
        int length = attributes.getLength();
        boolean hasWidth = false;
        boolean hasHeight = false;
        boolean hasOtherLayoutParam = false;
        for (int i = 0; i < length; ++i) {
            Attr attribute = (Attr)attributes.item(i);
            String name = attribute.getLocalName();
            if (name == null || !name.startsWith("layout_")) continue;
            if ("layout_width".equals(name)) {
                hasWidth = true;
                continue;
            }
            if ("layout_height".equals(name)) {
                hasHeight = true;
                continue;
            }
            if (!"http://schemas.android.com/apk/res/android".equals(attribute.getNamespaceURI())) continue;
            hasOtherLayoutParam = true;
        }
        boolean flagWidth = !hasOtherLayoutParam && hasWidth && !hasHeight;
        boolean bl = flagHeight = !hasOtherLayoutParam && !hasWidth && hasHeight;
        if (hasOtherLayoutParam && (!hasWidth || !hasHeight) || flagWidth || flagHeight) {
            for (int i = 0; i < length; ++i) {
                Attr attribute = (Attr)attributes.item(i);
                String name = attribute.getLocalName();
                if (name == null || !name.startsWith("layout_") || "layout_width".equals(name) && !flagWidth || "layout_height".equals(name) && !flagHeight || !"http://schemas.android.com/apk/res/android".equals(attribute.getNamespaceURI())) continue;
                String condition = !hasWidth && !hasHeight ? "both `layout_width` and `layout_height` are also specified" : (!hasWidth ? "`layout_width` is also specified" : "`layout_height` is also specified");
                String message2 = String.format("Layout parameter `%1$s` ignored unless %2$s on `<include>` tag", name, condition);
                LintFix.GroupBuilder fixes = this.fix().alternatives();
                if (!hasWidth) {
                    fixes.add(this.fix().set().todo("http://schemas.android.com/apk/res/android", "layout_width").build());
                }
                if (!hasHeight) {
                    fixes.add(this.fix().set().todo("http://schemas.android.com/apk/res/android", "layout_height").build());
                }
                context2.report(ISSUE, (Node)element, context2.getLocation(attribute), message2, fixes.build());
            }
        }
    }
}

