/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.client.api.UElementHandler;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.TypeEvaluator;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiType;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00142\u00020\u00012\u00020\u0002:\u0001\u0014B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\tH\u0016J\u0018\u0010\u000b\u001a\u0012\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\r0\f\u0018\u00010\tH\u0016J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/lint/checks/JavaScriptInterfaceDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "createUastHandler", "Lcom/android/tools/lint/client/api/UElementHandler;", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "getApplicableMethodNames", "", "", "getApplicableUastTypes", "Ljava/lang/Class;", "Lorg/jetbrains/uast/UElement;", "visitMethodCall", "", "node", "Lorg/jetbrains/uast/UCallExpression;", "method", "Lcom/intellij/psi/PsiMethod;", "Companion", "android.sdktools.lint-checks"})
public final class JavaScriptInterfaceDetector
extends Detector
implements SourceCodeScanner {
    @JvmField
    @NotNull
    public static final Issue ISSUE;
    private static final String ADD_JAVASCRIPT_INTERFACE = "addJavascriptInterface";
    private static final String JAVASCRIPT_INTERFACE_CLS = "android.webkit.JavascriptInterface";
    private static final String WEB_VIEW_CLS = "android.webkit.WebView";
    public static final Companion Companion;

    @Override
    @Nullable
    public List<String> getApplicableMethodNames() {
        return CollectionsKt.listOf((Object)ADD_JAVASCRIPT_INTERFACE);
    }

    @Override
    public void visitMethodCall(@NotNull JavaContext context2, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        if (context2.getMainProject().getTargetSdk() < 17) {
            return;
        }
        List arguments = node.getValueArguments();
        if (arguments.size() != 2) {
            return;
        }
        JavaEvaluator evaluator = context2.getEvaluator();
        if (!evaluator.isMemberInClass((PsiMember)method, WEB_VIEW_CLS)) {
            return;
        }
        UExpression first = (UExpression)arguments.get(0);
        PsiType evaluated = TypeEvaluator.evaluate((UElement)first);
        if (evaluated instanceof PsiClassType) {
            PsiClass psiClass = ((PsiClassType)evaluated).resolve();
            if (psiClass == null) {
                return;
            }
            PsiClass cls = psiClass;
            if (JavaScriptInterfaceDetector.Companion.isJavaScriptAnnotated(cls)) {
                return;
            }
            Location location = context2.getNameLocation((UElement)node);
            String message2 = "None of the methods in the added interface (" + cls.getName() + ") have " + "been annotated with `@android.webkit.JavascriptInterface`; they will not " + "be visible in API 17";
            JavaContext.report$default(context2, ISSUE, (UElement)node, location, message2, null, 16, null);
        }
    }

    @Override
    @Nullable
    public List<Class<? extends UElement>> getApplicableUastTypes() {
        return CollectionsKt.listOf(UDeclaration.class);
    }

    @Override
    @Nullable
    public UElementHandler createUastHandler(@NotNull JavaContext context2) {
        if (!context2.getMainProject().isAndroidProject()) {
            return null;
        }
        return new UElementHandler(context2){
            final /* synthetic */ JavaContext $context;

            public void visitDeclaration(@NotNull UDeclaration node) {
                PsiModifierList psiModifierList = node.getModifierList();
                if (psiModifierList == null) {
                    return;
                }
                PsiModifierList modifierList = psiModifierList;
                if (modifierList.hasModifierProperty("public")) {
                    return;
                }
                for (UAnnotation annotation : node.getAnnotations()) {
                    if (!Intrinsics.areEqual((Object)annotation.getQualifiedName(), (Object)"android.webkit.JavascriptInterface")) continue;
                    UDeclaration uDeclaration = node;
                    if (uDeclaration == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.uast.UElement");
                    }
                    JavaContext.report$default(this.$context, JavaScriptInterfaceDetector.ISSUE, (UElement)uDeclaration, this.$context.getNameLocation(node), "Must be public when using `@JavascriptInterface`", null, 16, null);
                }
            }
            {
                this.$context = $captured_local_variable$0;
            }
        };
    }

    static {
        Companion = new Companion(null);
        Collection collection = null;
        EnumSet enumSet = null;
        Implementation implementation = new Implementation(JavaScriptInterfaceDetector.class, Scope.JAVA_FILE_SCOPE);
        boolean bl = false;
        Severity severity = Severity.ERROR;
        int n = 8;
        Boolean bl2 = true;
        String string = "http://developer.android.com/reference/android/webkit/WebView.html#addJavascriptInterface(java.lang.Object, java.lang.String)";
        Category category = Category.SECURITY;
        ISSUE = Issue.Companion.create$default(Issue.Companion, "JavascriptInterface", "Missing @JavascriptInterface on methods", "\n                As of API 17, you must annotate methods in objects registered with the \\\n                `addJavascriptInterface` method with a `@JavascriptInterface` annotation.\n                ", implementation, string, category, n, severity, bl, bl2, enumSet, collection, 3328, null);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/android/tools/lint/checks/JavaScriptInterfaceDetector$Companion;", "", "()V", "ADD_JAVASCRIPT_INTERFACE", "", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "JAVASCRIPT_INTERFACE_CLS", "WEB_VIEW_CLS", "isJavaScriptAnnotated", "", "clz", "Lcom/intellij/psi/PsiClass;", "android.sdktools.lint-checks"})
    public static final class Companion {
        private final boolean isJavaScriptAnnotated(PsiClass clz) {
            for (PsiClass current = clz; current != null; current = current.getSuperClass()) {
                PsiModifierList modifierList;
                PsiModifierList psiModifierList = modifierList = current.getModifierList();
                if ((psiModifierList != null ? psiModifierList.findAnnotation(JavaScriptInterfaceDetector.JAVASCRIPT_INTERFACE_CLS) : null) != null) {
                    return true;
                }
                for (PsiMethod method : current.getMethods()) {
                    if (method.getModifierList().findAnnotation(JavaScriptInterfaceDetector.JAVASCRIPT_INTERFACE_CLS) == null) continue;
                    return true;
                }
            }
            return false;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

