/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LayoutDetector;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class LabelForDetector
extends LayoutDetector {
    public static final Issue ISSUE = Issue.create("LabelFor", "Missing accessibility label", "Editable text fields should provide an `android:hint` or, provided your `minSdkVersion` is at least 17, they may be referenced by a view with a `android:labelFor` attribute.\n\nWhen using `android:labelFor`, be sure to provide an `android:text` or an `android:contentDescription`.\n\nIf your view is labeled but by a label in a different layout which includes this one, just suppress this warning from lint.", Category.A11Y, 2, Severity.WARNING, new Implementation(LabelForDetector.class, Scope.RESOURCE_FILE_SCOPE));
    private static final String PREFIX = "Missing accessibility label";
    private static final String PROVIDE_HINT = "where minSdk < 17, you should provide an `android:hint`";
    private static final String PROVIDE_LABEL_FOR_OR_HINT = "provide either a view with an `android:labelFor` that references this view or provide an `android:hint`";
    private Set<String> mLabels;
    private List<Element> mEditableTextFields;

    @Override
    public Collection<String> getApplicableAttributes() {
        return Collections.singletonList("labelFor");
    }

    @Override
    public Collection<String> getApplicableElements() {
        return Arrays.asList("EditText", "AutoCompleteTextView", "MultiAutoCompleteTextView");
    }

    @Override
    public void afterCheckFile(Context context2) {
        if (this.mEditableTextFields != null) {
            if (this.mLabels == null) {
                this.mLabels = Collections.emptySet();
            }
            for (Element element : this.mEditableTextFields) {
                String id = element.getAttributeNS("http://schemas.android.com/apk/res/android", "id");
                boolean hintProvided = element.hasAttributeNS("http://schemas.android.com/apk/res/android", "hint");
                boolean labelForProvided = false;
                if (this.mLabels.contains(id)) {
                    labelForProvided = true;
                } else if (id.startsWith("@+id/")) {
                    labelForProvided = this.mLabels.contains("@id/" + Lint.stripIdPrefix(id));
                } else if (id.startsWith("@id/")) {
                    labelForProvided = this.mLabels.contains("@+id/" + Lint.stripIdPrefix(id));
                }
                XmlContext xmlContext = (XmlContext)context2;
                String message2 = "";
                Location location = xmlContext.getElementLocation(element);
                int minSdk = context2.getMainProject().getMinSdk();
                if (hintProvided && labelForProvided) {
                    if (minSdk >= 17) {
                        message2 = "provide either a view with an `android:labelFor` that references this view or provide an `android:hint`, but not both";
                    }
                } else if (!hintProvided && !labelForProvided) {
                    message2 = minSdk < 17 ? PROVIDE_HINT : PROVIDE_LABEL_FOR_OR_HINT;
                } else if (labelForProvided && minSdk < 17) {
                    message2 = PROVIDE_HINT;
                }
                if (message2.isEmpty()) continue;
                xmlContext.report(ISSUE, element, location, LabelForDetector.messageWithPrefix(message2));
            }
        }
        this.mLabels = null;
        this.mEditableTextFields = null;
    }

    @Override
    public void visitAttribute(XmlContext context2, Attr attribute) {
        assert (attribute.getLocalName().equals("labelFor"));
        Element element = attribute.getOwnerElement();
        if (this.mLabels == null) {
            this.mLabels = Sets.newHashSet();
        }
        this.mLabels.add(attribute.getValue());
        if (!element.getLocalName().equals("TextView")) {
            return;
        }
        Attr textAttributeNode = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "text");
        Attr contentDescriptionNode = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "contentDescription");
        if ((textAttributeNode == null || textAttributeNode.getValue().isEmpty()) && (contentDescriptionNode == null || contentDescriptionNode.getValue().isEmpty())) {
            LintFix fix = this.fix().alternatives(this.fix().set().todo("http://schemas.android.com/apk/res/android", "text").build(), this.fix().set().todo("http://schemas.android.com/apk/res/android", "contentDescription").build());
            context2.report(ISSUE, (Node)element, context2.getElementLocation(element, null, "http://schemas.android.com/apk/res/android", "labelFor"), LabelForDetector.messageWithPrefix("when using `android:labelFor`, you must also define an `android:text` or an `android:contentDescription`"), fix);
        }
    }

    @Override
    public void visitElement(XmlContext context2, Element element) {
        Attr hintAttributeNode;
        if (element.hasAttributeNS("http://schemas.android.com/apk/res/android", "hint") && (hintAttributeNode = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "hint")).getValue().isEmpty()) {
            context2.report(ISSUE, hintAttributeNode, context2.getLocation(hintAttributeNode), "Empty `android:hint` attribute");
        }
        if (this.mEditableTextFields == null) {
            this.mEditableTextFields = new ArrayList<Element>();
        }
        this.mEditableTextFields.add(element);
    }

    private static String messageWithPrefix(String message2) {
        return "Missing accessibility label: " + message2;
    }
}

