/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.resources.ResourceType;
import com.android.tools.lint.client.api.ResourceReference;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LayoutDetector;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.UastLintUtils;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.utils.Pair;
import com.intellij.psi.PsiMethod;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MergeRootFrameLayoutDetector
extends LayoutDetector
implements SourceCodeScanner {
    private Set<String> mWhitelistedLayouts;
    private List<Pair<String, Location.Handle>> mPending;
    public static final Issue ISSUE = Issue.create("MergeRootFrame", "FrameLayout can be replaced with `<merge>` tag", "If a `<FrameLayout>` is the root of a layout and does not provide background or padding etc, it can often be replaced with a `<merge>` tag which is slightly more efficient. Note that this depends on context, so make sure you understand how the `<merge>` tag works before proceeding.", Category.PERFORMANCE, 4, Severity.WARNING, new Implementation(MergeRootFrameLayoutDetector.class, EnumSet.of(Scope.ALL_RESOURCE_FILES, Scope.JAVA_FILE))).addMoreInfo("http://android-developers.blogspot.com/2009/03/android-layout-tricks-3-optimize-by.html");

    @Override
    public void afterCheckRootProject(Context context2) {
        if (this.mPending != null && this.mWhitelistedLayouts != null) {
            for (Pair<String, Location.Handle> pair : this.mPending) {
                Location.Handle handle;
                Object clientData;
                String layout = (String)pair.getFirst();
                if (!this.mWhitelistedLayouts.contains(layout) || (clientData = (handle = (Location.Handle)pair.getSecond()).getClientData()) instanceof Node && context2.getDriver().isSuppressed(null, ISSUE, (Node)clientData)) continue;
                Location location = handle.resolve();
                context2.report(ISSUE, location, "This `<FrameLayout>` can be replaced with a `<merge>` tag");
            }
        }
    }

    @Override
    public Collection<String> getApplicableElements() {
        return Arrays.asList("include", "FrameLayout");
    }

    @Override
    public void visitElement(XmlContext context2, Element element) {
        String tag = element.getTagName();
        if (tag.equals("include")) {
            String layout = element.getAttribute("layout");
            if (layout.startsWith("@layout/")) {
                layout = layout.substring("@layout/".length());
                this.whiteListLayout(layout);
            }
        } else {
            assert (tag.equals("FrameLayout"));
            if (Lint.isRootElement(element) && (MergeRootFrameLayoutDetector.isWidthFillParent(element) && MergeRootFrameLayoutDetector.isHeightFillParent(element) || !element.hasAttributeNS("http://schemas.android.com/apk/res/android", "layout_gravity")) && !element.hasAttributeNS("http://schemas.android.com/apk/res/android", "background") && !element.hasAttributeNS("http://schemas.android.com/apk/res/android", "foreground") && !MergeRootFrameLayoutDetector.hasPadding(element)) {
                String layout = Lint.getLayoutName(context2.file);
                Location.Handle handle = context2.createLocationHandle(element);
                handle.setClientData(element);
                if (!context2.getProject().getReportIssues()) {
                    return;
                }
                if (this.mPending == null) {
                    this.mPending = new ArrayList<Pair<String, Location.Handle>>();
                }
                this.mPending.add((Pair<String, Location.Handle>)Pair.of((Object)layout, (Object)handle));
            }
        }
    }

    private void whiteListLayout(String layout) {
        if (this.mWhitelistedLayouts == null) {
            this.mWhitelistedLayouts = new HashSet<String>();
        }
        this.mWhitelistedLayouts.add(layout);
    }

    @Override
    public List<String> getApplicableMethodNames() {
        return Collections.singletonList("setContentView");
    }

    @Override
    public void visitMethodCall(JavaContext context2, UCallExpression call, PsiMethod method) {
        ResourceReference reference;
        List expressions = call.getValueArguments();
        if (expressions.size() == 1 && (reference = UastLintUtils.toAndroidReferenceViaResolve((UElement)expressions.get(0))) != null && reference.getType() == ResourceType.LAYOUT) {
            this.whiteListLayout(reference.getName());
        }
    }

    private static boolean isFillParent(Element element, String dimension) {
        String width = element.getAttributeNS("http://schemas.android.com/apk/res/android", dimension);
        return width.equals("match_parent") || width.equals("fill_parent");
    }

    protected static boolean isWidthFillParent(Element element) {
        return MergeRootFrameLayoutDetector.isFillParent(element, "layout_width");
    }

    protected static boolean isHeightFillParent(Element element) {
        return MergeRootFrameLayoutDetector.isFillParent(element, "layout_height");
    }

    protected static boolean hasPadding(Element root) {
        return root.hasAttributeNS("http://schemas.android.com/apk/res/android", "padding") || root.hasAttributeNS("http://schemas.android.com/apk/res/android", "paddingLeft") || root.hasAttributeNS("http://schemas.android.com/apk/res/android", "paddingRight") || root.hasAttributeNS("http://schemas.android.com/apk/res/android", "paddingTop") || root.hasAttributeNS("http://schemas.android.com/apk/res/android", "paddingBottom");
    }
}

