/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.SdkConstants;
import com.android.builder.model.AndroidProject;
import com.android.builder.model.BuildTypeContainer;
import com.android.support.AndroidxName;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ConstantEvaluator;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.TypeEvaluator;
import com.android.tools.lint.detector.api.UastLintUtils;
import com.google.common.collect.Sets;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UFile;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.USimpleNameReferenceExpression;
import org.jetbrains.uast.UastUtils;

public class ObjectAnimatorDetector
extends Detector
implements SourceCodeScanner {
    public static final AndroidxName KEEP_ANNOTATION = AndroidxName.of((AndroidxName)SdkConstants.SUPPORT_ANNOTATIONS_PREFIX, (String)"Keep");
    private static final Implementation IMPLEMENTATION = new Implementation(ObjectAnimatorDetector.class, Scope.JAVA_FILE_SCOPE);
    public static final Issue MISSING_KEEP = Issue.create("AnimatorKeep", "Missing @Keep for Animated Properties", "When you use property animators, properties can be accessed via reflection. Those methods should be annotated with @Keep to ensure that during release builds, the methods are not potentially treated as unused and removed, or treated as internal only and get renamed to something shorter.\n\nThis check will also flag other potential reflection problems it encounters, such as a missing property, wrong argument types, etc.", Category.PERFORMANCE, 4, Severity.WARNING, IMPLEMENTATION).setAndroidSpecific(true);
    public static final Issue BROKEN_PROPERTY = Issue.create("ObjectAnimatorBinding", "Incorrect ObjectAnimator Property", "This check cross references properties referenced by String from `ObjectAnimator` and `PropertyValuesHolder` method calls and ensures that the corresponding setter methods exist and have the right signatures.", Category.CORRECTNESS, 4, Severity.ERROR, IMPLEMENTATION).setAndroidSpecific(true);
    private Set<Object> mAlreadyWarned;

    @Override
    public List<String> getApplicableMethodNames() {
        return Arrays.asList("ofInt", "ofArgb", "ofFloat", "ofMultiInt", "ofMultiFloat", "ofObject", "ofPropertyValuesHolder");
    }

    @Override
    public void visitMethodCall(JavaContext context2, UCallExpression call, PsiMethod method) {
        JavaEvaluator evaluator = context2.getEvaluator();
        if (!(evaluator.isMemberInClass((PsiMember)method, "android.animation.ObjectAnimator") || method.getName().equals("ofPropertyValuesHolder") && evaluator.isMemberInClass((PsiMember)method, "android.animation.ValueAnimator"))) {
            return;
        }
        List expressions = call.getValueArguments();
        if (expressions.size() < 2) {
            return;
        }
        PsiType type = TypeEvaluator.evaluate((UElement)expressions.get(0));
        if (!(type instanceof PsiClassType)) {
            return;
        }
        PsiClass targetClass = ((PsiClassType)type).resolve();
        if (targetClass == null) {
            return;
        }
        String methodName = method.getName();
        if (methodName.equals("ofPropertyValuesHolder")) {
            if (!evaluator.isMemberInClass((PsiMember)method, "android.animation.ObjectAnimator")) {
                return;
            }
            this.checkPropertyValueHolders(context2, targetClass, expressions);
        } else {
            String expectedType = ObjectAnimatorDetector.getExpectedType(call, 2);
            if (expectedType != null) {
                this.checkProperty(context2, (UExpression)expressions.get(1), targetClass, expectedType);
            }
        }
    }

    private static String getExpectedType(UCallExpression method, int evaluatorIndex) {
        String methodName = Lint.getMethodName(method);
        if (methodName == null) {
            return null;
        }
        switch (methodName) {
            case "ofArgb": 
            case "ofInt": {
                return "int";
            }
            case "ofFloat": {
                return "float";
            }
            case "ofMultiInt": {
                return "int[]";
            }
            case "ofMultiFloat": {
                return "float[]";
            }
            case "ofKeyframe": {
                return "android.animation.Keyframe";
            }
            case "ofObject": {
                PsiType evaluatorType;
                List args = method.getValueArguments();
                if (args.size() <= evaluatorIndex || (evaluatorType = TypeEvaluator.evaluate((UElement)args.get(evaluatorIndex))) == null) break;
                String typeName = evaluatorType.getCanonicalText();
                if ("android.animation.FloatEvaluator".equals(typeName)) {
                    return "float";
                }
                if ("android.animation.FloatArrayEvaluator".equals(typeName)) {
                    return "float[]";
                }
                if ("android.animation.IntEvaluator".equals(typeName) || "android.animation.ArgbEvaluator".equals(typeName)) {
                    return "int";
                }
                if ("android.animation.IntArrayEvaluator".equals(typeName)) {
                    return "int[]";
                }
                if (!"android.animation.PointFEvaluator".equals(typeName)) break;
                return "android.graphics.PointF";
            }
        }
        return null;
    }

    private void checkPropertyValueHolders(JavaContext context2, PsiClass targetClass, List<UExpression> expressions) {
        for (int i = 1; i < expressions.size(); ++i) {
            String expectedType;
            List args;
            UExpression arg = expressions.get(i);
            UCallExpression holder = ObjectAnimatorDetector.findHolderConstruction(context2, arg);
            if (holder == null || (args = holder.getValueArguments()).size() < 2 || (expectedType = ObjectAnimatorDetector.getExpectedType(holder, 1)) == null) continue;
            this.checkProperty(context2, (UExpression)args.get(0), targetClass, expectedType);
        }
    }

    private static UCallExpression findHolderConstruction(JavaContext context2, UExpression arg) {
        if (arg == null) {
            return null;
        }
        if (arg instanceof UCallExpression) {
            UCallExpression callExpression = (UCallExpression)arg;
            if (ObjectAnimatorDetector.isHolderConstructionMethod(context2, callExpression)) {
                return callExpression;
            }
        } else if (arg instanceof UReferenceExpression) {
            UCallExpression selector;
            UQualifiedReferenceExpression qualified;
            if (arg instanceof UQualifiedReferenceExpression && (qualified = (UQualifiedReferenceExpression)arg).getSelector() instanceof UCallExpression && ObjectAnimatorDetector.isHolderConstructionMethod(context2, selector = (UCallExpression)qualified.getSelector())) {
                return selector;
            }
            PsiElement resolved = ((UReferenceExpression)arg).resolve();
            if (resolved instanceof PsiVariable) {
                UCallExpression callExpression;
                UQualifiedReferenceExpression expression;
                PsiElement el;
                PsiVariable variable = (PsiVariable)resolved;
                UExpression lastAssignment = UastLintUtils.findLastAssignment(variable, (UElement)arg);
                while (lastAssignment instanceof USimpleNameReferenceExpression && (el = ((USimpleNameReferenceExpression)lastAssignment).resolve()) instanceof PsiLocalVariable) {
                    lastAssignment = UastLintUtils.findLastAssignment((PsiVariable)((PsiLocalVariable)el), (UElement)lastAssignment);
                }
                if (lastAssignment instanceof UCallExpression) {
                    UCallExpression callExpression2 = (UCallExpression)lastAssignment;
                    if (ObjectAnimatorDetector.isHolderConstructionMethod(context2, callExpression2)) {
                        return callExpression2;
                    }
                } else if (lastAssignment instanceof UQualifiedReferenceExpression && (expression = (UQualifiedReferenceExpression)lastAssignment).getSelector() instanceof UCallExpression && ObjectAnimatorDetector.isHolderConstructionMethod(context2, callExpression = (UCallExpression)expression.getSelector())) {
                    return callExpression;
                }
            }
        }
        return null;
    }

    private static boolean isHolderConstructionMethod(JavaContext context2, UCallExpression callExpression) {
        PsiMethod resolved;
        String referenceName = Lint.getMethodName(callExpression);
        return referenceName != null && referenceName.startsWith("of") && !referenceName.equals("ofKeyframe") && (resolved = callExpression.resolve()) != null && context2.getEvaluator().isMemberInClass((PsiMember)resolved, "android.animation.PropertyValuesHolder");
    }

    private void checkProperty(JavaContext context2, UExpression propertyNameExpression, PsiClass targetClass, String expectedType) {
        Object property = ConstantEvaluator.evaluate(context2, (UElement)propertyNameExpression);
        if (!(property instanceof String)) {
            return;
        }
        String propertyName = (String)property;
        String qualifiedName = targetClass.getQualifiedName();
        if (qualifiedName == null || qualifiedName.indexOf(46) == -1) {
            return;
        }
        String methodName = ObjectAnimatorDetector.getMethodName("set", propertyName);
        PsiMethod[] methods = targetClass.findMethodsByName(methodName, true);
        PsiMethod bestMethod = null;
        boolean isExactMatch = false;
        for (PsiMethod m : methods) {
            if (m.getParameterList().getParametersCount() == 1) {
                if (bestMethod == null) {
                    bestMethod = m;
                }
                if (!context2.getEvaluator().parametersMatch(m, expectedType)) continue;
                bestMethod = m;
                isExactMatch = true;
                break;
            }
            if (bestMethod != null) continue;
            bestMethod = m;
        }
        if (bestMethod == null) {
            this.report(context2, BROKEN_PROPERTY, propertyNameExpression, null, String.format("Could not find property setter method `%1$s` on `%2$s`", methodName, qualifiedName), null);
            return;
        }
        if (!isExactMatch) {
            this.report(context2, BROKEN_PROPERTY, propertyNameExpression, bestMethod, String.format("The setter for this property does not match the expected signature (`public void %1$s(%2$s arg`)", methodName, expectedType), null);
        } else if (context2.getEvaluator().isStatic((PsiModifierListOwner)bestMethod)) {
            this.report(context2, BROKEN_PROPERTY, propertyNameExpression, bestMethod, String.format("The setter for this property (%1$s.%2$s) should not be static", qualifiedName, methodName), null);
        } else {
            PsiMethod owner = bestMethod;
            while (owner != null) {
                PsiModifierList modifierList = owner.getModifierList();
                if (modifierList != null) {
                    for (PsiAnnotation annotation : modifierList.getAnnotations()) {
                        if (!KEEP_ANNOTATION.isEquals(annotation.getQualifiedName())) continue;
                        return;
                    }
                }
                owner = (PsiModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)owner, PsiModifierListOwner.class, (boolean)true);
            }
            if (!ObjectAnimatorDetector.isMinifying(context2)) {
                return;
            }
            this.report(context2, MISSING_KEEP, propertyNameExpression, bestMethod, "This method is accessed from an ObjectAnimator so it should be annotated with `@Keep` to ensure that it is not discarded or renamed in release builds", this.fix().data(bestMethod));
        }
    }

    private void report(JavaContext context2, Issue issue, UExpression propertyNameExpression, PsiMethod method, String message2, LintFix fix) {
        Location location;
        PsiMethod locationNode;
        boolean reportOnMethod;
        boolean bl = reportOnMethod = issue == MISSING_KEEP && method != null;
        if (reportOnMethod && method instanceof PsiCompiledElement) {
            return;
        }
        Object object = locationNode = reportOnMethod ? method : propertyNameExpression;
        if (this.mAlreadyWarned != null && this.mAlreadyWarned.contains(locationNode)) {
            return;
        }
        if (this.mAlreadyWarned == null) {
            this.mAlreadyWarned = Sets.newIdentityHashSet();
        }
        this.mAlreadyWarned.add(locationNode);
        Location methodLocation = null;
        if (method != null && !(method instanceof PsiCompiledElement)) {
            Location location2 = methodLocation = method.getNameIdentifier() != null ? context2.getRangeLocation((PsiElement)method.getNameIdentifier(), 0, (PsiElement)method.getParameterList(), 0) : context2.getNameLocation((PsiElement)method);
        }
        if (reportOnMethod) {
            location = methodLocation;
            Location secondary = context2.getLocation((UElement)propertyNameExpression);
            location.setSecondary(secondary);
            secondary.setMessage("ObjectAnimator usage here");
            if (ObjectAnimatorDetector.isInSameCompilationUnit((UElement)propertyNameExpression, (PsiElement)method)) {
                secondary.setVisible(false);
            } else {
                assert (issue == MISSING_KEEP);
                String secondaryMessage = String.format("The method referenced here (%1$s) has not been annotated with `@Keep` which means it could be discarded or renamed in release builds", method.getName());
                if (location == Location.NONE) {
                    location = secondary;
                    message2 = secondaryMessage;
                } else {
                    secondary.setMessage(secondaryMessage);
                }
            }
        } else {
            location = context2.getNameLocation((UElement)propertyNameExpression);
            if (methodLocation != null) {
                location = location.withSecondary(methodLocation, "Property setter here");
            }
        }
        UElement owner = UastUtils.getParentOfType((UElement)propertyNameExpression, UDeclaration.class, (boolean)false);
        if (owner != null && context2.getDriver().isSuppressed(context2, issue, owner)) {
            return;
        }
        context2.report(issue, (PsiElement)method, location, message2, fix);
    }

    private static boolean isInSameCompilationUnit(UElement element1, PsiElement element2) {
        PsiElement psi;
        PsiFile file;
        UFile containingFile = UastUtils.getContainingFile((UElement)element1);
        PsiFile psiFile = file = containingFile != null ? containingFile.getPsi() : null;
        if (file == null && (psi = element1.getPsi()) != null) {
            file = psi.getContainingFile();
        }
        return Objects.equals(file, element2.getContainingFile());
    }

    private static String getMethodName(String prefix, String propertyName) {
        if (propertyName == null || propertyName.length() == 0) {
            return prefix;
        }
        char firstLetter = Character.toUpperCase(propertyName.charAt(0));
        String theRest = propertyName.substring(1);
        return prefix + firstLetter + theRest;
    }

    private static boolean isMinifying(JavaContext context2) {
        Project project = context2.getMainProject();
        if (!project.isGradleProject()) {
            return true;
        }
        AndroidProject model = project.getGradleProjectModel();
        if (model != null) {
            for (BuildTypeContainer buildTypeContainer : model.getBuildTypes()) {
                if (!buildTypeContainer.getBuildType().isMinifyEnabled()) continue;
                return true;
            }
        } else {
            return true;
        }
        return false;
    }
}

