/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.utils.CharSequences;
import com.android.utils.SdkUtils;
import com.google.common.base.Splitter;
import java.io.File;
import java.util.Arrays;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0002J0\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\fH\u0002J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0017"}, d2={"Lcom/android/tools/lint/checks/PropertyFileDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "()V", "checkEscapes", "", "context", "Lcom/android/tools/lint/detector/api/Context;", "contents", "", "line", "", "offset", "", "valueStart", "checkLine", "isGitIgnored", "", "client", "Lcom/android/tools/lint/client/api/LintClient;", "file", "Ljava/io/File;", "run", "Companion", "android.sdktools.lint-checks"})
public final class PropertyFileDetector
extends Detector {
    @JvmField
    @NotNull
    public static final Issue ESCAPE;
    @JvmField
    @NotNull
    public static final Issue HTTP;
    @JvmField
    @NotNull
    public static final Issue PROXY_PASSWORD;
    public static final Companion Companion;

    @Override
    public void run(@NotNull Context context2) {
        CharSequence charSequence = context2.getContents();
        if (charSequence == null) {
            return;
        }
        CharSequence contents = charSequence;
        int offset = 0;
        Iterator iterator = Splitter.on((char)'\n').split(contents).iterator();
        String line = null;
        while (iterator.hasNext()) {
            line = (String)iterator.next();
            if (StringsKt.startsWith$default((String)line, (String)"#", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)line, (String)" ", (boolean)false, (int)2, null)) {
                offset += line.length() + 1;
                continue;
            }
            int valueStart = StringsKt.indexOf$default((CharSequence)line, (char)'=', (int)0, (boolean)false, (int)6, null) + 1;
            if (valueStart == 0) {
                offset += line.length() + 1;
                continue;
            }
            this.checkLine(context2, contents, offset, line, valueStart);
            offset += line.length() + 1;
        }
    }

    private final void checkLine(Context context2, CharSequence contents, int offset, String line, int valueStart) {
        String distributionPrefix = "distributionUrl=http\\";
        if (StringsKt.startsWith$default((String)line, (String)distributionPrefix, (boolean)false, (int)2, null)) {
            String string = line;
            int n = distributionPrefix.length() - 1;
            StringBuilder stringBuilder = new StringBuilder().append("https");
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(n);
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
            String string4 = string3;
            String https = stringBuilder.append(string4).toString();
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string5 = "Replace HTTP with HTTPS for better security; use %1$s";
            Object[] objectArray = new Object[]{StringsKt.replace$default((String)https, (String)"\\", (String)"\\\\", (boolean)false, (int)4, null)};
            boolean bl2 = false;
            String string6 = String.format(string5, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"java.lang.String.format(format, *args)");
            String message2 = string6;
            int startOffset = offset + valueStart;
            int endOffset = startOffset + 4;
            LintFix fix = LintFix.create().replace().text("http").with("https").build();
            Location location = Location.Companion.create(context2.file, contents, startOffset, endOffset);
            context2.report(HTTP, location, message2, fix);
        } else if (StringsKt.startsWith$default((String)line, (String)"systemProp.http.proxyPassword=", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)line, (String)"systemProp.https.proxyPassword=", (boolean)false, (int)2, null)) {
            if (this.isGitIgnored(context2.getClient(), context2.file)) {
                return;
            }
            int startOffset = offset + valueStart;
            int endOffset = line.length();
            Location location = Location.Companion.create(context2.file, contents, startOffset, endOffset);
            Context.report$default(context2, PROXY_PASSWORD, location, "Storing passwords in clear text is risky; make sure this file is not shared or checked in via version control", null, 8, null);
        } else if (StringsKt.indexOf$default((CharSequence)line, (char)'\\', (int)0, (boolean)false, (int)6, null) != -1 || StringsKt.indexOf$default((CharSequence)line, (char)':', (int)0, (boolean)false, (int)6, null) != -1) {
            this.checkEscapes(context2, contents, line, offset, valueStart);
        }
    }

    private final boolean isGitIgnored(LintClient client, File file) {
        for (File curr = file.getParentFile(); curr != null; curr = curr.getParentFile()) {
            CharSequence ignored;
            File ignoreFile = new File(curr, ".gitignore");
            if (!ignoreFile.exists() || CharSequences.indexOf((CharSequence)(ignored = client.readFile(ignoreFile)), (CharSequence)file.getName()) == -1) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final void checkEscapes(Context context2, CharSequence contents, String line, int offset, int valueStart) {
        boolean escaped = false;
        boolean hadNonPathEscape = false;
        int errorStart = -1;
        int errorEnd = -1;
        StringBuilder path2 = new StringBuilder();
        int n = valueStart;
        int n2 = line.length();
        while (n < n2) {
            void i;
            char c = line.charAt((int)i);
            if (c == '\\') {
                boolean bl = escaped = !escaped;
                if (escaped) {
                    path2.append(c);
                }
            } else if (c == ':') {
                if (!escaped) {
                    hadNonPathEscape = true;
                    if (errorStart < 0) {
                        errorStart = i;
                    }
                    errorEnd = i;
                } else {
                    escaped = false;
                }
                path2.append(c);
            } else {
                if (escaped) {
                    hadNonPathEscape = true;
                    if (errorStart < 0) {
                        errorStart = i;
                    }
                    errorEnd = i;
                }
                escaped = false;
                path2.append(c);
            }
            ++i;
        }
        String pathString = path2.toString();
        String c = line;
        int n3 = 0;
        int n4 = 0;
        String string = c;
        if (string == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string2 = string.substring(n3, valueStart);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String key = string2;
        if (hadNonPathEscape && StringsKt.endsWith$default((String)key, (String)".dir=", (boolean)false, (int)2, null) || new File(pathString).exists()) {
            String string3 = line;
            n4 = line.length();
            Companion companion = Companion;
            boolean bl = false;
            String string4 = string3;
            if (string4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.substring(valueStart, n4);
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            String string6 = string5;
            String escapedPath = companion.suggestEscapes(string6);
            String message2 = "Windows file separators (`\\`) and drive letter separators (':') must be escaped (`\\\\`) in property files; use " + StringsKt.replace$default((String)escapedPath, (String)"\\", (String)"\\\\", (boolean)false, (int)4, null);
            int startOffset = offset + errorStart;
            int endOffset = offset + errorEnd + 1;
            String locationRange = ((Object)contents.subSequence(startOffset, endOffset)).toString();
            String escapedRange = Companion.suggestEscapes(locationRange);
            LintFix fix = LintFix.create().name("Escape").replace().text(locationRange).with(escapedRange).build();
            Location location = Location.Companion.create(context2.file, contents, startOffset, endOffset);
            context2.report(ESCAPE, location, message2, fix);
        }
    }

    static {
        Companion = new Companion(null);
        ESCAPE = Issue.Companion.create("PropertyEscape", "Incorrect property escapes", "\n                All backslashes and colons in .property files must be escaped with a \\\n                backslash (\\). This means that when writing a Windows path, you must \\\n                escape the file separators, so the path \\My\\Files should be written as \\\n                `key=\\\\My\\\\Files.`", Category.CORRECTNESS, 6, Severity.ERROR, new Implementation(PropertyFileDetector.class, Scope.PROPERTY_SCOPE));
        HTTP = Issue.Companion.create("UsingHttp", "Using HTTP instead of HTTPS", "\n                The Gradle Wrapper is available both via HTTP and HTTPS. HTTPS is more \\\n                secure since it protects against man-in-the-middle attacks etc. Older \\\n                projects created in Android Studio used HTTP but we now default to HTTPS \\\n                and recommend upgrading existing projects.", Category.SECURITY, 6, Severity.WARNING, new Implementation(PropertyFileDetector.class, Scope.PROPERTY_SCOPE));
        PROXY_PASSWORD = Issue.Companion.create("ProxyPassword", "Proxy Password in Cleartext", "\n                Storing proxy server passwords in clear text is dangerous if this file is \\\n                shared via version control. If this is deliberate or this is a truly private \\\n                project, suppress this warning.", Category.SECURITY, 2, Severity.WARNING, new Implementation(PropertyFileDetector.class, Scope.PROPERTY_SCOPE));
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bR\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/android/tools/lint/checks/PropertyFileDetector$Companion;", "", "()V", "ESCAPE", "Lcom/android/tools/lint/detector/api/Issue;", "HTTP", "PROXY_PASSWORD", "suggestEscapes", "", "value", "android.sdktools.lint-checks"})
    public static final class Companion {
        @NotNull
        public final String suggestEscapes(@NotNull String value) {
            String escaped = StringsKt.replace$default((String)StringsKt.replace$default((String)value, (String)"\\:", (String)":", (boolean)false, (int)4, null), (String)"\\\\", (String)"\\", (boolean)false, (int)4, null);
            return SdkUtils.escapePropertyValue((String)escaped);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

