/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.SliceDetector;
import com.android.tools.lint.client.api.UElementHandler;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ConstantEvaluator;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.tools.lint.detector.api.XmlScanner;
import com.android.utils.XmlUtils;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.USimpleNameReferenceExpression;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SecurityDetector
extends Detector
implements XmlScanner,
SourceCodeScanner {
    private static final Implementation IMPLEMENTATION_MANIFEST = new Implementation(SecurityDetector.class, Scope.MANIFEST_SCOPE);
    private static final Implementation IMPLEMENTATION_JAVA = new Implementation(SecurityDetector.class, Scope.JAVA_FILE_SCOPE);
    public static final Issue EXPORTED_SERVICE = Issue.create("ExportedService", "Exported service does not require permission", "Exported services (services which either set `exported=true` or contain an intent-filter and do not specify `exported=false`) should define a permission that an entity must have in order to launch the service or bind to it. Without this, any application can use this service.", Category.SECURITY, 5, Severity.WARNING, IMPLEMENTATION_MANIFEST).setAndroidSpecific(true);
    public static final Issue EXPORTED_PROVIDER = Issue.create("ExportedContentProvider", "Content provider does not require permission", "Content providers are exported by default and any application on the system can potentially use them to read and write data. If the content provider provides access to sensitive data, it should be protected by specifying `export=false` in the manifest or by protecting it with a permission that can be granted to other applications.", Category.SECURITY, 5, Severity.WARNING, IMPLEMENTATION_MANIFEST).setAndroidSpecific(true);
    public static final Issue EXPORTED_RECEIVER = Issue.create("ExportedReceiver", "Receiver does not require permission", "Exported receivers (receivers which either set `exported=true` or contain an intent-filter and do not specify `exported=false`) should define a permission that an entity must have in order to launch the receiver or bind to it. Without this, any application can use this receiver.", Category.SECURITY, 5, Severity.WARNING, IMPLEMENTATION_MANIFEST).setAndroidSpecific(true);
    public static final Issue OPEN_PROVIDER = Issue.create("GrantAllUris", "Content provider shares everything", "The `<grant-uri-permission>` element allows specific paths to be shared. This detector checks for a path URL of just '/' (everything), which is probably not what you want; you should limit access to a subset.", Category.SECURITY, 7, Severity.WARNING, IMPLEMENTATION_MANIFEST).setAndroidSpecific(true);
    public static final Issue SET_READABLE = Issue.create("SetWorldReadable", "`File.setReadable()` used to make file world-readable", "Setting files world-readable is very dangerous, and likely to cause security holes in applications. It is strongly discouraged; instead, applications should use more formal mechanisms for interactions such as `ContentProvider`, `BroadcastReceiver`, and `Service`.", Category.SECURITY, 6, Severity.WARNING, IMPLEMENTATION_JAVA).setAndroidSpecific(true);
    public static final Issue SET_WRITABLE = Issue.create("SetWorldWritable", "`File.setWritable()` used to make file world-writable", "Setting files world-writable is very dangerous, and likely to cause security holes in applications. It is strongly discouraged; instead, applications should use more formal mechanisms for interactions such as `ContentProvider`, `BroadcastReceiver`, and `Service`.", Category.SECURITY, 6, Severity.WARNING, IMPLEMENTATION_JAVA).setAndroidSpecific(true);
    public static final Issue WORLD_WRITEABLE = Issue.create("WorldWriteableFiles", "`openFileOutput()` or similar call passing `MODE_WORLD_WRITEABLE`", "There are cases where it is appropriate for an application to write world writeable files, but these should be reviewed carefully to ensure that they contain no private data, and that if the file is modified by a malicious application it does not trick or compromise your application.", Category.SECURITY, 4, Severity.WARNING, IMPLEMENTATION_JAVA).setAndroidSpecific(true);
    public static final Issue WORLD_READABLE = Issue.create("WorldReadableFiles", "`openFileOutput()` or similar call passing `MODE_WORLD_READABLE`", "There are cases where it is appropriate for an application to write world readable files, but these should be reviewed carefully to ensure that they contain no private data that is leaked to other applications.", Category.SECURITY, 4, Severity.WARNING, IMPLEMENTATION_JAVA).setAndroidSpecific(true);
    private static final String FILE_CLASS = "java.io.File";

    @Override
    public Collection<String> getApplicableElements() {
        return Arrays.asList("service", "grant-uri-permission", "provider", "activity", "receiver");
    }

    @Override
    public void visitElement(XmlContext context2, Element element) {
        String tag;
        switch (tag = element.getTagName()) {
            case "service": {
                SecurityDetector.checkService(context2, element);
                break;
            }
            case "grant-uri-permission": {
                SecurityDetector.checkGrantPermission(context2, element);
                break;
            }
            case "provider": {
                SecurityDetector.checkProvider(context2, element);
                break;
            }
            case "receiver": {
                SecurityDetector.checkReceiver(context2, element);
            }
        }
    }

    public static boolean getExported(Element element) {
        String exportValue = element.getAttributeNS("http://schemas.android.com/apk/res/android", "exported");
        if (exportValue != null && !exportValue.isEmpty()) {
            return Boolean.valueOf(exportValue);
        }
        for (Element child : XmlUtils.getSubTags((Node)element)) {
            if (!child.getTagName().equals("intent-filter")) continue;
            return true;
        }
        return false;
    }

    private static boolean isUnprotectedByPermission(Element element) {
        Node parent;
        String permission = element.getAttributeNS("http://schemas.android.com/apk/res/android", "permission");
        if ("TODO".equals(permission)) {
            return true;
        }
        if ((permission == null || permission.isEmpty()) && (parent = element.getParentNode()).getNodeType() == 1 && parent.getNodeName().equals("application")) {
            Element application = (Element)parent;
            permission = application.getAttributeNS("http://schemas.android.com/apk/res/android", "permission");
            return permission == null || permission.isEmpty();
        }
        return false;
    }

    private static boolean isWearableListenerServiceAction(Element element) {
        for (Element child : XmlUtils.getSubTags((Node)element)) {
            if (!child.getTagName().equals("intent-filter")) continue;
            for (Element innerChild : XmlUtils.getSubTags((Node)child)) {
                String name;
                if (!innerChild.getTagName().equals("action") || !"com.google.android.gms.wearable.BIND_LISTENER".equals(name = innerChild.getAttributeNS("http://schemas.android.com/apk/res/android", "name")) && !"com.google.android.gms.wearable.DATA_CHANGED".equals(name) && !"com.google.android.gms.wearable.MESSAGE_RECEIVED".equals(name) && !"com.google.android.gms.wearable.CAPABILITY_CHANGED".equals(name) && !"com.google.android.gms.wearable.CHANNEL_EVENT".equals(name)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isStandardReceiver(Element element) {
        String name = element.getAttributeNS("http://schemas.android.com/apk/res/android", "name");
        if ("com.google.android.gms.tagmanager.InstallReferrerReceiver".equals(name)) {
            return true;
        }
        for (Element child : XmlUtils.getSubTags((Node)element)) {
            if (!child.getTagName().equals("intent-filter")) continue;
            for (Element innerChild : XmlUtils.getSubTags((Node)child)) {
                if (!innerChild.getTagName().equals("action")) continue;
                String categoryString = innerChild.getAttributeNS("http://schemas.android.com/apk/res/android", "name");
                return categoryString.startsWith("android.");
            }
        }
        return false;
    }

    private static void checkReceiver(XmlContext context2, Element element) {
        if (SecurityDetector.getExported(element) && SecurityDetector.isUnprotectedByPermission(element) && !SecurityDetector.isStandardReceiver(element)) {
            LintFix fix = LintFix.create().set().todo("http://schemas.android.com/apk/res/android", "permission").build();
            context2.report(EXPORTED_RECEIVER, (Node)element, context2.getNameLocation(element), "Exported receiver does not require permission", fix);
        }
    }

    private static void checkService(XmlContext context2, Element element) {
        if (SecurityDetector.getExported(element) && SecurityDetector.isUnprotectedByPermission(element) && !SecurityDetector.isWearableListenerServiceAction(element)) {
            LintFix fix = LintFix.create().set().todo("http://schemas.android.com/apk/res/android", "permission").build();
            context2.report(EXPORTED_SERVICE, (Node)element, context2.getNameLocation(element), "Exported service does not require permission", fix);
        }
    }

    private static void checkGrantPermission(XmlContext context2, Element element) {
        Attr path2 = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "path");
        Attr prefix = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "pathPrefix");
        Attr pattern = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "pathPattern");
        String msg = "Content provider shares everything; this is potentially dangerous.";
        if (path2 != null && path2.getValue().equals("/")) {
            context2.report(OPEN_PROVIDER, path2, context2.getLocation(path2), msg);
        }
        if (prefix != null && prefix.getValue().equals("/")) {
            context2.report(OPEN_PROVIDER, prefix, context2.getLocation(prefix), msg);
        }
        if (pattern != null && pattern.getValue().equals("/")) {
            context2.report(OPEN_PROVIDER, pattern, context2.getLocation(pattern), msg);
        }
    }

    private static void checkProvider(XmlContext context2, Element element) {
        String permission;
        String exportValue = element.getAttributeNS("http://schemas.android.com/apk/res/android", "exported");
        boolean exported = true;
        if (exportValue != null && !exportValue.isEmpty()) {
            exported = Boolean.valueOf(exportValue);
        }
        if (exported && ((permission = element.getAttributeNS("http://schemas.android.com/apk/res/android", "readPermission")) == null || permission.isEmpty()) && ((permission = element.getAttributeNS("http://schemas.android.com/apk/res/android", "writePermission")) == null || permission.isEmpty()) && ((permission = element.getAttributeNS("http://schemas.android.com/apk/res/android", "permission")) == null || permission.isEmpty())) {
            boolean hasPermission = false;
            for (Element child : XmlUtils.getSubTags((Node)element)) {
                String tag = child.getTagName();
                if (!tag.equals("path-permission")) continue;
                hasPermission = true;
                break;
            }
            if (SliceDetector.Companion.isSliceProvider(element)) {
                return;
            }
            if (!hasPermission) {
                LintFix fix = LintFix.create().set("http://schemas.android.com/apk/res/android", "exported", "false").build();
                context2.report(EXPORTED_PROVIDER, (Node)element, context2.getNameLocation(element), "Exported content providers can provide access to potentially sensitive data", fix);
            }
        }
    }

    @Override
    public List<String> getApplicableMethodNames() {
        return Arrays.asList("openFileOutput", "getSharedPreferences", "getDir", "setReadable", "setWritable");
    }

    @Override
    public void visitMethodCall(JavaContext context2, UCallExpression node, PsiMethod method) {
        List args = node.getValueArguments();
        String methodName = Lint.getMethodName(node);
        if (context2.getEvaluator().isMemberInSubClassOf((PsiMember)method, FILE_CLASS, false)) {
            if ("setReadable".equals(methodName)) {
                if (args.size() == 2 && Boolean.TRUE.equals(ConstantEvaluator.evaluate(context2, (UElement)args.get(0))) && Boolean.FALSE.equals(ConstantEvaluator.evaluate(context2, (UElement)args.get(1)))) {
                    context2.report(SET_READABLE, (UElement)node, context2.getLocation((UElement)node), "Setting file permissions to world-readable can be risky, review carefully");
                }
            } else if ("setWritable".equals(methodName) && args.size() == 2 && Boolean.TRUE.equals(ConstantEvaluator.evaluate(context2, (UElement)args.get(0))) && Boolean.FALSE.equals(ConstantEvaluator.evaluate(context2, (UElement)args.get(1)))) {
                context2.report(SET_WRITABLE, (UElement)node, context2.getLocation((UElement)node), "Setting file permissions to world-writable can be risky, review carefully");
            }
        }
    }

    @Override
    public List<Class<? extends UElement>> getApplicableUastTypes() {
        return Collections.singletonList(USimpleNameReferenceExpression.class);
    }

    @Override
    public UElementHandler createUastHandler(JavaContext context2) {
        return new IdentifierVisitor(context2);
    }

    private static class IdentifierVisitor
    extends UElementHandler {
        private final JavaContext context;

        public IdentifierVisitor(JavaContext context2) {
            this.context = context2;
        }

        @Override
        public void visitSimpleNameReferenceExpression(USimpleNameReferenceExpression node) {
            String name = node.getIdentifier();
            if ("MODE_WORLD_WRITEABLE".equals(name)) {
                Location location = this.context.getLocation((UElement)node);
                this.context.report(WORLD_WRITEABLE, (UElement)node, location, "Using `MODE_WORLD_WRITEABLE` when creating files can be risky, review carefully");
            } else if ("MODE_WORLD_READABLE".equals(name)) {
                Location location = this.context.getLocation((UElement)node);
                this.context.report(WORLD_READABLE, (UElement)node, location, "Using `MODE_WORLD_READABLE` when creating files can be risky, review carefully");
            }
        }
    }
}

