/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.tools.lint.detector.api.XmlScanner;
import java.util.Collection;
import java.util.Collections;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;

public class SignatureOrSystemDetector
extends Detector
implements XmlScanner {
    public static final Issue ISSUE = Issue.create("SignatureOrSystemPermissions", "signatureOrSystem permissions declared", "The `signature` protection level should probably be sufficient for most needs and works regardless of where applications are installed. The `signatureOrSystem` level is used for certain situations where multiple vendors have applications built into a system image and need to share specific features explicitly because they are being built together.", Category.SECURITY, 5, Severity.WARNING, new Implementation(SignatureOrSystemDetector.class, Scope.MANIFEST_SCOPE));
    private static final String SIGNATURE_OR_SYSTEM = "signatureOrSystem";

    @Override
    public Collection<String> getApplicableAttributes() {
        return Collections.singletonList("protectionLevel");
    }

    @Override
    public void visitAttribute(XmlContext context2, Attr attribute) {
        String protectionLevel = attribute.getValue();
        if (protectionLevel != null && protectionLevel.equals(SIGNATURE_OR_SYSTEM)) {
            String message2 = "`protectionLevel` should probably not be set to `signatureOrSystem`";
            LintFix fix = this.fix().replace().text(SIGNATURE_OR_SYSTEM).with("signature").build();
            context2.report(ISSUE, (Node)attribute, context2.getLocation(attribute), message2, fix);
        }
    }
}

