/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.SdkConstants;
import com.android.tools.lint.checks.AbstractAnnotationDetector;
import com.android.tools.lint.checks.AnnotationDetector;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.AnnotationUsageType;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.UastLintUtils;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UAnonymousClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.ULambdaExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 12\u00020\u00012\u00020\u0002:\u00011B\u0005\u00a2\u0006\u0002\u0010\u0003J(\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\b2\u000e\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005H\u0002J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u000bH\u0016JL\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u000b2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00150\u000bH\u0002J\u0016\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00150\u000bH\u0002J\u0010\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0002J\u001e\u0010\u001c\u001a\u00020\u00062\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00060\u000b2\u0006\u0010\u001e\u001a\u00020\u0019H\u0002J \u0010\u001f\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020\u0011H\u0002J\"\u0010!\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\"\u001a\u0004\u0018\u00010\u0013H\u0002J\u0018\u0010#\u001a\u00020\u00192\u0006\u0010$\u001a\u00020\u00062\u0006\u0010%\u001a\u00020\u0006H\u0002J\u001e\u0010#\u001a\u00020\u00192\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00060\u000b2\u0006\u0010%\u001a\u00020\u0006H\u0002J\u0010\u0010'\u001a\u00020\u00192\u0006\u0010\u0007\u001a\u00020\u0015H\u0002J|\u0010(\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010)\u001a\u00020\u00112\u0006\u0010*\u001a\u00020+2\u0006\u0010\u0007\u001a\u00020\u00152\u0006\u0010,\u001a\u00020\u00062\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\u0010-\u001a\u0004\u0018\u00010.2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00150\u000b2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00150\u000b2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00150\u000b2\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u00150\u000bH\u0016\u00a8\u00062"}, d2={"Lcom/android/tools/lint/checks/ThreadDetector;", "Lcom/android/tools/lint/checks/AbstractAnnotationDetector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "addThreadAnnotations", "", "", "annotation", "Lcom/intellij/psi/PsiAnnotation;", "result", "applicableAnnotations", "", "checkThreading", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "node", "Lorg/jetbrains/uast/UElement;", "method", "Lcom/intellij/psi/PsiMethod;", "signature", "Lorg/jetbrains/uast/UAnnotation;", "allMethodAnnotations", "allClassAnnotations", "containsThreadingAnnotation", "", "array", "describeThread", "describeThreads", "annotations", "any", "getThreadContext", "methodCall", "getThreads", "originalMethod", "isCompatibleThread", "caller", "callee", "callers", "isThreadingAnnotation", "visitAnnotationUsage", "usage", "type", "Lcom/android/tools/lint/detector/api/AnnotationUsageType;", "qualifiedName", "referenced", "Lcom/intellij/psi/PsiElement;", "allMemberAnnotations", "allPackageAnnotations", "Companion", "android.sdktools.lint-checks"})
public final class ThreadDetector
extends AbstractAnnotationDetector
implements SourceCodeScanner {
    private static final Implementation IMPLEMENTATION;
    @JvmField
    @NotNull
    public static final Issue THREAD;
    public static final Companion Companion;

    @Override
    @NotNull
    public List<String> applicableAnnotations() {
        return CollectionsKt.listOf((Object[])new String[]{AnnotationDetector.UI_THREAD_ANNOTATION.oldName(), AnnotationDetector.UI_THREAD_ANNOTATION.newName(), AnnotationDetector.MAIN_THREAD_ANNOTATION.oldName(), AnnotationDetector.MAIN_THREAD_ANNOTATION.newName(), AnnotationDetector.BINDER_THREAD_ANNOTATION.oldName(), AnnotationDetector.BINDER_THREAD_ANNOTATION.newName(), AnnotationDetector.WORKER_THREAD_ANNOTATION.oldName(), AnnotationDetector.WORKER_THREAD_ANNOTATION.newName(), AnnotationDetector.ANY_THREAD_ANNOTATION.oldName(), AnnotationDetector.ANY_THREAD_ANNOTATION.newName()});
    }

    @Override
    public void visitAnnotationUsage(@NotNull JavaContext context2, @NotNull UElement usage, @NotNull AnnotationUsageType type, @NotNull UAnnotation annotation, @NotNull String qualifiedName, @Nullable PsiMethod method, @Nullable PsiElement referenced, @NotNull List<? extends UAnnotation> annotations, @NotNull List<? extends UAnnotation> allMemberAnnotations, @NotNull List<? extends UAnnotation> allClassAnnotations, @NotNull List<? extends UAnnotation> allPackageAnnotations) {
        if (method != null) {
            this.checkThreading(context2, usage, method, qualifiedName, annotation, allMemberAnnotations, allClassAnnotations);
        }
    }

    private final void checkThreading(JavaContext context2, UElement node, PsiMethod method, String signature, UAnnotation annotation, List<? extends UAnnotation> allMethodAnnotations, List<? extends UAnnotation> allClassAnnotations) {
        List<String> threadContext = this.getThreadContext(context2, node);
        if (threadContext != null && !this.isCompatibleThread(threadContext, signature)) {
            String name;
            String s;
            if (UastLintUtils.containsAnnotation(allClassAnnotations, annotation)) {
                if (this.containsThreadingAnnotation(allMethodAnnotations)) {
                    return;
                }
            } else {
                boolean bl = UastLintUtils.containsAnnotation(allMethodAnnotations, annotation);
                boolean bl2 = false;
                boolean bl3 = false;
                if (_Assertions.ENABLED && !bl) {
                    boolean bl4 = false;
                    String string = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                Boolean isFirst = null;
                for (UAnnotation other : allMethodAnnotations) {
                    if (other == annotation) {
                        if (isFirst != null) continue;
                        isFirst = true;
                        continue;
                    }
                    if (!this.isThreadingAnnotation(other)) continue;
                    if (isFirst == null) {
                        return;
                    }
                    s = other.getQualifiedName();
                    if (s == null || !this.isCompatibleThread(threadContext, s)) continue;
                    return;
                }
            }
            if (StringsKt.startsWith$default((String)(name = method.getName()), (String)"post", (boolean)false, (int)2, null) && context2.getEvaluator().isMemberInClass((PsiMember)method, "android.view.View")) {
                return;
            }
            List<String> list2 = this.getThreads(context2, method);
            if (list2 == null) {
                return;
            }
            List<String> targetThreads = list2;
            if (targetThreads.containsAll((Collection)threadContext)) {
                return;
            }
            if (targetThreads.contains(AnnotationDetector.ANY_THREAD_ANNOTATION.oldName()) || targetThreads.contains(AnnotationDetector.ANY_THREAD_ANNOTATION.newName())) {
                return;
            }
            s = StringCompanionObject.INSTANCE;
            String string = "%1$s %2$s must be called from the %3$s thread, currently inferred thread is %4$s thread";
            Object[] objectArray = new Object[]{method.isConstructor() ? "Constructor" : "Method", method.getName(), this.describeThreads(targetThreads, true), this.describeThreads(threadContext, false)};
            boolean bl = false;
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
            String message2 = string2;
            Location location = context2.getLocation(node);
            this.report(context2, THREAD, node, location, message2);
        }
    }

    private final boolean containsThreadingAnnotation(List<? extends UAnnotation> array) {
        for (UAnnotation uAnnotation : array) {
            if (!this.isThreadingAnnotation(uAnnotation)) continue;
            return true;
        }
        return false;
    }

    private final boolean isThreadingAnnotation(UAnnotation annotation) {
        String signature = annotation.getQualifiedName();
        return signature != null && StringsKt.endsWith$default((String)signature, (String)"Thread", (boolean)false, (int)2, null) && SdkConstants.SUPPORT_ANNOTATIONS_PREFIX.isPrefix(signature);
    }

    /*
     * WARNING - void declaration
     */
    private final String describeThreads(List<String> annotations, boolean any) {
        StringBuilder sb = new StringBuilder();
        int n = 0;
        int n2 = ((Collection)annotations).size();
        while (n < n2) {
            void i;
            if (i > 0) {
                if (i == annotations.size() - 1) {
                    if (any) {
                        sb.append(" or ");
                    } else {
                        sb.append(" and ");
                    }
                } else {
                    sb.append(", ");
                }
            }
            sb.append(this.describeThread(annotations.get((int)i)));
            ++i;
        }
        return sb.toString();
    }

    private final String describeThread(String annotation) {
        String string = annotation;
        return Intrinsics.areEqual((Object)string, (Object)AnnotationDetector.UI_THREAD_ANNOTATION.oldName()) || Intrinsics.areEqual((Object)string, (Object)AnnotationDetector.UI_THREAD_ANNOTATION.newName()) ? "UI" : (Intrinsics.areEqual((Object)string, (Object)AnnotationDetector.MAIN_THREAD_ANNOTATION.oldName()) || Intrinsics.areEqual((Object)string, (Object)AnnotationDetector.MAIN_THREAD_ANNOTATION.newName()) ? "main" : (Intrinsics.areEqual((Object)string, (Object)AnnotationDetector.BINDER_THREAD_ANNOTATION.oldName()) || Intrinsics.areEqual((Object)string, (Object)AnnotationDetector.BINDER_THREAD_ANNOTATION.newName()) ? "binder" : (Intrinsics.areEqual((Object)string, (Object)AnnotationDetector.WORKER_THREAD_ANNOTATION.oldName()) || Intrinsics.areEqual((Object)string, (Object)AnnotationDetector.WORKER_THREAD_ANNOTATION.newName()) ? "worker" : (Intrinsics.areEqual((Object)string, (Object)AnnotationDetector.ANY_THREAD_ANNOTATION.oldName()) || Intrinsics.areEqual((Object)string, (Object)AnnotationDetector.ANY_THREAD_ANNOTATION.newName()) ? "any" : "other"))));
    }

    private final boolean isCompatibleThread(List<String> callers, String callee) {
        boolean bl = !callers.isEmpty();
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        for (String caller : callers) {
            if (this.isCompatibleThread(caller, callee)) continue;
            return false;
        }
        return true;
    }

    private final boolean isCompatibleThread(String caller, String callee) {
        if (Intrinsics.areEqual((Object)callee, (Object)caller)) {
            return true;
        }
        if (AnnotationDetector.ANY_THREAD_ANNOTATION.isEquals(callee)) {
            return true;
        }
        if (AnnotationDetector.UI_THREAD_ANNOTATION.isEquals(callee) ? AnnotationDetector.MAIN_THREAD_ANNOTATION.isEquals(caller) : AnnotationDetector.MAIN_THREAD_ANNOTATION.isEquals(callee) && AnnotationDetector.UI_THREAD_ANNOTATION.isEquals(caller)) {
            return true;
        }
        int callerNameIndex = StringsKt.lastIndexOf$default((CharSequence)caller, (char)'.', (int)0, (boolean)false, (int)6, null);
        int calleeNameIndex = StringsKt.lastIndexOf$default((CharSequence)callee, (char)'.', (int)0, (boolean)false, (int)6, null);
        if (callerNameIndex != -1 && calleeNameIndex != -1) {
            return StringsKt.regionMatches((String)caller, (int)callerNameIndex, (String)callee, (int)calleeNameIndex, (int)(caller.length() - callerNameIndex), (boolean)false);
        }
        return false;
    }

    private final List<String> getThreadContext(JavaContext context2, UElement methodCall) {
        UElement uElement = UastUtils.getParentOfType((UElement)methodCall, UMethod.class, (boolean)true, (Class[])new Class[]{UAnonymousClass.class, ULambdaExpression.class});
        if (!(uElement instanceof PsiMethod)) {
            uElement = null;
        }
        PsiMethod method = (PsiMethod)uElement;
        return this.getThreads(context2, method);
    }

    private final List<String> getThreads(JavaContext context2, PsiMethod originalMethod) {
        PsiMethod method = originalMethod;
        if (method != null) {
            PsiAnnotation[] annotations;
            JavaEvaluator evaluator = context2.getEvaluator();
            List<String> result = null;
            PsiClass cls = method.getContainingClass();
            while (method != null) {
                for (PsiAnnotation annotation : annotations = evaluator.getAllAnnotations((PsiModifierListOwner)method, false)) {
                    result = this.addThreadAnnotations(annotation, result);
                }
                if (result != null) {
                    return result;
                }
                if (evaluator.isStatic((PsiModifierListOwner)method)) {
                    return null;
                }
                method = evaluator.getSuperMethod(method);
            }
            while (cls != null) {
                for (PsiAnnotation annotation : annotations = evaluator.getAllAnnotations((PsiModifierListOwner)cls, false)) {
                    result = this.addThreadAnnotations(annotation, result);
                }
                if (result != null) {
                    return result;
                }
                cls = cls.getSuperClass();
            }
        }
        return null;
    }

    private final List<String> addThreadAnnotations(PsiAnnotation annotation, List<String> result) {
        List resultList = result;
        String name = annotation.getQualifiedName();
        if (name != null && SdkConstants.SUPPORT_ANNOTATIONS_PREFIX.isPrefix(name) && StringsKt.endsWith$default((String)name, (String)"Thread", (boolean)false, (int)2, null)) {
            if (resultList == null) {
                resultList = new ArrayList(4);
            }
            if (StringsKt.startsWith$default((String)name, (String)SdkConstants.SUPPORT_ANNOTATIONS_PREFIX.newName(), (boolean)false, (int)2, null)) {
                String string = name;
                int n = SdkConstants.SUPPORT_ANNOTATIONS_PREFIX.newName().length();
                StringBuilder stringBuilder = new StringBuilder().append(SdkConstants.SUPPORT_ANNOTATIONS_PREFIX.oldName());
                boolean bl = false;
                String string2 = string.substring(n);
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).substring(startIndex)");
                String string3 = string2;
                String oldName = stringBuilder.append(string3).toString();
                resultList.add(oldName);
            } else {
                resultList.add(name);
            }
        }
        return resultList;
    }

    static {
        Companion = new Companion(null);
        IMPLEMENTATION = new Implementation(ThreadDetector.class, Scope.JAVA_FILE_SCOPE);
        Collection collection = null;
        EnumSet enumSet = null;
        Implementation implementation = IMPLEMENTATION;
        boolean bl = false;
        Boolean bl2 = true;
        Severity severity = Severity.ERROR;
        int n = 6;
        Category category = Category.CORRECTNESS;
        String string = "http://developer.android.com/guide/components/processes-and-threads.html#Threads";
        THREAD = Issue.Companion.create$default(Issue.Companion, "WrongThread", "Wrong Thread", "\n                Ensures that a method which expects to be called on a specific thread, is \\\n                actually called from that thread. For example, calls on methods in widgets \\\n                should always be made on the UI thread.\n                ", implementation, string, category, n, severity, bl, bl2, enumSet, collection, 3328, null);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/lint/checks/ThreadDetector$Companion;", "", "()V", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "THREAD", "Lcom/android/tools/lint/detector/api/Issue;", "android.sdktools.lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

